/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.api;

import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class IdDenormalizer {
    private static String VENDOR_ID;
    private static String MODEL_ID;
    static final String className;
    private static ILogger traceLogger;

    static {
        Class<?> clazz;
        VENDOR_ID = "VENDOR_ID";
        MODEL_ID = "MODEL_ID";
        try {
            clazz = Class.forName("org.eclipse.aperi.common.api.IdDenormalizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        traceLogger = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap denormalizeIDsForFabric(HashMap hashMap) throws Exception {
        String string = "denormalizeIDsForFabric";
        DBConnection dBConnection = ServiceUtils.getConnection();
        try {
            try {
                if (dBConnection == null) throw new SQLException("ERROR invalid input");
                if (hashMap == null) {
                    throw new SQLException("ERROR invalid input");
                }
                if (hashMap.get(VENDOR_ID) != null) {
                    hashMap.put(VENDOR_ID, Normalizer.VendorGetName(dBConnection, ((Integer)hashMap.get(VENDOR_ID)).shortValue()));
                }
                if (hashMap.get(MODEL_ID) != null) {
                    hashMap.put(MODEL_ID, Normalizer.ModelGetName(dBConnection, ((Integer)hashMap.get(MODEL_ID)).shortValue()));
                }
                dBConnection.commit();
            }
            catch (Exception exception) {
                dBConnection.rollback();
                if (traceLogger == null) throw exception;
                if (!traceLogger.isLogging()) throw exception;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                if (traceLogger == null) throw throwable;
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing connection : ", exception);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (Exception exception) {
            if (traceLogger == null) return hashMap;
            if (!traceLogger.isLogging()) return hashMap;
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, String.valueOf(string) + " Error closing connection : ", exception);
            return hashMap;
        }
        if (dBConnection == null) return hashMap;
        dBConnection.close();
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap denormalizeIDsForStorageSubsystem(HashMap hashMap) throws ServerException, SQLException {
        DBConnection dBConnection = ServiceUtils.getConnection();
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(className, "denormalizeIDsForStorageSubsystem", new Object[]{dBConnection});
        try {
            try {
                if (dBConnection == null) throw new SQLException("ERROR invalid input");
                if (hashMap == null) {
                    throw new SQLException("ERROR invalid input");
                }
                if (hashMap.get(VENDOR_ID) != null) {
                    hashMap.put(VENDOR_ID, Normalizer.VendorGetName(dBConnection, (Short)hashMap.get(VENDOR_ID)));
                }
                if (hashMap.get(MODEL_ID) != null) {
                    hashMap.put(MODEL_ID, Normalizer.ModelGetName(dBConnection, (Short)hashMap.get(MODEL_ID)));
                }
                dBConnection.commit();
            }
            catch (Exception exception) {
                dBConnection.rollback();
                throw DiskMessageHelper.getServerException("HWN021503E", (Object)exception.getMessage(), exception, logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Error closing connection :", sQLException);
                throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
            }
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (SQLException sQLException) {
            logTraceHelper.traceError("Error closing connection :", sQLException);
            throw DiskMessageHelper.getServerException("HWN021503E", null, sQLException, logTraceHelper);
        }
        if (dBConnection == null) return hashMap;
        dBConnection.close();
        return hashMap;
    }
}

