/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.identifier;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.identifier.ArrayId;
import org.eclipse.aperi.common.identifier.ComponentId;
import org.eclipse.aperi.common.identifier.DeviceAdapterId;
import org.eclipse.aperi.common.identifier.DeviceId;
import org.eclipse.aperi.common.identifier.IoGroupId;
import org.eclipse.aperi.common.identifier.MDiskGroupId;
import org.eclipse.aperi.common.identifier.MDiskId;
import org.eclipse.aperi.common.identifier.PortId;
import org.eclipse.aperi.common.identifier.StorageExtentId;
import org.eclipse.aperi.common.identifier.StoragePoolId;
import org.eclipse.aperi.common.identifier.SubsysControllerId;
import org.eclipse.aperi.common.identifier.SubsystemId;
import org.eclipse.aperi.common.identifier.SvcNodeId;
import org.eclipse.aperi.common.identifier.SwitchId;
import org.eclipse.aperi.common.identifier.TopLevCompId;
import org.eclipse.aperi.common.identifier.VolumeId;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.Port;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.Switch;
import org.eclipse.aperi.infrastructure.database.objects.Switch2port;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;

public class ConversionUtil {
    public static DeviceId convertStringToSubsystemId(String string, int n, int n2) throws InvalidParameterException {
        SubsystemId subsystemId = null;
        String[] stringArray = null;
        String string2 = null;
        short s = -1;
        stringArray = ConversionUtil.tokenize(string);
        if (stringArray.length >= 2) {
            string2 = stringArray[0];
            try {
                s = Short.parseShort(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                s = -1;
            }
        }
        if (string2 == null || s == -1) {
            throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0010E", new String[]{string}));
        }
        subsystemId = new SubsystemId(string2, s);
        return subsystemId;
    }

    public static DeviceId convertStringToSwitchId(String string) {
        return new SwitchId(string);
    }

    public static ComponentId convertStringToComponentId(String string, short s, int n, int n2) {
        ComponentId componentId = null;
        switch (s) {
            case 1: {
                componentId = new TopLevCompId(ConversionUtil.convertStringToSubsystemId(string, n, n2));
                break;
            }
            case 13: {
                componentId = new TopLevCompId(ConversionUtil.convertStringToSwitchId(string));
                break;
            }
            case 12: 
            case 15: {
                componentId = ConversionUtil.getNameNameFormatCompId(string, s, n, n2);
                break;
            }
            case 3: 
            case 5: {
                componentId = ConversionUtil.getIntegerCompId(string, s, n, n2);
                break;
            }
            case 2: {
                componentId = ConversionUtil.getSubsystemPortCompId(string, s, n, n2);
                break;
            }
            case 14: {
                componentId = ConversionUtil.getSwitchPortCompId(string, s, n, n2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                componentId = ConversionUtil.getStringCompId(string, s, n, n2);
            }
        }
        return componentId;
    }

    private static ComponentId getNameNameFormatCompId(String string, short s, int n, int n2) {
        ComponentId componentId = null;
        String[] stringArray = null;
        String string2 = null;
        short s2 = -1;
        String string3 = null;
        short s3 = -1;
        stringArray = ConversionUtil.tokenize(string);
        if (stringArray.length >= 4) {
            string3 = stringArray[0];
            string2 = stringArray[2];
            try {
                s3 = Short.parseShort(stringArray[1]);
                s2 = Short.parseShort(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                s3 = -1;
                s2 = -1;
            }
        }
        if (string2 != null && s2 != -1 && string3 != null && s3 != -1) {
            DeviceId deviceId = null;
            deviceId = s != 13 && s != 14 ? new SubsystemId(string2, s2) : new SwitchId(string2);
            switch (s) {
                case 12: {
                    componentId = new VolumeId(deviceId, string3, s3);
                    break;
                }
                case 15: {
                    componentId = new SvcNodeId(deviceId, string3, s3);
                }
            }
        } else {
            throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0013E", new String[]{string}));
        }
        return componentId;
    }

    private static ComponentId getIntegerCompId(String string, short s, int n, int n2) {
        ComponentId componentId = null;
        String[] stringArray = null;
        String string2 = null;
        short s2 = -1;
        short s3 = -1;
        stringArray = ConversionUtil.tokenize(string);
        if (stringArray.length >= 3) {
            string2 = stringArray[1];
            try {
                s3 = Integer.parseInt(stringArray[0]);
                s2 = Short.parseShort(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                s2 = -1;
                s3 = -1;
            }
        }
        if (string2 != null && s2 != -1 && s3 != -1) {
            DeviceId deviceId = null;
            deviceId = s != 13 && s != 14 ? new SubsystemId(string2, s2) : new SwitchId(string2);
            switch (s) {
                case 3: {
                    componentId = new SubsysControllerId(deviceId, s3);
                    break;
                }
                case 5: {
                    componentId = new IoGroupId(deviceId, s3);
                }
            }
        } else {
            throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0013E", new String[]{string}));
        }
        return componentId;
    }

    private static ComponentId getStringCompId(String string, short s, int n, int n2) {
        ComponentId componentId = null;
        String[] stringArray = null;
        String string2 = null;
        short s2 = -1;
        String string3 = null;
        stringArray = ConversionUtil.tokenize(string);
        if (stringArray.length >= 3) {
            string3 = stringArray[0];
            string2 = stringArray[1];
            try {
                s2 = Short.parseShort(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                s2 = -1;
            }
        }
        if (string2 != null && s2 != -1 && string3 != null) {
            DeviceId deviceId = null;
            deviceId = s != 13 && s != 14 ? new SubsystemId(string2, s2) : new SwitchId(string2);
            switch (s) {
                case 7: {
                    componentId = new MDiskGroupId(deviceId, string3);
                    break;
                }
                case 8: {
                    componentId = new DeviceAdapterId(deviceId, string3);
                    break;
                }
                case 9: {
                    componentId = new StorageExtentId(deviceId, string3);
                    break;
                }
                case 10: {
                    componentId = new ArrayId(deviceId, string3);
                    break;
                }
                case 11: {
                    componentId = new MDiskId(deviceId, string3);
                }
            }
        } else {
            throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0013E", new String[]{string}));
        }
        return componentId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ComponentId getSwitchPortCompId(String string, short s, int n, int n2) {
        Object object;
        String string2;
        TResPortTable tResPortTable;
        block24: {
            PortId portId = null;
            DBConnection dBConnection = null;
            Hashtable<ColumnInfo, String> hashtable = null;
            DBCursor dBCursor = null;
            DBCursor dBCursor2 = null;
            tResPortTable = null;
            boolean bl = false;
            string2 = null;
            if (string == null) break block24;
            dBConnection = ConversionUtil.getDbConnection();
            hashtable = new Hashtable<ColumnInfo, String>();
            try {
                block23: {
                    try {
                        hashtable.put(Port.getColumnInfo("NAME"), string);
                        dBCursor = Port.getCursor(dBConnection, hashtable, null);
                        if (dBCursor.next()) {
                            tResPortTable = ((Port.PortCursor)dBCursor).getObject();
                        }
                        if (dBCursor.next()) {
                            tResPortTable = null;
                        }
                        if (tResPortTable == null) break block23;
                        object = "SELECT b.SWITCH_WWN FROM " + Switch2port.getTablename() + " as a, " + Switch.getTablename() + " as b " + "WHERE +a." + "PORT_ID" + "=" + tResPortTable.getPortId() + " AND a." + "SWITCH_WWN" + "=b." + "SWITCH_WWN" + " AND b." + "PARENT_SWITCH_WWN" + " IS NULL";
                        DBResultSet dBResultSet = null;
                        try {
                            dBResultSet = ComplexQuery.sqlQuery(dBConnection, (String)object, null);
                            if (dBResultSet == null) break block23;
                            try {
                                if (dBResultSet.next()) {
                                    string2 = dBResultSet.getString(1);
                                }
                                if (dBResultSet.next()) {
                                    bl = true;
                                }
                            }
                            catch (SQLException sQLException) {
                                sQLException.printStackTrace();
                            }
                        }
                        catch (SQLException sQLException) {
                            sQLException.printStackTrace();
                        }
                    }
                    catch (SQLException sQLException) {
                        tResPortTable = null;
                        sQLException.printStackTrace();
                    }
                }
                Object var15_19 = null;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    if (dBCursor != null) {
                        dBCursor.close();
                    }
                    if (dBCursor2 != null) {
                        dBCursor2.close();
                    }
                    if (dBConnection == null) throw throwable;
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            if (dBCursor != null) {
                dBCursor.close();
            }
            if (dBCursor2 != null) {
                dBCursor2.close();
            }
            if (dBConnection != null) {
                dBConnection.close();
            }
            if (tResPortTable == null || bl) {
                throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0012E", new String[]{string}));
            }
        }
        if (string2 != null && string != null) {
            object = new SwitchId(string2);
            return new PortId((DeviceId)object, string, tResPortTable.getNameFormat());
        }
        throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0011E", new String[]{string}));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ComponentId getSubsystemPortCompId(String string, short s, int n, int n2) {
        TResStorageSubsystemTable tResStorageSubsystemTable;
        TResPortTable tResPortTable;
        block20: {
            PortId portId = null;
            DBConnection dBConnection = null;
            Hashtable<ColumnInfo, Object> hashtable = null;
            DBCursor dBCursor = null;
            DBCursor dBCursor2 = null;
            tResPortTable = null;
            tResStorageSubsystemTable = null;
            if (string == null) break block20;
            dBConnection = ConversionUtil.getDbConnection();
            hashtable = new Hashtable<ColumnInfo, Object>();
            try {
                try {
                    hashtable.put(Port.getColumnInfo("NAME"), string);
                    dBCursor = Port.getCursor(dBConnection, hashtable, null);
                    if (dBCursor.next()) {
                        tResPortTable = ((Port.PortCursor)dBCursor).getObject();
                    }
                    if (dBCursor.next()) {
                        tResPortTable = null;
                    }
                    if (tResPortTable != null) {
                        hashtable.clear();
                        hashtable.put(StorageSubsystem.getColumnInfo("SUBSYSTEM_ID"), new Integer(tResPortTable.getSubsystemId()));
                        dBCursor2 = StorageSubsystem.getCursor(dBConnection, hashtable, null);
                        if (dBCursor2.next()) {
                            tResStorageSubsystemTable = ((StorageSubsystem.StorageSubsystemCursor)dBCursor2).getObject();
                        }
                        if (dBCursor2.next()) {
                            tResStorageSubsystemTable = null;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    tResPortTable = null;
                    tResStorageSubsystemTable = null;
                    sQLException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (dBCursor != null) {
                        dBCursor.close();
                    }
                    if (dBCursor2 != null) {
                        dBCursor2.close();
                    }
                    if (dBConnection == null) throw throwable;
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            {
                Object var12_15 = null;
            }
            try {}
            catch (SQLException sQLException) {}
            if (dBCursor != null) {
                dBCursor.close();
            }
            if (dBCursor2 != null) {
                dBCursor2.close();
            }
            if (dBConnection != null) {
                dBConnection.close();
            }
            if (tResPortTable == null || tResStorageSubsystemTable == null) {
                throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0012E", new String[]{string}));
            }
        }
        if (tResStorageSubsystemTable.getName() != null && string != null) {
            SubsystemId subsystemId = new SubsystemId(tResStorageSubsystemTable.getName(), tResStorageSubsystemTable.getNameFormat());
            return new PortId((DeviceId)subsystemId, string, tResPortTable.getNameFormat());
        }
        throw new InvalidParameterException(n, n2, new SRMMessage("HWNPM0011E", new String[]{string}));
    }

    private static String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+\\", true);
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("+")) {
                vector.addElement(string2);
                string2 = "";
                continue;
            }
            if (string3.equals("\\") && stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken();
                if (string3.equals("+")) {
                    string2 = String.valueOf(string2) + "+";
                    continue;
                }
                if (string3.equals("\\")) {
                    string2 = String.valueOf(string2) + "\\";
                    continue;
                }
                string2 = String.valueOf(string2) + string3;
                continue;
            }
            string2 = String.valueOf(string2) + string3;
        }
        if (string2.length() > 0) {
            vector.addElement(string2);
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static DBConnection getDbConnection() throws ServerException {
        DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
        DBConnection dBConnection = null;
        try {
            dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
        }
        catch (SQLException sQLException) {
            dBConnection = null;
        }
        if (dBConnection == null) {
            throw new ServerException(new SRMMessage("HWNPM0015E", null));
        }
        return dBConnection;
    }

    public static String convertSubsystemIdToString(SubsystemId subsystemId) {
        return String.valueOf(ConversionUtil.escape(subsystemId.getInternalName())) + '+' + subsystemId.getNameFormat();
    }

    public static String convertSwitchIdToString(SwitchId switchId) {
        return switchId.getInternalName();
    }

    public static String convertComponentIdToString(ComponentId componentId) {
        String string = null;
        if (componentId instanceof VolumeId) {
            string = String.valueOf(ConversionUtil.escape(componentId.getInternalName())) + '+' + ((VolumeId)componentId).getNameFormat() + '+' + ConversionUtil.escape(componentId.getDeviceId().getInternalName()) + '+' + ((SubsystemId)componentId.getDeviceId()).getNameFormat();
        } else if (componentId instanceof PortId) {
            string = componentId.getInternalName();
        } else if (componentId instanceof ArrayId || componentId instanceof StorageExtentId || componentId instanceof DeviceAdapterId || componentId instanceof MDiskId || componentId instanceof MDiskGroupId) {
            string = String.valueOf(ConversionUtil.escape(componentId.getInternalName())) + '+' + ConversionUtil.escape(componentId.getDeviceId().getInternalName()) + '+' + ((SubsystemId)componentId.getDeviceId()).getNameFormat();
        } else if (componentId instanceof SvcNodeId) {
            string = String.valueOf(ConversionUtil.escape(componentId.getInternalName())) + '+' + ((SvcNodeId)componentId).getNameFormat() + '+' + ConversionUtil.escape(componentId.getDeviceId().getInternalName()) + '+' + ((SubsystemId)componentId.getDeviceId()).getNameFormat();
        } else if (componentId instanceof IoGroupId) {
            string = "" + ((IoGroupId)componentId).getIoGroupNumber() + '+' + ConversionUtil.escape(componentId.getDeviceId().getInternalName()) + '+' + ((SubsystemId)componentId.getDeviceId()).getNameFormat();
        } else if (componentId instanceof SubsysControllerId) {
            string = "" + ((SubsysControllerId)componentId).getControllerNumber() + '+' + ConversionUtil.escape(componentId.getDeviceId().getInternalName()) + '+' + ((SubsystemId)componentId.getDeviceId()).getNameFormat();
        } else if (componentId instanceof TopLevCompId && componentId.getDeviceId() instanceof SubsystemId) {
            string = String.valueOf(ConversionUtil.escape(componentId.getDeviceId().getInternalName())) + '+' + ((SubsystemId)componentId.getDeviceId()).getNameFormat();
        } else if (componentId instanceof TopLevCompId && componentId.getDeviceId() instanceof SwitchId) {
            string = componentId.getDeviceId().getInternalName();
        }
        return string;
    }

    private static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '+') {
                stringBuffer.append("\\+");
            } else if (string.charAt(n) == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static short getInternalCompType(ComponentId componentId) {
        int n = 0;
        if (componentId instanceof SubsysControllerId) {
            n = 3;
        } else if (componentId instanceof ArrayId) {
            n = 10;
        } else if (componentId instanceof VolumeId) {
            n = 12;
        } else if (componentId instanceof MDiskGroupId) {
            n = 7;
        } else if (componentId instanceof MDiskId) {
            n = 11;
        } else if (componentId instanceof IoGroupId) {
            n = 5;
        } else if (componentId instanceof DeviceAdapterId) {
            n = 8;
        } else if (componentId instanceof StorageExtentId) {
            n = 9;
        } else if (componentId instanceof StoragePoolId) {
            n = 4;
        } else if (componentId instanceof PortId) {
            n = 2;
        } else if (componentId instanceof SvcNodeId) {
            n = 15;
        }
        return (short)n;
    }
}

