/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import java.util.ArrayList;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadPool;
import org.eclipse.aperi.disk.common.util.thread.ExecGroup;

public final class DiskThreadManager {
    private static DiskThreadManager stSingletonInstance = null;
    private DiskThreadPool cThreads = new DiskThreadPool();

    static {
        stSingletonInstance = new DiskThreadManager();
    }

    private DiskThreadManager() {
    }

    public static final DiskThreadManager get() {
        return stSingletonInstance;
    }

    public static Object executeWithTimeLimit(Object object, String string, Object[] objectArray, long l, LogTraceHelper logTraceHelper) throws DiskManagerTimeoutException, DiskManagerExecException {
        return DiskThreadManager.executeWithTimeLimit(object, string, DiskThreadManager.getParamTypes(objectArray), objectArray, l, logTraceHelper);
    }

    public static Object executeWithTimeLimit(Object object, String string, Class[] classArray, Object[] objectArray, long l, LogTraceHelper logTraceHelper) throws DiskManagerTimeoutException, DiskManagerExecException {
        ExecGroup execGroup = DiskThreadManager.getExecutionGroup();
        try {
            Long l2 = execGroup.execute(object, string, classArray, objectArray, logTraceHelper);
            execGroup.waitForCompletion(l);
            if (execGroup.getExecutionError(l2) != null) {
                throw new DiskManagerExecException(execGroup.getExecutionError(l2));
            }
            Object object2 = execGroup.getExecutionResult(l2);
            Object var9_9 = null;
            execGroup.clear();
            return object2;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            execGroup.clear();
            throw throwable;
        }
    }

    public static ExecGroup getExecutionGroup() {
        return new ExecGroup(DiskThreadManager.get());
    }

    protected DiskMgrThread getThread() {
        return this.cThreads.getThread(this);
    }

    protected void returnThread(DiskMgrThread diskMgrThread) {
        this.cThreads.returnThread(diskMgrThread);
    }

    public static void shutdown() {
        DiskThreadManager.get().cThreads.clear();
    }

    public static Class[] getParamTypes(Object[] objectArray) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == null) {
                throw new IllegalArgumentException("Element at index " + n + "in parameter array must not be null.");
            }
            arrayList.add(objectArray[n].getClass());
            ++n;
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }
}

