/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkCllctnTable;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskHistTable;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskTable;

public class SubsystemDBHelper {
    private static final int DEL_VOLUMES = 0;
    private static final int DEL_POOLS = 1;
    private static final int DEL_PHYVOLS = 2;
    private static final int DEL_PORTS = 3;

    public static boolean deleteStorageVolumes(int[] nArray) throws SQLException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.discovery.SubsystemDBHelper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(clazz, "deleteStorageVolumes", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 0);
            boolean bl2 = bl;
            Object var3_4 = null;
            logTraceHelper.exit(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            logTraceHelper.exit(bl);
            throw throwable;
        }
    }

    public static boolean deleteStoragePools(int[] nArray) throws SQLException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.discovery.SubsystemDBHelper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(clazz, "deleteStoragePools", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 1);
            boolean bl2 = bl;
            Object var3_4 = null;
            logTraceHelper.exit(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            logTraceHelper.exit(bl);
            throw throwable;
        }
    }

    public static boolean deletePorts(int[] nArray) throws SQLException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.discovery.SubsystemDBHelper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(clazz, "deletePorts", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 3);
            boolean bl2 = bl;
            Object var3_4 = null;
            logTraceHelper.exit(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            logTraceHelper.exit(bl);
            throw throwable;
        }
    }

    public static boolean deletePhysicalVolumes(int[] nArray) throws SQLException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.disk.discovery.SubsystemDBHelper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(clazz, "deletePhysicalVolumes", new Object[]{nArray});
        Boolean bl = new Boolean(false);
        try {
            bl = SubsystemDBHelper.deadlockSafeSubentityDeletion(nArray, logTraceHelper, 2);
            boolean bl2 = bl;
            Object var3_4 = null;
            logTraceHelper.exit(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            logTraceHelper.exit(bl);
            throw throwable;
        }
    }

    public static boolean handleDeadlock(DBConnection dBConnection, LogTraceHelper logTraceHelper, RetryDeleteParameters retryDeleteParameters, Exception exception, Result result, String string) {
        logTraceHelper.traceInfo("Deadlock ..... rollback!");
        try {
            dBConnection.rollback();
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceInfo("Exception in rollback  " + sQLException.getMessage());
            retryDeleteParameters.setToRetry(false);
            throw DiskMessageHelper.getServerException("HWN021503E", exception.getMessage(), logTraceHelper);
        }
        retryDeleteParameters.setNumRetries(retryDeleteParameters.getNumRetries() + 1);
        if (retryDeleteParameters.getNumRetries() > retryDeleteParameters.getAllowed_Retries()) {
            retryDeleteParameters.setToRetry(false);
            if (result != null && string != null) {
                result.setSRMMessage("HWN021672E", new String[]{string});
            }
            return false;
        }
        logTraceHelper.traceInfo("Retry " + retryDeleteParameters.getNumRetries() + " after deadlock");
        retryDeleteParameters.setToRetry(true);
        retryDeleteParameters.setMsWaitPeriod((long)((double)retryDeleteParameters.getMult_Retry_Interval() * RetryDeleteParameters.getRandGen().nextDouble() * (double)retryDeleteParameters.getNumRetries()));
        if (retryDeleteParameters.getMsWaitPeriod() < retryDeleteParameters.getMin_Retry_Internal()) {
            retryDeleteParameters.setMsWaitPeriod(retryDeleteParameters.getMin_Retry_Internal());
        }
        try {
            Thread.sleep(retryDeleteParameters.getMsWaitPeriod());
        }
        catch (InterruptedException interruptedException) {
            logTraceHelper.traceInfo("InterruptedException " + exception.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Boolean deadlockSafeSubentityDeletion(int[] var0, LogTraceHelper var1_1, int var2_2) throws SQLException {
        var3_3 = new Boolean(false);
        var4_4 = null;
        var5_5 = new RetryDeleteParameters();
        var5_5.init(var1_1);
        try {
            if (var0 != null && var0.length != 0) {
                var6_6 = "(" + ParameterHelper.intArrayToString(var0) + ")";
                while (var5_5.isToRetry()) {
                    try {
                        var4_4 = ServiceUtils.getConnection();
                        var4_4.setAutoCommit(false);
                        switch (var2_2) {
                            case 0: {
                                var3_3 = new Boolean(SubsystemDBHelper.performVolDelete(var4_4, var6_6, var0));
                                break;
                            }
                            case 2: {
                                var3_3 = new Boolean(SubsystemDBHelper.performPhyVolDelete(var4_4, var6_6, var0));
                                break;
                            }
                            case 3: {
                                var3_3 = new Boolean(SubsystemDBHelper.performPortDelete(var4_4, var6_6, var0));
                                break;
                            }
                            case 1: {
                                var3_3 = new Boolean(SubsystemDBHelper.performPoolDelete(var4_4, var6_6, var0));
                                break;
                            }
                        }
                        var4_4.commit();
                        var5_5.setToRetry(false);
                    }
                    catch (SQLException var7_7) {
                        if (SQLExceptionHelper.isDeadlock(var4_4, var7_7) == false) throw var7_7;
                        if (!SubsystemDBHelper.handleDeadlock(var4_4, var1_1, var5_5, var7_7, null, null)) continue;
                    }
                }
            }
        }
        catch (Throwable var9_8) {
            var8_9 = null;
            try {
                if (var4_4 == null) throw var9_8;
                var4_4.close();
                throw var9_8;
            }
            catch (RuntimeException var10_11) {
                var1_1.traceError("Error during commit or close of DBConnection", var10_11);
                var1_1.exit(new Boolean(false));
                throw var10_11;
            }
            catch (SQLException var10_12) {
                var1_1.traceError("Error during commit or close of DBConnection", var10_12);
                var1_1.exit(new Boolean(false));
                throw var10_12;
            }
        }
        {
            var8_10 = null;
        }
        ** try [egrp 2[TRYBLOCK] [3, 4 : 252->265)] { 
lbl50:
        // 1 sources

        if (var4_4 == null) return var3_3;
        var4_4.close();
        return var3_3;
lbl53:
        // 1 sources

        catch (RuntimeException var10_13) {
            var1_1.traceError("Error during commit or close of DBConnection", var10_13);
            var1_1.exit(new Boolean(false));
            throw var10_13;
        }
lbl57:
        // 1 sources

        catch (SQLException var10_14) {
            var1_1.traceError("Error during commit or close of DBConnection", var10_14);
            var1_1.exit(new Boolean(false));
            throw var10_14;
        }
    }

    private static int execDelete(String string, String string2, String string3, DBConnection dBConnection) throws SQLException {
        String string4 = "DELETE FROM " + string + " WHERE " + string2 + " IN " + string3;
        return ComplexQuery.sqlUpdate(dBConnection, string4, null);
    }

    private static boolean performPoolDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        SubsystemDBHelper.execDelete(TResStorageExtentTable.getTablename(), "POOL_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResStoragePoolTable.getTablename(), "POOL_ID", string, dBConnection) == nArray.length;
    }

    private static boolean performPortDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        String string2 = "SELECT MASKING_INFO_ID FROM " + TResDataPathTable.getTablename() + " WHERE " + "TARGET_PORT_ID" + " IN " + string;
        String string3 = "DELETE FROM " + TResMaskingInfoTable.getTablename() + " WHERE " + "MASKING_INFO_ID" + " IN (" + string2 + ")";
        ComplexQuery.sqlUpdate(dBConnection, string3, null);
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "TARGET_PORT_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "INITIATOR_PORT_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResCimkeyPortTable.getTablename(), "CIMKEY_PORT_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResPortTable.getTablename(), "PORT_ID", string, dBConnection) == nArray.length;
    }

    private static boolean performPhyVolDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        SubsystemDBHelper.execDelete(TStatDiskTable.getTablename(), "DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TStatDiskHistTable.getTablename(), "DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResPhysicalvolume2extentTable.getTablename(), "PHYSICAL_VOLUME_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResPhysicalVolumeTable.getTablename(), "PHYSICAL_VOLUME_ID", string, dBConnection) == nArray.length;
    }

    private static boolean performVolDelete(DBConnection dBConnection, String string, int[] nArray) throws SQLException {
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "DEVICE_LUN_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResChunkTable.getTablename(), "LOGICAL_DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResChunkCllctnTable.getTablename(), "LOGICAL_DISK_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResVolume2extentTable.getTablename(), "VOLUME_ID", string, dBConnection);
        SubsystemDBHelper.execDelete(TResCimkeyVolumeTable.getTablename(), "VOLUME_ID", string, dBConnection);
        return SubsystemDBHelper.execDelete(TResStorageVolumeTable.getTablename(), "SVID", string, dBConnection) == nArray.length;
    }
}

