/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertEmailEditor
implements ActionListener,
ListSelectionListener {
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private JDialog dialog = new JDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI0155T"), true);
    private Container contentpane = this.dialog.getContentPane();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem saveItem = new JMenuItem();
    private JMenuItem defaultsItem = new JMenuItem();
    private JMenuItem closeItem = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpCS = new JMenuItem();
    private JPanel topPanel = new JPanel(new BorderLayout());
    private JPanel spacePanel = new JPanel();
    private JLabel spaceLabel = new JLabel(" ");
    private JPanel subjectPanel = new JPanel();
    private JLabel subjectLabel = new JLabel(String.valueOf(MessageLog.getMessageNoID("GUI0156L")) + "   ");
    private TTextField subjectField;
    private JPanel textPanel = new JPanel(new BorderLayout());
    private JLabel textLabel = new JLabel(MessageLog.getMessageNoID("GUI0157L"));
    private JScrollPane textScroll = new JScrollPane();
    private JTextArea textArea = new JTextArea();
    private JPanel parmPanel = new JPanel();
    private JLabel parmLabel = new JLabel(MessageLog.getMessageNoID("GUI0163L"));
    private JPanel listPanel = new JPanel();
    private JList parmList = new JList();
    protected String subject;
    protected String text;
    private String defaultText;
    private String defaultSubject;
    private String initialText;
    private String initialSubject;
    private Map<Integer, Object> parmIdToMsgMap;
    private Map<Object, Integer> parmMsgToIdMap;

    public void edit(String string, String string2, AlertDefinition alertDefinition) {
        Object object;
        Serializable serializable;
        Object object2;
        this.subject = string;
        this.text = string2;
        this.defaultSubject = MessageLog.getMessageNoID(alertDefinition.getEmailSubjectID());
        this.defaultText = MessageLog.getMessageNoID(alertDefinition.getEmailMsgID());
        this.parmIdToMsgMap = new HashMap<Integer, Object>();
        this.parmMsgToIdMap = new HashMap<Object, Integer>();
        Map<Integer, String> map = alertDefinition.getEmailParmMsgIdMap();
        if (map != null) {
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                serializable = object2.next();
                object = MessageLog.getMessageNoID(map.get(serializable));
                this.parmIdToMsgMap.put((Integer)serializable, object);
                this.parmMsgToIdMap.put(object, (Integer)serializable);
            }
        }
        if (AlertEmailEditor.isNullString(string)) {
            string = this.defaultSubject;
        }
        if (AlertEmailEditor.isNullString(string2)) {
            string2 = this.defaultText;
        }
        this.initialSubject = string;
        object2 = new StringBuffer(2048);
        Util.formatLine(string2, (StringBuffer)object2, this.parmIdToMsgMap);
        this.initialText = ((StringBuffer)object2).toString();
        this.fileMenu.setText(MessageLog.getMessageNoID("GUI5005L"));
        this.saveItem.setText(MessageLog.getMessageNoID("GUI5006L"));
        this.defaultsItem.setText(MessageLog.getMessageNoID("GUI0162L"));
        this.closeItem.setText(MessageLog.getMessageNoID("GUI5008L"));
        this.saveItem.addActionListener(this);
        this.defaultsItem.addActionListener(this);
        this.closeItem.addActionListener(this);
        this.fileMenu.add(this.saveItem);
        this.fileMenu.add(this.defaultsItem);
        this.fileMenu.add(this.closeItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText(MessageLog.getMessageNoID("GUI0072L"));
        this.helpCS.setText(MessageLog.getMessageNoID("GUI0075L"));
        Help.setHelpID(this.helpCS, "asco40");
        this.helpCS.addActionListener(Help.getDisplayHelpFromSource());
        this.helpMenu.add(this.helpCS);
        this.menuBar.add(this.helpMenu);
        this.dialog.setJMenuBar(this.menuBar);
        GuiUtil.setAccessibleDescription(this.dialog, MessageLog.getMessageNoID("GUI0155T"));
        GuiUtil.setAccessibleLabel(this.textLabel, this.textArea, "", this.textLabel.getText(), this.textLabel.getText());
        GuiUtil.setAccessibleLabel(this.subjectLabel, this.subjectField, "", this.subjectLabel.getText(), this.subjectLabel.getText());
        GuiUtil.setAccessibleLabel(this.parmLabel, this.parmList, "", this.parmLabel.getText(), this.parmLabel.getText());
        this.helpMenu.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        this.subjectField = TTextField.newTTextField(this.initialSubject, 120, false);
        this.subjectPanel.setLayout(new BoxLayout(this.subjectPanel, 0));
        this.subjectPanel.add(this.subjectLabel);
        this.subjectPanel.add(this.subjectField);
        this.subjectPanel.add(new JLabel("    "));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(GuiUtil.wrapAtWords());
        this.textArea.setText(this.initialText);
        this.textPanel.add((Component)new JLabel("    "), "West");
        this.textPanel.add((Component)new JLabel("    "), "East");
        this.textPanel.add((Component)new JLabel("    "), "South");
        this.textPanel.add((Component)this.textLabel, "North");
        this.textPanel.add((Component)this.textScroll, "Center");
        this.textScroll.setViewportView(this.textArea);
        this.spacePanel.add(this.spaceLabel);
        this.topPanel.add((Component)this.spacePanel, "North");
        this.topPanel.add((Component)this.subjectPanel, "South");
        this.parmPanel.setLayout(new BoxLayout(this.parmPanel, 1));
        this.parmPanel.add(this.parmLabel);
        this.listPanel.add(this.parmList);
        this.parmPanel.add(this.listPanel);
        this.parmList.setListData(this.parmMsgToIdMap.keySet().toArray());
        this.parmList.setSelectionMode(0);
        this.parmList.addListSelectionListener(this);
        this.contentpane.add((Component)this.topPanel, "North");
        this.contentpane.add((Component)this.textPanel, "Center");
        this.contentpane.add((Component)this.parmPanel, "South");
        serializable = this.dialog.getRootPane();
        Help.setHelpID((Component)serializable, "asco40");
        ((JComponent)serializable).registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        ((JComponent)serializable).registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        object = this.dialog.getToolkit().getScreenSize();
        int n = (((Dimension)object).width - 500) / 2;
        int n2 = (((Dimension)object).height - 500) / 2;
        this.dialog.setBounds(n, n2, 700, 500);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowClosing());
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveItem) {
            this.saveText();
        } else if (object == this.defaultsItem) {
            this.subjectField.setText(this.defaultSubject);
            StringBuffer stringBuffer = new StringBuffer();
            Util.formatLine(this.defaultText, stringBuffer, this.parmIdToMsgMap);
            this.textArea.setText(stringBuffer.toString());
        } else if (object == this.closeItem) {
            this.close();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.parmList.getSelectedIndex();
        if (!listSelectionEvent.getValueIsAdjusting() && n > -1) {
            int n2 = this.textArea.getCaretPosition();
            this.textArea.insert(this.parmList.getSelectedValue().toString(), n2);
            this.parmList.removeSelectionInterval(0, this.parmIdToMsgMap.size() - 1);
            this.textArea.requestFocus();
        }
    }

    private void close() {
        String string = this.subjectField.getText();
        String string2 = this.textArea.getText();
        if ((AlertEmailEditor.isNullString(this.subject) && AlertEmailEditor.isNullString(string) || string.equals(this.initialSubject)) && (AlertEmailEditor.isNullString(this.text) && AlertEmailEditor.isNullString(string2) || string2.equals(this.initialText))) {
            this.dialog.dispose();
        } else {
            new JOptionPane();
            int n = JOptionPane.showConfirmDialog(this.dialog, MessageLog.getMessageNoID("GUI0159T"), MessageLog.getMessageNoID("GUI0158T"), 1);
            switch (n) {
                case 0: {
                    if (!this.saveText()) break;
                }
                case 1: {
                    this.dialog.dispose();
                }
            }
        }
    }

    private boolean saveText() {
        String string = this.encode();
        if (string == null) {
            return false;
        }
        this.text = AlertEmailEditor.isNullString(string) || string.equals(this.defaultText) ? null : string;
        String string2 = this.subjectField.getText();
        this.subject = AlertEmailEditor.isNullString(string2) || string2.equals(this.defaultSubject) ? null : string2;
        this.initialText = this.textArea.getText();
        this.initialSubject = string2;
        return true;
    }

    private String encode() {
        StringBuffer stringBuffer = new StringBuffer(this.textArea.getText());
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length());
        StringBuffer stringBuffer3 = new StringBuffer(30);
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n2);
            stringBuffer2.append(c);
            if (c == '[') {
                int n3 = n2++;
                stringBuffer3.setLength(0);
                stringBuffer3.append(c);
                while (n2 < stringBuffer.length()) {
                    c = stringBuffer.charAt(n2);
                    stringBuffer3.append(c);
                    if (c == ']') {
                        ++n;
                        String string = stringBuffer3.toString();
                        Integer n4 = this.parmMsgToIdMap.get(string);
                        if (n4 != null) {
                            stringBuffer2.append(n4);
                            stringBuffer2.append(c);
                            break;
                        }
                        this.textArea.setCaretPosition(n3);
                        Object[] objectArray = new Object[]{string, new Integer(n3)};
                        JOptionPane.showMessageDialog(this.dialog, MessageLog.getMessageNoID("GUI0161T", objectArray), MessageLog.getMessageNoID("GUI0160T"), 2);
                        return null;
                    }
                    ++n2;
                }
            }
            ++n2;
        }
        return stringBuffer2.toString();
    }

    public static boolean isNullString(String string) {
        return string == null || string.length() == 0 || string.length() == 1 && string.charAt(0) == ' ';
    }

    private class WindowClosing
    extends WindowAdapter {
        private WindowClosing() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AlertEmailEditor.this.close();
        }
    }
}

