/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.eclipse.aperi.TStorm.gui.OSAlertLogTableData;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogDetailPanel
extends JPanel
implements ActionListener {
    private static final String[] alertStates = new String[]{"GUI2029L", "GUI2039T", "GUI0060L"};
    private static final String SCRIPT_LOG = "S";
    private static final String JOB_LOG = "J";
    private AlertLog logRecord;
    private GridBagConstraints labelConstraint;
    private GridBagConstraints valueConstraint;

    public void addPair(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        this.add((Component)jLabel, this.labelConstraint);
        if (string2 == null) {
            string2 = AlertLogDDI.notApplicableText;
        }
        jLabel = new JLabel(string2);
        jLabel.setFont(BaseTree.plainFont);
        jLabel.setForeground(Color.black);
        this.add((Component)jLabel, this.valueConstraint);
    }

    public void addIDPair(String string, String string2) {
        this.addPair(MessageLog.getMessageNoID(string), string2);
    }

    private String format(long l, int n) {
        String string;
        if (n == 1) {
            string = Long.toString(l);
        } else {
            l = n == 3 ? (l <<= 20) : (l <<= 9);
            string = Util.formatBytes(l);
        }
        return string;
    }

    public AlertLogDetailPanel(ExtAlertLog extAlertLog) {
        super(new GridBagLayout());
        Object object;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 30;
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.bottom = 18;
        gridBagConstraints.anchor = 17;
        String string = MessageLog.getMessageNoID("GUI2035L");
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createHorizontalStrut(100), gridBagConstraints);
        gridBagConstraints = null;
        this.labelConstraint = new GridBagConstraints();
        this.labelConstraint.anchor = 17;
        this.labelConstraint.insets.left = 40;
        this.labelConstraint.insets.top = 0;
        this.labelConstraint.insets.right = 24;
        this.valueConstraint = new GridBagConstraints();
        this.valueConstraint.anchor = 17;
        this.valueConstraint.gridwidth = 0;
        this.valueConstraint.insets.top = this.labelConstraint.insets.top;
        this.logRecord = extAlertLog;
        if (extAlertLog.alComputerID > 0) {
            this.addIDPair("STG1102L", extAlertLog.alComputer);
        }
        if (extAlertLog.alViolatorType == 33) {
            string = CreateOrEditDDI.getObjectTypeName(extAlertLog.alResourceType);
            if (string != null) {
                this.addPair(string, extAlertLog.getAlObjectName());
            }
            if ((string = CreateOrEditDDI.getObjectTypeName(extAlertLog.alViolatorType)) != null) {
                this.addPair(string, Integer.toString(extAlertLog.alViolatorID));
            }
        } else {
            switch (extAlertLog.alProductID) {
                case 0: {
                    OSAlertLogTableData.addResourceDescription(extAlertLog, this);
                }
            }
        }
        string = (string = AlertConditionManager.getConditionMessageId(extAlertLog.alAlertCondition)) != null ? MessageLog.getMessageNoID(string) : "?";
        this.addIDPair("GUI2023L", string);
        string = Integer.toString(extAlertLog.alState);
        try {
            string = MessageLog.getMessageNoID(alertStates[extAlertLog.alState]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.add(Box.createVerticalStrut(12), gridBagConstraints);
        this.addIDPair("GUI2040L", string);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Date date = new Date(extAlertLog.alLastAlertTime);
        string = dateFormat.format(date);
        if (!AlertConditionManager.isAccumulate(extAlertLog.alAlertCondition)) {
            this.addIDPair("STG3065L", string);
        } else {
            date = new Date(extAlertLog.alFirstAlertTime);
            object = dateFormat.format(date);
            this.addIDPair("GUI2024L", (String)object);
            this.addIDPair("GUI2025L", string);
            this.addIDPair("GUI2031L", Integer.toString(extAlertLog.alAlertCount));
        }
        string = AlertConditionManager.getValueTypeLabelId(extAlertLog.alAlertCondition);
        if (string != null) {
            Object[] objectArray;
            byte by = AlertConditionManager.getValueFlags(extAlertLog.alAlertCondition);
            int n = by & 3;
            if (n == 2 && extAlertLog.alThresholdType == 1) {
                n = 1;
            }
            long l = extAlertLog.alViolatingValue;
            String string2 = this.format(l, n);
            string = MessageLog.getMessageNoID(string);
            int n2 = this.labelConstraint.insets.top;
            this.labelConstraint.insets.top = 12;
            this.valueConstraint.insets.top = 12;
            this.addPair(string, string2);
            this.labelConstraint.insets.top = n2;
            this.valueConstraint.insets.top = n2;
            if ((by & 0x10) == 0 && (l = (long)extAlertLog.alPreviousValue) >= 0L) {
                string2 = this.format(l, n);
                objectArray = new Object[]{string};
                string = MessageLog.getMessageNoID("GUI2032L", objectArray);
                this.addPair(string, string2);
            }
            if ((by & 4) != 0) {
                l = extAlertLog.alThresholdValue;
                objectArray = new StringBuffer(40);
                if ((by & 8) != 0) {
                    objectArray.append('<');
                } else {
                    objectArray.append('>');
                }
                objectArray.append(' ');
                if (extAlertLog.alThresholdType >= 3) {
                    objectArray.append(Util.formatBytes(l <<= 10));
                } else if (extAlertLog.alThresholdType == 2) {
                    objectArray.append(Long.toString(l));
                    objectArray.append('%');
                } else {
                    objectArray.append(Long.toString(l));
                }
                this.addIDPair("GUI2033L", objectArray.toString());
            }
            if ((by & 0x10) != 0) {
                string2 = this.format(extAlertLog.alPreviousValue, 2);
                this.addIDPair("STG4210L", string2);
                string2 = this.format(extAlertLog.alViolatorID, 2);
                this.addIDPair("STG4211L", string2);
            }
        }
        this.add(Box.createVerticalStrut(12), gridBagConstraints);
        this.addIDPair("GUI2027L", extAlertLog.alCreator);
        this.addIDPair("GUI2028L", extAlertLog.getAlName());
        this.add(Box.createVerticalStrut(12), gridBagConstraints);
        if (extAlertLog.alScriptComputerID > 0) {
            this.addIDPair("GUI2069L", extAlertLog.alScriptName);
            object = GuiUtil.getComputer(extAlertLog.alScriptComputerID);
            this.addIDPair("GUI2070L", ((GComputer)object).gcTSName);
            string = MessageLog.getMessageNoID("GUI0268L");
            JButton jButton = new JButton(string);
            jButton.setEnabled(!Util.isEmpty(extAlertLog.alScriptLogFile));
            jButton.setFont(BaseTree.boldFont);
            jButton.setActionCommand(SCRIPT_LOG);
            jButton.addActionListener(this);
            this.add(Box.createVerticalStrut(1), this.labelConstraint);
            this.add((Component)jButton, this.valueConstraint);
            this.add(Box.createVerticalStrut(12), gridBagConstraints);
        }
        if (!Util.isEmpty(extAlertLog.alJobLogFile)) {
            string = MessageLog.getMessageNoID("GUI0269L");
            object = new JButton(string);
            ((JComponent)object).setFont(BaseTree.boldFont);
            ((AbstractButton)object).setActionCommand(JOB_LOG);
            ((AbstractButton)object).addActionListener(this);
            this.add(Box.createVerticalStrut(1), this.labelConstraint);
            this.add((Component)object, this.valueConstraint);
            this.add(Box.createVerticalStrut(12), gridBagConstraints);
        }
        gridBagConstraints = null;
        this.labelConstraint.gridheight = 0;
        this.labelConstraint.anchor = 18;
        jLabel = new JLabel(MessageLog.getMessageNoID("GUI2034L"));
        jLabel.setFont(BaseTree.boldFont);
        jLabel.setForeground(Color.black);
        this.add((Component)jLabel, this.labelConstraint);
        object = new JTextArea();
        ((JTextComponent)object).setEditable(false);
        ((JTextArea)object).setLineWrap(true);
        ((JTextArea)object).setWrapStyleWord(true);
        ((JComponent)object).setBackground(this.getBackground());
        ((JTextComponent)object).setText(extAlertLog.alMessage);
        this.valueConstraint.gridheight = 0;
        this.valueConstraint.fill = 1;
        this.valueConstraint.weighty = 1.0;
        this.add((Component)object, this.valueConstraint);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == SCRIPT_LOG) {
            int n = this.logRecord.alScriptComputerID;
            String string2 = this.logRecord.alScriptLogFile;
            new LogViewer(n, null, string2);
        } else {
            int n = this.logRecord.alComputerID;
            String string3 = this.logRecord.alJobLogFile;
            new LogViewer(n, null, string3);
        }
    }
}

