/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.ListElementEditor;
import org.eclipse.aperi.gui.SizeLimitedDocument;

public class DefaultListEditor
extends JTextField
implements ListElementEditor,
DocumentListener,
ActionListener {
    private EditableList list;

    public DefaultListEditor(int n, EditableList editableList) {
        this.list = editableList;
        SizeLimitedDocument sizeLimitedDocument = new SizeLimitedDocument(n, false);
        this.setDocument(sizeLimitedDocument);
        sizeLimitedDocument.addDocumentListener(this);
        this.addActionListener(this);
    }

    public DefaultListEditor(int n) {
        this(n, null);
    }

    public void setList(EditableList editableList) {
        this.list = editableList;
    }

    public Object getObject() {
        String string = this.getText();
        this.setText("");
        return string;
    }

    public void setObject(Object object) {
        this.setText(object.toString());
        this.requestFocus();
    }

    public void objectRemoved(Object object) {
    }

    public Component getComponent() {
        return this;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.list.setAddEnabled(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        String string = this.getText();
        if (string == null || string.length() == 0) {
            this.list.setAddEnabled(false);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.getObject();
        if (string != null && string.length() > 0) {
            this.list.addObject(string);
        }
    }
}

