/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.accessibility.AccessibleContext;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.HelpBrokerTS;
import org.eclipse.aperi.gui.JobChangeManager;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public final class GuiUtil {
    public static final int TYPICAL_FIELD_HEIGHT = 20;
    public static final int TYPICAL_CONDITION_COMBO_WIDTH = 425;
    public static final int TYPICAL_VALUE_UNITS_FIELD_WIDTH = 190;
    private static final DecimalFormat dFmt = new DecimalFormat();
    private static final DecimalFormat ddFmt = new DecimalFormat("00");
    private static final DecimalFormat dddFmt = new DecimalFormat("000");
    private static final DecimalFormat d0Fmt = new DecimalFormat("###0");
    private static final DecimalFormat d2Fmt = new DecimalFormat("###0.00");
    private static GridBagConstraints gbcNorthWest = new GridBagConstraints();
    private static GridBagConstraints gbcSouthWest = new GridBagConstraints();
    private static GridBagConstraints gbcWest = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private static final int TOP_MARGIN = 4;
    private static final int BOTTOM_MARGIN = 6;
    private static final int LEFT_MARGIN = 10;
    private static final int RIGHT_MARGIN = 10;
    private static final Border aperiBorder = BorderFactory.createLineBorder(Color.darkGray);
    private static final String ERR_GET_COMP = MessageLog.getMessageNoID("GUI0016M");
    public static boolean sortOrderNotASCII = false;
    private static String userName;

    static {
        GuiUtil.gbcNorthWest.gridwidth = 0;
        GuiUtil.gbcWest.gridx = 0;
        GuiUtil.gbcWest.gridy = 1;
        GuiUtil.gbcWest.gridheight = -1;
        GuiUtil.gbcSouthWest.gridx = 0;
        GuiUtil.gbcSouthWest.gridwidth = 8;
        GuiUtil.gbcSouthWest.gridheight = 0;
        GuiUtil.gbcSouthWest.weighty = 1.0;
        GuiUtil.gbcLast.gridwidth = 0;
        GuiUtil.gbcLast.weightx = 1.0;
    }

    private GuiUtil() {
    }

    public static String formatElapsed(long l, boolean bl) {
        if (l < 0L) {
            return Util.getString("NA");
        }
        long l2 = l % 1000L;
        long l3 = l / 1000L;
        long l4 = l3 % 60L;
        long l5 = (l3 /= 60L) % 60L;
        long l6 = l3 / 60L;
        return new String(String.valueOf(l6) + ":" + ddFmt.format(l5) + ":" + ddFmt.format(l4) + (bl ? "." + dddFmt.format(l2) : " "));
    }

    public static String formatElapsed(int n) {
        if (n < 0) {
            return Util.getString("NA");
        }
        long l = n % 60;
        long l2 = n / 60;
        long l3 = l2 % 24L;
        long l4 = l2 / 24L;
        StringBuffer stringBuffer = new StringBuffer(50);
        if (l4 > 0L) {
            stringBuffer = stringBuffer.append(l4);
            stringBuffer = stringBuffer.append(" ");
            stringBuffer = stringBuffer.append(MessageLog.getMessageNoID("GUI0116L"));
            stringBuffer = stringBuffer.append("   ");
        }
        if (l3 > 0L) {
            stringBuffer = stringBuffer.append(l3);
            stringBuffer = stringBuffer.append(" ");
            stringBuffer = stringBuffer.append(MessageLog.getMessageNoID("GUI0117L"));
            stringBuffer = stringBuffer.append("   ");
        }
        stringBuffer = stringBuffer.append(l);
        stringBuffer = stringBuffer.append(" ");
        stringBuffer = stringBuffer.append(MessageLog.getMessageNoID("GUI0118L"));
        return stringBuffer.toString();
    }

    public static char getMnemonic(String string) {
        String string2 = null;
        try {
            try {
                string2 = Util.getString(string);
                if (string2.equals("")) {
                    string2 = "0";
                }
            }
            catch (Exception exception) {
                System.out.println("GuiUtil::getMnemonic() -- " + string + " not found in resource bundle.");
                string2 = "0";
            }
        }
        catch (Throwable throwable) {}
        return string2.trim().toUpperCase().charAt(0);
    }

    public static String getString(String string) {
        return Util.getString(string);
    }

    public static String getString(String string, String[] stringArray) {
        return Util.getString(string, stringArray);
    }

    public static String getString(String string, String string2) {
        return Util.getString(string, string2);
    }

    public static String getString(String string, String string2, String string3) {
        return Util.getString(string, string2, string3);
    }

    public static String cleanString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\f\r\t");
        if (stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static void setAccessible(Component component, String string, String string2) {
        AccessibleContext accessibleContext = null;
        try {
            accessibleContext = component.getAccessibleContext();
            accessibleContext.setAccessibleName(GuiUtil.resolveString(string));
            accessibleContext.setAccessibleDescription(GuiUtil.resolveString(string2));
        }
        catch (Exception exception) {}
    }

    public static void setAccessibleDescription(Component component, String string) {
        AccessibleContext accessibleContext = null;
        try {
            accessibleContext = component.getAccessibleContext();
            accessibleContext.setAccessibleDescription(GuiUtil.resolveString(string));
        }
        catch (Exception exception) {}
    }

    public static void setAccessibleLabel(JLabel jLabel, Component component, String string, String string2, String string3) {
        jLabel.setLabelFor(component);
        GuiUtil.setAccessible(component, string2, string3);
    }

    private static String resolveString(String string) {
        return Util.getString(string);
    }

    public static boolean wrapAtWords() {
        boolean bl = true;
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals(new Locale("ja", "", "").getLanguage()) || locale.getLanguage().equals(new Locale("ko", "", "").getLanguage()) || locale.getLanguage().equals(new Locale("zh", "", "").getLanguage())) {
            bl = false;
        }
        return bl;
    }

    public static ImageIcon createImageIcon(String string) {
        Class<?> clazz;
        ImageIcon imageIcon = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.GuiUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.gui.GuiUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            uRL = clazz2.getResource("images/" + string);
        }
        try {
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
        }
        catch (Exception exception) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.gui.GuiUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            imageIcon = new ImageIcon(clazz3.getResource("images/exclam.gif"));
            System.out.println("GuiUtil.createImageIcon() couldn't locate image " + string + ".");
        }
        return imageIcon;
    }

    public static ImageIcon createImageIcon(String string, String string2) {
        Class<?> clazz;
        ImageIcon imageIcon = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.GuiUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        URL uRL = clazz.getResource(string);
        if (uRL == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.gui.GuiUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            uRL = clazz2.getResource("images/" + string);
        }
        try {
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL, string2);
            }
        }
        catch (Exception exception) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("org.eclipse.aperi.gui.GuiUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            imageIcon = new ImageIcon(clazz3.getResource("images/exclam.gif"));
            System.out.println("GuiUtil.createImageIcon() couldn't locate image " + string + ".");
        }
        return imageIcon;
    }

    public static String formatDateTime(Date date) {
        return Util.formatDateTime(date);
    }

    public static String formatNumber(long l) {
        return NumberFormat.getInstance().format(l);
    }

    public static String formatNumber(double d) {
        return NumberFormat.getInstance().format(d);
    }

    public static boolean getConfirmation(Component component, String string, String string2, boolean bl) {
        int n;
        if (bl) {
            string = MessageLog.getMessageNoID(string);
            string2 = MessageLog.getMessageNoID(string2);
        }
        return (n = JOptionPane.showConfirmDialog(component, string2, string, 0)) == 0;
    }

    public static String displayOkCancelPane(String string, String string2, int n, boolean bl, String string3, String string4, Frame frame) {
        JComponent jComponent;
        int n2 = string2.length() - 3;
        if (n2 > 20) {
            n2 = 21;
        }
        if (n < n2) {
            n2 = n;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string2);
        TTextField tTextField = TTextField.newTTextField("x", n2, n, bl, true);
        if (string4 != null) {
            jComponent = new JTextArea();
            int n3 = string4.length() / 2;
            if (n3 < 100) {
                n3 += 100;
            }
            jComponent.setPreferredSize(new Dimension(400, n3));
            ((JTextComponent)jComponent).setText(string4);
            ((JTextComponent)jComponent).setEditable(false);
            ((JTextArea)jComponent).setFont(new Font("Serif", 1, 14));
            jComponent.setBackground(jPanel.getBackground());
            ((JTextArea)jComponent).setLineWrap(true);
            ((JTextArea)jComponent).setWrapStyleWord(true);
            jPanel.add((Component)jComponent, "First");
        }
        jPanel.add((Component)jLabel, "Center");
        jPanel.add((Component)tTextField, "Last");
        jComponent = new JOptionPane(jPanel, 3, 2);
        JDialog jDialog = ((JOptionPane)jComponent).createDialog(frame, string);
        tTextField.setText(string3);
        jDialog.show();
        Integer n4 = (Integer)((JOptionPane)jComponent).getValue();
        String string5 = n4 != null && n4 == 0 ? tTextField.getText() : null;
        return string5;
    }

    public static String displayOkCancelPane(String string, String string2, int n, boolean bl, String string3, Frame frame) {
        return GuiUtil.displayOkCancelPane(string, string2, n, bl, string3, null, frame);
    }

    public static String formatFilesystem(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(string);
        stringBuffer.append(" : ");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static void centerDialog(Component component) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - component.getWidth()) / 2;
        int n2 = (dimension.height - component.getHeight()) / 2;
        component.setLocation(n, n2);
    }

    public static Border getBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(aperiBorder, string);
        Font font = titledBorder.getTitleFont().deriveFont(1);
        titledBorder.setTitleFont(font);
        return titledBorder;
    }

    public static Border getBorder() {
        return aperiBorder;
    }

    public static JPanel getPanel() {
        JPanel jPanel = new JPanel();
        GuiUtil.initPanel(jPanel);
        return jPanel;
    }

    public static void initPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        jPanel.add(Box.createVerticalStrut(4), gbcNorthWest);
        jPanel.add(Box.createHorizontalStrut(10), gbcWest);
    }

    public static JPanel getBorderedPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(GuiUtil.getBorder());
        GuiUtil.initPanel(jPanel);
        return jPanel;
    }

    public static JPanel getTitledBorderedPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(GuiUtil.getBorder(string));
        GuiUtil.initPanel(jPanel);
        return jPanel;
    }

    public static void completePanel(JPanel jPanel) {
        jPanel.add(Box.createVerticalStrut(6), gbcSouthWest);
        jPanel.add(Box.createHorizontalStrut(10), gbcLast);
    }

    public static NameList sortNameList(NameList nameList) {
        if (!sortOrderNotASCII) {
            return nameList;
        }
        TreeMap<String, NameList> treeMap = new TreeMap<String, NameList>();
        while (nameList != null) {
            treeMap.put(nameList.toString(), nameList);
            nameList = nameList.nlNext;
        }
        NameList nameList2 = null;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            NameList nameList3 = (NameList)iterator.next();
            nameList3.nlNext = null;
            if (nameList2 != null) {
                nameList2.nlNext = nameList3;
            } else {
                nameList = nameList3;
            }
            nameList2 = nameList3;
        }
        return nameList;
    }

    public static boolean isAnyDiskArrayInstalled() {
        return true;
    }

    public static void setAllEnabled(Component component, boolean bl) {
        if (!(component instanceof JLabel)) {
            component.setEnabled(bl);
            if (component instanceof Container) {
                Container container = (Container)component;
                int n = container.getComponentCount();
                while (n > 0) {
                    GuiUtil.setAllEnabled(container.getComponent(--n), bl);
                }
            }
        }
    }

    public static HelpBrokerTS getHelpBroker() {
        Class<?> clazz;
        String string = "org/eclipse/aperi/gui/help/OS/storagealert.hs";
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.FilterResultsViewer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ClassLoader classLoader = clazz.getClassLoader();
        URL uRL = HelpSet.findHelpSet((ClassLoader)classLoader, (String)string);
        HelpSet helpSet = null;
        try {
            helpSet = new HelpSet(classLoader, uRL);
        }
        catch (Exception exception) {
            System.out.println("Help Set " + string + " not found");
            exception.printStackTrace();
        }
        return new HelpBrokerTS(helpSet);
    }

    public static Request newGUIRequest(String string) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.subType = string;
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.userName = GuiUtil.getUserName();
        request.flags = (byte)4;
        return request;
    }

    public static Request newGUIDeviceRequest(String string) {
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", string, DeviceRequest.DR_DISK);
        deviceRequest.serviceName = RequestTypeManager.getInternalName(deviceRequest.typeCode);
        deviceRequest.userName = GuiUtil.getUserName();
        deviceRequest.flags = (byte)4;
        return deviceRequest;
    }

    public static Request newGUIDeviceRequest(String string, short s, Serializable serializable) {
        DeviceRequest deviceRequest = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", string, s, serializable);
        deviceRequest.serviceName = RequestTypeManager.getInternalName(deviceRequest.typeCode);
        deviceRequest.userName = GuiUtil.getUserName();
        deviceRequest.flags = (byte)4;
        return deviceRequest;
    }

    public static boolean isIPFormatValid(String string) {
        return true;
    }

    public static String getUserName() {
        if (userName == null) {
            userName = System.getProperty("user.name", " ");
        }
        return userName;
    }

    public static void setUserName(String string) {
        userName = string;
    }

    public static boolean confirmDelete(Component component, String string) {
        Object object;
        String string2;
        if (string == null) {
            string2 = MessageLog.getMessageNoID("GUI0045L");
        } else {
            object = new Object[]{string};
            string2 = MessageLog.getMessageNoID("GUI0048L", object);
        }
        object = null;
        object = string == null ? MessageLog.getMessageNoID("GUI0100M", null) : Util.getString("CONFIRM_DELETE", string);
        JOptionPane jOptionPane = new JOptionPane();
        JDialog jDialog = jOptionPane.createDialog(component, string2);
        int n = JOptionPane.showConfirmDialog(jDialog, object, string2, 0);
        return n == 0;
    }

    public static boolean confirmDelete(Component component) {
        return GuiUtil.confirmDelete(component, null);
    }

    public static GComputer getComputer(int n) {
        GComputer gComputer;
        Integer n2 = new Integer(n);
        Hashtable<Integer, GComputer> hashtable = null;
        if (hashtable == null) {
            hashtable = new Hashtable<Integer, GComputer>();
            gComputer = GuiClient.getComputer(-2);
            while (gComputer != null) {
                hashtable.put(new Integer(gComputer.gcComputerID), gComputer);
                gComputer = gComputer.gcNext;
            }
        }
        if ((gComputer = (GComputer)hashtable.get(n2)) == null) {
            gComputer = GuiClient.getComputer(n);
            if (gComputer != null) {
                if (gComputer.gcManufacturer.toLowerCase().equals("unknown")) {
                    gComputer.gcManufacturer = MessageLog.getMessageNoID("GUI0129T");
                }
                hashtable.put(n2, gComputer);
            } else {
                gComputer = new GComputer();
                gComputer.gcComputerID = n;
                gComputer.gcTSName = ERR_GET_COMP;
                hashtable.put(n2, gComputer);
            }
        }
        return gComputer;
    }

    public static void displayException(GeneralException generalException) {
        GuiUtil.displayErrorMessage(generalException.getMessage());
    }

    public static void displayErrorMessage(String string) {
        Object object;
        String string2 = string.substring(0, 8);
        String string3 = string.substring(10);
        int n = 100;
        if (string3.length() > n) {
            int n2 = string3.length() / n;
            if (n2 * n != string3.length()) {
                ++n2;
            }
            if (n2 > 4) {
                n2 = 4;
            }
            object = new TextArea(string3, 1, 100);
            ((TextArea)object).setEditable(false);
        } else {
            object = string3;
        }
        JOptionPane.showMessageDialog(null, object, string2, 0);
    }

    public static boolean isJobDefintionNode(short s) {
        return s == 36 || s == 16 || s == 17 || s == 15 || s == 67 || s == 102 || s == 39 || s == 40 || s == 112 || s == 116;
    }

    public static boolean isDiscoveryNode(short s) {
        return s == 104 || s == 105 || s == 106 || s == 32;
    }

    public static void triggerJobChange(short s) {
        NameList nameList = new NameList();
        nameList.nlInfo = s;
        JobChangeManager.signalChange(1001, nameList);
    }
}

