/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.eclipse.aperi.common.Util;

public class SortTable
extends JTable {
    private int[] indexes = new int[0];
    private Vector sortingColumns = new Vector();
    private int sortedColumn = -1;
    private boolean ascending = true;
    private TableSorterArrow hRenderer = new TableSorterArrow();
    private MouseAdapter headMouseListener = new HeaderListener(this.hRenderer);
    public boolean sortInProgress = false;

    public SortTable() {
        this(null);
    }

    public SortTable(TableModel tableModel) {
        super(tableModel);
        this.tableHeader.addMouseListener(this.headMouseListener);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        int n = this.columnModel.getColumnCount() - 1;
        while (n >= 0) {
            this.columnModel.getColumn(n).setHeaderRenderer(this.hRenderer);
            --n;
        }
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5 = this.dataModel.getColumnClass(n3);
        Object object2 = this.dataModel.getValueAt(n, n3);
        Object object3 = this.dataModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        try {
            clazz4 = Class.forName("java.lang.Number");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz5.getSuperclass() == clazz4) {
            Number number;
            double d;
            Number number2 = (Number)this.dataModel.getValueAt(n, n3);
            double d2 = number2.doubleValue();
            if (d2 < (d = (number = (Number)this.dataModel.getValueAt(n2, n3)).doubleValue())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
        try {
            clazz3 = Class.forName("java.util.Date");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz5 == clazz3) {
            Date date;
            long l;
            Date date2 = (Date)this.dataModel.getValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (Date)this.dataModel.getValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz5 == clazz2) {
            String string2;
            String string3 = (String)this.dataModel.getValueAt(n, n3);
            int n4 = string3.compareTo(string2 = (String)this.dataModel.getValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        try {
            clazz = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz5 == clazz) {
            Boolean bl;
            boolean bl2;
            Boolean bl3 = (Boolean)this.dataModel.getValueAt(n, n3);
            boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)this.dataModel.getValueAt(n2, n3)).booleanValue())) {
                return 0;
            }
            if (bl4) {
                return 1;
            }
            return -1;
        }
        Object object4 = this.dataModel.getValueAt(n, n3);
        String string4 = object4.toString();
        int n5 = string4.compareTo(string = (object = this.dataModel.getValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int n, int n2) {
        int n3 = 0;
        while (n3 < this.sortingColumns.size()) {
            Integer n4 = (Integer)this.sortingColumns.elementAt(n3);
            int n5 = this.compareRowsByColumn(n, n2, n4);
            if (n5 != 0) {
                return this.ascending ? n5 : -n5;
            }
            ++n3;
        }
        return 0;
    }

    public void reallocateIndexes() {
        this.sortedColumn = -1;
        if (this.hRenderer != null) {
            this.hRenderer.setColumn(-1);
        }
        int n = this.dataModel.getRowCount();
        this.indexes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.indexes[n2] = n2;
            ++n2;
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.reallocateIndexes();
    }

    public void sort() {
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            int n6 = n;
            while (n6 < n2) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            return;
        }
        int n7 = n;
        while (n7 < n2) {
            nArray2[n7] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            ++n7;
        }
    }

    public void swap(int n, int n2) {
        int n3 = this.indexes[n];
        this.indexes[n] = this.indexes[n2];
        this.indexes[n2] = n3;
    }

    public Object getValueAt(int n, int n2) {
        return super.getValueAt(this.indexes[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, this.indexes[n], n2);
    }

    public void sortByColumn(int n) {
        if (n != this.sortedColumn) {
            this.sortByColumn(n, true);
        } else {
            this.sortByColumn(n, !this.ascending);
        }
        super.tableChanged(new TableModelEvent(this.getModel()));
    }

    public int convertRowToIndex(int n) {
        return this.indexes[n];
    }

    public int convertIndexToRow(int n) {
        int n2 = this.indexes.length - 1;
        while (n2 >= 0 && this.indexes[n2] != n) {
            --n2;
        }
        return n2;
    }

    public int getSelectedIndex() {
        int n = this.getSelectedRow();
        return n >= 0 ? this.convertRowToIndex(n) : -1;
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortedColumn = n;
        this.hRenderer.setColumn(n);
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        int n2 = this.getSelectedIndex();
        this.sort();
        if (n2 != -1) {
            int n3 = this.convertIndexToRow(n2);
            this.sortInProgress = true;
            this.setRowSelectionInterval(n3, n3);
            this.sortInProgress = false;
        }
    }

    class HeaderListener
    extends MouseAdapter {
        TableSorterArrow hRenderer;
        int mouseColumn;

        HeaderListener(TableSorterArrow tableSorterArrow) {
            this.hRenderer = tableSorterArrow;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.mouseColumn = SortTable.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            if (mouseEvent.getClickCount() == 1 && this.mouseColumn != -1) {
                boolean bl;
                boolean bl2 = bl = (mouseEvent.getModifiers() & 1) != 0;
                if (bl) {
                    SortTable.this.sortByColumn(SortTable.this.convertColumnIndexToModel(this.mouseColumn), false);
                } else {
                    SortTable.this.sortByColumn(SortTable.this.convertColumnIndexToModel(this.mouseColumn));
                }
            }
        }
    }

    class TableSorterArrow
    extends JButton
    implements TableCellRenderer {
        JButton downButton;
        JButton upButton;
        int dataColumn = -1;

        public TableSorterArrow() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setHorizontalTextPosition(2);
            this.setIcon(new BlankIcon());
            this.downButton = new JButton();
            this.downButton.setMargin(new Insets(0, 0, 0, 0));
            this.downButton.setHorizontalTextPosition(2);
            this.downButton.setIcon(new DownArrowIcon());
            this.downButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_DESCENDING"));
            this.upButton = new JButton();
            this.upButton.setMargin(new Insets(0, 0, 0, 0));
            this.upButton.setHorizontalTextPosition(2);
            this.upButton.setIcon(new UpArrowIcon());
            this.upButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_ASCENDING"));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JButton jButton = this;
            if (this.dataColumn != -1 && n2 == jTable.convertColumnIndexToView(this.dataColumn)) {
                jButton = SortTable.this.ascending ? this.upButton : this.downButton;
            }
            jButton.setText(object == null ? "" : object.toString());
            return jButton;
        }

        public void setColumn(int n) {
            this.dataColumn = n;
        }

        private class UpArrowIcon
        implements Icon,
        UIResource {
            private UpArrowIcon() {
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 11;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
                graphics.translate(n, n2);
                int n3 = 0;
                while (n3 <= 5) {
                    graphics.drawLine(6 - n3, 3 + n3, 6 + n3, 3 + n3);
                    ++n3;
                }
                graphics.translate(-n, -n2);
            }
        }

        private class DownArrowIcon
        implements Icon,
        UIResource {
            private DownArrowIcon() {
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 11;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
                graphics.translate(n, n2);
                int n3 = 0;
                while (n3 <= 5) {
                    graphics.drawLine(6 - n3, 8 - n3, 6 + n3, 8 - n3);
                    ++n3;
                }
                graphics.translate(-n, -n2);
            }
        }

        private class BlankIcon
        implements Icon,
        UIResource {
            private BlankIcon() {
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 11;
            }
        }
    }
}

