/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.Selector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.xmsg.MessageLog;

public class TreeSelector
extends Selector
implements TreeSelectionListener,
MouseListener,
KeyListener {
    protected JTree sourceTree;
    protected JTree selectedTree;
    private int configuredCleanupDepth = 1;
    boolean multipleObjectsDisallowed = false;
    boolean returningDbTsSubtree = false;
    private static final int EXCLUDE_ROOT = Integer.MIN_VALUE;
    private Map excludeMap;
    private Reparenter reparenter;

    public static void expandAll(JTree jTree) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode2.getChildCount() > 0) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
            treePath = treePath.getParentPath();
            jTree.expandPath(treePath);
        }
    }

    public void setCleanupDepth(int n) {
        this.configuredCleanupDepth = n;
    }

    public void setUpExcludes() {
        this.excludeMap = new HashMap();
        TreeSelectorNode treeSelectorNode = this.getExcludeRoot();
        if (treeSelectorNode != null) {
            Enumeration<TreeNode> enumeration = treeSelectorNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
                if (!treeSelectorNode2.excludable) continue;
                ExcludeList excludeList = new ExcludeList();
                excludeList.excluded = true;
                NameList nameList = treeSelectorNode2.getNameList();
                MutableInteger mutableInteger = new MutableInteger(nameList.nlID);
                this.excludeMap.put(mutableInteger, excludeList);
                treeSelectorNode2.excludeParents = excludeList;
            }
        }
        TreeSelector.expandAll(this.selectedTree);
    }

    public TreeSelector(JTree jTree, JTree jTree2, Reparenter reparenter, boolean bl) {
        super(jTree, jTree2, bl);
        this.sourceTree = jTree;
        this.selectedTree = jTree2;
        this.setTreeOptions(jTree);
        this.setTreeOptions(jTree2);
        jTree.putClientProperty("JTree.lineStyle", "Angled");
        jTree2.putClientProperty("JTree.lineStyle", "Angled");
        this.setUpExcludes();
        jTree2.addMouseListener(this);
        jTree.addMouseListener(this);
        this.reparenter = reparenter;
        jTree.setSelectionRow(0);
        jTree2.setSelectionRow(0);
    }

    public TreeSelector(JTree jTree, JTree jTree2, Reparenter reparenter) {
        this(jTree, jTree2, reparenter, false);
    }

    public TreeSelector(JTree jTree, JTree jTree2, boolean bl) {
        this(jTree, jTree2, null, bl);
    }

    public TreeSelector(JTree jTree, JTree jTree2) {
        this(jTree, jTree2, null, false);
    }

    private void setTreeOptions(JTree jTree) {
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.addTreeSelectionListener(this);
        jTree.setCellRenderer(new NameListTreeCellRenderer());
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.sourceTree.clearSelection();
            this.selectedTree.clearSelection();
        }
        this.sourceTree.setEnabled(bl);
        this.selectedTree.setEnabled(bl);
        this.setEnabledPane(this.rightPane, bl);
        this.setEnabledPane(this.leftPane, bl);
    }

    private void setEnabledPane(JPanel jPanel, boolean bl) {
        Component[] componentArray = jPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
    }

    public void disableMultipleSelection() {
        this.multipleObjectsDisallowed = true;
    }

    public void returnEntireDbTsSubtree() {
        this.returningDbTsSubtree = true;
    }

    public NameList getNameList() {
        return this.getNameList(this.selectedTree);
    }

    private NameList getNameList(JTree jTree) {
        NameList nameList = null;
        NameList nameList2 = null;
        String string = null;
        if (this.returningDbTsSubtree) {
            string = MessageLog.getMessageNoID("DBG0518L");
        }
        boolean bl = false;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = treeSelectorNode.preorderEnumeration();
        TreeSelectorNode treeSelectorNode2 = null;
        while (enumeration.hasMoreElements()) {
            treeSelectorNode = (TreeSelectorNode)enumeration.nextElement();
            NameList nameList3 = treeSelectorNode.getNameList();
            if (this.returningDbTsSubtree && nameList3.nlName != null && string.compareTo(nameList3.nlName) == 0) {
                bl = true;
            }
            if (nameList3.nlID <= 0 && !bl) continue;
            if (treeSelectorNode.expandOnRightOnly) {
                treeSelectorNode2 = treeSelectorNode;
            } else if (treeSelectorNode.isNodeAncestor(treeSelectorNode2)) continue;
            if (!treeSelectorNode.selectable && !treeSelectorNode.excludable && !bl) continue;
            nameList3.nlNext = null;
            if (nameList == null) {
                nameList = nameList3;
            } else {
                nameList2.nlNext = nameList3;
            }
            nameList2 = nameList3;
        }
        return nameList;
    }

    public NameList getReportingNameList() {
        return this.getReportingNameList(this.selectedTree);
    }

    private NameList getReportingNameList(JTree jTree) {
        NameList nameList = null;
        NameList nameList2 = null;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)defaultTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = treeSelectorNode.preorderEnumeration();
        TreeSelectorNode treeSelectorNode2 = null;
        while (enumeration.hasMoreElements()) {
            treeSelectorNode = (TreeSelectorNode)enumeration.nextElement();
            NameList nameList3 = treeSelectorNode.getNameList();
            if (nameList3.nlID <= 0) continue;
            if (treeSelectorNode.expandOnRightOnly) {
                treeSelectorNode2 = treeSelectorNode;
            } else if (treeSelectorNode.isNodeAncestor(treeSelectorNode2)) continue;
            nameList3.nlNext = null;
            if (nameList == null) {
                nameList = nameList3;
            } else {
                nameList2.nlNext = nameList3;
            }
            nameList2 = nameList3;
        }
        return nameList;
    }

    public void exclude(TreePath treePath) {
        Comparable comparable;
        TreeSelectorNode treeSelectorNode = this.getExcludeRoot();
        if (treeSelectorNode == null) {
            treeSelectorNode = TreeSelector.addExcludeRoot(this.selectedTree);
        }
        TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)treePath.getLastPathComponent();
        NameList nameList = treeSelectorNode2.getNameList();
        nameList.nlState = (byte)(nameList.nlState | 1);
        ExcludeList excludeList = treeSelectorNode2.excludeParents;
        excludeList.excluded = true;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
        int n = excludeList.size();
        TreeNode[] treeNodeArray = new TreeNode[n];
        Iterator iterator = excludeList.iterator();
        while (n > 0) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)iterator.next();
            treeNodeArray[--n] = mutableTreeNode.getParent();
            iterator.remove();
            defaultTreeModel.removeNodeFromParent(mutableTreeNode);
        }
        while (n < treeNodeArray.length) {
            excludeList.add(treeNodeArray[n]);
            ++n;
        }
        Object[] objectArray = treePath.getParentPath().getPath();
        int n2 = 1;
        if (this.reparenter != null) {
            comparable = new MutableInteger(n2);
            treeSelectorNode = this.reparenter.reparent(treeSelectorNode, nameList, (MutableInteger)comparable);
            n2 = comparable.value;
        }
        comparable = this.getToParent(defaultTreeModel, objectArray, treePath.getPathCount() - n2, treeSelectorNode);
        this.addChild(defaultTreeModel, (TreeSelectorNode)comparable, treeSelectorNode2);
        treeSelectorNode2.setButtonFlag(false);
        TreePath treePath2 = new TreePath(treeSelectorNode2.getPath());
        this.selectedTree.makeVisible(treePath2);
        this.selectedTree.getSelectionModel().setSelectionPath(treePath2);
    }

    private TreeSelectorNode getExcludeRoot() {
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)this.selectedTree.getModel().getRoot();
        if (treeSelectorNode.getChildCount() > 0) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)treeSelectorNode.getLastChild();
            if (treeSelectorNode2.getNameList().nlID == Integer.MIN_VALUE) {
                return treeSelectorNode2;
            }
        }
        return null;
    }

    public void pruneExcluded(TreeSelectorNode treeSelectorNode) {
        TreeSelectorNode treeSelectorNode2;
        TreeSelectorNode treeSelectorNode3 = this.getExcludeRoot();
        Enumeration<TreeNode> enumeration = treeSelectorNode.depthFirstEnumeration();
        TreeSelectorNode treeSelectorNode4 = null;
        LinkedList<TreeSelectorNode> linkedList = new LinkedList<TreeSelectorNode>();
        MutableInteger mutableInteger = new MutableInteger();
        while (enumeration.hasMoreElements()) {
            treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
            if (!treeSelectorNode2.excludable) continue;
            NameList nameList = treeSelectorNode2.getNameList();
            mutableInteger.value = nameList.nlID;
            ExcludeList excludeList = (ExcludeList)this.excludeMap.get(mutableInteger);
            if (excludeList == null) {
                excludeList = new ExcludeList();
                excludeList.excluded = false;
                this.excludeMap.put(mutableInteger, excludeList);
                mutableInteger = new MutableInteger();
            }
            treeSelectorNode2.excludeParents = excludeList;
            if (!excludeList.excluded) {
                excludeList.add(treeSelectorNode2);
                continue;
            }
            excludeList.add(treeSelectorNode2.getParent());
            boolean bl = false;
            Enumeration<TreeNode> enumeration2 = treeSelectorNode3.depthFirstEnumeration();
            while (!bl && enumeration2.hasMoreElements()) {
                treeSelectorNode4 = (TreeSelectorNode)enumeration2.nextElement();
                if (!treeSelectorNode4.excludable) continue;
                nameList = treeSelectorNode4.getNameList();
                if (nameList.nlID != mutableInteger.value) continue;
                bl = true;
            }
            if (!bl) continue;
            linkedList.add(treeSelectorNode2);
        }
        if (linkedList.size() > 0) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                treeSelectorNode2 = (TreeSelectorNode)iterator.next();
                defaultTreeModel.removeNodeFromParent(treeSelectorNode2);
            }
        }
    }

    public void unExclude(TreePath treePath) {
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)treePath.getLastPathComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
        defaultTreeModel.removeNodeFromParent(treeSelectorNode);
        Object[] objectArray = treePath.getParentPath().getPath();
        this.cleanupPath(defaultTreeModel, objectArray, objectArray.length - 1, 0);
        ExcludeList excludeList = treeSelectorNode.excludeParents;
        if (excludeList == null) {
            return;
        }
        excludeList.excluded = false;
        int n = excludeList.size();
        if (n <= 0) {
            return;
        }
        NameList nameList = treeSelectorNode.getNameList();
        nameList.nlState = (byte)(nameList.nlState & 0xFFFFFFFE);
        TreeSelectorNode[] treeSelectorNodeArray = new TreeSelectorNode[n];
        Iterator iterator = excludeList.iterator();
        while (n > 0) {
            TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)iterator.next();
            treeSelectorNodeArray[--n] = new TreeSelectorNode(nameList, treeSelectorNode.selectable, true, treeSelectorNode.getAllowsChildren(), treeSelectorNode.expandOnRightOnly, treeSelectorNode.selectErrorMsgID, treeSelectorNode2.showClusterName, treeSelectorNode2.showVsName);
            treeSelectorNodeArray[n].excludeParents = excludeList;
            treeSelectorNodeArray[n].setButtonFlag(treeSelectorNodeArray[n].canSelect());
            iterator.remove();
            this.addChild(defaultTreeModel, treeSelectorNode2, treeSelectorNodeArray[n]);
        }
        while (n < treeSelectorNodeArray.length) {
            excludeList.add(treeSelectorNodeArray[n]);
            ++n;
        }
        TreePath treePath2 = new TreePath(treeSelectorNode.getPath());
        this.selectedTree.getSelectionModel().setSelectionPath(treePath2);
    }

    public void pruneSelected(TreeSelectorNode treeSelectorNode, int n) {
        TreeSelectorNode treeSelectorNode2;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
        Enumeration<TreeNode> enumeration = ((TreeSelectorNode)defaultTreeModel.getRoot()).children();
        do {
            if (!enumeration.hasMoreElements()) {
                return;
            }
            treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
        } while (treeSelectorNode2.hiOrderSortKey != n);
        defaultTreeModel = (DefaultTreeModel)this.sourceTree.getModel();
        Enumeration<TreeNode> enumeration2 = treeSelectorNode2.depthFirstEnumeration();
        block1: while (enumeration2.hasMoreElements()) {
            TreeSelectorNode treeSelectorNode3 = (TreeSelectorNode)enumeration2.nextElement();
            if (!treeSelectorNode3.selectable) continue;
            Enumeration<TreeNode> enumeration3 = treeSelectorNode.depthFirstEnumeration();
            while (enumeration3.hasMoreElements()) {
                TreeSelectorNode treeSelectorNode4 = (TreeSelectorNode)enumeration3.nextElement();
                if (treeSelectorNode4.compareTo(treeSelectorNode3) != 0) continue;
                TreeSelectorNode treeSelectorNode5 = (TreeSelectorNode)treeSelectorNode4.getParent();
                Object[] objectArray = treeSelectorNode5.getPath();
                defaultTreeModel.removeNodeFromParent(treeSelectorNode4);
                this.cleanupPath(defaultTreeModel, objectArray, objectArray.length - 1, 1);
                continue block1;
            }
        }
    }

    public static TreeSelectorNode makeExcludeRoot() {
        NameList nameList = new NameList();
        nameList.nlName = MessageLog.getMessageNoID("GUI0248L");
        nameList.nlID = Integer.MIN_VALUE;
        nameList.nlInfo = (short)-1;
        TreeSelectorNode treeSelectorNode = new TreeSelectorNode(nameList, false, false, true);
        treeSelectorNode.setButtonFlag(false);
        treeSelectorNode.setSortKey(Short.MAX_VALUE);
        return treeSelectorNode;
    }

    private static TreeSelectorNode addExcludeRoot(JTree jTree) {
        TreeSelectorNode treeSelectorNode = TreeSelector.makeExcludeRoot();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)defaultTreeModel.getRoot();
        defaultTreeModel.insertNodeInto(treeSelectorNode, treeSelectorNode2, treeSelectorNode2.getChildCount());
        return treeSelectorNode;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        boolean bl = false;
        JTree jTree = (JTree)treeSelectionEvent.getSource();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        TreeSelectionModel treeSelectionModel = null;
        TreeSelectorNode treeSelectorNode = null;
        if (treePathArray != null) {
            int n = 0;
            while (n < treePathArray.length) {
                treeSelectorNode = (TreeSelectorNode)treePathArray[n].getLastPathComponent();
                if (treeSelectorNode.selectable) {
                    bl = true;
                }
                ++n;
            }
        }
        if (jTree == this.sourceTree) {
            this.addButton.setEnabled(bl);
            if (bl) {
                this.delButton.setEnabled(false);
                treeSelectionModel = this.selectedTree.getSelectionModel();
                treePathArray = treeSelectionModel.getSelectionPaths();
                if (treePathArray != null) {
                    treeSelectionModel.removeSelectionPaths(treePathArray);
                }
            }
        } else {
            this.delButton.setEnabled(bl);
            if (bl) {
                this.addButton.setEnabled(false);
                treeSelectionModel = this.sourceTree.getSelectionModel();
                treePathArray = treeSelectionModel.getSelectionPaths();
                if (treePathArray != null) {
                    treeSelectionModel.removeSelectionPaths(treePathArray);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.addButton) {
                if (this.multipleObjectsDisallowed) {
                    this.removeSelection();
                }
                this.processSelections(this.sourceTree, this.selectedTree);
                this.addButton.setEnabled(false);
                this.sourceTree.setSelectionRow(0);
                this.sourceTree.requestFocus();
            } else if (jButton == this.delButton) {
                this.processSelections(this.selectedTree, this.sourceTree);
                this.delButton.setEnabled(false);
                this.selectedTree.setSelectionRow(0);
                this.selectedTree.requestFocus();
            }
        }
    }

    private void removeNode(List list, TreeSelectorNode treeSelectorNode) {
        if (list.size() <= 0) {
            return;
        }
        list.remove(treeSelectorNode);
        if (list.size() <= 0) {
            NameList nameList = treeSelectorNode.getNameList();
            MutableInteger mutableInteger = new MutableInteger(nameList.nlID);
            this.excludeMap.remove(mutableInteger);
        }
    }

    private void purgeFromExcluded(TreeSelectorNode treeSelectorNode, TreeSelectorNode treeSelectorNode2) {
        Enumeration<TreeNode> enumeration = treeSelectorNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeSelectorNode treeSelectorNode3 = (TreeSelectorNode)enumeration.nextElement();
            if (treeSelectorNode3.excludeParents == null) continue;
            this.removeNode(treeSelectorNode3.excludeParents, treeSelectorNode2);
        }
    }

    public void nodeUnselected(TreeSelectorNode treeSelectorNode) {
        Cloneable cloneable;
        TreeSelectorNode treeSelectorNode2;
        Enumeration<TreeNode> enumeration;
        int n = -1;
        if (treeSelectorNode.getChildCount() > 0) {
            enumeration = treeSelectorNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
                int n2 = treeSelectorNode2.getLevel();
                if (n2 > n) {
                    n = n2;
                }
                if (!treeSelectorNode2.excludable || (cloneable = treeSelectorNode2.excludeParents) == null) continue;
                this.removeNode((List)((Object)cloneable), treeSelectorNode2);
            }
        }
        if ((cloneable = this.getExcludeRoot()) == null) {
            return;
        }
        if ((n -= treeSelectorNode.getLevel()) <= 1) {
            this.purgeFromExcluded((TreeSelectorNode)cloneable, treeSelectorNode);
        } else {
            enumeration = treeSelectorNode.children();
            while (enumeration.hasMoreElements()) {
                treeSelectorNode2 = (TreeSelectorNode)enumeration.nextElement();
                this.purgeFromExcluded((TreeSelectorNode)cloneable, treeSelectorNode2);
            }
        }
    }

    public void processSelections(JTree jTree, JTree jTree2) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        DefaultTreeModel defaultTreeModel2 = (DefaultTreeModel)jTree2.getModel();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray != null) {
            int n = 0;
            while (n < treePathArray.length) {
                TreePath treePath = treePathArray[n];
                TreeSelectorNode treeSelectorNode = (TreeSelectorNode)treePath.getLastPathComponent();
                if (treeSelectorNode.selectable) {
                    defaultTreeModel.removeNodeFromParent(treeSelectorNode);
                    if (jTree2 == this.sourceTree && treeSelectorNode.expandOnRightOnly) {
                        this.nodeUnselected(treeSelectorNode);
                    }
                    Object[] objectArray = treePath.getParentPath().getPath();
                    TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)defaultTreeModel2.getRoot();
                    boolean bl = treeSelectorNode2.getChildCount() == 0;
                    TreeSelectorNode treeSelectorNode3 = this.getToParent(defaultTreeModel2, objectArray, 1, treeSelectorNode2);
                    this.addChild(defaultTreeModel2, treeSelectorNode3, treeSelectorNode);
                    treeSelectorNode.getNameList();
                    int n2 = 0;
                    if (jTree2 == this.selectedTree) {
                        n2 = this.configuredCleanupDepth;
                        jTree2.makeVisible(new TreePath(treeSelectorNode.getPath()));
                    } else if (bl) {
                        jTree2.makeVisible(new TreePath(treeSelectorNode.getPath()));
                    }
                    this.cleanupPath(defaultTreeModel, objectArray, objectArray.length - 1, n2);
                }
                ++n;
            }
        }
    }

    public void removeSelection() {
        int n = this.selectedTree.getRowCount();
        if (n > 0) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.selectedTree.getModel();
            DefaultTreeModel defaultTreeModel2 = (DefaultTreeModel)this.sourceTree.getModel();
            TreePath treePath = this.selectedTree.getPathForRow(n - 1);
            TreeSelectorNode treeSelectorNode = (TreeSelectorNode)treePath.getLastPathComponent();
            defaultTreeModel.removeNodeFromParent(treeSelectorNode);
            Object[] objectArray = treePath.getParentPath().getPath();
            TreeSelectorNode treeSelectorNode2 = this.getToParent(defaultTreeModel2, objectArray, 1, (TreeSelectorNode)defaultTreeModel2.getRoot());
            this.addChild(defaultTreeModel2, treeSelectorNode2, treeSelectorNode);
            this.cleanupPath(defaultTreeModel, objectArray, objectArray.length - 1, 0);
        }
    }

    private TreeSelectorNode getToParent(DefaultTreeModel defaultTreeModel, Object[] objectArray, int n, TreeSelectorNode treeSelectorNode) {
        if (n == objectArray.length) {
            return treeSelectorNode;
        }
        TreeSelectorNode treeSelectorNode2 = (TreeSelectorNode)objectArray[n];
        TreeSelectorNode treeSelectorNode3 = null;
        int n2 = 0;
        Enumeration<TreeNode> enumeration = treeSelectorNode.children();
        while (enumeration.hasMoreElements()) {
            TreeSelectorNode treeSelectorNode4 = (TreeSelectorNode)enumeration.nextElement();
            int n3 = treeSelectorNode4.compareTo(treeSelectorNode2);
            if (n3 == 0) {
                treeSelectorNode3 = treeSelectorNode4;
                break;
            }
            if (n3 > 0 && !treeSelectorNode2.isNonClusteredLabel) break;
            ++n2;
        }
        if (treeSelectorNode3 == null) {
            treeSelectorNode3 = (TreeSelectorNode)treeSelectorNode2.clone();
            treeSelectorNode3.selectable = false;
            treeSelectorNode3.expandOnRightOnly = false;
            defaultTreeModel.insertNodeInto(treeSelectorNode3, treeSelectorNode, n2);
        }
        return this.getToParent(defaultTreeModel, objectArray, ++n, treeSelectorNode3);
    }

    public void addChild(DefaultTreeModel defaultTreeModel, TreeSelectorNode treeSelectorNode, TreeSelectorNode treeSelectorNode2) {
        int n = 0;
        Enumeration<TreeNode> enumeration = treeSelectorNode.children();
        while (enumeration.hasMoreElements()) {
            TreeSelectorNode treeSelectorNode3 = (TreeSelectorNode)enumeration.nextElement();
            if (treeSelectorNode3.compareTo(treeSelectorNode2) > 0) break;
            ++n;
        }
        if (treeSelectorNode2.expandOnRightOnly) {
            boolean bl;
            boolean bl2 = bl = defaultTreeModel == this.selectedTree.getModel();
            if (!bl) {
                treeSelectorNode2.removeAllChildren();
                treeSelectorNode2.childrenFetched = false;
            }
            treeSelectorNode2.setAllowsChildren(true);
        }
        defaultTreeModel.insertNodeInto(treeSelectorNode2, treeSelectorNode, n);
    }

    private void cleanupPath(DefaultTreeModel defaultTreeModel, Object[] objectArray, int n, int n2) {
        if (n <= n2) {
            return;
        }
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)objectArray[n];
        if (treeSelectorNode.getChildCount() == 0) {
            defaultTreeModel.removeNodeFromParent(treeSelectorNode);
            this.cleanupPath(defaultTreeModel, objectArray, n - 1, n2);
        }
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent.getSource() != this.selectedTree) {
            return;
        }
        if (this.selectedTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) > -1) {
            TreePath treePath = this.selectedTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreeSelectorNode treeSelectorNode = (TreeSelectorNode)treePath.getLastPathComponent();
            if (treeSelectorNode.excludable) {
                NameList nameList = treeSelectorNode.getNameList();
                this.showPopupMenu(mouseEvent, treePath, nameList);
            }
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent, TreePath treePath, NameList nameList) {
        Component component = mouseEvent.getComponent();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem();
        if ((nameList.nlState & 1) == 0) {
            jMenuItem.setText(MessageLog.getMessageNoID("STG4031L"));
        } else {
            jMenuItem.setText(MessageLog.getMessageNoID("STG4035L"));
        }
        ExcludeListener excludeListener = new ExcludeListener(treePath, nameList);
        jMenuItem.addActionListener(excludeListener);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(component, n, n2);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        JTree jTree;
        int n;
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (!(object instanceof JTree)) {
            return;
        }
        JTree jTree2 = (JTree)object;
        int n2 = mouseEvent.getX();
        TreePath treePath = jTree2.getPathForLocation(n2, n = mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        TreeSelectorNode treeSelectorNode = (TreeSelectorNode)treePath.getLastPathComponent();
        if (!treeSelectorNode.selectable) {
            return;
        }
        if (!treeSelectorNode.getButtonFlag()) {
            return;
        }
        if (jTree2 == this.selectedTree) {
            jTree = this.sourceTree;
        } else {
            if (this.multipleObjectsDisallowed) {
                this.removeSelection();
            }
            jTree = this.selectedTree;
        }
        this.processSelections(jTree2, jTree);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isAltDown() && keyEvent.getKeyCode() == 65) {
            this.sourceTree.setSelectionRow(0);
            this.sourceTree.requestFocus();
        } else if (keyEvent.isAltDown() && keyEvent.getKeyCode() == 78) {
            this.selectedTree.setSelectionRow(0);
            this.selectedTree.requestFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public NameList getSelectedList() {
        return this.getNameList(this.selectedTree);
    }

    public NameList getAvailableList() {
        return this.getNameList(this.sourceTree);
    }

    public void replaceTrees(JTree jTree, JTree jTree2) {
        this.selectedTree.setModel(jTree2.getModel());
        this.sourceTree.setModel(jTree.getModel());
        this.sourceTree.setSelectionRow(0);
        this.selectedTree.setSelectionRow(0);
    }

    public void disableAddButton() {
        this.addButton.setEnabled(false);
    }

    public static class ExcludeList
    extends LinkedList {
        public boolean excluded;
    }

    public static interface Reparenter {
        public TreeSelectorNode reparent(TreeSelectorNode var1, NameList var2, MutableInteger var3);
    }

    private class ExcludeListener
    implements ActionListener {
        private TreePath path;
        private NameList name;

        public ExcludeListener(TreePath treePath, NameList nameList) {
            this.path = treePath;
            this.name = nameList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((this.name.nlState & 1) == 0) {
                TreeSelector.this.exclude(this.path);
            } else {
                TreeSelector.this.unExclude(this.path);
            }
        }
    }
}

