/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.AgentListPanel;
import org.eclipse.aperi.gui.admin.agent.CimomAgentTableModel;
import org.eclipse.aperi.gui.common.CIMOMMgmtAddCIMOMDialog;
import org.eclipse.aperi.gui.config.service.CimomManagedDeviceDialog;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.CimomManagedDeviceReq;

public class CimomAgentListPanel
extends AgentListPanel {
    private JButton addCimomButton = null;
    private JButton testConnectionButton = null;
    private JButton removeCimomButton = null;
    private JButton deviceBtn = null;

    public CimomAgentListPanel(AgentListDDI agentListDDI) {
        super(agentListDDI);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        this.addCimomButton = this.getButton(GuiUtil.getString("CIMOM_MGMT_ADD"));
        this.addCimomButton.setToolTipText(GuiUtil.getString("CIMOM_MGMT_ADD_TIP"));
        this.addCimomButton.setEnabled(this.capabilities.isAperiAdmin());
        this.testConnectionButton = this.getButton(GuiUtil.getString("CIMOM_MGMT_TST"));
        this.testConnectionButton.setToolTipText(GuiUtil.getString("CIMOM_MGMT_TST_TIP"));
        this.removeCimomButton = this.getButton(GuiUtil.getString("CIMOM_MGMT_REM"));
        this.removeCimomButton.setToolTipText(GuiUtil.getString("CIMOM_MGMT_REM_TIP"));
        this.deviceBtn = this.getButton(GuiUtil.getString("CONFIG_CIMAGENT_BUTTON_SHOW_DEVICES"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.addCimomButton);
        jPanel2.add(this.testConnectionButton);
        jPanel2.add(this.removeCimomButton);
        jPanel2.add(this.deviceBtn);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    void disableAllButtons() {
        this.testConnectionButton.setEnabled(false);
        this.removeCimomButton.setEnabled(false);
        this.deviceBtn.setEnabled(false);
    }

    void chooseButtons(Object object) {
        boolean bl;
        boolean bl2 = bl = object instanceof Vector && ((Vector)object).size() > 1;
        if (!bl) {
            this.testConnectionButton.setEnabled(true);
            this.deviceBtn.setEnabled(true);
        } else {
            this.testConnectionButton.setEnabled(false);
            this.deviceBtn.setEnabled(false);
        }
        this.removeCimomButton.setEnabled(this.capabilities.isAperiAdmin());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        actionEvent.getActionCommand();
        int[] nArray = this.getTable().getSelectedRows();
        CIMOM[] cIMOMArray = new CIMOM[nArray.length];
        AgentListPanel cfr_ignored_0 = (AgentListPanel)this.getDDI().panel;
        int n = 0;
        while (n < cIMOMArray.length) {
            cIMOMArray[n] = (CIMOM)this.getDDI().elementAt(nArray[n]);
            ++n;
        }
        if (object == this.addCimomButton) {
            new CIMOMMgmtAddCIMOMDialog(guiMain.getFrame(), GuiUtil.getString("CIMOM_MGMT_ADD_TITLE"), this.getDDI());
        } else if (object == this.testConnectionButton) {
            this.testConnection(cIMOMArray[0]);
        } else if (object == this.removeCimomButton) {
            this.removeCimom(cIMOMArray);
        } else if (object == this.refreshNowButton) {
            this.getDDI().getData();
        } else if (object == this.deviceBtn) {
            this.displayManagedDevice(cIMOMArray[0]);
        }
    }

    public static String getBestDisplayName(CIMOM cIMOM) {
        String string = cIMOM.getDisplayName();
        if (string == null || string.length() == 0) {
            string = cIMOM.getServiceUrl();
        }
        return string;
    }

    public static String getBestDisplayName(CIMOM[] cIMOMArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < cIMOMArray.length) {
            CIMOM cIMOM = cIMOMArray[n];
            String string = cIMOM.getDisplayName();
            if (string == null || string.length() == 0) {
                string = cIMOM.getServiceUrl();
            }
            stringBuffer.append("\n" + string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] getBestDisplayNameAsArray(CIMOM[] cIMOMArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < cIMOMArray.length) {
            CIMOM cIMOM = cIMOMArray[n];
            String string = cIMOM.getDisplayName();
            if (string == null || string.length() == 0) {
                string = cIMOM.getServiceUrl();
            }
            treeSet.add(string);
            ++n;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String getLocalizedStatus(CIMOMConnectionStatus cIMOMConnectionStatus) {
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNCONFIGURED) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.UNKNOWN) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.INVALID_NAMESPACE) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.TIMEOUT) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.REFUSED) {
            return GuiUtil.getString("DISK_COMMON_STATE_UNREACHABLE");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.LOGIN_FAILED) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.SSL_REGISTRATION_INVALID) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
        }
        if (cIMOMConnectionStatus == CIMOMConnectionStatus.CIMCLIENT_ERROR) {
            return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
        }
        return GuiUtil.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    }

    private void removeCimom(CIMOM[] cIMOMArray) {
        if (cIMOMArray.length > 0) {
            String[] stringArray = CimomAgentListPanel.getBestDisplayNameAsArray(cIMOMArray);
            String string = GuiUtil.getString("GUI8103I");
            JList<String> jList = new JList<String>(stringArray);
            int n = stringArray.length < 6 ? stringArray.length : 6;
            jList.setVisibleRowCount(n);
            JScrollPane jScrollPane = new JScrollPane(jList);
            int n2 = JOptionPane.showOptionDialog(guiMain.getFrame(), new Object[]{string, jScrollPane}, GuiUtil.getString("CIMOM_MGMT_REM_TITLE"), 2, 2, null, null, null);
            if (n2 == 0) {
                this.removeCIMOMrequest(cIMOMArray);
            }
        }
    }

    private void testConnection(CIMOM cIMOM) {
        final CIMOM cIMOM2 = cIMOM;
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtTestCIMOMsHandler");
        request.requestData = cIMOM;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4) {
                    int n;
                    String string;
                    CIMOMConnectionStatus cIMOMConnectionStatus = (CIMOMConnectionStatus)response.responseData;
                    if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
                        string = Util.getString("GUI8102I", CimomAgentListPanel.getBestDisplayName(cIMOM2));
                        n = 1;
                    } else {
                        string = Util.getString("GUI8101I", CimomAgentListPanel.getBestDisplayName(cIMOM2), CimomAgentListPanel.getLocalizedStatus(cIMOMConnectionStatus));
                        n = 0;
                    }
                    cIMOM2.setStatus(cIMOMConnectionStatus);
                    CimomAgentListPanel.this.getTableModel().refreshCimom(cIMOM2);
                    JOptionPane.showMessageDialog(guiMain.getFrame(), string, GuiUtil.getString("CIMOM_MGMT_TST_TITLE"), n);
                }
            }
        }, request);
    }

    protected void removeCIMOMrequest(CIMOM[] cIMOMArray) {
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtRemoveCIMOMsHandler");
        request.requestData = cIMOMArray.length == 1 ? cIMOMArray[0] : cIMOMArray;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                CimomAgentListPanel.this.getTableModel().refreshCimoms(s, response, true, CimomAgentListPanel.this.getDDI());
            }
        }, request);
        int n = 0;
        while (n < cIMOMArray.length) {
            this.getDDI().getTreeNode(cIMOMArray[n], false, true);
            ++n;
        }
    }

    public CimomAgentTableModel getTableModel() {
        return (CimomAgentTableModel)this.getDDI().getTableModel();
    }

    private void displayManagedDevice(CIMOM cIMOM) {
        if (cIMOM != null) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.CimomManagedDeviceHndlr";
            request.requestData = new CimomManagedDeviceReq(cIMOM.getServiceId());
            request.flags = (byte)4;
            GuiClient.doRequest(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        CimomManagedDeviceReq cimomManagedDeviceReq = (CimomManagedDeviceReq)response.responseData;
                        ArrayList arrayList = cimomManagedDeviceReq.list;
                        if (arrayList != null) {
                            new CimomManagedDeviceDialog(guiMain.getFrame(), GuiUtil.getString("CONFIG_CIMMGMT_CIM_MANAGED_DEVICE"), arrayList);
                        }
                    }
                }
            }, request);
        }
    }
}

