/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;

public class CIMOMMgmtDetailsPanel
extends JPanel
implements ActionListener,
DocumentListener {
    HashMap model;
    protected static final String SERVICE_URL = Util.getString("CIMOM_MGMT_SERVICE_URL_LABEL");
    protected static final String HI_NAME = Util.getString("CIMOM_MGMT_HI_NAME_LABEL");
    protected static final String DESCRIPTION = Util.getString("CIMOM_MGMT_DESCRIPTION_LABEL");
    protected static final String SOFTWARE_LEVEL = Util.getString("CIMOM_MGMT_SOFTWARE_LEVEL_LABEL");
    protected static final String PROTOCOL_VERSION = Util.getString("CIMOM_MGMT_PROTOCOL_VERSION_LABEL");
    protected static final String AUTHENTICATION_VERSION = Util.getString("CIMOM_MGMT_AUTHENTICATION_VERSION_LABEL");
    protected static final String USER_ID = Util.getString("CIMOM_MGMT_USER_ID_LABEL");
    protected static final String PASSWORD = Util.getString("CIMOM_MGMT_PASSWORD_LABEL");
    protected static final String PASSWORD_CONFIRM = Util.getString("CIMOM_MGMT_PASSWORD_CONFIRM_LABEL");
    protected static final String TRUSTSTORE_LOCATION = Util.getString("CIMOM_MGMT_TRUSTSTORE_LOCATION_LABEL");
    protected static final String TRUSTSTORE_PASSPHRASE = Util.getString("CIMOM_MGMT_TRUSTSTORE_PASSPHRASE_LABEL");
    protected static final String ALIAS = Util.getString("CIMOM_MGMT_ALIAS_LABEL");
    protected static final String SERVICE_ID = Util.getString("CIMOM_MGMT_SERVICE_ID_LABEL");
    protected static final String INTEROP_SCHEMA_NAMESPACE = Util.getString("CIMOM_MGMT_INTEROP_SCHEMA_NAMESPACE_LABEL");
    protected static final String PROTOCOL = Util.getString("CIMOM_MGMT_PROTOCOL_LABEL");
    protected static final String DISPLAY_NAME = Util.getString("CIMOM_MGMT_DISPLAY_NAME_LABEL");
    protected static final String SLP_ATTRIBUTES = Util.getString("CIMOM_MGMT_SLP_ATTRIBUTES_LABEL");
    protected static final String STATUS = Util.getString("CIMOM_MGMT_STATUS_LABEL");
    protected static final String TIMESTAMP = Util.getString("CIMOM_MGMT_TIMESTAMP_LABEL");
    protected static final String CHECKBOX_LABEL = Util.getString("CIMOM_MGT_TESTBEFORE_UPDATE_LABEL");
    private static final String CIMOM_MGT_CONNECTION_STATUS_SUCCESS = Util.getString("CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
    private static final String CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED = Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
    private static final String CIMOM_MGT_CONNECTION_STATUS_UNKNOWN = Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    private static final String CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE = Util.getString("CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
    private static final String CIMOM_MGT_CONNECTION_STATUS_TIMEOUT = Util.getString("CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
    private static final String CIMOM_MGT_CONNECTION_STATUS_REFUSED = Util.getString("DISK_COMMON_STATE_UNREACHABLE");
    private static final String CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED = Util.getString("CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
    private static final String CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR = Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
    private static final String CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID = Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
    private static final String CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR = Util.getString("CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
    private static final String FIELD = "CIMOM_FIELD";
    private static final int MIN_FIELD_WIDTH = 30;
    private DirtyListenerInterface dirtyListener = null;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private static HashMap CIMOMConnectionStatus2LocalizedString = new HashMap();

    static {
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.SUCCESS, CIMOM_MGT_CONNECTION_STATUS_SUCCESS);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.UNCONFIGURED, CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.UNKNOWN, CIMOM_MGT_CONNECTION_STATUS_UNKNOWN);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.INVALID_NAMESPACE, CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.TIMEOUT, CIMOM_MGT_CONNECTION_STATUS_TIMEOUT);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.REFUSED, CIMOM_MGT_CONNECTION_STATUS_REFUSED);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.LOGIN_FAILED, CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR, CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.SSL_REGISTRATION_INVALID, CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID);
        CIMOMConnectionStatus2LocalizedString.put(CIMOMConnectionStatus.CIMCLIENT_ERROR, CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR);
    }

    public CIMOMMgmtDetailsPanel(CIMOM cIMOM, boolean bl, String string) {
        this.model = new HashMap();
        this.buildPanel(cIMOM, bl, string);
        this.validateAndEnable(null);
    }

    public CIMOMMgmtDetailsPanel(CIMOM cIMOM) {
        this(cIMOM, true, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.talkDirty(actionEvent.getActionCommand());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.talkDirty((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.talkDirty((String)documentEvent.getDocument().getProperty(FIELD));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.talkDirty((String)documentEvent.getDocument().getProperty(FIELD));
    }

    protected void validateAndEnable(String string) {
        String string2;
        JTextField jTextField = this.getTextFieldFromRow(PASSWORD);
        JTextField jTextField2 = this.getTextFieldFromRow(PASSWORD_CONFIRM);
        String string3 = jTextField.getText();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = jTextField2.getText()) == null) {
            string2 = "";
        }
        if (!string3.equals(string2)) {
            jTextField.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
            jTextField2.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
        } else {
            jTextField.setBorder(BorderFactory.createBevelBorder(1));
            jTextField2.setBorder(BorderFactory.createBevelBorder(1));
        }
    }

    protected void makeNonEditable(JTextField jTextField) {
        if (jTextField == null) {
            return;
        }
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        jTextField.setFont(this.getFont().deriveFont(0));
        jTextField.setForeground(Color.black);
    }

    protected void makeEditable(JTextField jTextField) {
        if (jTextField == null) {
            return;
        }
        jTextField.setEditable(true);
        jTextField.setBorder(BorderFactory.createBevelBorder(1));
        jTextField.setFont(this.getFont().deriveFont(0));
        jTextField.setForeground(Color.black);
    }

    protected JTextField getTextFieldFromRow(String string) {
        return (JTextField)this.model.get(string);
    }

    private void buildRow(GridBagPanel gridBagPanel, String string, String string2) {
        JTextField jTextField = new JTextField(string2);
        this.setWidth(string2, jTextField);
        this.buildRowWithTextField(gridBagPanel, string, jTextField);
    }

    private void buildPasswordRow(GridBagPanel gridBagPanel, String string, String string2) {
        JPasswordField jPasswordField = new JPasswordField(string2);
        this.setWidth(string2, jPasswordField);
        this.buildRowWithTextField(gridBagPanel, string, jPasswordField);
    }

    private void setWidth(String string, JTextField jTextField) {
        jTextField.setColumns(Math.max(string == null ? 0 : string.length(), 30));
    }

    private void buildRowWithTextField(GridBagPanel gridBagPanel, String string, JTextField jTextField) {
        JLabel jLabel = new JLabel(string, 10);
        gridBagPanel.add(jLabel);
        this.makeNonEditable(jTextField);
        GuiUtil.setAccessibleLabel(jLabel, jTextField, "", string, string);
        this.addEditListeners(string, jTextField);
        gridBagPanel.add(jTextField);
        this.model.put(string, jTextField);
        gridBagPanel.newRow();
    }

    private void addEditListeners(String string, JTextField jTextField) {
        jTextField.setActionCommand(string);
        jTextField.addActionListener(this);
        jTextField.getDocument().addDocumentListener(this);
        jTextField.getDocument().putProperty(FIELD, string);
    }

    private void buildPanel(CIMOM cIMOM, boolean bl, String string) {
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.buildGridBag(cIMOM, bl, string), "Before");
    }

    private GridBagPanel buildGridBag(CIMOM cIMOM, boolean bl, String string) {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.buildRow(gridBagPanel, SERVICE_URL, cIMOM.getServiceUrl());
        this.buildRow(gridBagPanel, DISPLAY_NAME, cIMOM.getDisplayName());
        this.buildRow(gridBagPanel, DESCRIPTION, cIMOM.getDescription());
        this.buildRow(gridBagPanel, "", "");
        this.buildRow(gridBagPanel, USER_ID, cIMOM.getUserId());
        this.buildPasswordRow(gridBagPanel, PASSWORD, cIMOM.getPassword());
        this.buildPasswordRow(gridBagPanel, PASSWORD_CONFIRM, string != null ? string : cIMOM.getPassword());
        this.buildRow(gridBagPanel, INTEROP_SCHEMA_NAMESPACE, cIMOM.getInteropSchemaNamespace());
        this.buildRow(gridBagPanel, "", "");
        this.buildRow(gridBagPanel, TRUSTSTORE_LOCATION, cIMOM.getTrustStoreLocation());
        this.buildRow(gridBagPanel, HI_NAME, cIMOM.getHiName());
        this.buildRow(gridBagPanel, SOFTWARE_LEVEL, cIMOM.getSoftwareLevel());
        this.buildRow(gridBagPanel, PROTOCOL_VERSION, cIMOM.getProtocolVersion());
        this.buildRow(gridBagPanel, AUTHENTICATION_VERSION, cIMOM.getAuthenticationMechanism());
        this.buildRow(gridBagPanel, ALIAS, cIMOM.getAlias());
        this.buildRow(gridBagPanel, SERVICE_ID, cIMOM.getServiceId());
        this.buildRow(gridBagPanel, PROTOCOL, cIMOM.getProtocol());
        this.buildRow(gridBagPanel, SLP_ATTRIBUTES, cIMOM.getSlpAttributes());
        this.buildRow(gridBagPanel, STATUS, CIMOMMgmtDetailsPanel.getStatus(cIMOM));
        this.buildRow(gridBagPanel, TIMESTAMP, this.getStatusTimestamp(cIMOM));
        this.buildRow(gridBagPanel, "", "");
        this.buildCheckboxRow(gridBagPanel, CHECKBOX_LABEL, bl);
        gridBagPanel.createStretchBox();
        return gridBagPanel;
    }

    private void buildCheckboxRow(GridBagPanel gridBagPanel, String string, boolean bl) {
        gridBagPanel.add(new JLabel(string, 10));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        jCheckBox.setActionCommand(string);
        jCheckBox.addActionListener(this);
        gridBagPanel.add(jCheckBox);
        this.model.put(string, jCheckBox);
        gridBagPanel.newRow();
    }

    private boolean getStateFromCheckBox(String string) {
        return ((JCheckBox)this.model.get(string)).isSelected();
    }

    public boolean testBeforeAdd() {
        return this.getStateFromCheckBox(CHECKBOX_LABEL);
    }

    public String passwordConfirm() {
        return this.getFieldText(PASSWORD_CONFIRM);
    }

    private String getStatusTimestamp(CIMOM cIMOM) {
        if (cIMOM.getStatusTimestamp() == null) {
            return DateFormat.getDateTimeInstance(1, 1).format(new Date());
        }
        return DateFormat.getDateTimeInstance(1, 1).format(cIMOM.getStatusTimestamp().getTime());
    }

    public static String getStatus(CIMOM cIMOM) {
        String string;
        if (cIMOM.getStatus() != null) {
            string = (String)CIMOMConnectionStatus2LocalizedString.get(cIMOM.getStatus());
            if (string == null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.gui.common.CIMOMMgmtDetailsPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                System.err.println(String.valueOf(clazz.getName()) + ": Unknown CIMOM Connection Status Value " + cIMOM.getStatus().toString());
                string = (String)CIMOMConnectionStatus2LocalizedString.get(CIMOMConnectionStatus.UNKNOWN);
            }
        } else {
            string = (String)CIMOMConnectionStatus2LocalizedString.get(CIMOMConnectionStatus.UNKNOWN);
        }
        return string;
    }

    private String getFieldText(String string) {
        String string2 = this.getTextFieldFromRow(string).getText();
        return string2 != null ? string2.trim() : null;
    }

    public CIMOM getModel() {
        CIMOM cIMOM = new CIMOM();
        cIMOM.setServiceUrl(this.getFieldText(SERVICE_URL));
        cIMOM.setHiName(this.getFieldText(HI_NAME));
        cIMOM.setDescription(this.getFieldText(DESCRIPTION));
        cIMOM.setSoftwareLevel(this.getFieldText(SOFTWARE_LEVEL));
        cIMOM.setProtocolVersion(this.getFieldText(PROTOCOL_VERSION));
        cIMOM.setAuthenticationMechanism(this.getFieldText(AUTHENTICATION_VERSION));
        cIMOM.setUserId(this.getFieldText(USER_ID));
        cIMOM.setPassword(this.getFieldText(PASSWORD));
        cIMOM.setTrustStoreLocation(this.getFieldText(TRUSTSTORE_LOCATION));
        cIMOM.setAlias(this.getFieldText(ALIAS));
        cIMOM.setServiceId(this.getFieldText(SERVICE_ID));
        cIMOM.setInteropSchemaNamespace(this.getFieldText(INTEROP_SCHEMA_NAMESPACE));
        cIMOM.setProtocol(this.getFieldText(PROTOCOL));
        cIMOM.setDisplayName(this.getFieldText(DISPLAY_NAME));
        cIMOM.setSlpAttributes(this.getFieldText(SLP_ATTRIBUTES));
        return cIMOM;
    }

    public boolean validatePanel() {
        String string;
        boolean bl = true;
        JTextField jTextField = this.getTextFieldFromRow(PASSWORD);
        JTextField jTextField2 = this.getTextFieldFromRow(PASSWORD_CONFIRM);
        String string2 = jTextField.getText();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = jTextField2.getText()) == null) {
            string = "";
        }
        if (!string2.equals(string)) {
            bl = false;
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8103E"), Util.getString("CIMOM_MGMT_EDT_TITLE"), 0);
        }
        return bl;
    }

    protected void talkDirty(String string) {
        this.validateAndEnable(string);
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, string);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        this.dirtyListener = dirtyListenerInterface;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListenerInterface) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }

    protected void equalizeEditableTextFieldsSize() {
        int n = 0;
        int n2 = 0;
        while (n2 < 2) {
            Iterator iterator = this.model.keySet().iterator();
            while (iterator.hasNext()) {
                JTextField jTextField;
                String string = (String)iterator.next();
                Object v = this.model.get(string);
                if (!(v instanceof JTextField) || !(jTextField = (JTextField)v).isEditable()) continue;
                if (n2 == 0) {
                    int n3 = jTextField.getColumns();
                    if (n3 <= n) continue;
                    n = n3;
                    continue;
                }
                jTextField.setColumns(n);
            }
            ++n2;
        }
    }
}

