/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class DashMain
implements ActionListener,
GuiRequestor {
    private DashTotalsRow dashTotalsRow;
    public static int screenWidth;
    private byte[] currentPanels;
    private JButton cycleButton;
    private JButton refreshButton;
    private static String CYCLENAME;
    private static String REFRESHNAME;
    private BlackLabel fullTitle;
    private JPanel currentPanel;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    static {
        CYCLENAME = MessageLog.getMessageNoID("STG5237L");
        REFRESHNAME = MessageLog.getMessageNoID("STG0003L");
    }

    public DashMain() {
        PanelClasses.panelObjects = new Object[PanelClasses.panelClasses.length];
    }

    public String getTitle() {
        return this.fullTitle.getText();
    }

    public JPanel getDashboard(DashTotalsRow dashTotalsRow, boolean bl) {
        this.dashTotalsRow = dashTotalsRow;
        screenWidth = this.guiMain.getFrame().getToolkit().getScreenSize().width;
        DashTotalsRow dashTotalsRow2 = null;
        DashTotalsRow dashTotalsRow3 = this.dashTotalsRow;
        DashTotalsRow dashTotalsRow4 = null;
        DashTotalsRow dashTotalsRow5 = this.dashTotalsRow.dtrNext;
        while (dashTotalsRow5 != null) {
            if (dashTotalsRow5.dtrStatisticType == 3 && dashTotalsRow5.dtrUserName.startsWith("Administrators")) {
                dashTotalsRow3.dtrNext = dashTotalsRow5.dtrNext;
                dashTotalsRow4 = dashTotalsRow5.dtrNext;
                dashTotalsRow5.dtrNext = dashTotalsRow2;
                dashTotalsRow2 = dashTotalsRow5;
                dashTotalsRow5 = dashTotalsRow4;
                continue;
            }
            dashTotalsRow3 = dashTotalsRow5;
            dashTotalsRow5 = dashTotalsRow5.dtrNext;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (this.currentPanels == null) {
            this.currentPanels = new byte[PanelClasses.defaultPanels.length];
            this.createCurrentPanels(PanelClasses.defaultPanels);
        }
        if (bl) {
            byte by = this.currentPanels[this.currentPanels.length - 1];
            int n = this.currentPanels.length - 1;
            while (n > 0) {
                this.currentPanels[n] = this.currentPanels[n - 1];
                --n;
            }
            this.currentPanels[0] = by;
        }
        JPanel jPanel2 = this.buildTitle();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(this.addPanel(this.currentPanels[1]));
        jPanel3.add(this.addPanel(this.currentPanels[2]));
        jPanel3.add(this.addPanel(this.currentPanels[0]));
        jPanel3.add(this.addPanel(this.currentPanels[3]));
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        this.cycleButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
        while (dashTotalsRow2 != null) {
            dashTotalsRow5 = dashTotalsRow2;
            dashTotalsRow2 = dashTotalsRow2.dtrNext;
            dashTotalsRow5.dtrNext = this.dashTotalsRow;
            this.dashTotalsRow = dashTotalsRow5;
        }
        this.currentPanel = jPanel;
        return jPanel;
    }

    public JPanel getDisplayedDashboard() {
        return this.currentPanel;
    }

    private void createCurrentPanels(byte[] byArray) {
        int n = 0;
        while (n < this.currentPanels.length) {
            if (byArray[n] > 0) {
                int n2 = byArray[n] - 1;
                this.currentPanels[n2] = (byte)n;
            }
            ++n;
        }
    }

    private JPanel buildTitle() {
        Capabilities capabilities = this.guiMain.getCapabilities();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints3.anchor = 13;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(2, 1, 2, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.cycleButton = new JButton(CYCLENAME);
        this.refreshButton = new JButton(REFRESHNAME);
        GuiUtil.setAccessible(this.cycleButton, CYCLENAME, "BUTTON_DASH_CYCLE_DESC");
        GuiUtil.setAccessible(this.cycleButton, REFRESHNAME, "BUTTON_DASH_REFRESH_DESC");
        this.cycleButton.setToolTipText(Util.getString("TOOLTIP_DASH_CYCLE"));
        this.refreshButton.setToolTipText(Util.getString("TOOLTIP_DASH_REFRESH"));
        this.cycleButton.setMargin(insets);
        this.refreshButton.setMargin(insets);
        this.fullTitle = new BlackLabel(MessageLog.getMessageNoID("STG5278L", GuiUtil.formatDateTime(new Date(this.dashTotalsRow.dtrUpdateTime))));
        Font font = this.fullTitle.getFont();
        float f = font.getSize();
        f += f / 4.0f;
        this.fullTitle.setFont(font.deriveFont(f));
        jPanel.add(Box.createHorizontalStrut(2));
        jPanel.add(this.cycleButton);
        jPanel.add(Box.createGlue());
        jPanel.add(this.fullTitle);
        jPanel.add(Box.createGlue());
        jPanel.add(Box.createHorizontalStrut(2));
        if (capabilities.isAperiAdmin() || capabilities.isDataAdmin()) {
            jPanel.add(this.refreshButton);
            jPanel.add(Box.createHorizontalStrut(2));
        }
        return jPanel;
    }

    private Component addPanel(int n) {
        boolean bl = true;
        JComponent jComponent = null;
        Component component = null;
        String string = PanelClasses.panelClasses[n];
        PanelClasses panelClasses = null;
        try {
            Class<?> clazz;
            Class<?> clazz2 = Class.forName(string);
            Class[] classArray = new Class[1];
            try {
                clazz = Class.forName("org.eclipse.aperi.server.guireq.DashTotalsRow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz;
            Class[] classArray2 = classArray;
            Constructor<?> constructor = clazz2.getConstructor(classArray2);
            Object[] objectArray = new Object[]{this.dashTotalsRow};
            panelClasses = (PanelClasses)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
        if (panelClasses != null) {
            if (panelClasses.isScrollable()) {
                jComponent = new JScrollPane();
                jComponent.setBorder(GuiUtil.getBorder());
            } else {
                jComponent = new JPanel();
                ((JPanel)jComponent).setLayout(new BorderLayout());
                ((JPanel)jComponent).setBorder(GuiUtil.getBorder());
                bl = false;
            }
            try {
                component = panelClasses.getComponent(PanelClasses.panelObjects[n], true);
            }
            catch (GeneralException generalException) {
                component = new JLabel(generalException.getMessage());
            }
            PanelClasses.panelObjects[n] = panelClasses.getObject();
        }
        if (component == null) {
            jComponent = new JScrollPane();
            bl = true;
            component = new JLabel(MessageLog.getMessageNoID("GUI5083E", string));
        }
        if (bl) {
            ((JScrollPane)jComponent).setViewportView(component);
        } else {
            ((JPanel)jComponent).add(component, "Center");
        }
        return jComponent;
    }

    public void losingFocus() {
        this.cycleButton.removeActionListener(this);
        this.refreshButton.removeActionListener(this);
    }

    public void editPrefs() {
        System.out.println("edit prefs");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cycleButton) {
            this.guiMain.showNull(true);
        } else if (object == this.refreshButton) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.server.UpdateTotalsHndlr";
            request.flags = (byte)4;
            request.requestData = GuiUtil.getUserName();
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            this.guiMain.setDashTotalsRow((DashTotalsRow)response.responseData);
            this.guiMain.showNull(false);
        }
    }
}

