/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneMemberPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneWizard;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;

public class AssignZoneMembersStep
extends WizardPage
implements ActionListener {
    ZoneCNS zoneCNS;
    ZoneMemberPanel zPanel;
    ZoneMember[] zoneMembers = null;

    public AssignZoneMembersStep(int n, Zone zone, ZoneCNS zoneCNS, boolean bl, ZoneMember[] zoneMemberArray) {
        super(n);
        this.setName("AssignZoneMembersStep");
        this.zoneCNS = zoneCNS;
        this.zoneMembers = zoneMemberArray;
        this.create(zone, bl);
    }

    public void create(Zone zone, boolean bl) {
        Container container = this.getContentPane();
        this.zPanel = new ZoneMemberPanel(bl, zone, this.zoneCNS, this.zoneMembers);
        container.add(this.zPanel);
        this.setUpHelp(FabricGuiUtil.FHELP_ZC_ZWIZ2);
    }

    public Object next() {
        return "AssignZoneSetsStep";
    }

    public boolean nextBegin() {
        boolean bl = true;
        ZoneWizard zoneWizard = (ZoneWizard)this.getParent();
        Vector vector = this.getZoneMembers();
        if (!(vector != null && vector.size() >= 1 || zoneWizard.supportsEmptyZone())) {
            bl = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZone_NoZoneMembersError"));
            return bl;
        }
        if (zoneWizard.maxZoneMembers() > 0 && vector.size() > zoneWizard.maxZoneMembers()) {
            bl = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZonePanel_MaxZoneMembers"));
            return bl;
        }
        return bl;
    }

    private JPanel getPane(JComponent jComponent, JLabel jLabel) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jComponent);
        jScrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public Vector getZoneMembers() {
        return this.zPanel.getZoneMembers();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

