/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneSelectorPanel
implements ActionListener {
    ZoneCNS zoneCNS;
    ZoneSet zoneSet;
    Zone[] origZones;
    DefaultListModel srcModel = new DefaultListModel();
    DefaultListModel selModel = new DefaultListModel();
    JList selList;
    TUpDownListSelector listSelector;

    public ZoneSelectorPanel(ZoneCNS zoneCNS, ZoneSet zoneSet, Zone[] zoneArray) {
        this.zoneCNS = zoneCNS;
        this.zoneSet = zoneSet;
        this.origZones = zoneArray;
    }

    public JPanel createPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selList = this.createCurrentZonesList();
        this.listSelector = new TUpDownListSelector(this.createAvailableZonesList(), this.selList, FabricGuiUtil.getString("FabricZone_PotentialZones"), FabricGuiUtil.getString("FabricZone_CurrentZones"), false);
        this.populateModels();
        jPanel.add((Component)this.listSelector, "Center");
        return jPanel;
    }

    private void populateModels() {
        int n;
        Zone[] zoneArray = this.zoneCNS.getAllZones();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.origZones != null) {
            n = 0;
            while (n < this.origZones.length) {
                this.selModel.addElement(this.origZones[n].getName());
                hashMap.put(this.origZones[n].getName(), this.origZones[n].getName());
                ++n;
            }
        }
        n = 0;
        while (n < zoneArray.length) {
            if (!hashMap.containsKey(zoneArray[n].getName())) {
                this.srcModel.addElement(zoneArray[n].getName());
            }
            ++n;
        }
    }

    public ArrayList getSelectList() {
        return this.listSelector.getSelList();
    }

    private JList createAvailableZonesList() {
        return new JList(this.srcModel);
    }

    private JList createCurrentZonesList() {
        return new JList(this.selModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

