/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.cartridges;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesDDI;
import org.eclipse.aperi.gui.tape.common.TapeLocation;
import org.eclipse.aperi.gui.tape.common.model.GUICartridge;

public class CartridgesTableModel
extends BaseTableModel {
    private CartridgesDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_LABEL_LABEL"), Util.getString("TAPE_DESCRIPTION_LABEL"), Util.getString("TAPE_CAPACITY_LABEL"), Util.getString("TAPE_TYPE_LABEL"), Util.getString("TAPE_CLEANER_MEDIA_LABEL"), Util.getString("TAPE_DUAL_SIDED_LABEL"), Util.getString("TAPE_LOCATION_LABEL")};
    private static final int CART_LABEL = 0;
    private static final int CART_DESC = 1;
    private static final int CART_CAP = 2;
    private static final int CART_TYPE = 3;
    private static final int CART_CM = 4;
    private static final int CART_DUALS = 5;
    private static final int CART_LOC = 6;

    CartridgesTableModel(CartridgesDDI cartridgesDDI) {
        this.aDDI = cartridgesDDI;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getCartridges().size();
    }

    public Object getTableDataItem(int n, int n2) {
        GUICartridge gUICartridge = (GUICartridge)this.aDDI.getCartridges().elementAt(n);
        switch (n2) {
            case 0: {
                return gUICartridge.getLabel();
            }
            case 1: {
                return gUICartridge.getDescription();
            }
            case 2: {
                return new Double(GUIEntityUtil.convertStorageCapacity(gUICartridge.getCapacity(), 0, 3, 2));
            }
            case 3: {
                return gUICartridge.getType();
            }
            case 4: {
                if (!gUICartridge.isCleanerMedia()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 5: {
                if (!gUICartridge.isDualSided()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 6: {
                return new TapeLocation(gUICartridge.getLocation());
            }
        }
        return "";
    }
}

