/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.LayoutManager;
import java.text.CollationKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoCanvas;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoEntity;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoUnit;
import org.eclipse.aperi.gui.topo.widget.DefaultTopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.ITopoUnitModel;
import org.eclipse.aperi.gui.topo.widget.TopoConstant;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;

public abstract class AbstractJTopoContainer
extends AbstractJTopoUnit {
    protected Vector entityV = new Vector();

    protected AbstractJTopoContainer() {
        this((ITopoUnitModel)null, true);
    }

    protected AbstractJTopoContainer(ITopoUnitModel iTopoUnitModel, boolean bl) {
        super(iTopoUnitModel, bl);
        this.initState();
    }

    private void initState() {
        this.entityV.clear();
        this.removeAll();
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    protected Object createWidgetModel() {
        return new DefaultTopoUnitModel();
    }

    public Vector getEntities() {
        return this.entityV;
    }

    public boolean isContainEntity(AbstractJTopoEntity abstractJTopoEntity) {
        return this.entityV.contains(abstractJTopoEntity);
    }

    public void addEntity(AbstractJTopoEntity abstractJTopoEntity) {
        this.entityV.add(abstractJTopoEntity);
        this.add(abstractJTopoEntity);
    }

    public void removeEntity(AbstractJTopoEntity abstractJTopoEntity) {
        this.entityV.remove(abstractJTopoEntity);
        this.remove(abstractJTopoEntity);
    }

    public void removeAllEntities() {
        this.entityV.clear();
        this.removeAll();
    }

    public void setOverlayHealthEnabled(boolean bl) {
    }

    public void setOverlayPerfEnabled(boolean bl) {
    }

    public void setArrange(AbstractJTopoCanvas.ArrangeRecord arrangeRecord) {
        Integer n = arrangeRecord.getProp();
        boolean bl = arrangeRecord.isAsc();
        if (TopoConstant.ARRANGE_DISPLAYNAME.equals(n)) {
            Collections.sort(this.entityV, new Arrange_ByDisplayName(bl));
        } else if (TopoConstant.ARRANGE_STATUS.equals(n)) {
            Collections.sort(this.entityV, new Arrange_ByStatus(bl));
        } else {
            return;
        }
        this.removeAll();
        int n2 = 0;
        while (n2 < this.entityV.size()) {
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)this.entityV.elementAt(n2);
            this.add(abstractJTopoEntity);
            ++n2;
        }
        this.revalidate();
        this.repaint();
    }

    protected LayoutManager createDefaultLayout() {
        return new DefaultLayout();
    }

    protected class Arrange_ByDisplayName
    implements Comparator {
        protected boolean sort_asc;

        public Arrange_ByDisplayName(boolean bl) {
            this.sort_asc = bl;
        }

        public int compare(Object object, Object object2) {
            Comparable comparable;
            Comparable comparable2;
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)object;
            AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)object2;
            GraphEntity graphEntity = abstractJTopoEntity.getFocusEntity();
            GraphEntity graphEntity2 = abstractJTopoEntity2.getFocusEntity();
            int n = 0;
            boolean bl = true;
            if (graphEntity == null && graphEntity2 == null) {
                n = 0;
            } else if (graphEntity == null) {
                n = 1;
            } else if (graphEntity2 == null) {
                n = -1;
            } else {
                bl = false;
            }
            if (!bl) {
                bl = true;
                comparable2 = graphEntity.getSortingValue();
                comparable = graphEntity2.getSortingValue();
                if (comparable2 != null && comparable != null) {
                    n = comparable2.compareTo(comparable);
                } else if (comparable2 != null) {
                    n = -1;
                } else if (comparable != null) {
                    n = 1;
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                bl = true;
                comparable2 = graphEntity.getCollationKey();
                comparable = graphEntity2.getCollationKey();
                if (comparable2 != null && comparable != null) {
                    n = ((CollationKey)comparable2).compareTo((CollationKey)comparable);
                } else if (comparable2 != null) {
                    n = -1;
                } else if (comparable != null) {
                    n = 1;
                } else {
                    bl = false;
                }
            }
            if (!bl) {
                n = 0;
            }
            if (!this.sort_asc) {
                n = -n;
            }
            return n;
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    protected class Arrange_ByStatus
    implements Comparator {
        protected boolean sort_asc;

        public Arrange_ByStatus(boolean bl) {
            this.sort_asc = bl;
        }

        public int compare(Object object, Object object2) {
            AbstractJTopoEntity abstractJTopoEntity = (AbstractJTopoEntity)object;
            AbstractJTopoEntity abstractJTopoEntity2 = (AbstractJTopoEntity)object2;
            GraphEntity graphEntity = abstractJTopoEntity.getFocusEntity();
            GraphEntity graphEntity2 = abstractJTopoEntity2.getFocusEntity();
            if (graphEntity == null && graphEntity2 == null) {
                return 0;
            }
            if (graphEntity == null) {
                return 1;
            }
            if (graphEntity2 == null) {
                return -1;
            }
            Integer n = graphEntity.getHealthStatus();
            Integer n2 = graphEntity2.getHealthStatus();
            int n3 = n != null && n2 != null ? n.compareTo(n2) : (n != null ? -1 : (n2 != null ? 1 : 0));
            if (!this.sort_asc) {
                n3 = -n3;
            }
            return n3;
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    protected class DefaultLayout
    extends TopoLayoutUtilities.SquareGridLayout {
    }
}

