/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.widget.AbstractJTopoTitle;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.ITopoGroupModel;
import org.eclipse.aperi.gui.topo.widget.ITopoNodeModel;
import org.eclipse.aperi.gui.topo.widget.TopoResource;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public abstract class AbstractJTopoGroupTitle
extends AbstractJTopoTitle {
    private static final String GAP_ICONJUMPING = "      ";
    protected String strType;
    protected ImageIcon[] iconJumping;
    protected ImageIcon iconRecursive;
    protected String strCounter;
    protected Point strTypeP;
    protected Rectangle strTypeR;
    protected String[] iconJumpingPositionStr;
    protected Rectangle[] iconJumpingR;
    protected Rectangle iconRecursiveR;
    protected Point strCounterP;
    protected Rectangle strCounterR;
    protected boolean isIconRecursiveEnabled;
    protected boolean isStrCounterEnabled;

    protected AbstractJTopoGroupTitle() {
        this((ITopoNodeModel)null, true);
    }

    protected AbstractJTopoGroupTitle(ITopoNodeModel iTopoNodeModel, boolean bl) {
        super(iTopoNodeModel, bl);
        this.setBorder(null);
        this.setBackground(TopoResource.COLOR_TITLE_BACKGROUND);
        this.iconRecursive = TopoResource.ICON_BOX_RECURSIVE_SELECTION;
        this.strTypeP = new Point();
        this.strTypeR = new Rectangle();
        this.iconRecursiveR = new Rectangle();
        this.strCounterP = new Point();
        this.strCounterR = new Rectangle();
        this.initState();
    }

    private void initState() {
        this.isIconRecursiveEnabled = true;
        this.isStrCounterEnabled = true;
        this.strType = null;
        this.iconJumping = null;
        this.strCounter = null;
        this.strTypeP.setLocation(0, 0);
        this.strTypeR.setBounds(0, 0, 0, 0);
        this.iconJumpingPositionStr = null;
        this.iconJumpingR = null;
        this.iconRecursiveR.setBounds(0, 0, 0, 0);
        this.strCounterP.setLocation(0, 0);
        this.strCounterR.setBounds(0, 0, 0, 0);
    }

    public void resetState() {
        super.resetState();
        this.initState();
    }

    public void modelChanged() {
        this.modelChanged_setCounter();
        super.modelChanged();
    }

    protected void modelChanged_setLabel() {
        GraphGroupKey.Key key;
        int n;
        Serializable serializable;
        Object object;
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        this.strType = iTopoGroupModel.getType();
        GraphGroupKey graphGroupKey = iTopoGroupModel.getGroupKey();
        if (graphGroupKey != null) {
            object = new StringBuffer();
            ((StringBuffer)object).append(" (");
            serializable = graphGroupKey.getKeys();
            n = 0;
            while (n < ((Vector)serializable).size()) {
                if (n != 0) {
                    ((StringBuffer)object).append("+");
                }
                if ((key = (GraphGroupKey.Key)((Vector)serializable).elementAt(n)).getJumpingEntity() != null) {
                    ((StringBuffer)object).append(GAP_ICONJUMPING);
                }
                ((StringBuffer)object).append(key.getMethodValueAlias());
                ++n;
            }
            ((StringBuffer)object).append(")");
            this.strLabel = ((StringBuffer)object).toString();
        } else {
            object = iTopoGroupModel.getLabel();
            this.strLabel = ((String)object).equals(this.strType) ? "" : " (" + (String)object + ")";
        }
        if (graphGroupKey != null) {
            object = graphGroupKey.getKeys();
            this.iconJumpingPositionStr = new String[((Vector)object).size()];
            this.iconJumping = new ImageIcon[((Vector)object).size()];
            this.iconJumpingR = new Rectangle[((Vector)object).size()];
            serializable = new StringBuffer();
            n = 0;
            while (n < ((Vector)object).size()) {
                if (n != 0) {
                    ((StringBuffer)serializable).append("+");
                }
                this.iconJumpingPositionStr[n] = " (" + ((StringBuffer)serializable).toString();
                this.iconJumping[n] = null;
                this.iconJumpingR[n] = new Rectangle();
                key = (GraphGroupKey.Key)((Vector)object).elementAt(n);
                if (key.getJumpingEntity() != null) {
                    ((StringBuffer)serializable).append(GAP_ICONJUMPING);
                }
                ((StringBuffer)serializable).append(key.getMethodValueAlias());
                ++n;
            }
        } else {
            this.iconJumpingPositionStr = new String[0];
            this.iconJumping = new ImageIcon[0];
            this.iconJumpingR = new Rectangle[0];
        }
    }

    protected void modelChanged_setTooltip() {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        String string = iTopoGroupModel.getLabel();
        String string2 = iTopoGroupModel.getType();
        GraphGroupKey graphGroupKey = iTopoGroupModel.getGroupKey();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        if (!string.equals(string2)) {
            stringBuffer.append(" (");
            if (graphGroupKey != null && !graphGroupKey.isEmpty()) {
                stringBuffer.append(graphGroupKey.getFullLabel());
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(")");
        }
        this.tooltipLabel = stringBuffer.toString();
    }

    protected void modelChanged_setCounter() {
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        int n = iTopoGroupModel.getTotalCount();
        int n2 = iTopoGroupModel.getUnfilteredCount();
        TopoSetting topoSetting = this.canvas.getControllerView().getControllerApp().getTopoSetting();
        int n3 = topoSetting.getFilteringLevel();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (n3 != 0) {
            stringBuffer.append(n2);
            stringBuffer.append(" / ");
        }
        stringBuffer.append(n);
        stringBuffer.append("]");
        this.strCounter = stringBuffer.toString();
    }

    protected void modelChanged_setSelection() {
        super.modelChanged_setSelection();
        ITopoNodeModel iTopoNodeModel = (ITopoNodeModel)this.widgetModel;
        Color color = null;
        color = iTopoNodeModel.isSelected() ? TopoResource.COLOR_SELECTED : TopoResource.COLOR_TITLE_BACKGROUND;
        this.setBackground(color);
        ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
        GraphGroupKey graphGroupKey = iTopoGroupModel.getGroupKey();
        if (graphGroupKey != null) {
            Vector vector = graphGroupKey.getKeys();
            int n = 0;
            while (n < vector.size()) {
                GraphGroupKey.Key key = (GraphGroupKey.Key)vector.elementAt(n);
                if (key.getJumpingEntity() != null) {
                    this.iconJumping[n] = iTopoNodeModel.isSelected() ? key.getIconSelected() : key.getIconUnselected();
                }
                ++n;
            }
        }
    }

    protected void modelChanged_setHighlight() {
    }

    protected void handleMouseClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
            int n = 0;
            while (n < this.iconJumpingR.length) {
                Rectangle rectangle = this.iconJumpingR[n];
                if (rectangle.contains(point)) {
                    ITopoGroupModel iTopoGroupModel = (ITopoGroupModel)this.widgetModel;
                    GraphGroupKey graphGroupKey = iTopoGroupModel.getGroupKey();
                    GraphGroupKey.Key key = graphGroupKey.getKey(n);
                    GraphEntity graphEntity = key.getJumpingEntity();
                    ControllerApp controllerApp = this.canvas.getControllerView().getControllerApp();
                    controllerApp.openView(graphEntity, null);
                    return;
                }
                ++n;
            }
        }
        if (this.iconRecursiveR.contains(point)) {
            this.handleMouseClick_recursive(mouseEvent);
        } else {
            this.handleMouseClick_background(mouseEvent);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        String string = null;
        string = this.iconRecursiveR.contains(point) ? GuiUtil.getString("TOPO_LABEL_MENU_CANVAS_SELECTALL") : super.getToolTipText(mouseEvent);
        return string;
    }

    protected void layoutItself() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.focusEntity == null) {
            return;
        }
        graphics.setFont(TopoResource.FONT_BOLD);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.strType != null) {
            n = fontMetrics.stringWidth(this.strType);
            n2 = fontMetrics.getHeight();
            n3 = fontMetrics.getAscent();
        }
        graphics.setFont(TopoResource.FONT_PLAIN);
        fontMetrics = graphics.getFontMetrics();
        int n4 = 0;
        int n5 = 0;
        if (this.strLabel != null) {
            n4 = fontMetrics.stringWidth(this.strLabel);
            n5 = fontMetrics.getHeight();
        }
        int n6 = 0;
        int n7 = 0;
        if (this.strCounter != null) {
            n6 = fontMetrics.stringWidth(this.strCounter);
            n7 = fontMetrics.getHeight();
        }
        Insets insets = this.getInsets();
        int n8 = insets.left + insets.right;
        int n9 = insets.top + insets.bottom;
        n8 += 10;
        if (this.iconHealth != null) {
            n8 += this.iconHealth.getIconWidth() + 3;
        }
        if (this.iconPerf != null) {
            n8 += this.iconPerf.getIconWidth() + 3;
        }
        n8 += 6;
        n8 += this.iconType.getIconWidth() + 3;
        n8 += n + 3;
        n8 = this.labelMode == 0 ? (n8 += this.maxLabelWidth_compact) : (this.labelMode == 1 ? (n8 += n4 < this.maxLabelWidth_relax ? n4 : this.maxLabelWidth_relax) : (n8 += n4));
        if (this.iconPin != null) {
            n8 += 3 + this.iconPin.getIconWidth();
        }
        if (this.isIconRecursiveEnabled) {
            n8 += 3 + this.iconRecursive.getIconWidth();
        }
        if (this.isStrCounterEnabled) {
            n8 += 3 + n6;
        }
        this.preferredSizeD = new Dimension(n8, n9 += 22);
        n8 = this.getWidth();
        n9 = this.getHeight();
        if (n8 != 0 && n9 != 0) {
            int n10;
            int n11 = insets.left + 5;
            int n12 = insets.top;
            int n13 = n8 - insets.left - insets.right - 10;
            if (this.iconHealth != null) {
                n13 -= this.iconHealth.getIconWidth() + 3;
            }
            if (this.iconPerf != null) {
                n13 -= this.iconPerf.getIconWidth() + 3;
            }
            n13 -= 6;
            n13 -= this.iconType.getIconWidth() + 3;
            n13 -= n + 3;
            if (this.iconPin != null) {
                n13 -= 3 + this.iconPin.getIconWidth();
            }
            if (this.isIconRecursiveEnabled) {
                n13 -= 3 + this.iconRecursive.getIconWidth();
            }
            if (this.isStrCounterEnabled) {
                n13 -= 3 + n6;
            }
            int n14 = n13;
            n11 += (n13 -= n4) > 0 ? n13 / 2 : 0;
            if (this.iconHealth != null) {
                n10 = (n9 - insets.top - insets.bottom - this.iconHealth.getIconHeight()) / 2;
                n10 = n10 > 0 ? n10 : 0;
                this.iconHealthR.setBounds(n11, n12 + n10, this.iconHealth.getIconWidth(), this.iconHealth.getIconHeight());
                n11 += this.iconHealth.getIconWidth() + 3;
            } else {
                this.iconHealthR.setBounds(0, 0, 0, 0);
            }
            if (this.iconPerf != null) {
                n10 = (n9 - insets.top - insets.bottom - this.iconPerf.getIconHeight()) / 2;
                n10 = n10 > 0 ? n10 : 0;
                this.iconPerfR.setBounds(n11, n12 + n10, this.iconPerf.getIconWidth(), this.iconPerf.getIconHeight());
                n11 += this.iconPerf.getIconWidth() + 3;
            } else {
                this.iconPerfR.setBounds(0, 0, 0, 0);
            }
            n10 = (n9 - insets.top - insets.bottom - this.iconType.getIconHeight()) / 2;
            n10 = n10 > 0 ? n10 : 0;
            this.iconTypeR.setBounds(n11 += 3, n12 + n10, this.iconType.getIconWidth(), this.iconType.getIconHeight());
            n10 = (n9 - insets.top - insets.bottom - n2) / 2;
            n10 = n10 > 0 ? n10 : 0;
            this.strTypeP.setLocation(n11 += this.iconType.getIconWidth() + 3, n12 + n10 + n3);
            this.strTypeR.setBounds(n11, n12 + n10, n, n2);
            n11 += n + 3;
            if (this.strLabel != null) {
                Object object;
                int n15;
                n10 = (n9 - insets.top - insets.bottom - n5) / 2;
                n10 = n10 > 0 ? n10 : 0;
                int n16 = n13 > 0 ? n4 : n14;
                this.strLabelP.setLocation(n11, n12 + n10 + n3);
                this.strLabelR.setBounds(n11, n12 + n10, n16, n5);
                if (n13 < 0) {
                    this.clippedStrLabel = "";
                    n15 = 0;
                    while (n15 < this.strLabel.length()) {
                        object = String.valueOf(this.strLabel.substring(0, n15)) + "...";
                        int n17 = fontMetrics.stringWidth((String)object);
                        if (n17 <= n14) {
                            this.clippedStrLabel = object;
                            ++n15;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.clippedStrLabel = this.strLabel;
                }
                n15 = 0;
                while (n15 < this.iconJumpingR.length) {
                    object = this.iconJumpingR[n15];
                    ImageIcon imageIcon = this.iconJumping[n15];
                    if (imageIcon != null) {
                        int n18 = fontMetrics.stringWidth(this.iconJumpingPositionStr[n15]);
                        if (n18 + imageIcon.getIconWidth() < n16) {
                            ((Rectangle)object).setBounds(n11 + n18, n12 + n10, imageIcon.getIconWidth(), imageIcon.getIconHeight());
                        } else {
                            ((Rectangle)object).setBounds(0, 0, 0, 0);
                        }
                    } else {
                        ((Rectangle)object).setBounds(0, 0, 0, 0);
                    }
                    ++n15;
                }
                n11 += n16 + 3;
            } else {
                this.strLabelR.setBounds(0, 0, 0, 0);
            }
            n11 += 3;
            if (this.iconPin != null) {
                n10 = (n9 - insets.top - insets.bottom - this.iconPin.getIconHeight()) / 2;
                n10 = n10 > 0 ? n10 : 0;
                this.iconPinR.setBounds(n11, n12 + n10, this.iconPin.getIconWidth(), this.iconPin.getIconHeight());
                n11 += this.iconPin.getIconWidth() + 3;
            } else {
                this.iconPinR.setBounds(0, 0, 0, 0);
            }
            if (this.isIconRecursiveEnabled) {
                n10 = (n9 - insets.top - insets.bottom - this.iconRecursive.getIconHeight()) / 2;
                n10 = n10 > 0 ? n10 : 0;
                this.iconRecursiveR.setBounds(n11, n12 + n10, this.iconRecursive.getIconWidth(), this.iconRecursive.getIconHeight());
                n11 += this.iconRecursive.getIconWidth() + 3;
            }
            if (this.isStrCounterEnabled) {
                n10 = (n9 - insets.top - insets.bottom - n7) / 2;
                n10 = n10 > 0 ? n10 : 0;
                this.strCounterP.setLocation(n11, n12 + n10 + n3);
                this.strCounterR.setBounds(n11, n12 + n10, n6, n7);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isIconRecursiveEnabled) {
            this.iconRecursive.paintIcon(this, graphics, this.iconRecursiveR.x, this.iconRecursiveR.y);
        }
        if (this.strType != null) {
            graphics.setFont(TopoResource.FONT_BOLD);
            graphics.setColor(TopoResource.COLOR_FONT);
            graphics.drawString(this.strType, this.strTypeP.x, this.strTypeP.y);
        }
        int n = 0;
        while (n < this.iconJumpingR.length) {
            Rectangle rectangle = this.iconJumpingR[n];
            ImageIcon imageIcon = this.iconJumping[n];
            if (rectangle.getX() != 0.0 && imageIcon != null) {
                imageIcon.paintIcon(this, graphics, rectangle.x, rectangle.y);
            }
            ++n;
        }
        if (this.isStrCounterEnabled && this.strCounter != null) {
            graphics.setFont(TopoResource.FONT_PLAIN);
            graphics.setColor(TopoResource.COLOR_FONT);
            graphics.drawString(this.strCounter, this.strCounterP.x, this.strCounterP.y);
        }
    }

    public void setIconRecursiveEnabled(boolean bl) {
        this.isIconRecursiveEnabled = bl;
        this.revalidate();
        this.repaint();
    }

    public void setStrCounterEnabled(boolean bl) {
        this.isStrCounterEnabled = bl;
        this.revalidate();
        this.repaint();
    }
}

