/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;

public class DBResultSet {
    private ResultSet resultSet;
    private DBPreparedStatement dbps = null;

    public DBResultSet(ResultSet resultSet, DBPreparedStatement dBPreparedStatement) throws SQLException {
        if (resultSet == null || dBPreparedStatement == null) {
            throw new SQLException("DBResultSet constructor called with null ResultSet or DBPreparedStatement");
        }
        this.resultSet = resultSet;
        this.dbps = dBPreparedStatement;
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
    }

    public DBPreparedStatement getStatement() throws SQLException {
        return this.dbps;
    }

    public void closeAll() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            if (this.dbps != null) {
                this.dbps.close();
            }
            if (this.dbps != null) {
                this.dbps.close();
            }
        }
    }

    public boolean isAfterLast() throws SQLException {
        return this.resultSet.isAfterLast();
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public int current() throws SQLException {
        return this.resultSet.getRow();
    }

    public short getShort(int n) throws SQLException {
        short s = this.resultSet.getShort(n);
        return s;
    }

    public int getInt(int n) throws SQLException {
        int n2 = this.resultSet.getInt(n);
        return n2;
    }

    public double getDouble(int n) throws SQLException {
        double d = this.resultSet.getDouble(n);
        return d;
    }

    public long getLong(int n) throws SQLException {
        long l = this.resultSet.getLong(n);
        return l;
    }

    public float getFloat(int n) throws SQLException {
        float f = this.resultSet.getFloat(n);
        return f;
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.resultSet.getBoolean(n);
    }

    public String getString(int n) throws SQLException {
        String string = this.resultSet.getString(n);
        return string;
    }

    public byte getByte(int n) throws SQLException {
        return this.resultSet.getByte(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray = this.resultSet.getBytes(n);
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        byte[] byArray = this.resultSet.getBytes(string);
        return byArray;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = this.resultSet.getTimestamp(n);
        return timestamp;
    }

    public int getFetchSize() throws SQLException {
        return this.resultSet.getFetchSize();
    }

    public void setFetchSize(int n) throws SQLException {
        this.resultSet.setFetchSize(n);
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = this.resultSet.getBigDecimal(n);
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal = this.resultSet.getBigDecimal(string);
        return bigDecimal;
    }

    public String getString(String string) throws SQLException {
        String string2 = this.resultSet.getString(string);
        return string2;
    }

    public short getShort(String string) throws SQLException {
        short s = this.resultSet.getShort(string);
        return s;
    }

    public double getDouble(String string) throws SQLException {
        double d = this.resultSet.getDouble(string);
        return d;
    }

    public int getInt(String string) throws SQLException {
        int n = this.resultSet.getInt(string);
        return n;
    }

    public long getLong(String string) throws SQLException {
        long l = this.resultSet.getLong(string);
        return l;
    }

    public float getFloat(String string) throws SQLException {
        float f = this.resultSet.getFloat(string);
        return f;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp = this.resultSet.getTimestamp(string);
        return timestamp;
    }

    public Date getDate(String string) throws SQLException {
        Date date = this.resultSet.getDate(string);
        return date;
    }

    public Time getTime(String string) throws SQLException {
        Time time = this.resultSet.getTime(string);
        return time;
    }

    public Date getDate(int n) throws SQLException {
        Date date = this.resultSet.getDate(n);
        return date;
    }

    public Time getTime(int n) throws SQLException {
        Time time = this.resultSet.getTime(n);
        return time;
    }

    public Object getObject(String string) throws SQLException {
        return this.resultSet.getObject(string);
    }

    public Object getObject(int n) throws SQLException {
        return this.resultSet.getObject(n);
    }

    public Clob getClob(int n) throws SQLException {
        Clob clob = this.resultSet.getClob(n);
        return clob;
    }

    public Clob getClob(String string) throws SQLException {
        Clob clob = this.resultSet.getClob(string);
        return clob;
    }

    public Object[] getAttribute(Vector vector, Vector vector2) throws SQLException {
        if (vector.size() <= 0) {
            return null;
        }
        Object[] objectArray = new Object[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            int n2 = vector2.indexOf(vector.elementAt(n)) + 1;
            objectArray[n] = this.resultSet.getObject(n2);
            ++n;
        }
        return objectArray;
    }
}

