/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.history.snapshot;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.ParameterizedSql;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespaceSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimomSnapshot;
import org.eclipse.aperi.infrastructure.database.objects.SnapshotMetadata;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomSnapshotTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSnapshotMetadataTable;
import org.eclipse.aperi.infrastructure.history.snapshot.SnapshotUtil;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public class SnapshotCimom {
    private static String REGISTERED_CIMOM_TABLE;
    private static String CIMOM2NAMESPACE_TABLE;
    private static ILogger traceLogger;
    private static String className;
    private static boolean TRACE;

    static {
        Class<?> clazz;
        REGISTERED_CIMOM_TABLE = "T_RES_REGISTERED_CIMOM";
        CIMOM2NAMESPACE_TABLE = "T_RES_CIMOM2NAMESPACE";
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.infrastructure.history.snapshot.SnapshotCimom");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        TRACE = false;
        traceLogger = DBConstants.getLogger();
        if (traceLogger != null) {
            TRACE = traceLogger.isLogging();
        }
    }

    static int create(DBConnection dBConnection, int n) throws Exception {
        int n2;
        block12: {
            String string = "create(" + n + ")";
            int n3 = -1;
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            RegisteredCimom registeredCimom = null;
            DBCursor dBCursor = null;
            if (TRACE) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
            }
            try {
                hashtable.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), String.valueOf(n));
                dBCursor = RegisteredCimom.getCursor(dBConnection, hashtable, null);
                if (dBCursor.next()) {
                    registeredCimom = ((RegisteredCimom.RegisteredCimomCursor)dBCursor).getAttributes();
                }
                if (registeredCimom == null) {
                    Exception exception = new Exception("Bad CIMOM ID: " + n);
                    if (TRACE) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, exception);
                    }
                    throw exception;
                }
                n3 = AutoIdentifier.getIdentifier(9, 1);
                Timestamp timestamp = CurrentTime.getTimestamp(dBConnection);
                SnapshotUtil.createSnapshotMetadata(dBConnection, n3, timestamp, n, 3, true);
                SnapshotCimom.createRegisteredCimomSnapshot(dBConnection, registeredCimom, n3, REGISTERED_CIMOM_TABLE);
                SnapshotCimom.createCimom2NamespaceSnapshot(dBConnection, registeredCimom, n3, CIMOM2NAMESPACE_TABLE);
                if (TRACE) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
                }
                n2 = n3;
                Object var9_11 = null;
                if (dBCursor == null) break block12;
            }
            catch (SQLException sQLException) {
                try {
                    try {
                        dBConnection.rollback();
                    }
                    catch (SQLException sQLException2) {}
                    if (TRACE) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    block13: {
                        Object var9_12 = null;
                        if (dBCursor == null) break block13;
                        dBCursor.close();
                    }
                    throw throwable;
                }
            }
            dBCursor.close();
        }
        return n2;
    }

    static void delete(DBConnection dBConnection, int n) throws Exception {
        String string = "delete(" + n + ")";
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string);
        }
        try {
            hashtable.put(TResCimom2namespaceSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            Cimom2namespaceSnapshot.deletes(dBConnection, hashtable);
            hashtable.put(TResRegisteredCimomSnapshotTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            RegisteredCimomSnapshot.deletes(dBConnection, hashtable);
            hashtable.put(TResSnapshotMetadataTable.getColumnInfo("SNAPSHOT_ID"), String.valueOf(n));
            SnapshotMetadata.deletes(dBConnection, hashtable);
        }
        catch (SQLException sQLException) {
            try {
                dBConnection.rollback();
            }
            catch (SQLException sQLException2) {}
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string);
        }
    }

    private static void createRegisteredCimomSnapshot(DBConnection dBConnection, RegisteredCimom registeredCimom, int n, String string) throws SQLException {
        String string2 = "createRegisteredCimomSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(3, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResRegisteredCimomTable.getColumnInfo("REG_CIMOM_ID"), String.valueOf(registeredCimom.getRegCimomId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }

    private static void createCimom2NamespaceSnapshot(DBConnection dBConnection, RegisteredCimom registeredCimom, int n, String string) throws SQLException {
        String string2 = "createCimom2NamespaceSnapshot(" + n + ", " + string + ")";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
        if (TRACE) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string2);
        }
        try {
            String string3 = SnapshotUtil.getSnapshotCreationStmt(3, string);
            if (string3 != null) {
                hashtable.put("<<SNAPSHOT_ID>>", String.valueOf(n));
                hashtable2.put(TResCimom2namespaceTable.getColumnInfo("CIMOM_ID"), String.valueOf(registeredCimom.getRegCimomId()));
                ParameterizedSql.sqlUpdate(dBConnection, string3, hashtable, hashtable2);
            }
        }
        catch (SQLException sQLException) {
            if (TRACE) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, className, string2, sQLException);
            }
            throw sQLException;
        }
        if (TRACE) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string2);
        }
    }
}

