/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import com.ibm.log.Level;
import com.ibm.log.LogEventProducer;
import com.ibm.log.PDLogger;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.mgr.PropertyFileDataStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.RequestType;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class TraceLoggerFactory {
    public static Map<String, Integer> servicesFlags = new HashMap<String, Integer>();
    public static Map<String, PDLogger> loggers = new HashMap<String, PDLogger>();
    public static LogManager mgr;
    private static String agentMachine;
    private static final String SEP1 = " ";
    private static final String SEP2 = " | ";
    private static final String SEP3 = ", rc=";

    static {
        agentMachine = null;
    }

    public static void initializeTraceLogger(String string, String string2) {
        TraceLoggerFactory.initializeTraceLogger(string, string2, null);
    }

    public static void initializeTraceLogger(String string, String string2, String string3) {
        TraceLoggerFactory.disableTraceFlag();
        Iterator iterator = RequestType.getValues().iterator();
        while (iterator.hasNext()) {
            servicesFlags.put((String)iterator.next(), 0);
        }
        PropertyFileDataStore propertyFileDataStore = null;
        try {
            propertyFileDataStore = new PropertyFileDataStore(string);
            DataStoreConfig dataStoreConfig = propertyFileDataStore.getConfig("ITSRM.handler.file");
            dataStoreConfig.setProperty("fileName", string2);
            propertyFileDataStore.updateConfig(dataStoreConfig);
            if (string3 != null) {
                dataStoreConfig = propertyFileDataStore.getConfig("ITSRMaudit.handler.file");
                dataStoreConfig.setProperty("fileName", string3);
                propertyFileDataStore.updateConfig(dataStoreConfig);
            }
            mgr = LogManager.getManagerWithMergedDataStore((DataStore)propertyFileDataStore, (boolean)false);
        }
        catch (Exception exception) {
            MessageLog.logException("GEN2014E", exception);
        }
    }

    public static void startLogger(String string, String string2) {
        if (mgr != null) {
            try {
                loggers.put(string2, (PDLogger)mgr.getLogger(string));
            }
            catch (Exception exception) {
                mgr = null;
                TraceLoggerFactory.disableTraceFlag();
                MessageLog.logException("GEN2019E", exception, string);
            }
            if (loggers.get(string2) != null) {
                if (loggers.get(string2).isLogging()) {
                    Level level = loggers.get(string2).getLevel();
                    servicesFlags.put(string2, level.getValue());
                    TraceLoggerFactory.enableTraceFlag();
                }
                if (string2.equals("org.eclipse.aperi.common.svp.AuditSvp")) {
                    TraceLoggerFactory.enableAuditFlag();
                }
                loggers.get(string2).text(Level.DEBUG_MIN, (Object)"TraceLogger", "startLogger", String.valueOf(string) + " started.");
            }
        } else {
            MessageLog.logMessage("GEN2015E", string);
        }
    }

    public static void stopLogger(String string) {
        if (mgr != null) {
            if (loggers.get(string) != null) {
                mgr.returnLogger((LogEventProducer)loggers.get(string));
            }
            loggers.put(string, null);
            servicesFlags.put(string, 0);
            int n = 0;
            Iterator iterator = RequestType.getValues().iterator();
            while (iterator.hasNext()) {
                n += servicesFlags.get(iterator.next()).intValue();
            }
            if (n > 0) {
                TraceLoggerFactory.enableTraceFlag();
            } else {
                TraceLoggerFactory.disableTraceFlag();
            }
            if (string == "org.eclipse.aperi.common.svp.AuditSvp") {
                TraceLoggerFactory.disableAuditFlag();
            }
        }
    }

    public static void setTraceConfig(HashMap hashMap, String string) throws LocalizableException {
        Boolean bl = (Boolean)hashMap.get("enableFlag");
        String string2 = (String)hashMap.get("level");
        String string3 = (String)hashMap.get("maxFiles");
        String string4 = (String)hashMap.get("maxFileSize");
        int n = Integer.parseInt(string4) / 1000;
        string4 = Integer.toString(n);
        if (mgr == null) {
            String string5 = MessageLog.getMessage("GEN2016E");
            throw new LocalizableException(string5, null);
        }
        DataStore dataStore = mgr.getDataStore();
        DataStoreConfig dataStoreConfig = dataStore.getConfig("ITSRM.handler.file");
        dataStoreConfig.setProperty("maxFiles", string3);
        dataStoreConfig.setProperty("maxFileSize", string4);
        if (string.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.Server");
            dataStoreConfig.setProperty("logging", bl.toString());
            dataStoreConfig.setProperty("level", string2);
        } else if (string.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.Agent");
            dataStoreConfig.setProperty("logging", bl.toString());
            dataStoreConfig.setProperty("level", string2);
        } else if (string.equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.Scheduler");
            dataStoreConfig.setProperty("logging", bl.toString());
            dataStoreConfig.setProperty("level", string2);
        } else if (string.equals("org.eclipse.aperi.server.svp.AgentSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.TivoliSRM-Agent");
            dataStoreConfig.setProperty("logging", bl.toString());
            dataStoreConfig.setProperty("level", string2);
        } else if (string.equals("org.eclipse.aperi.server.svp.GuiSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.TivoliSRM-GUI");
            dataStoreConfig.setProperty("logging", bl.toString());
            dataStoreConfig.setProperty("level", string2);
        } else if (string.equals("org.eclipse.aperi.server.svp.CimomSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.TivoliSRM-CIMOM");
            dataStoreConfig.setProperty("logging", bl.toString());
            dataStoreConfig.setProperty("level", string2);
        }
        if (bl.booleanValue()) {
            Level level = Level.getLevel((String)string2);
            TraceLoggerFactory.enableTraceFlag();
            servicesFlags.put(string, level.getValue());
        } else {
            servicesFlags.put(string, 0);
            int n2 = 0;
            Iterator iterator = RequestType.getValues().iterator();
            while (iterator.hasNext()) {
                n2 += servicesFlags.get(iterator.next()).intValue();
            }
            if (n2 > 0) {
                TraceLoggerFactory.enableTraceFlag();
            } else {
                TraceLoggerFactory.disableTraceFlag();
            }
        }
        try {
            dataStore.updateConfig(dataStoreConfig);
            dataStore.saveConfig(false);
        }
        catch (Exception exception) {
            String string6 = MessageLog.getMessage("GEN2013E");
            throw new LocalizableException(string6, null);
        }
    }

    public static HashMap getTraceConfig(String string) throws LocalizableException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (mgr == null) {
            String string2 = MessageLog.getMessage("GEN2017E");
            throw new LocalizableException(string2, null);
        }
        DataStore dataStore = mgr.getDataStore();
        DataStoreConfig dataStoreConfig = dataStore.getConfig("ITSRM.handler.file");
        String string3 = dataStoreConfig.getProperty("maxFiles");
        int n = Integer.parseInt(dataStoreConfig.getProperty("maxFileSize")) * 1000;
        String string4 = Integer.toString(n);
        hashMap.put("maxFiles", string3);
        hashMap.put("maxFileSize", string4);
        if (string.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.Server");
            String string5 = dataStoreConfig.getProperty("logging");
            String string6 = dataStoreConfig.getProperty("level");
            Boolean bl = Boolean.valueOf(string5);
            hashMap.put("enableFlag", bl);
            hashMap.put("level", string6);
        } else if (string.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.Agent");
            String string7 = dataStoreConfig.getProperty("logging");
            String string8 = dataStoreConfig.getProperty("level");
            Boolean bl = Boolean.valueOf(string7);
            hashMap.put("enableFlag", bl);
            hashMap.put("level", string8);
        } else if (string.equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.Scheduler");
            String string9 = dataStoreConfig.getProperty("logging");
            String string10 = dataStoreConfig.getProperty("level");
            Boolean bl = Boolean.valueOf(string9);
            hashMap.put("enableFlag", bl);
            hashMap.put("level", string10);
        } else if (string.equals("org.eclipse.aperi.server.svp.AgentSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.TivoliSRM-Agent");
            String string11 = dataStoreConfig.getProperty("logging");
            String string12 = dataStoreConfig.getProperty("level");
            Boolean bl = Boolean.valueOf(string11);
            hashMap.put("enableFlag", bl);
            hashMap.put("level", string12);
        } else if (string.equals("org.eclipse.aperi.server.svp.GuiSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.TivoliSRM-GUI");
            String string13 = dataStoreConfig.getProperty("logging");
            String string14 = dataStoreConfig.getProperty("level");
            Boolean bl = Boolean.valueOf(string13);
            hashMap.put("enableFlag", bl);
            hashMap.put("level", string14);
        } else if (string.equals("org.eclipse.aperi.server.svp.CimomSvp")) {
            dataStoreConfig = dataStore.getConfig("ITSRM.logger.trace.TivoliSRM-CIMOM");
            String string15 = dataStoreConfig.getProperty("logging");
            String string16 = dataStoreConfig.getProperty("level");
            Boolean bl = Boolean.valueOf(string15);
            hashMap.put("enableFlag", bl);
            hashMap.put("level", string16);
        }
        return hashMap;
    }

    public static void setAuditConfig(HashMap hashMap, String string) throws LocalizableException {
        Boolean bl = (Boolean)hashMap.get("enableFlag");
        String string2 = bl != false ? "DEBUG_MAX" : (String)hashMap.get("level");
        String string3 = (String)hashMap.get("maxFiles");
        String string4 = (String)hashMap.get("maxFileSize");
        int n = Integer.parseInt(string4) / 1000;
        string4 = Integer.toString(n);
        if (mgr == null) {
            String string5 = MessageLog.getMessage("GEN2016E");
            throw new LocalizableException(string5, null);
        }
        DataStore dataStore = mgr.getDataStore();
        DataStoreConfig dataStoreConfig = dataStore.getConfig("ITSRMaudit.handler.file");
        dataStoreConfig.setProperty("maxFiles", string3);
        dataStoreConfig.setProperty("maxFileSize", string4);
        dataStoreConfig = dataStore.getConfig("ITSRM.logger.audit");
        dataStoreConfig.setProperty("logging", bl.toString());
        dataStoreConfig.setProperty("level", string2);
        if (bl.booleanValue()) {
            Level level = Level.getLevel((String)string2);
            TraceLoggerFactory.enableTraceFlag();
            servicesFlags.put(string, level.getValue());
        } else {
            servicesFlags.put(string, 0);
            int n2 = 0;
            Iterator iterator = RequestType.getValues().iterator();
            while (iterator.hasNext()) {
                n2 += servicesFlags.get(iterator.next()).intValue();
            }
            if (n2 > 0) {
                TraceLoggerFactory.enableTraceFlag();
            } else {
                TraceLoggerFactory.disableTraceFlag();
            }
        }
        try {
            dataStore.updateConfig(dataStoreConfig);
            dataStore.saveConfig(false);
        }
        catch (Exception exception) {
            String string6 = MessageLog.getMessage("GEN2013E");
            throw new LocalizableException(string6, null);
        }
    }

    public static HashMap getAuditConfig(String string) throws LocalizableException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (mgr == null) {
            String string2 = MessageLog.getMessage("GEN2017E");
            throw new LocalizableException(string2, null);
        }
        DataStore dataStore = mgr.getDataStore();
        DataStoreConfig dataStoreConfig = dataStore.getConfig("ITSRMaudit.handler.file");
        String string3 = dataStoreConfig.getProperty("maxFiles");
        int n = Integer.parseInt(dataStoreConfig.getProperty("maxFileSize")) * 1000;
        String string4 = Integer.toString(n);
        hashMap.put("maxFiles", string3);
        hashMap.put("maxFileSize", string4);
        dataStoreConfig = dataStore.getConfig("ITSRM.logger.audit");
        String string5 = dataStoreConfig.getProperty("logging");
        String string6 = dataStoreConfig.getProperty("level");
        Boolean bl = Boolean.valueOf(string5);
        hashMap.put("enableFlag", bl);
        hashMap.put("level", string6);
        return hashMap;
    }

    public static void entry(String string, String string2, String string3) {
        String string4 = TSThread.getServiceID();
        if (loggers.get(string4) == null) {
            return;
        }
        if (servicesFlags.get(string4) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SEP1);
            stringBuffer.append(string2);
            stringBuffer.append("(");
            stringBuffer.append(string3);
            stringBuffer.append(")");
            stringBuffer.append("  --");
            stringBuffer.append(RequestTypeManager.getInternalName(string4));
            if (loggers.get(string4) != null) {
                loggers.get(string4).entry(Level.DEBUG_MAX, (Object)string, stringBuffer.toString());
            }
        }
    }

    public static void exit(String string, String string2) {
        String string3 = TSThread.getServiceID();
        if (loggers.get(string3) == null) {
            return;
        }
        if (servicesFlags.get(string3) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SEP1);
            stringBuffer.append(string2);
            stringBuffer.append("  --");
            stringBuffer.append(RequestTypeManager.getInternalName(string3));
            if (loggers.get(string3) != null) {
                loggers.get(string3).exit(Level.DEBUG_MAX, (Object)string, stringBuffer.toString());
            }
        }
    }

    public static void exit(String string, String string2, Object object) {
        String string3 = TSThread.getServiceID();
        if (loggers.get(string3) == null) {
            return;
        }
        if (servicesFlags.get(string3) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(SEP1);
            stringBuffer.append(string2);
            stringBuffer.append(SEP3);
            stringBuffer.append(object);
            stringBuffer.append("  --");
            stringBuffer.append(RequestTypeManager.getInternalName(string3));
            if (loggers.get(string3) != null) {
                loggers.get(string3).exit(Level.DEBUG_MAX, (Object)string, stringBuffer.toString());
            }
        }
    }

    public static void exit(String string, String string2, boolean bl) {
        TraceLoggerFactory.exit(string, string2, new Boolean(bl));
    }

    public static void exit(String string, String string2, int n) {
        TraceLoggerFactory.exit(string, string2, Integer.toString(n));
    }

    public static void exit(String string, String string2, short s) {
        TraceLoggerFactory.exit(string, string2, Integer.toString(s));
    }

    public static void exit(String string, String string2, char c) {
        TraceLoggerFactory.exit(string, string2, Integer.toString(c));
    }

    public static void exit(String string, String string2, byte by) {
        TraceLoggerFactory.exit(string, string2, Integer.toString(by));
    }

    public static void exit(String string, String string2, long l) {
        TraceLoggerFactory.exit(string, string2, Integer.toString((int)l));
    }

    public static void exception(String string, String string2, Throwable throwable) {
        String string3 = TSThread.getServiceID();
        if (loggers.get(string3) == null) {
            return;
        }
        if (servicesFlags.get(string3) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("EXCEPTION ");
            if (loggers.get(string3) != null) {
                loggers.get(string3).exception(Level.DEBUG_MIN, (Object)string, string2, throwable, stringBuffer.toString());
            }
        }
    }

    public static void traceMessage(int n, String string, String string2, String string3) {
        String string4 = TSThread.getServiceID();
        if (loggers.get(string4) == null) {
            return;
        }
        if (servicesFlags.get(string4) > 0) {
            Level level = Level.DEBUG_MAX;
            switch (n) {
                case 1: {
                    level = Level.DEBUG_MIN;
                    break;
                }
                case 2: {
                    level = Level.DEBUG_MID;
                    break;
                }
                case 3: {
                    level = Level.DEBUG_MAX;
                }
            }
            PDLogger pDLogger = loggers.get(string4);
            if (pDLogger != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                stringBuffer.append("  --");
                stringBuffer.append(RequestTypeManager.getInternalName(string4));
                pDLogger.text(level, (Object)string, stringBuffer.toString(), string3);
            }
        }
    }

    private static synchronized void enableTraceFlag() {
        TraceLogger.enableTrace = true;
    }

    private static synchronized void disableTraceFlag() {
        TraceLogger.enableTrace = false;
    }

    private static synchronized void enableAuditFlag() {
        TraceLogger.enableAudit = true;
    }

    private static synchronized void disableAuditFlag() {
        TraceLogger.enableAudit = false;
    }

    public static void auditMessage(String string, String string2, String string3) {
        Level level = Level.DEBUG_MAX;
        loggers.get("org.eclipse.aperi.common.svp.AuditSvp").text(level, (Object)string, string2, string3);
    }
}

