/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.cmdline;

import org.eclipse.aperi.sanmgmt.cmdline.Column;

public class ColumnManager {
    private static final boolean DEBUG = false;
    private static ColumnManager cm;
    private static final int INITIAL_CAPACITY = 8;
    private static final int CAPACITY_INCREMENT = 4;
    Column[] columns;
    boolean[] inUse;
    int size = 0;

    private ColumnManager(int n) {
        this.columns = new Column[n];
        this.inUse = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.columns[n2] = new Column();
            this.inUse[n2] = false;
            ++n2;
        }
    }

    public static synchronized ColumnManager getManager() {
        if (cm == null) {
            cm = new ColumnManager(8);
        }
        return cm;
    }

    public synchronized Column getColumn() {
        int n = 0;
        while (n < this.inUse.length) {
            if (!this.inUse[n]) {
                this.inUse[n] = true;
                ++this.size;
                return this.columns[n];
            }
            ++n;
        }
        Column[] columnArray = this.columns;
        boolean[] blArray = this.inUse;
        this.columns = new Column[columnArray.length + 4];
        this.inUse = new boolean[blArray.length + 4];
        System.arraycopy(columnArray, 0, this.columns, 0, columnArray.length);
        System.arraycopy(blArray, 0, this.inUse, 0, blArray.length);
        int n2 = columnArray.length;
        while (n2 < this.columns.length) {
            this.columns[n2] = new Column();
            this.inUse[n2] = false;
            ++n2;
        }
        this.inUse[columnArray.length] = true;
        ++this.size;
        return this.columns[columnArray.length];
    }

    public synchronized void returnColumn(Column column) {
        int n = 0;
        while (n < this.columns.length) {
            if (this.columns[n] == column) {
                this.inUse[n] = false;
                --this.size;
                this.columns[n].resetColumn();
            }
            ++n;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.columns.length;
    }
}

