/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.middleware.data;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.AuthRoles;
import org.eclipse.aperi.sanmgmt.middleware.data.GroupData;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;

public final class Roles {
    private static Roles instance;
    private static boolean passthrough;
    private static Hashtable roleMap;
    private static Hashtable baseMap;
    public static final int INVALID_USER = -1;
    public static final int INVALID_PASSWORD = -2;
    private static String UPDATE_BY_ROLE_ID;
    private static String INSERT_BY_ROLE_ID;
    private static String DELETE_BY_ROLE_ID;
    public static final int API_ERROR = -2;
    public static final int RIGHTS_ALREADY_ENABLED = 0;
    public static final int RIGHTS_NOT_ENABLED = 1;
    public static final int SUCCESS = 2;
    public static final String SE_SERVICE_LOGON_NAME = "SeServiceLogonRight";

    static {
        try {
            System.loadLibrary("Common");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            System.out.println(unsatisfiedLinkError.getMessage());
            unsatisfiedLinkError.printStackTrace(System.out);
        }
        instance = null;
        passthrough = false;
        if (System.getProperty("tpc.roles.check.passthrough") != null) {
            passthrough = true;
        }
        roleMap = new Hashtable();
        baseMap = new Hashtable();
        baseMap.put(new Integer(RoleChecker.SUPERUSER), new RoleData(RoleChecker.SUPERUSER, null));
        baseMap.put(new Integer(RoleChecker.APERI_ADMIN), new RoleData(RoleChecker.APERI_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DISK_ADMIN), new RoleData(RoleChecker.DISK_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DISK_VIEWER), new RoleData(RoleChecker.DISK_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.FABRIC_ADMIN), new RoleData(RoleChecker.FABRIC_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.FABRIC_VIEWER), new RoleData(RoleChecker.FABRIC_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.DATA_ADMIN), new RoleData(RoleChecker.DATA_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.DATA_VIEWER), new RoleData(RoleChecker.DATA_VIEWER, null));
        baseMap.put(new Integer(RoleChecker.TAPE_ADMIN), new RoleData(RoleChecker.TAPE_ADMIN, null));
        baseMap.put(new Integer(RoleChecker.TAPE_VIEWER), new RoleData(RoleChecker.TAPE_VIEWER, null));
        UPDATE_BY_ROLE_ID = "UPDATE t_res_auth_roles SET role_name=?, group_name=?, group_type=? where role_id=?";
        INSERT_BY_ROLE_ID = "INSERT into t_res_auth_roles (role_name, group_name, group_type, role_id) values (?,?,?,?)";
        DELETE_BY_ROLE_ID = "DELETE from t_res_auth_roles where role_id=?";
    }

    private static native int isValidUser(String var0, String var1, boolean var2);

    private static native boolean isGroupMember(String var0, String var1, int var2);

    private static native boolean isValidGroup(String var0, int var1);

    private static native int getGroupType(String var0);

    private static native int checkAccountRights(String var0, String[] var1, boolean var2);

    private static native String localAdminGroup();

    private static native String retrieveNativeLog();

    private Roles() {
    }

    public static Roles getInstance() throws SQLException {
        if (instance == null) {
            try {
                instance = new Roles();
                Roles.refresh();
            }
            catch (SQLException sQLException) {
                instance = null;
                throw sQLException;
            }
        }
        return instance;
    }

    public static boolean getPassthrough() {
        return passthrough;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refresh() throws SQLException {
        block14: {
            var0 = null;
            var1_1 = null;
            try {
                var2_2 = DBConnPoolDataSource.getInstance();
                var0 = (DBConnection)var2_2.getPooledConnection();
                Roles.roleMap.clear();
                var1_1 = AuthRoles.getCursor(var0, null, null);
                if (var1_1 != null) {
                    var3_3 = null;
                    while (var1_1.next()) {
                        var3_3 = var1_1.getObject();
                        if (var3_3 == null) continue;
                        var4_4 = new Integer(var3_3.getRoleId());
                        var5_5 = new RoleData(var3_3.getRoleName(), var3_3.getGroupName(), (int)var3_3.getGroupType());
                        Roles.roleMap.put(var4_4, var5_5);
                    }
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    if (var1_1 != null) {
                        var1_1.close();
                    }
                }
                catch (Exception var8_9) {
                    var8_9.printStackTrace();
                }
                try {
                    if (var0 == null) throw var7_6;
                    var0.close();
                    throw var7_6;
                }
                catch (Exception var8_9) {
                    var8_9.printStackTrace();
                }
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 112->123)] { 
lbl38:
            // 1 sources

            if (var1_1 != null) {
                var1_1.close();
            }
            break block14;
lbl41:
            // 1 sources

            catch (Exception var8_10) {
                var8_10.printStackTrace();
            }
        }
        try {}
        catch (Exception var8_10) {
            var8_10.printStackTrace();
            return;
        }
        if (var0 == null) return;
        var0.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(RoleData[] var1_1) throws SQLException {
        block41: {
            block42: {
                block39: {
                    block40: {
                        block36: {
                            block38: {
                                var2_2 = null;
                                var3_3 = null;
                                var4_4 = null;
                                var5_5 = null;
                                var6_6 = false;
                                var7_7 = 0;
                                while (true) {
                                    if (var7_7 >= var1_1.length) {
                                        ** try [egrp 0[TRYBLOCK] [2 : 60->338)] { 
lbl10:
                                        // 1 sources

                                        break;
                                    }
                                    if (var1_1[var7_7] == null) return var6_6;
                                    if (var1_1[var7_7].getGroupName() != null && !this.isValidRoleData(var1_1[var7_7])) {
                                        return var6_6;
                                    }
                                    ++var7_7;
                                }
                                {
                                    try {
                                        var7_8 = DBConnPoolDataSource.getInstance();
                                        var2_2 = (DBConnection)var7_8.getPooledConnection();
                                        var3_3 = var2_2.prepareStatement(Roles.DELETE_BY_ROLE_ID);
                                        var4_4 = var2_2.prepareStatement(Roles.INSERT_BY_ROLE_ID);
                                        var5_5 = var2_2.prepareStatement(Roles.UPDATE_BY_ROLE_ID);
                                        var8_10 = 0;
                                        while (true) {
                                            block37: {
                                                if (var8_10 < var1_1.length) break block37;
                                                var2_2.commit();
                                                Roles.refresh();
                                                var6_6 = true;
                                                ** GOTO lbl-1000
                                            }
                                            var9_12 = RoleChecker.getRoleID(var1_1[var8_10].getRoleName());
                                            var10_13 = var1_1[var8_10].getRoleName();
                                            var11_14 = var1_1[var8_10].getGroupName();
                                            var12_15 = var1_1[var8_10].getGroupType();
                                            var13_16 = (RoleData)Roles.roleMap.get(new Integer(var9_12));
                                            if (var11_14 == null) {
                                                if (var13_16 != null) {
                                                    var3_3.setInt(1, var9_12);
                                                    var3_3.executeUpdate();
                                                }
                                            } else if (var13_16 == null) {
                                                var4_4.setString(1, var10_13);
                                                var4_4.setString(2, var11_14);
                                                var4_4.setInt(3, var12_15);
                                                var4_4.setInt(4, var9_12);
                                                var4_4.executeUpdate();
                                            } else if (var11_14.compareTo(var13_16.getGroupName()) != 0) {
                                                var5_5.setString(1, var10_13);
                                                var5_5.setString(2, var11_14);
                                                var5_5.setInt(3, var12_15);
                                                var5_5.setInt(4, var9_12);
                                                var5_5.executeUpdate();
                                            }
                                            ++var8_10;
                                        }
                                    }
                                    catch (SQLException var7_9) {
                                        try {
                                            if (var2_2 != null) {
                                                var2_2.rollback();
                                            }
                                        }
                                        catch (SQLException var8_11) {
                                            var8_11.printStackTrace();
                                        }
                                        var7_9.printStackTrace();
                                        throw var7_9;
                                    }
                                }
lbl67:
                                // 1 sources

                                catch (Throwable var15_17) {
                                    var14_18 = null;
                                    if (var3_3 != null) {
                                        try {
                                            var3_3.close();
                                        }
                                        catch (SQLException var16_20) {
                                            var16_20.printStackTrace();
                                        }
                                        var3_3 = null;
                                    }
                                    if (var4_4 != null) {
                                        try {
                                            var4_4.close();
                                        }
                                        catch (SQLException var16_20) {
                                            var16_20.printStackTrace();
                                        }
                                        var4_4 = null;
                                    }
                                    if (var5_5 != null) {
                                        try {
                                            var5_5.close();
                                        }
                                        catch (SQLException var16_20) {
                                            var16_20.printStackTrace();
                                        }
                                        var5_5 = null;
                                    }
                                    try {
                                        if (var2_2 == null) throw var15_17;
                                        var2_2.close();
                                        throw var15_17;
                                    }
                                    catch (Exception var16_20) {
                                        var16_20.printStackTrace();
                                    }
                                    throw var15_17;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    var14_19 = null;
                                    if (var3_3 == null) break block36;
                                }
                                ** try [egrp 3[TRYBLOCK] [4 : 352->359)] { 
lbl104:
                                // 1 sources

                                var3_3.close();
                                break block38;
lbl106:
                                // 1 sources

                                catch (SQLException var16_21) {
                                    var16_21.printStackTrace();
                                }
                            }
                            var3_3 = null;
                        }
                        if (var4_4 == null) break block39;
                        ** try [egrp 4[TRYBLOCK] [5 : 373->381)] { 
lbl113:
                        // 1 sources

                        var4_4.close();
                        break block40;
lbl115:
                        // 1 sources

                        catch (SQLException var16_21) {
                            var16_21.printStackTrace();
                        }
                    }
                    var4_4 = null;
                }
                if (var5_5 == null) break block41;
                ** try [egrp 5[TRYBLOCK] [6 : 396->404)] { 
lbl122:
                // 1 sources

                var5_5.close();
                break block42;
lbl124:
                // 1 sources

                catch (SQLException var16_21) {
                    var16_21.printStackTrace();
                }
            }
            var5_5 = null;
        }
        try {}
        catch (Exception var16_21) {
            var16_21.printStackTrace();
            return var6_6;
        }
        if (var2_2 == null) return var6_6;
        var2_2.close();
        return var6_6;
    }

    public int getUserRoles(String string) {
        int n;
        block8: {
            n = 0;
            try {
                Object object;
                if (passthrough) {
                    n = RoleChecker.SUPERUSER;
                } else if (roleMap.get(new Integer(RoleChecker.SUPERUSER)) == null) {
                    object = null;
                    object = System.getProperty("os.name").startsWith("Win") ? "Administrators" : "adm";
                    if (Roles.isGroupMember(string, (String)object, GroupData.LOCAL_GROUP)) {
                        n = RoleChecker.SUPERUSER;
                    }
                }
                if (n != RoleChecker.NO_ROLE) break block8;
                object = roleMap.keys();
                while (object.hasMoreElements()) {
                    int n2;
                    Object k = object.nextElement();
                    RoleData roleData = (RoleData)roleMap.get(k);
                    String string2 = roleData.getGroupName();
                    if (string2 == null || !Roles.isGroupMember(string, string2, n2 = roleData.getGroupType())) continue;
                    int n3 = (Integer)k;
                    if (n3 == RoleChecker.SUPERUSER) {
                        n = n3;
                        break;
                    }
                    n |= n3;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return n;
    }

    public boolean setGroupType(RoleData roleData) {
        boolean bl = false;
        int n = 0;
        try {
            if (roleData.getGroupName() != null) {
                if (Roles.checkLocalGroup(roleData.getGroupName())) {
                    n = GroupData.LOCAL_GROUP;
                } else if (Roles.checkLocalGroup(roleData.getGroupName(), GroupData.DOMAIN_GROUP)) {
                    n = GroupData.DOMAIN_GROUP;
                }
            }
            if (n > 0) {
                roleData.setGroupType(n);
                bl = true;
            } else {
                bl = false;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return bl;
    }

    public boolean isValidRoleData(RoleData roleData) {
        String string;
        boolean bl = false;
        if (roleData != null && RoleChecker.getRoleID(roleData.getRoleName()) > 0 && (string = roleData.getGroupName()) != null) {
            bl = this.setGroupType(roleData);
        }
        return bl;
    }

    public Hashtable getRoleMap() {
        return roleMap;
    }

    public Hashtable getFullRoleMap() {
        Hashtable hashtable = new Hashtable(baseMap);
        hashtable.putAll(roleMap);
        return hashtable;
    }

    public static boolean checkLocalGroup(String string) {
        return Roles.checkLocalGroup(string, GroupData.LOCAL_GROUP);
    }

    public static boolean checkLocalGroup(String string, int n) {
        boolean bl = false;
        try {
            bl = Roles.isValidGroup(string, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return bl;
    }

    public static int validateLocalLogin(String string, String string2) {
        int n = -1;
        try {
            n = string != null ? (string2 != null ? Roles.isValidUser(string, string2, false) : -2) : -1;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n;
    }

    public static int validateDomainLogin(String string, String string2) {
        int n = -1;
        try {
            n = string != null ? (string2 != null ? Roles.isValidUser(string, string2, true) : -2) : -1;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n;
    }

    public static int validateAccountRights(String string, String[] stringArray, boolean bl) {
        int n = -1;
        try {
            if (string != null) {
                n = Roles.checkAccountRights(string, stringArray, bl);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return n;
    }

    public static String nativeLog() {
        String string = "";
        boolean bl = false;
        if (bl && System.getProperty("os.name").startsWith("Win")) {
            try {
                string = Roles.retrieveNativeLog();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return string;
    }

    public static String administratorsGroup() {
        String string = "";
        if (System.getProperty("os.name").startsWith("Win")) {
            try {
                string = Roles.localAdminGroup();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return string;
    }

    public static boolean validateUserMembership(String string, String string2, int n) {
        boolean bl = false;
        try {
            bl = Roles.isGroupMember(string, string2, n);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
        return bl;
    }
}

