/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.tsanm.zone.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone2ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone2ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias2ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet2Zone;

public class ZoneDefinition
implements Serializable,
Cloneable {
    static final long serialVersionUID = 7902029858130148138L;
    private String version = "5.0.0";
    protected ArrayList zonesets = new ArrayList();
    protected ArrayList zones = new ArrayList();
    protected ArrayList members = new ArrayList();
    protected ArrayList aliases = new ArrayList();
    protected ArrayList zoneset2zone = new ArrayList();
    protected ArrayList zone2member = new ArrayList();
    protected ArrayList zone2alias = new ArrayList();
    protected ArrayList alias2member = new ArrayList();
    private String activeZoneSet = null;
    private String lastActiveZoneSet = null;
    static final String className;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public synchronized Object clone() {
        try {
            ZoneDefinition zoneDefinition = (ZoneDefinition)super.clone();
            zoneDefinition.zonesets = (ArrayList)this.zonesets.clone();
            zoneDefinition.zones = (ArrayList)this.zones.clone();
            zoneDefinition.members = (ArrayList)this.members.clone();
            zoneDefinition.aliases = (ArrayList)this.aliases.clone();
            zoneDefinition.zoneset2zone = (ArrayList)this.zoneset2zone.clone();
            zoneDefinition.zone2member = (ArrayList)this.zone2member.clone();
            zoneDefinition.zone2alias = (ArrayList)this.zone2alias.clone();
            zoneDefinition.alias2member = (ArrayList)this.alias2member.clone();
            return zoneDefinition;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        String string = null;
        string = new String();
        if (this.zonesets.size() > 0 || this.zones.size() > 0 || this.members.size() > 0 || this.aliases.size() > 0) {
            Object object;
            int n;
            Object object2;
            Serializable[] serializableArray;
            string = string.concat("\n\n===========================================================");
            string = string.concat("\nZone Definition members:\n");
            string = string.concat("\n\tZoneSets:\n");
            ZoneSet[] zoneSetArray = this.zonesets.toArray(new ZoneSet[0]);
            int n2 = 0;
            while (n2 < zoneSetArray.length) {
                string = string.concat("\t\t" + zoneSetArray[n2].getName() + "\n");
                ++n2;
            }
            string = string.concat("\n\tActive ZoneSet:\n");
            if (this.activeZoneSet != null) {
                string = string.concat("\t\t" + this.activeZoneSet + "\n");
            }
            string = string.concat("\n\tZones:\n");
            Zone[] zoneArray = this.zones.toArray(new Zone[0]);
            int n3 = 0;
            while (n3 < zoneArray.length) {
                string = string.concat("\t\t" + zoneArray[n3].getName() + "; " + zoneArray[n3].getVendorType() + "\n");
                Enumeration enumeration = zoneArray[n3].getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    string = string.concat("\t\t\tParameter: " + string2 + ", " + zoneArray[n3].getParameterValue(string2) + "\n");
                }
                ++n3;
            }
            string = string.concat("\n\tZoneAliases:\n");
            ZoneAlias[] zoneAliasArray = this.aliases.toArray(new ZoneAlias[0]);
            int n4 = 0;
            while (n4 < zoneAliasArray.length) {
                string = string.concat("\t\t" + zoneAliasArray[n4].getName() + "\n");
                ++n4;
            }
            string = string.concat("\n\tZoneMembers:\n");
            ZoneMember[] zoneMemberArray = this.members.toArray(new ZoneMember[0]);
            int n5 = 0;
            while (n5 < zoneMemberArray.length) {
                string = string.concat("\t\t" + zoneMemberArray[n5].getName() + "; " + zoneMemberArray[n5].getType() + "\n");
                ++n5;
            }
            string = string.concat("\n\nZone Definition relationships:\n");
            n5 = 0;
            while (n5 < zoneSetArray.length) {
                serializableArray = zoneSetArray[n5].getName();
                string = this.activeZoneSet != null && serializableArray.equals(this.activeZoneSet) ? string.concat("\n\tActive ZoneSet: " + (String)serializableArray + "\n") : string.concat("\n\tZoneSet: " + (String)serializableArray + "\n");
                object2 = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
                n = 0;
                while (n < ((ZoneSet2Zone[])object2).length) {
                    if (object2[n].getZoneSetName().equals(zoneSetArray[n5].getName())) {
                        Zone2ZoneMember[] zone2ZoneMemberArray;
                        string = string.concat("\t\tZone: " + object2[n].getZoneName() + "; " + object2[n].getZoneVendorType() + "\n");
                        Zone zone = this.getZone(object2[n].getZoneName(), object2[n].getZoneVendorType());
                        object = zone.getParameterNames();
                        while (object.hasMoreElements()) {
                            zone2ZoneMemberArray = (Zone2ZoneMember[])object.nextElement();
                            string = string.concat("\t\t\tParameter: " + (String)zone2ZoneMemberArray + ", " + zone.getParameterValue((String)zone2ZoneMemberArray) + "\n");
                        }
                        object = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
                        int n6 = 0;
                        while (n6 < ((Zone2ZoneAlias[])object).length) {
                            if (object[n6].getZoneName().equals(object2[n].getZoneName())) {
                                string = string.concat("\t\t\tZoneAlias: " + object[n6].getZoneAliasName() + "\n");
                                ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                                int n7 = 0;
                                while (n7 < zoneAlias2ZoneMemberArray.length) {
                                    if (zoneAlias2ZoneMemberArray[n7].getZoneAliasName().equals(((Zone2ZoneAlias)object[n6]).getZoneAliasName())) {
                                        ZoneMember zoneMember = this.getZoneMember(zoneAlias2ZoneMemberArray[n7].getZoneMemberName(), zoneAlias2ZoneMemberArray[n7].getZoneMemberType());
                                        string = string.concat("\t\t\t\tZoneMember: " + zoneMember.getName() + "; " + zoneMember.getType() + "\n");
                                    }
                                    ++n7;
                                }
                            }
                            ++n6;
                        }
                        zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
                        int n8 = 0;
                        while (n8 < zone2ZoneMemberArray.length) {
                            if (zone2ZoneMemberArray[n8].getZoneName().equals(object2[n].getZoneName())) {
                                ZoneMember zoneMember = this.getZoneMember(zone2ZoneMemberArray[n8].getZoneMemberName(), zone2ZoneMemberArray[n8].getZoneMemberType());
                                string = string.concat("\t\t\tZoneMember: " + zoneMember.getName() + "; " + zoneMember.getType() + "\n");
                            }
                            ++n8;
                        }
                    }
                    ++n;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < zoneArray.length) {
                if (this.isOrphaned(zoneArray[n5]) && !this.isEmpty(zoneArray[n5])) {
                    string = string.concat("\n\tZone: " + zoneArray[n5].getName() + "; " + zoneArray[n5].getVendorType() + "\n");
                    serializableArray = zoneArray[n5].getParameterNames();
                    while (serializableArray.hasMoreElements()) {
                        object2 = (String)serializableArray.nextElement();
                        string = string.concat("\t\tParameter: " + (String)object2 + ", " + zoneArray[n5].getParameterValue((String)object2) + "\n");
                    }
                    serializableArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
                    int n9 = 0;
                    while (n9 < serializableArray.length) {
                        if (((Zone2ZoneAlias)serializableArray[n9]).getZoneName().equals(zoneArray[n5].getName())) {
                            string = string.concat("\t\tZoneAlias: " + ((Zone2ZoneAlias)serializableArray[n9]).getZoneAliasName() + "\n");
                            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                            int n10 = 0;
                            while (n10 < zoneAlias2ZoneMemberArray.length) {
                                if (zoneAlias2ZoneMemberArray[n10].getZoneAliasName().equals(((Zone2ZoneAlias)serializableArray[n9]).getZoneAliasName())) {
                                    object = this.getZoneMember(zoneAlias2ZoneMemberArray[n10].getZoneMemberName(), zoneAlias2ZoneMemberArray[n10].getZoneMemberType());
                                    string = string.concat("\t\t\tZoneMember: " + ((ZoneMember)object).getName() + "; " + ((ZoneMember)object).getType() + "\n");
                                }
                                ++n10;
                            }
                        }
                        ++n9;
                    }
                    object2 = this.zone2member.toArray(new Zone2ZoneMember[0]);
                    n = 0;
                    while (n < ((ZoneSet2Zone[])object2).length) {
                        if (((Zone2ZoneMember)((Object)object2[n])).getZoneName().equals(zoneArray[n5].getName())) {
                            ZoneMember zoneMember = this.getZoneMember(((Zone2ZoneMember)((Object)object2[n])).getZoneMemberName(), ((Zone2ZoneMember)((Object)object2[n])).getZoneMemberType());
                            string = string.concat("\t\tZoneMember: " + zoneMember.getName() + "; " + zoneMember.getType() + "\n");
                        }
                        ++n;
                    }
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < zoneAliasArray.length) {
                if (this.isOrphaned(zoneAliasArray[n5]) && !this.isEmpty(zoneAliasArray[n5])) {
                    string = string.concat("\n\tZoneAlias: " + zoneAliasArray[n5].getName() + "\n");
                    serializableArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                    int n11 = 0;
                    while (n11 < serializableArray.length) {
                        if (serializableArray[n11].getZoneAliasName().equals(zoneAliasArray[n5].getName())) {
                            ZoneMember zoneMember = this.getZoneMember(((ZoneAlias2ZoneMember)serializableArray[n11]).getZoneMemberName(), ((ZoneAlias2ZoneMember)serializableArray[n11]).getZoneMemberType());
                            string = string.concat("\t\tZoneMember: " + zoneMember.getName() + "; " + zoneMember.getType() + "\n");
                        }
                        ++n11;
                    }
                }
                ++n5;
            }
            string = string.concat("===========================================================\n\n");
        } else {
            string = string.concat("\nNothing present in the Zone Definition\n");
        }
        return string;
    }

    public void addZoneSets(ZoneSet[] zoneSetArray) {
        int n = 0;
        while (n < zoneSetArray.length) {
            this.addZoneSet(zoneSetArray[n]);
            ++n;
        }
    }

    public void addZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null && !this.zonesets.contains(zoneSet)) {
            this.zonesets.add(zoneSet);
            if (this.activeZoneSet == null && this.lastActiveZoneSet != null && this.lastActiveZoneSet.equals(zoneSet.getName())) {
                this.activeZoneSet = zoneSet.getName();
                this.lastActiveZoneSet = null;
            }
        }
    }

    public ZoneSet[] getZoneSets() {
        return this.zonesets.toArray(new ZoneSet[0]);
    }

    public ZoneSet[] getZoneSets(Zone zone) {
        ArrayList<ZoneSet> arrayList = new ArrayList<ZoneSet>();
        if (zone != null) {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneName().equals(zone.getName())) {
                    arrayList.add(this.getZoneSet(zoneSet2ZoneArray[n].getZoneSetName()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new ZoneSet[0]);
    }

    public ZoneSet getZoneSet(String string) {
        if (string != null) {
            ZoneSet[] zoneSetArray = this.zonesets.toArray(new ZoneSet[0]);
            int n = 0;
            while (n < zoneSetArray.length) {
                if (zoneSetArray[n].getName().equals(string)) {
                    return zoneSetArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public void deleteZoneSets(ZoneSet[] zoneSetArray) {
        int n = 0;
        while (n < zoneSetArray.length) {
            this.deleteZoneSet(zoneSetArray[n]);
            ++n;
        }
    }

    public void deleteZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null) {
            if (this.activeZoneSet != null && this.activeZoneSet.equals(zoneSet.getName())) {
                this.activeZoneSet = null;
                this.lastActiveZoneSet = zoneSet.getName();
            }
            this.zonesets.remove(zoneSet);
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneSetName().equals(zoneSet.getName())) {
                    this.getZone(zoneSet2ZoneArray[n].getZoneName(), zoneSet2ZoneArray[n].getZoneVendorType());
                    this.zoneset2zone.remove(zoneSet2ZoneArray[n]);
                }
                ++n;
            }
        }
    }

    public void activateZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null) {
            this.addZoneSet(zoneSet);
            this.activeZoneSet = zoneSet.getName();
            this.lastActiveZoneSet = null;
        }
    }

    public void deactivateZoneSet() {
        this.activeZoneSet = null;
        this.lastActiveZoneSet = null;
    }

    public void deactivateZoneSet(ZoneSet zoneSet) {
        if (zoneSet != null && this.activeZoneSet != null && this.activeZoneSet.equals(zoneSet.getName())) {
            this.activeZoneSet = null;
            this.lastActiveZoneSet = null;
        }
    }

    public ZoneSet getActiveZoneSet() {
        if (this.activeZoneSet != null) {
            return this.getZoneSet(this.activeZoneSet);
        }
        return null;
    }

    private boolean isEmpty(ZoneSet zoneSet) {
        boolean bl = true;
        if (zoneSet == null) {
            bl = false;
        } else {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneSetName().equals(zoneSet.getName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public void addZones(Zone[] zoneArray) {
        int n = 0;
        while (n < zoneArray.length) {
            this.addZone(zoneArray[n]);
            ++n;
        }
    }

    public void addZone(Zone zone) {
        if (zone != null && !this.zones.contains(zone)) {
            this.zones.add(zone);
        }
    }

    public void addZone(ZoneSet zoneSet, Zone zone) {
        if (zoneSet != null && zone != null) {
            this.addZoneSet(zoneSet);
            this.addZone(zone);
            ZoneSet2Zone zoneSet2Zone = new ZoneSet2Zone(zoneSet.getName(), zone.getName(), zone.getVendorType());
            if (!this.zoneset2zone.contains(zoneSet2Zone)) {
                this.zoneset2zone.add(zoneSet2Zone);
            }
        }
    }

    public void removeZone(ZoneSet zoneSet, Zone zone) {
        if (zoneSet != null && zone != null) {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneSetName().equals(zoneSet.getName()) && zoneSet2ZoneArray[n].getZoneName().equals(zone.getName())) {
                    ZoneSet zoneSet2 = this.getZoneSet(zoneSet2ZoneArray[n].getZoneSetName());
                    this.zoneset2zone.remove(zoneSet2ZoneArray[n]);
                    if (this.isEmpty(zoneSet2)) {
                        this.deleteZoneSet(zoneSet2);
                    }
                }
                ++n;
            }
        }
    }

    public ZoneSet[] removeZoneAndReturnDeletedZoneSets(ZoneSet zoneSet, Zone zone) {
        ArrayList<ZoneSet> arrayList = new ArrayList<ZoneSet>();
        if (zoneSet != null && zone != null) {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneSetName().equals(zoneSet.getName()) && zoneSet2ZoneArray[n].getZoneName().equals(zone.getName())) {
                    ZoneSet zoneSet2 = this.getZoneSet(zoneSet2ZoneArray[n].getZoneSetName());
                    this.zoneset2zone.remove(zoneSet2ZoneArray[n]);
                    if (this.isEmpty(zoneSet2)) {
                        if (!arrayList.contains(zoneSet2)) {
                            arrayList.add(zoneSet2);
                        }
                        this.deleteZoneSet(zoneSet2);
                    }
                }
                ++n;
            }
        }
        return arrayList.toArray(new ZoneSet[0]);
    }

    public Zone[] getZones() {
        return this.zones.toArray(new Zone[0]);
    }

    public Zone getZone(String string) {
        if (string != null) {
            Zone[] zoneArray = this.zones.toArray(new Zone[0]);
            int n = 0;
            while (n < zoneArray.length) {
                if (zoneArray[n].getName().equals(string) && zoneArray[n].getVendorType() == 1) {
                    return zoneArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public Zone getZone(String string, short s) {
        if (string != null) {
            Zone[] zoneArray = this.zones.toArray(new Zone[0]);
            int n = 0;
            while (n < zoneArray.length) {
                if (zoneArray[n].getName().equals(string) && zoneArray[n].getVendorType() == s) {
                    return zoneArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public Zone[] getZones(ZoneSet zoneSet) {
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        if (zoneSet != null) {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneSetName().equals(zoneSet.getName())) {
                    arrayList.add(this.getZone(zoneSet2ZoneArray[n].getZoneName(), zoneSet2ZoneArray[n].getZoneVendorType()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new Zone[0]);
    }

    public Zone[] getZones(ZoneAlias zoneAlias) {
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        if (zoneAlias != null) {
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n].getZoneAliasName().equals(zoneAlias.getName())) {
                    arrayList.add(this.getZone(zone2ZoneAliasArray[n].getZoneName(), zone2ZoneAliasArray[n].getZoneVendorType()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new Zone[0]);
    }

    public Zone[] getZones(ZoneMember zoneMember) {
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        if (zoneMember != null) {
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n = 0;
            while (n < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n].getZoneMemberName().equalsIgnoreCase(zoneMember.getName()) && zone2ZoneMemberArray[n].getZoneMemberType() == zoneMember.getType()) {
                    arrayList.add(this.getZone(zone2ZoneMemberArray[n].getZoneName(), zone2ZoneMemberArray[n].getZoneVendorType()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new Zone[0]);
    }

    public void deleteZones(Zone[] zoneArray) {
        int n = 0;
        while (n < zoneArray.length) {
            this.deleteZone(zoneArray[n]);
            ++n;
        }
    }

    public void deleteZone(Zone zone) {
        if (zone != null) {
            this.zones.remove(zone);
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneName().equals(zone.getName())) {
                    ZoneSet zoneSet = this.getZoneSet(zoneSet2ZoneArray[n].getZoneSetName());
                    this.zoneset2zone.remove(zoneSet2ZoneArray[n]);
                    if (this.isEmpty(zoneSet)) {
                        this.deleteZoneSet(zoneSet);
                    }
                }
                ++n;
            }
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n2 = 0;
            while (n2 < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n2].getZoneName().equals(zone.getName())) {
                    this.getZoneAlias(zone2ZoneAliasArray[n2].getZoneAliasName());
                    this.zone2alias.remove(zone2ZoneAliasArray[n2]);
                }
                ++n2;
            }
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n3 = 0;
            while (n3 < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n3].getZoneName().equals(zone.getName())) {
                    ZoneMember zoneMember = this.getZoneMember(zone2ZoneMemberArray[n3].getZoneMemberName(), zone2ZoneMemberArray[n3].getZoneMemberType());
                    this.zone2member.remove(zone2ZoneMemberArray[n3]);
                    if (this.isOrphaned(zoneMember)) {
                        this.deleteMember(zoneMember);
                    }
                }
                ++n3;
            }
        }
    }

    public ZoneSet[] deleteZoneAndReturnDeletedZoneSets(Zone zone) {
        ArrayList arrayList = new ArrayList();
        this.deleteZone(zone, arrayList);
        return arrayList.toArray(new ZoneSet[0]);
    }

    public ZoneSet[] deleteZonesAndReturnDeletedZoneSets(Zone[] zoneArray) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < zoneArray.length) {
            this.deleteZone(zoneArray[n], arrayList);
            ++n;
        }
        return arrayList.toArray(new ZoneSet[0]);
    }

    public void deleteZone(Zone zone, ArrayList arrayList) {
        if (zone != null) {
            this.zones.remove(zone);
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneName().equals(zone.getName())) {
                    ZoneSet zoneSet = this.getZoneSet(zoneSet2ZoneArray[n].getZoneSetName());
                    this.zoneset2zone.remove(zoneSet2ZoneArray[n]);
                    if (this.isEmpty(zoneSet)) {
                        if (!arrayList.contains(zoneSet)) {
                            arrayList.add(zoneSet);
                        }
                        this.deleteZoneSet(zoneSet);
                    }
                }
                ++n;
            }
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n2 = 0;
            while (n2 < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n2].getZoneName().equals(zone.getName())) {
                    this.getZoneAlias(zone2ZoneAliasArray[n2].getZoneAliasName());
                    this.zone2alias.remove(zone2ZoneAliasArray[n2]);
                }
                ++n2;
            }
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n3 = 0;
            while (n3 < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n3].getZoneName().equals(zone.getName())) {
                    ZoneMember zoneMember = this.getZoneMember(zone2ZoneMemberArray[n3].getZoneMemberName(), zone2ZoneMemberArray[n3].getZoneMemberType());
                    this.zone2member.remove(zone2ZoneMemberArray[n3]);
                    if (this.isOrphaned(zoneMember)) {
                        this.deleteMember(zoneMember);
                    }
                }
                ++n3;
            }
        }
    }

    private boolean isOrphaned(Zone zone) {
        boolean bl = true;
        if (zone == null) {
            bl = false;
        } else {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                if (zoneSet2ZoneArray[n].getZoneName().equals(zone.getName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isEmpty(Zone zone) {
        boolean bl = true;
        if (zone == null) {
            bl = false;
        } else {
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n].getZoneName().equals(zone.getName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
                int n2 = 0;
                while (n2 < zone2ZoneMemberArray.length) {
                    if (zone2ZoneMemberArray[n2].getZoneName().equals(zone.getName())) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public void addMembers(ZoneMember[] zoneMemberArray) {
        int n = 0;
        while (n < zoneMemberArray.length) {
            this.addMember(zoneMemberArray[n]);
            ++n;
        }
    }

    public void addMember(ZoneMember zoneMember) {
        if (zoneMember != null && !this.members.contains(zoneMember)) {
            this.members.add(zoneMember);
        }
    }

    public void addMember(Zone zone, ZoneMember zoneMember) {
        if (zone != null && zoneMember != null) {
            this.addZone(zone);
            this.addMember(zoneMember);
            Zone2ZoneMember zone2ZoneMember = new Zone2ZoneMember(zone.getName(), zone.getVendorType(), zoneMember.getName(), zoneMember.getType());
            if (!this.zone2member.contains(zone2ZoneMember)) {
                this.zone2member.add(zone2ZoneMember);
            }
        }
    }

    public void addMembers(Zone zone, ZoneMember[] zoneMemberArray) {
        if (zone != null) {
            this.addZone(zone);
            this.addMembers(zoneMemberArray);
            int n = 0;
            while (n < zoneMemberArray.length) {
                Zone2ZoneMember zone2ZoneMember;
                if (zoneMemberArray[n] != null && !this.zone2member.contains(zone2ZoneMember = new Zone2ZoneMember(zone.getName(), zone.getVendorType(), zoneMemberArray[n].getName(), zoneMemberArray[n].getType()))) {
                    this.zone2member.add(zone2ZoneMember);
                }
                ++n;
            }
        }
    }

    public void addMember(ZoneAlias zoneAlias, ZoneMember zoneMember) {
        if (zoneAlias != null && zoneMember != null) {
            this.addAlias(zoneAlias);
            this.addMember(zoneMember);
            ZoneAlias2ZoneMember zoneAlias2ZoneMember = new ZoneAlias2ZoneMember(zoneAlias.getName(), zoneMember.getName(), zoneMember.getType());
            if (!this.alias2member.contains(zoneAlias2ZoneMember)) {
                this.alias2member.add(zoneAlias2ZoneMember);
            }
        }
    }

    public void addMembers(ZoneAlias zoneAlias, ZoneMember[] zoneMemberArray) {
        if (zoneAlias != null) {
            this.addAlias(zoneAlias);
            this.addMembers(zoneMemberArray);
            int n = 0;
            while (n < zoneMemberArray.length) {
                ZoneAlias2ZoneMember zoneAlias2ZoneMember;
                if (zoneMemberArray[n] != null && !this.alias2member.contains(zoneAlias2ZoneMember = new ZoneAlias2ZoneMember(zoneAlias.getName(), zoneMemberArray[n].getName(), zoneMemberArray[n].getType()))) {
                    this.alias2member.add(zoneAlias2ZoneMember);
                }
                ++n;
            }
        }
    }

    public void removeMember(Zone zone, ZoneMember zoneMember) {
        if (zone != null && zoneMember != null) {
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n = 0;
            while (n < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n].getZoneName().equals(zone.getName()) && zone2ZoneMemberArray[n].getZoneMemberName().equalsIgnoreCase(zoneMember.getName()) && zone2ZoneMemberArray[n].getZoneMemberType() == zoneMember.getType()) {
                    Zone zone2 = this.getZone(zone2ZoneMemberArray[n].getZoneName(), zone2ZoneMemberArray[n].getZoneVendorType());
                    this.zone2member.remove(zone2ZoneMemberArray[n]);
                    if (this.isEmpty(zone2)) {
                        this.deleteZone(zone2);
                    }
                }
                ++n;
            }
        }
    }

    public void removeMember(ZoneAlias zoneAlias, ZoneMember zoneMember) {
        if (zoneAlias != null && zoneMember != null) {
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n = 0;
            while (n < zoneAlias2ZoneMemberArray.length) {
                if (zoneAlias2ZoneMemberArray[n].getZoneAliasName().equals(zoneAlias.getName()) && zoneAlias2ZoneMemberArray[n].getZoneMemberName().equalsIgnoreCase(zoneMember.getName()) && zoneAlias2ZoneMemberArray[n].getZoneMemberType() == zoneMember.getType()) {
                    ZoneAlias zoneAlias2 = this.getZoneAlias(zoneAlias2ZoneMemberArray[n].getZoneAliasName());
                    this.alias2member.remove(zoneAlias2ZoneMemberArray[n]);
                    if (this.isEmpty(zoneAlias2)) {
                        this.deleteAlias(zoneAlias2);
                    }
                }
                ++n;
            }
        }
    }

    public ZoneMember[] getMembers() {
        return this.members.toArray(new ZoneMember[0]);
    }

    public ZoneMember[] getMembers(Zone zone) {
        ArrayList<ZoneMember> arrayList = new ArrayList<ZoneMember>();
        if (zone != null) {
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n = 0;
            while (n < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n].getZoneName().equals(zone.getName())) {
                    arrayList.add(this.getZoneMember(zone2ZoneMemberArray[n].getZoneMemberName(), zone2ZoneMemberArray[n].getZoneMemberType()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new ZoneMember[0]);
    }

    public ZoneMember[] getMembers(ZoneAlias zoneAlias) {
        ArrayList<ZoneMember> arrayList = new ArrayList<ZoneMember>();
        if (zoneAlias != null) {
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n = 0;
            while (n < zoneAlias2ZoneMemberArray.length) {
                if (zoneAlias2ZoneMemberArray[n].getZoneAliasName().equals(zoneAlias.getName())) {
                    arrayList.add(this.getZoneMember(zoneAlias2ZoneMemberArray[n].getZoneMemberName(), zoneAlias2ZoneMemberArray[n].getZoneMemberType()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new ZoneMember[0]);
    }

    public ZoneMember getZoneMember(String string, short s) {
        if (string != null) {
            ZoneMember[] zoneMemberArray = this.members.toArray(new ZoneMember[0]);
            int n = 0;
            while (n < zoneMemberArray.length) {
                if (zoneMemberArray[n].getName().equalsIgnoreCase(string) && zoneMemberArray[n].getType() == s) {
                    return zoneMemberArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public void deleteMembers(ZoneMember[] zoneMemberArray) {
        int n = 0;
        while (n < zoneMemberArray.length) {
            this.deleteMember(zoneMemberArray[n]);
            ++n;
        }
    }

    public void deleteMember(ZoneMember zoneMember) {
        if (zoneMember != null) {
            this.members.remove(zoneMember);
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n = 0;
            while (n < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n].getZoneMemberName().equalsIgnoreCase(zoneMember.getName()) && zone2ZoneMemberArray[n].getZoneMemberType() == zoneMember.getType()) {
                    Zone zone = this.getZone(zone2ZoneMemberArray[n].getZoneName(), zone2ZoneMemberArray[n].getZoneVendorType());
                    this.zone2member.remove(zone2ZoneMemberArray[n]);
                    if (this.isEmpty(zone)) {
                        this.deleteZone(zone);
                    }
                }
                ++n;
            }
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n2 = 0;
            while (n2 < zoneAlias2ZoneMemberArray.length) {
                if (zoneAlias2ZoneMemberArray[n2].getZoneMemberName().equalsIgnoreCase(zoneMember.getName()) && zoneAlias2ZoneMemberArray[n2].getZoneMemberType() == zoneMember.getType()) {
                    ZoneAlias zoneAlias = this.getZoneAlias(zoneAlias2ZoneMemberArray[n2].getZoneAliasName());
                    this.alias2member.remove(zoneAlias2ZoneMemberArray[n2]);
                    if (this.isEmpty(zoneAlias)) {
                        this.deleteAlias(zoneAlias);
                    }
                }
                ++n2;
            }
        }
    }

    private boolean isOrphaned(ZoneMember zoneMember) {
        boolean bl = true;
        if (zoneMember == null) {
            bl = false;
        } else {
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n = 0;
            while (n < zone2ZoneMemberArray.length) {
                if (zone2ZoneMemberArray[n].getZoneMemberName().equals(zoneMember.getName()) && zone2ZoneMemberArray[n].getZoneMemberType() == zoneMember.getType()) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
                int n2 = 0;
                while (n2 < zoneAlias2ZoneMemberArray.length) {
                    if (zoneAlias2ZoneMemberArray[n2].getZoneMemberName().equals(zoneMember.getName()) && zoneAlias2ZoneMemberArray[n2].getZoneMemberType() == zoneMember.getType()) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public void addAliases(ZoneAlias[] zoneAliasArray) {
        int n = 0;
        while (n < zoneAliasArray.length) {
            this.addAlias(zoneAliasArray[n]);
            ++n;
        }
    }

    public void addAlias(ZoneAlias zoneAlias) {
        if (zoneAlias != null && !this.aliases.contains(zoneAlias)) {
            this.aliases.add(zoneAlias);
        }
    }

    public void addAlias(Zone zone, ZoneAlias zoneAlias) {
        if (zone != null && zoneAlias != null) {
            this.addZone(zone);
            this.addAlias(zoneAlias);
            Zone2ZoneAlias zone2ZoneAlias = new Zone2ZoneAlias(zone.getName(), zone.getVendorType(), zoneAlias.getName());
            if (!this.zone2alias.contains(zone2ZoneAlias)) {
                this.zone2alias.add(zone2ZoneAlias);
            }
        }
    }

    public void removeAlias(Zone zone, ZoneAlias zoneAlias) {
        if (zone != null && zoneAlias != null) {
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n].getZoneName().equals(zone.getName()) && zone2ZoneAliasArray[n].getZoneAliasName().equals(zoneAlias.getName())) {
                    Zone zone2 = this.getZone(zone2ZoneAliasArray[n].getZoneName(), zone2ZoneAliasArray[n].getZoneVendorType());
                    this.zone2alias.remove(zone2ZoneAliasArray[n]);
                    if (this.isEmpty(zone2)) {
                        this.deleteZone(zone2);
                    }
                }
                ++n;
            }
        }
    }

    public ZoneAlias[] getAliases() {
        return this.aliases.toArray(new ZoneAlias[0]);
    }

    public ZoneAlias[] getAliases(Zone zone) {
        ArrayList<ZoneAlias> arrayList = new ArrayList<ZoneAlias>();
        if (zone != null) {
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n].getZoneName().equals(zone.getName())) {
                    arrayList.add(this.getZoneAlias(zone2ZoneAliasArray[n].getZoneAliasName()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new ZoneAlias[0]);
    }

    public ZoneAlias[] getAliases(ZoneMember zoneMember) {
        ArrayList<ZoneAlias> arrayList = new ArrayList<ZoneAlias>();
        if (zoneMember != null) {
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n = 0;
            while (n < zoneAlias2ZoneMemberArray.length) {
                if (zoneAlias2ZoneMemberArray[n].getZoneMemberName().equalsIgnoreCase(zoneMember.getName()) && zoneAlias2ZoneMemberArray[n].getZoneMemberType() == zoneMember.getType()) {
                    arrayList.add(this.getZoneAlias(zoneAlias2ZoneMemberArray[n].getZoneAliasName()));
                }
                ++n;
            }
        }
        return arrayList.toArray(new ZoneAlias[0]);
    }

    public ZoneAlias getZoneAlias(String string) {
        if (string != null) {
            ZoneAlias[] zoneAliasArray = this.aliases.toArray(new ZoneAlias[0]);
            int n = 0;
            while (n < zoneAliasArray.length) {
                if (zoneAliasArray[n].getName().equals(string)) {
                    return zoneAliasArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    public void deleteAliases(ZoneAlias[] zoneAliasArray) {
        int n = 0;
        while (n < zoneAliasArray.length) {
            this.deleteAlias(zoneAliasArray[n]);
            ++n;
        }
    }

    public void deleteAlias(ZoneAlias zoneAlias) {
        if (zoneAlias != null) {
            this.aliases.remove(zoneAlias);
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n].getZoneAliasName().equals(zoneAlias.getName())) {
                    Zone zone = this.getZone(zone2ZoneAliasArray[n].getZoneName(), zone2ZoneAliasArray[n].getZoneVendorType());
                    this.zone2alias.remove(zone2ZoneAliasArray[n]);
                    if (this.isEmpty(zone)) {
                        this.deleteZone(zone);
                    }
                }
                ++n;
            }
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n2 = 0;
            while (n2 < zoneAlias2ZoneMemberArray.length) {
                if (zoneAlias2ZoneMemberArray[n2].getZoneAliasName().equals(zoneAlias.getName())) {
                    ZoneMember zoneMember = this.getZoneMember(zoneAlias2ZoneMemberArray[n2].getZoneMemberName(), zoneAlias2ZoneMemberArray[n2].getZoneMemberType());
                    this.alias2member.remove(zoneAlias2ZoneMemberArray[n2]);
                    if (this.isOrphaned(zoneMember)) {
                        this.deleteMember(zoneMember);
                    }
                }
                ++n2;
            }
        }
    }

    private boolean isOrphaned(ZoneAlias zoneAlias) {
        boolean bl = true;
        if (zoneAlias == null) {
            bl = false;
        } else {
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                if (zone2ZoneAliasArray[n].getZoneAliasName().equals(zoneAlias.getName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isEmpty(ZoneAlias zoneAlias) {
        boolean bl = true;
        if (zoneAlias == null) {
            bl = false;
        } else {
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n = 0;
            while (n < zoneAlias2ZoneMemberArray.length) {
                if (zoneAlias2ZoneMemberArray[n].getZoneAliasName().equals(zoneAlias.getName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean isSameZoneSet(ZoneDefinition zoneDefinition, String string) {
        return this.isSameZoneSet(zoneDefinition, string, false);
    }

    public boolean isSameZoneSet(ZoneDefinition zoneDefinition, String string, boolean bl) {
        boolean bl2 = true;
        if (zoneDefinition == null) {
            bl2 = false;
        } else {
            ZoneSet zoneSet = this.getZoneSet(string);
            ZoneSet zoneSet2 = zoneDefinition.getZoneSet(string);
            if (zoneSet != null && zoneSet.isIdenticalTo(zoneSet2)) {
                if (bl) {
                    bl2 = this.compareDescriptions(zoneSet.getDescription(), zoneSet2.getDescription());
                }
                if (bl2) {
                    Zone[] zoneArray;
                    Zone[] zoneArray2 = this.getZones(zoneSet);
                    if (zoneArray2.length == (zoneArray = zoneDefinition.getZones(zoneSet2)).length) {
                        int n = 0;
                        while (n < zoneArray2.length) {
                            if (!zoneDefinition.zoneSetContainsZone(zoneSet2, zoneArray2[n]) || !this.isSameZone(zoneDefinition, zoneArray2[n].getName(), zoneArray2[n].getVendorType(), bl)) {
                                bl2 = false;
                                break;
                            }
                            ++n;
                        }
                    } else {
                        bl2 = false;
                    }
                }
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean isSameZoneSet(ZoneDefinition zoneDefinition, String string, ArrayList arrayList, ArrayList arrayList2) {
        boolean bl;
        block9: {
            block8: {
                bl = true;
                arrayList.clear();
                arrayList2.clear();
                if (zoneDefinition != null) break block8;
                bl = false;
                ZoneSet zoneSet = this.getZoneSet(string);
                Zone[] zoneArray = this.getZones(zoneSet);
                int n = 0;
                while (n < zoneArray.length) {
                    arrayList.add(zoneArray[n]);
                    ++n;
                }
                break block9;
            }
            bl = this.isSameZoneSet(zoneDefinition, string);
            if (bl) break block9;
            ZoneSet zoneSet = this.getZoneSet(string);
            Zone[] zoneArray = this.getZones(zoneSet);
            ZoneSet zoneSet2 = zoneDefinition.getZoneSet(string);
            int n = 0;
            while (n < zoneArray.length) {
                if (zoneSet2 == null || !zoneDefinition.zoneSetContainsZone(zoneSet2, zoneArray[n]) || !this.isSameZone(zoneDefinition, zoneArray[n].getName(), zoneArray[n].getVendorType())) {
                    arrayList.add(zoneArray[n]);
                }
                ++n;
            }
            if (zoneSet2 != null) {
                Zone[] zoneArray2 = zoneDefinition.getZones(zoneSet2);
                int n2 = 0;
                while (n2 < zoneArray2.length) {
                    if (this.getZone(zoneArray2[n2].getName(), zoneArray2[n2].getVendorType()) == null) {
                        arrayList2.add(zoneArray2[n2]);
                    } else if (!this.zoneSetContainsZone(zoneSet, zoneArray2[n2]) || !this.isSameZone(zoneDefinition, zoneArray2[n2].getName(), zoneArray2[n2].getVendorType())) {
                        arrayList2.add(zoneArray2[n2]);
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public boolean isSameZone(ZoneDefinition zoneDefinition, String string, short s) {
        return this.isSameZone(zoneDefinition, string, s, false);
    }

    public boolean isSameZone(ZoneDefinition zoneDefinition, String string, short s, boolean bl) {
        boolean bl2 = true;
        if (zoneDefinition == null) {
            bl2 = false;
        } else {
            Zone zone = this.getZone(string, s);
            Zone zone2 = zoneDefinition.getZone(string, s);
            if (zone != null && zone.isIdenticalTo(zone2)) {
                if (bl) {
                    bl2 = this.compareDescriptions(zone.getDescription(), zone2.getDescription());
                }
                if (bl2) {
                    ZoneMember[] zoneMemberArray;
                    ZoneMember[] zoneMemberArray2 = this.getMembers(zone);
                    if (zoneMemberArray2.length == (zoneMemberArray = zoneDefinition.getMembers(zone2)).length) {
                        int n = 0;
                        while (n < zoneMemberArray2.length) {
                            if (!zoneDefinition.zoneContainsMember(zone2, zoneMemberArray2[n]) || !zoneMemberArray2[n].isIdenticalTo(zoneDefinition.getZoneMember(zoneMemberArray2[n].getName(), zoneMemberArray2[n].getType()))) {
                                bl2 = false;
                                break;
                            }
                            ++n;
                        }
                        if (bl2) {
                            ZoneAlias[] zoneAliasArray;
                            ZoneAlias[] zoneAliasArray2 = this.getAliases(zone);
                            if (zoneAliasArray2.length == (zoneAliasArray = zoneDefinition.getAliases(zone2)).length) {
                                int n2 = 0;
                                while (n2 < zoneAliasArray2.length) {
                                    if (!zoneDefinition.zoneContainsAlias(zone2, zoneAliasArray2[n2]) || !this.isSameAlias(zoneDefinition, zoneAliasArray2[n2].getName(), bl)) {
                                        bl2 = false;
                                        break;
                                    }
                                    ++n2;
                                }
                            } else {
                                bl2 = false;
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                }
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean isSameAlias(ZoneDefinition zoneDefinition, String string) {
        return this.isSameAlias(zoneDefinition, string, false);
    }

    public boolean isSameAlias(ZoneDefinition zoneDefinition, String string, boolean bl) {
        boolean bl2 = true;
        if (zoneDefinition == null) {
            bl2 = false;
        } else {
            ZoneAlias zoneAlias = this.getZoneAlias(string);
            ZoneAlias zoneAlias2 = zoneDefinition.getZoneAlias(string);
            if (zoneAlias != null && zoneAlias.isIdenticalTo(zoneAlias2)) {
                if (bl) {
                    bl2 = this.compareDescriptions(zoneAlias.getDescription(), zoneAlias2.getDescription());
                }
                if (bl2) {
                    ZoneMember[] zoneMemberArray;
                    ZoneMember[] zoneMemberArray2 = this.getMembers(zoneAlias);
                    if (zoneMemberArray2.length == (zoneMemberArray = zoneDefinition.getMembers(zoneAlias2)).length) {
                        int n = 0;
                        while (n < zoneMemberArray2.length) {
                            if (!zoneDefinition.zoneAliasContainsMember(zoneAlias2, zoneMemberArray2[n]) || !zoneMemberArray2[n].isIdenticalTo(zoneDefinition.getZoneMember(zoneMemberArray2[n].getName(), zoneMemberArray2[n].getType()))) {
                                bl2 = false;
                                break;
                            }
                            ++n;
                        }
                    } else {
                        bl2 = false;
                    }
                }
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean zoneSetContainsZone(ZoneSet zoneSet, Zone zone) {
        boolean bl = false;
        if (zoneSet != null && zone != null) {
            ZoneSet2Zone[] zoneSet2ZoneArray = this.zoneset2zone.toArray(new ZoneSet2Zone[0]);
            int n = 0;
            while (n < zoneSet2ZoneArray.length) {
                Zone zone2;
                if (zoneSet2ZoneArray[n].getZoneSetName().equals(zoneSet.getName()) && zone.equals(zone2 = this.getZone(zoneSet2ZoneArray[n].getZoneName(), zoneSet2ZoneArray[n].getZoneVendorType()))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean zoneContainsMember(Zone zone, ZoneMember zoneMember) {
        boolean bl = false;
        if (zone != null && zoneMember != null) {
            Zone2ZoneMember[] zone2ZoneMemberArray = this.zone2member.toArray(new Zone2ZoneMember[0]);
            int n = 0;
            while (n < zone2ZoneMemberArray.length) {
                ZoneMember zoneMember2;
                if (zone2ZoneMemberArray[n].getZoneName().equals(zone.getName()) && zoneMember.equals(zoneMember2 = this.getZoneMember(zone2ZoneMemberArray[n].getZoneMemberName(), zone2ZoneMemberArray[n].getZoneMemberType()))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean zoneAliasContainsMember(ZoneAlias zoneAlias, ZoneMember zoneMember) {
        boolean bl = false;
        if (zoneAlias != null && zoneMember != null) {
            ZoneAlias2ZoneMember[] zoneAlias2ZoneMemberArray = this.alias2member.toArray(new ZoneAlias2ZoneMember[0]);
            int n = 0;
            while (n < zoneAlias2ZoneMemberArray.length) {
                ZoneMember zoneMember2;
                if (zoneAlias2ZoneMemberArray[n].getZoneAliasName().equals(zoneAlias.getName()) && zoneMember.equals(zoneMember2 = this.getZoneMember(zoneAlias2ZoneMemberArray[n].getZoneMemberName(), zoneAlias2ZoneMemberArray[n].getZoneMemberType()))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean zoneContainsAlias(Zone zone, ZoneAlias zoneAlias) {
        boolean bl = false;
        if (zone != null && zoneAlias != null) {
            Zone2ZoneAlias[] zone2ZoneAliasArray = this.zone2alias.toArray(new Zone2ZoneAlias[0]);
            int n = 0;
            while (n < zone2ZoneAliasArray.length) {
                ZoneAlias zoneAlias2;
                if (zone2ZoneAliasArray[n].getZoneName().equals(zone.getName()) && zoneAlias.equals(zoneAlias2 = this.getZoneAlias(zone2ZoneAliasArray[n].getZoneAliasName()))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean compareDescriptions(String string, String string2) {
        boolean bl = string != null ? string.equals(string2) : string2 == null;
        return bl;
    }

    public boolean equals(Object object) {
        ZoneSet[] zoneSetArray;
        ZoneSet[] zoneSetArray2;
        boolean bl = false;
        if (object != null && object instanceof ZoneDefinition && (zoneSetArray2 = this.getZoneSets()).length == (zoneSetArray = ((ZoneDefinition)object).getZoneSets()).length) {
            bl = true;
            int n = 0;
            while (n < zoneSetArray2.length) {
                if (!this.isSameZoneSet((ZoneDefinition)object, zoneSetArray2[n].getName(), true)) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean equalsIgnoreDescriptions(Object object) {
        ZoneSet[] zoneSetArray;
        ZoneSet[] zoneSetArray2;
        boolean bl = false;
        if (object != null && object instanceof ZoneDefinition && (zoneSetArray2 = this.getZoneSets()).length == (zoneSetArray = ((ZoneDefinition)object).getZoneSets()).length) {
            bl = true;
            int n = 0;
            while (n < zoneSetArray2.length) {
                if (!this.isSameZoneSet((ZoneDefinition)object, zoneSetArray2[n].getName())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = "1.3.0";
        }
        return this.version;
    }
}

