/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces;

import java.util.Stack;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ZoneDefSaxParser
extends DefaultHandler {
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;
    private ZoneDefinition zoneDefinition;
    private Stack zStack = null;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneDefSaxParser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public ZoneDefSaxParser(ZoneDefinition zoneDefinition) {
        String string = "ZoneDefSaxParser";
        this.zoneDefinition = zoneDefinition;
        msgLogger = ZoneConstants.msgLogger = LogManagerFactory.getMessageLogger("aperi.logger.message.SanZoneControl");
        traceLogger = ZoneConstants.traceLogger;
        this.zStack = new Stack();
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, className, string);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = "startElement";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string4);
        }
        if (string3.equalsIgnoreCase("ZoningConfigurations")) {
            if (traceLogger.isLogging()) {
                String string5 = "qualifiedName = " + string3;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string4, string5);
            }
        } else if (string3.equalsIgnoreCase("ZoneSet")) {
            String string6 = attributes.getValue("name");
            boolean bl = false;
            if (attributes.getValue("active").equalsIgnoreCase("FALSE")) {
                bl = false;
            } else if (attributes.getValue("active").equalsIgnoreCase("TRUE")) {
                bl = true;
            }
            ZoneSet zoneSet = new ZoneSet(string6);
            this.zoneDefinition.addZoneSet(zoneSet);
            if (bl) {
                this.zoneDefinition.activateZoneSet(zoneSet);
            }
            this.zStack.push(zoneSet);
            if (traceLogger.isLogging()) {
                String string7 = "qualifiedName = " + string3 + " name = " + string6 + " isActive = " + bl;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string4, string7);
            }
        } else if (string3.equalsIgnoreCase("Zone")) {
            String string8 = attributes.getValue("name");
            String string9 = attributes.getValue("vendorType");
            short s = string9 == null ? (short)1 : Short.parseShort(string9);
            if (s != 12336) {
                Object object;
                Zone zone = this.zoneDefinition.getZone(string8);
                if (zone == null) {
                    zone = new Zone(string8, s);
                    this.zoneDefinition.addZone(zone);
                }
                if (!this.zStack.empty() && (object = this.zStack.peek()) instanceof ZoneSet) {
                    this.zoneDefinition.addZone((ZoneSet)object, zone);
                }
                this.zStack.push(zone);
                if (traceLogger.isLogging()) {
                    object = "qualifiedName = " + string3 + " name = " + string8 + " vendorType = " + string9;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string4, (String)object);
                }
            } else if (traceLogger.isLogging()) {
                String string10 = "Found but ignored erroneous zone: qualifiedName = " + string3 + " name = " + string8 + " vendorType = " + string9;
                traceLogger.text(IRecordType.TYPE_WARN, className, string4, string10);
            }
        } else if (string3.equalsIgnoreCase("ZoneAlias")) {
            Object object;
            String string11 = attributes.getValue("name");
            ZoneAlias zoneAlias = this.zoneDefinition.getZoneAlias(string11);
            if (zoneAlias == null) {
                zoneAlias = new ZoneAlias(string11);
                this.zoneDefinition.addAlias(zoneAlias);
            }
            if (!this.zStack.empty() && (object = this.zStack.peek()) instanceof Zone) {
                this.zoneDefinition.addAlias((Zone)object, zoneAlias);
            }
            this.zStack.push(zoneAlias);
            if (traceLogger.isLogging()) {
                object = "qualifiedName = " + string3 + " name = " + string11;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string4, (String)object);
            }
        } else if (string3.equalsIgnoreCase("ZoneMember")) {
            String string12 = attributes.getValue("name");
            short s = new Integer(attributes.getValue("type")).shortValue();
            ZoneMember zoneMember = new ZoneMember(s, string12);
            Object e = this.zStack.peek();
            if (e instanceof Zone) {
                this.zoneDefinition.addMember((Zone)e, zoneMember);
            } else if (e instanceof ZoneAlias) {
                this.zoneDefinition.addMember((ZoneAlias)e, zoneMember);
            }
            this.zStack.push(zoneMember);
            if (traceLogger.isLogging()) {
                String string13 = "qualifiedName = " + string3 + " name = " + string12 + " type = " + s;
                traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string4, string13);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = "endElement";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, className, string4);
            String string5 = "qName = " + string3;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, className, string4, string5);
        }
        if (!this.zStack.empty()) {
            this.zStack.pop();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, className, string4);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(this.GetErrorString(sAXParseException));
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(this.GetErrorString(sAXParseException));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw new SAXException(this.GetErrorString(sAXParseException));
    }

    private String GetErrorString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer("Line: ");
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append("\nMessage: ");
        stringBuffer.append(sAXParseException.getMessage());
        return stringBuffer.toString();
    }
}

