/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.common.ListElement;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.StatDataWriter;
import org.eclipse.aperi.server.guireq.AlertDefinition;

public class Alert
extends ListElement {
    static final long serialVersionUID = 1826896167609385913L;
    private long alertTime;
    private AlertDefinition alertDef;
    private String[] parms;
    private int[][] varBindOID;
    private String[] tecSlotNames;
    private int resourceID;
    private int computerID;
    private short resourceType;
    private int violatingValue;
    private int previousValue;
    private int violatorID;
    private short violatorType;
    private int trapType;
    private byte dbmsType;
    private int parentID;
    private int[] enterprise;
    private Hashtable varBinds;
    private String tecClass;
    private Hashtable tecAttributes;
    private String msgID;
    private Object[] msgParms;
    private int[] affectedResources = null;
    private String affectedHosts = null;
    private boolean hasAffectedResources = false;
    public StatDataWriter statWriter;
    public Serializable jobData;

    public Alert(int n, int n2, short s, AlertDefinition alertDefinition, String[] stringArray, int n3, int[][] nArray, String[] stringArray2) {
        this(n, n2, s, alertDefinition, stringArray, n3, nArray, stringArray2, -1, -1, -1, -1);
    }

    public Alert(int n, int n2, short s, AlertDefinition alertDefinition, String[] stringArray, int n3, int[][] nArray, String[] stringArray2, int n4, int n5) {
        this(n, n2, s, alertDefinition, stringArray, n3, nArray, stringArray2, n4, n5, -1, -1);
    }

    public Alert(int n, int n2, short s, AlertDefinition alertDefinition, String[] stringArray, int n3, int[][] nArray, String[] stringArray2, int n4, int n5, byte by, int n6) {
        this(n, n2, s, alertDefinition, stringArray, n3, nArray, stringArray2, n4, n5, -1, -1, by, n6);
    }

    public Alert(int n, int n2, short s, AlertDefinition alertDefinition, String[] stringArray, int n3, int[][] nArray, String[] stringArray2, int n4, int n5, int n6, short s2) {
        this(n, n2, s, alertDefinition, stringArray, n3, nArray, stringArray2, n4, n5, n6, s2, 0, -1);
    }

    public Alert(int n, int n2, short s, AlertDefinition alertDefinition, String[] stringArray, int n3, int[][] nArray, String[] stringArray2, int n4, int n5, int n6, short s2, byte by, int n7) {
        this.computerID = n;
        this.resourceID = n2;
        this.resourceType = s;
        this.alertDef = alertDefinition;
        this.parms = stringArray;
        this.trapType = n3;
        this.varBindOID = nArray;
        this.tecSlotNames = stringArray2;
        this.violatingValue = n4;
        this.previousValue = n5;
        this.violatorID = n6;
        this.violatorType = s2;
        this.dbmsType = by;
        this.parentID = n7;
        this.setAlertTime();
    }

    public Alert(int n, int n2, short s, AlertDefinition alertDefinition, int[] nArray, int n3, Hashtable hashtable, String string, Hashtable hashtable2, String string2, Object[] objectArray) {
        this.computerID = n;
        this.resourceID = n2;
        this.resourceType = s;
        this.alertDef = alertDefinition;
        this.enterprise = nArray;
        this.trapType = n3;
        this.varBinds = hashtable;
        this.tecClass = string;
        this.tecAttributes = hashtable2;
        this.msgID = string2;
        this.msgParms = objectArray;
        this.dbmsType = alertDefinition.aldDbmsType;
        this.setAlertTime();
        if (objectArray != null) {
            this.parms = new String[objectArray.length];
            int n4 = 0;
            while (n4 < objectArray.length) {
                this.parms[n4] = objectArray[n4].toString();
                ++n4;
            }
        }
    }

    private void setAlertTime() {
        try {
            this.alertTime = CurrentTime.getTimestamp().getTime();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.Alert");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "Alert", sQLException);
            }
            this.alertTime = System.currentTimeMillis();
            return;
        }
    }

    public long getAlertTime() {
        return this.alertTime;
    }

    public AlertDefinition getAlertDefinition() {
        return this.alertDef;
    }

    public String[] getParameters() {
        return this.parms;
    }

    public int[][] getVarBindOID() {
        return this.varBindOID;
    }

    public String[] getTecSlotNames() {
        return this.tecSlotNames;
    }

    public int getComputerID() {
        return this.computerID;
    }

    public short getResourceType() {
        return this.resourceType;
    }

    public int getResourceID() {
        return this.resourceID;
    }

    public short getViolatorType() {
        return this.violatorType;
    }

    public int getViolatorID() {
        return this.violatorID;
    }

    public int getViolatingValue() {
        return this.violatingValue;
    }

    public int getPreviousValue() {
        return this.previousValue;
    }

    public int getTrapType() {
        return this.trapType;
    }

    public byte getDbmsType() {
        return this.dbmsType;
    }

    public int getParentID() {
        return this.parentID;
    }

    public void setAlertDefinition(AlertDefinition alertDefinition) {
        this.alertDef = alertDefinition;
    }

    public int[] getEnterprise() {
        return this.enterprise;
    }

    public Hashtable getVarBinds() {
        return this.varBinds;
    }

    public String getTecClass() {
        return this.tecClass;
    }

    public Hashtable getTecAttributes() {
        return this.tecAttributes;
    }

    public String getMessageID() {
        return this.msgID;
    }

    public Object[] getMessageParameters() {
        return this.msgParms;
    }

    public boolean hasAffectedResources() {
        return this.hasAffectedResources;
    }

    public int[] getAffectedResources() {
        return this.affectedResources;
    }

    public String getAffectedHosts() {
        return this.affectedHosts;
    }

    public void setHasAffectedResources(boolean bl) {
        this.hasAffectedResources = bl;
    }

    public void setAffectedResources(int[] nArray) {
        this.affectedResources = nArray;
    }

    public void setAffectedHosts(String string) {
        this.affectedHosts = string;
    }
}

