/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.IMessageBundleSource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundleManager
implements IRegistryChangeListener,
IDisposable {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PREFIX = "prefix";
    public static final String ATTR_SOURCE = "source";
    private SortedMap<Integer, Map<String, IMessageBundleSource>> bundleSourceCache;
    private String extensionPointId;
    private ReadWriteLock cacheLock;

    public MessageBundleManager(String string) {
        this.extensionPointId = string;
        this.bundleSourceCache = new TreeMap<Integer, Map<String, IMessageBundleSource>>();
        this.cacheLock = new ReentrantReadWriteLock(true);
    }

    public void initialize() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(this.extensionPointId);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                try {
                    this.addSource(iConfigurationElementArray[n]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
            iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
        } else if (System.getProperty("osgi.framework") != null) {
            throw new RuntimeException("Failed to obtain reference to extension registry.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.cacheLock.writeLock().lock();
        try {
            RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
            Iterator<Map<String, IMessageBundleSource>> iterator = this.bundleSourceCache.values().iterator();
            block5: while (true) {
                block8: {
                    if (iterator.hasNext()) break block8;
                    this.bundleSourceCache.clear();
                    break;
                }
                Map<String, IMessageBundleSource> map = iterator.next();
                Iterator<IMessageBundleSource> iterator2 = map.values().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        map.clear();
                        continue block5;
                    }
                    IMessageBundleSource iMessageBundleSource = iterator2.next();
                    try {
                        iMessageBundleSource.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.cacheLock.writeLock().unlock();
            return;
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IExtension iExtension = iExtensionDeltaArray[n].getExtension();
            if (iExtension.getExtensionPointUniqueIdentifier().equals(this.extensionPointId)) {
                int n2;
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                if (iExtensionDeltaArray[n].getKind() == 1) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.addSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                } else if (iExtensionDeltaArray[n].getKind() == 2) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.removeSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String string = iConfigurationElement.getAttribute(ATTR_PREFIX);
            if (string != null) {
                Map<String, IMessageBundleSource> map = this.getPrefixSourceMap(string.length());
                if (map.containsKey(string)) {
                    throw new RuntimeException(new StringBuffer("Message source named ").append(map.get(string)).append(" already registered under prefix ").append(string).toString());
                }
                IMessageBundleSource iMessageBundleSource = (IMessageBundleSource)iConfigurationElement.createExecutableExtension(ATTR_SOURCE);
                if (iMessageBundleSource != null) {
                    map.put(string, iMessageBundleSource);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.cacheLock.writeLock().unlock();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            Map<String, IMessageBundleSource> map;
            IMessageBundleSource iMessageBundleSource;
            String string = iConfigurationElement.getAttribute(ATTR_PREFIX);
            if (string != null && (iMessageBundleSource = (map = this.getPrefixSourceMap(string.length())).remove(string)) != null) {
                iMessageBundleSource.dispose();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.cacheLock.writeLock().unlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.cacheLock.writeLock().unlock();
            return;
        }
    }

    private Map<String, IMessageBundleSource> getPrefixSourceMap(Integer n) {
        HashMap hashMap = (HashMap)this.bundleSourceCache.get(n);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.bundleSourceCache.put(n, hashMap);
        }
        return hashMap;
    }

    public ResourceBundle getBundle(String string) {
        return this.getBundle(string, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceBundle getBundle(String string, Locale locale) {
        IMessageBundleSource iMessageBundleSource;
        block7: {
            iMessageBundleSource = null;
            if (string == null) break block7;
            this.cacheLock.readLock().lock();
            try {
                Integer[] integerArray = this.bundleSourceCache.keySet().toArray(new Integer[0]);
                int n = integerArray.length - 1;
                while (n >= 0) {
                    block8: {
                        if (string.length() < integerArray[n]) break block8;
                        String string2 = string.substring(0, integerArray[n]);
                        iMessageBundleSource = this.getPrefixSourceMap(integerArray[n]).get(string2);
                        if (iMessageBundleSource != null) break;
                    }
                    --n;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.cacheLock.readLock().unlock();
                throw throwable;
            }
            {
                Object var7_9 = null;
                this.cacheLock.readLock().unlock();
            }
        }
        if (iMessageBundleSource != null) {
            return iMessageBundleSource.getResourceBundle(locale);
        }
        return null;
    }
}

