/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.Util;
import org.eclipse.aperi.download.interfaces.IDownload;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadConfig {
    public static final String ATTR_DOWNLOAD = "download";
    public static final String ATTR_TYPE = "type";
    private Vector<IDownload> _downloads = new Vector();

    public DownloadConfig(String string) throws SAXException, IOException, ConfigurationException {
        Document document = this.loadConfig(string);
        NodeList nodeList = document.getElementsByTagName(ATTR_DOWNLOAD);
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string2 = Util.getNamedAttribute(node.getAttributes(), ATTR_TYPE, true);
            try {
                Class<?> clazz;
                Class<?> clazz2 = Class.forName(string2);
                Class[] classArray = new Class[1];
                try {
                    clazz = Class.forName("org.w3c.dom.Node");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                classArray[0] = clazz;
                Constructor<?> constructor = clazz2.getConstructor(classArray);
                this._downloads.add((IDownload)constructor.newInstance(node));
            }
            catch (Exception exception) {
                throw new ConfigurationException(new StringBuffer("Invalid download type: ").append(string2).toString(), exception);
            }
            ++n;
        }
    }

    private Document loadConfig(String string) throws SAXException, IOException {
        File file = new File(string);
        DOMParser dOMParser = new DOMParser();
        FileInputStream fileInputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(fileInputStream);
        dOMParser.parse(inputSource);
        return dOMParser.getDocument();
    }

    public Vector<IDownload> getDownloads() {
        return this._downloads;
    }

    public Vector<IDownload> getMirroredDownloads() {
        Vector<IDownload> vector = new Vector<IDownload>();
        for (IDownload iDownload : this._downloads) {
            if (!iDownload.isMirrored()) continue;
            vector.add(iDownload);
        }
        return vector;
    }
}

