/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.util.Vector;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.DownloadTarget;
import org.eclipse.aperi.download.interfaces.IDownloadTarget;
import org.eclipse.aperi.download.interfaces.IZipFile;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements IZipFile {
    public static final String ATTR_INTERNAL_PATH = "path";
    public static final String ATTR_TARGET = "target";
    private String internalPath = null;
    private Vector<IDownloadTarget> downloadTargets = new Vector();

    public ZipFile(Node node) throws ConfigurationException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.internalPath = namedNodeMap.getNamedItem(ATTR_INTERNAL_PATH).getNodeValue();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals(ATTR_TARGET)) {
                this.downloadTargets.add(new DownloadTarget(node2));
            }
            ++n;
        }
    }

    @Override
    public Vector<IDownloadTarget> getDownloadTargets() {
        return this.downloadTargets;
    }

    @Override
    public String getInternalPath() {
        return this.internalPath;
    }
}

