/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertEmail;

public class TAlertEmail
extends RepositoryAccessor {
    public static final String ID_COLUMN_NAME = "alert_id";
    private static final String SELECT_BY_ID = "select alert_id, subject, text, recipients, quota_violator from t_alert_email where alert_id = ?";
    private static final String INSERT = "insert into t_alert_email (alert_id, subject, text, recipients, quota_violator) values (?,?,?,?,?)";

    public TAlertEmail(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TAlertEmail", (String)"dbc");
        }
        this.tableName = "t_alert_email";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TAlertEmail");
        }
    }

    public void prepSelectByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
    }

    public void getAlertEmail(AlertDefinition alertDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getAlertEmail", (String)"alert");
        }
        alertDefinition.aldEmailDef = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, alertDefinition.aldAlertID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                AlertEmail alertEmail = new AlertEmail();
                this.stmtPhase = 1;
                this.colIndex = 1;
                alertEmail.aleAlertID = this.getInt(this.resultSet);
                alertEmail.aleSubject = this.getString(this.resultSet);
                alertEmail.aleText = this.getString(this.resultSet);
                alertEmail.aleRecipients = this.getString(this.resultSet);
                alertEmail.aleQuotaViolator = this.getByte(this.resultSet);
                alertDefinition.aldEmailDef = alertEmail;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getAlertEmail", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        if (alertDefinition.aldEmailDef == null) {
            alertDefinition.aldEmail = false;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAlertEmail");
        }
    }

    public void insert(AlertEmail alertEmail) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"email");
        }
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.insertStmt, alertEmail.aleAlertID);
            this.setString(this.insertStmt, alertEmail.aleSubject);
            this.setString(this.insertStmt, alertEmail.aleText);
            this.setString(this.insertStmt, alertEmail.aleRecipients);
            this.setByte(this.insertStmt, alertEmail.aleQuotaViolator);
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
            this.closeInsert();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void deleteByID(int n, String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteByID", (String)"alertID, type");
        }
        EditableObjectProxy editableObjectProxy = new EditableObjectProxy(this, null, string);
        editableObjectProxy.deleteByID(n, ID_COLUMN_NAME);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAlertEmail");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteByID");
        }
    }
}

