/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Group2Res;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.server.handler.gui.GroupDefHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class TGroup2Res
extends RepositoryAccessor {
    Connection save_dbc;
    private static final short DIRECT_RESOURCE = 1;
    private static final short INDIRECT_RESOURCE = 2;
    private static final short DIRECT_GROUP = 3;
    private static final short INDIRECT_GROUP = 4;
    private static final short MASKED_RESOURCE = 5;
    private static final short PARENT_LEVELS = 5;
    private static final String INSERT = "insert into t_group2res ( resource_id, group_id, parent_id, res_type, res_indicator, ancestors ) values (?, ?, ?, ?, ?, ?)";
    private static final String DELETE = "delete from t_group2res where resource_id = ? and group_id = ? and  parent_id = ?  and res_indicator = ? and ancestors = ? ";
    private static final String DELETE_GROUP = "delete from t_group2res where resource_id = ? or group_id = ? ";
    private static final String DELETE_RESOURCE = "delete from t_group2res where resource_id = ? ";
    private static final String SELECT_CHILDREN = "select resource_id, group_id, parent_id, res_type, res_indicator, ancestors from t_group2res where group_id = ? ";
    private static final String SELECT_COMPUTER_NAMES = "select r.host_name as name, r.computer_id as ID, 1 as type, '' as creator, s.cluster_id as cl_id from t_res_host r, t_stat_computer s  where r.computer_id = s.computer_id and r.computer_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) union select g.name as name, g.group_id as ID, g.group_type as type,  g.creator as creator, 0 as cl_id from  t_group g where g.group_id in (select resource_id from t_group2res  where group_id = ? and res_indicator = 3) order by name";
    private static final String SELECT_FILESYSTEM_COMPUTERS = "select c.host_name as name, r.computer_id as ID, 1 as type, '' as creator  from t_res_filesystem r, t_res_host c  where r.computer_id = c.computer_id and r.filesystem_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) union select g.name as name, g.group_id as ID, g.group_type as type,  g.creator as creator  from t_group g where g.group_id in (select resource_id from t_group2res  where group_id = ? and res_indicator = 3) order by name";
    private static final String SELECT_FILESYSTEM_NAMES = "select r.mount_point as name, r.filesystem_id as ID, 3 as type, '' as creator, r.computer_id as comp_id  from t_res_filesystem r  where r.filesystem_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) union select g.name as name, g.group_id as ID, g.group_type as type,  g.creator as creator, -1 as comp_id from t_group g where g.group_id in (select resource_id from t_group2res  where group_id = ? and res_indicator = 3) order by comp_id, name";
    private static final String SELECT_FS = "select r.mount_point as name, r.filesystem_id as ID, 3 as type, r.computer_id as comp_id  from t_res_filesystem r  where r.computer_id  = ? and r.filesystem_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) order by comp_id, name";
    private static final String SELECT_ANCESTOR = "select resource_id, group_id, parent_id, res_type, res_indicator, ancestors from t_group2res where resource_id = ? and ( res_indicator = ? or res_indicator = ? )";
    private static final String SELECT_COMPUTER_BY_GID = "select c.host_name as name, c.computer_id as ID, 1 as type, c.computer_id as comp_id  from t_res_host c  where c.computer_id in (select distinct(resource_id) from t_group2res where  group_id = ? and ((res_indicator = 1) OR (res_indicator = 2) OR (res_indicator = 5)))";
    private static final String SELECT_FS_BY_GID = "select r.mount_point as name, r.filesystem_id as ID, 3 as type, r.computer_id as comp_id  from t_res_filesystem r  where r.filesystem_id in (select distinct(resource_id) from t_group2res where  group_id = ? and ((res_indicator = 1) OR (res_indicator = 2) OR (res_indicator = 5))) order by comp_id, name";
    private static final String SELECT_MON_GROUP_BY_COMP_ID = "select t.group_id from t_group2res t, t_group r where r.group_type = 0 and t.group_id = r.group_id and t.res_indicator = 1 and t.resource_id = ? ";
    private static final String SELECT_MON_GROUP_BY_FS_ID = "select t.group_id from t_group2res t, t_group r where r.group_type = 2 and t.group_id = r.group_id and t.res_indicator = 1 and t.resource_id = ? ";
    boolean locked = false;
    String resName = null;

    public TGroup2Res(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TGroup2Res", (String)"dbc");
        }
        this.save_dbc = connection;
        this.tableName = "t_group2res";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TGroup2Res");
        }
    }

    private ArrayList findAncestors(int n, boolean bl) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findAncestors", (String)"group_id, isDelete");
        }
        boolean bl2 = false;
        ArrayList<Group2Res> arrayList = new ArrayList<Group2Res>(30);
        if (n > 0) {
            try {
                this.selectStmt = this.prepareStmt(SELECT_ANCESTOR);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.setShort(this.selectStmt, (short)3);
                this.setShort(this.selectStmt, (short)4);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.resultSet.next()) {
                    this.colIndex = 1;
                    Group2Res group2Res = new Group2Res();
                    group2Res.g2resResourceID = this.getInt(this.resultSet);
                    group2Res.g2resGroupID = this.getInt(this.resultSet);
                    group2Res.g2resParentID = this.getInt(this.resultSet);
                    group2Res.g2resResourceType = this.getShort(this.resultSet);
                    group2Res.g2resIndicator = this.getShort(this.resultSet);
                    group2Res.g2resAncestors = this.getString(this.resultSet);
                    object = new StringTokenizer(group2Res.g2resAncestors, ":");
                    int n2 = ((StringTokenizer)object).countTokens();
                    if (bl) {
                        if (n2 > 5) {
                            bl2 = true;
                            break;
                        }
                    } else if (n2 >= 5) {
                        bl2 = true;
                        break;
                    }
                    arrayList.add(group2Res);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"findAncestors", (Throwable)sQLException);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
            this.closeResultSet();
            this.closeSelect();
            if (bl2) {
                this.cleanup();
                if (this.locked) {
                    this.unlockTGroup();
                }
                object = MessageLog.getMessage((String)"SRV0166E");
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"findAncestors");
                }
                throw new GeneralException((String)object);
            }
        }
        object = arrayList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findAncestors", object);
        }
        return object;
    }

    private int getParentLevels(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getParentLevels", (String)"group_id");
        }
        int n2 = 0;
        if (n > 0) {
            try {
                this.selectStmt = this.prepareStmt(SELECT_ANCESTOR);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.setShort(this.selectStmt, (short)3);
                this.setShort(this.selectStmt, (short)4);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.resultSet.next()) {
                    this.colIndex = 1;
                    Group2Res group2Res = new Group2Res();
                    group2Res.g2resResourceID = this.getInt(this.resultSet);
                    group2Res.g2resGroupID = this.getInt(this.resultSet);
                    group2Res.g2resParentID = this.getInt(this.resultSet);
                    group2Res.g2resResourceType = this.getShort(this.resultSet);
                    group2Res.g2resIndicator = this.getShort(this.resultSet);
                    group2Res.g2resAncestors = this.getString(this.resultSet);
                    StringTokenizer stringTokenizer = new StringTokenizer(group2Res.g2resAncestors, ":");
                    int n3 = stringTokenizer.countTokens();
                    if (n3 <= n2) continue;
                    n2 = n3;
                }
                this.closeResultSet();
                this.closeSelect();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getParentLevels", (Throwable)sQLException);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
            int n4 = n2 + 1;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getParentLevels", (int)n4);
            }
            return n4;
        }
        int n5 = 0;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getParentLevels", (int)n5);
        }
        return n5;
    }

    private int getChildrenLevels(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getChildrenLevels", (String)"grp_id");
        }
        int n2 = 0;
        if (n < 0) {
            int n3 = n2;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getChildrenLevels", (int)n3);
            }
            return n3;
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT_CHILDREN);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                Group2Res group2Res = new Group2Res();
                group2Res.g2resResourceID = this.getInt(this.resultSet);
                group2Res.g2resGroupID = this.getInt(this.resultSet);
                group2Res.g2resParentID = this.getInt(this.resultSet);
                group2Res.g2resResourceType = this.getShort(this.resultSet);
                group2Res.g2resIndicator = this.getShort(this.resultSet);
                group2Res.g2resAncestors = this.getString(this.resultSet);
                StringTokenizer stringTokenizer = new StringTokenizer(group2Res.g2resAncestors, ":");
                int n4 = stringTokenizer.countTokens();
                if (n4 <= n2) continue;
                n2 = n4;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getChildrenLevels", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        this.closeSelect();
        int n5 = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getChildrenLevels", (int)n5);
        }
        return n5;
    }

    public NameList getFSforComputer(NameList nameList, int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getFSforComputer", (String)"nlComp, group_id, group_type");
        }
        NameList nameList2 = null;
        NameList nameList3 = null;
        String string = null;
        switch (s) {
            case 90: {
                string = SELECT_FS;
                break;
            }
            default: {
                string = null;
            }
        }
        int n2 = nameList.nlID;
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n2);
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                nameList3 = new NameList();
                nameList3.nlName = this.getString(this.resultSet);
                nameList3.nlID = this.getInt(this.resultSet);
                nameList3.nlInfo = this.getShort(this.resultSet);
                nameList3.nlID2 = this.getInt(this.resultSet);
                nameList3.nlNext = nameList2;
                nameList2 = nameList3;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getFSforComputer", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        this.closeSelect();
        NameList nameList4 = nameList3;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getFSforComputer", nameList4);
        }
        return nameList4;
    }

    public NameList getMemberList(int n, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMemberList", (String)"group_id, group_type");
        }
        NameList nameList = null;
        NameList nameList2 = null;
        String string = null;
        switch (s) {
            case 0: 
            case 89: {
                string = SELECT_COMPUTER_BY_GID;
                break;
            }
            case 2: 
            case 90: {
                string = SELECT_FS_BY_GID;
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            try {
                this.selectStmt = this.prepareStmt(string);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.resultSet.next()) {
                    this.colIndex = 1;
                    nameList2 = new NameList();
                    nameList2.nlName = this.getString(this.resultSet);
                    nameList2.nlID = this.getInt(this.resultSet);
                    nameList2.nlInfo = this.getShort(this.resultSet);
                    if (s == 90 || s == 2) {
                        nameList2.nlID2 = this.getInt(this.resultSet);
                    }
                    nameList2.nlNext = nameList;
                    nameList = nameList2;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getMemberList", (Throwable)sQLException);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
            this.closeResultSet();
            this.closeSelect();
        }
        NameList nameList3 = nameList2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMemberList", nameList3);
        }
        return nameList3;
    }

    public NameList getMembers(int n, short s) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMembers", (String)"group_id, group_type");
        }
        NameList nameList = null;
        NameList nameList2 = null;
        String string = null;
        switch (s) {
            case 89: {
                string = SELECT_COMPUTER_NAMES;
                break;
            }
            case 90: {
                string = SELECT_FILESYSTEM_NAMES;
                break;
            }
            case 98: {
                string = SELECT_FILESYSTEM_COMPUTERS;
                break;
            }
            case 99: {
                string = SELECT_COMPUTER_NAMES;
                break;
            }
            default: {
                string = null;
            }
        }
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                nameList2 = new NameList();
                nameList2.nlName = this.getString(this.resultSet);
                nameList2.nlID = this.getInt(this.resultSet);
                nameList2.nlInfo = this.getShort(this.resultSet);
                object = this.getString(this.resultSet);
                if (this.isGroup(nameList2.nlInfo)) {
                    nameList2.nlName = String.valueOf(object) + "." + nameList2.nlName;
                }
                if (s == 90 && !this.isGroup(nameList2.nlInfo)) {
                    nameList2.nlID2 = this.getInt(this.resultSet);
                }
                if (nameList2.nlInfo == 1 && s != 98) {
                    nameList2.nlClusterID = this.getInt(this.resultSet);
                    if (nameList2.nlClusterID > 0) {
                        TResCluster tResCluster = new TResCluster(this.dbc);
                        tResCluster.fillInClusterDetails(nameList2);
                    }
                }
                nameList2.nlNext = nameList;
                nameList = nameList2;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getMembers", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        this.closeSelect();
        object = nameList2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMembers", object);
        }
        return object;
    }

    private ArrayList findChildResources(int n, boolean bl) throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"findChildResources", (String)"grp_id, isDelete");
        }
        boolean bl2 = false;
        ArrayList<Group2Res> arrayList = new ArrayList<Group2Res>(512);
        try {
            this.selectStmt = this.prepareStmt(SELECT_CHILDREN);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                Group2Res group2Res = new Group2Res();
                group2Res.g2resResourceID = this.getInt(this.resultSet);
                group2Res.g2resGroupID = this.getInt(this.resultSet);
                group2Res.g2resParentID = this.getInt(this.resultSet);
                group2Res.g2resResourceType = this.getShort(this.resultSet);
                group2Res.g2resIndicator = this.getShort(this.resultSet);
                group2Res.g2resAncestors = this.getString(this.resultSet);
                object = new StringTokenizer(group2Res.g2resAncestors, ":");
                int n2 = ((StringTokenizer)object).countTokens();
                if (bl) {
                    if (n2 > 5) {
                        bl2 = true;
                        break;
                    }
                } else if (n2 >= 5) {
                    bl2 = true;
                    break;
                }
                arrayList.add(group2Res);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"findChildResources", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        this.closeSelect();
        if (bl2) {
            this.cleanup();
            if (this.locked) {
                this.unlockTGroup();
            }
            object = MessageLog.getMessage((String)"SRV0166E");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"findChildResources");
            }
            throw new GeneralException((String)object);
        }
        object = arrayList;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"findChildResources", (Object)object);
        }
        return object;
    }

    private void removeResources(int n, short s, ArrayList arrayList, ArrayList arrayList2) throws GeneralException {
        Group2Res group2Res;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"removeResources", (String)"group_id, MonOrRepGroup, removeList, parentList");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.stmtType = 3;
            this.stmtPhase = 0;
            this.colIndex = 1;
            group2Res = new Group2Res();
            group2Res = (Group2Res)arrayList.get(n2);
            try {
                if (s == GroupDefHndlr.REPORTING_GROUP) {
                    this.setInt(this.deleteStmt, group2Res.g2resResourceID);
                    this.setInt(this.deleteStmt, group2Res.g2resGroupID);
                    this.setInt(this.deleteStmt, group2Res.g2resParentID);
                    this.setShort(this.deleteStmt, group2Res.g2resIndicator);
                    this.setString(this.deleteStmt, group2Res.g2resAncestors);
                } else {
                    this.setInt(this.deleteStmt, group2Res.g2resResourceID);
                    this.setInt(this.deleteStmt, n);
                    this.setInt(this.deleteStmt, n);
                    this.setShort(this.deleteStmt, (short)1);
                    this.setString(this.deleteStmt, String.valueOf(n));
                }
                this.stmtPhase = 3;
                this.deleteStmt.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"removeResources", (Throwable)sQLException);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.sqlError(sQLException);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList2.size()) {
            group2Res = (Group2Res)arrayList2.get(n2);
            int n3 = group2Res.g2resGroupID;
            String string = group2Res.g2resAncestors;
            int n4 = 0;
            while (n4 < arrayList.size()) {
                this.stmtType = 3;
                this.stmtPhase = 0;
                this.colIndex = 1;
                Group2Res group2Res2 = (Group2Res)((Group2Res)arrayList.get(n4)).clone();
                group2Res2.g2resGroupID = n3;
                group2Res2.g2resIndicator = group2Res2.g2resIndicator == 1 ? (short)2 : (group2Res2.g2resIndicator == 3 ? (short)4 : group2Res2.g2resIndicator);
                group2Res2.g2resAncestors = s == GroupDefHndlr.REPORTING_GROUP ? String.valueOf(string) + ":" + group2Res2.g2resAncestors : String.valueOf(string) + ":" + n;
                try {
                    this.setInt(this.deleteStmt, group2Res2.g2resResourceID);
                    this.setInt(this.deleteStmt, group2Res2.g2resGroupID);
                    this.setInt(this.deleteStmt, group2Res2.g2resParentID);
                    this.setShort(this.deleteStmt, group2Res2.g2resIndicator);
                    this.setString(this.deleteStmt, group2Res2.g2resAncestors);
                    this.stmtPhase = 3;
                    this.deleteStmt.executeUpdate();
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"removeResources", (Throwable)sQLException);
                    }
                    if (this.locked) {
                        this.unlockTGroup();
                    }
                    this.sqlError(sQLException);
                }
                ++n4;
            }
            ++n2;
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"removeResources");
        }
    }

    private void insertResources(int n, short s, ArrayList arrayList, ArrayList arrayList2) throws GeneralException {
        Group2Res group2Res;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertResources", (String)"group_id, MonOrRepGroup, addList, parentList");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.stmtType = 1;
            this.stmtPhase = 0;
            this.colIndex = 1;
            group2Res = new Group2Res();
            group2Res = (Group2Res)arrayList.get(n2);
            try {
                if (s == GroupDefHndlr.REPORTING_GROUP) {
                    this.setInt(this.insertStmt, group2Res.g2resResourceID);
                    this.setInt(this.insertStmt, group2Res.g2resGroupID);
                    this.setInt(this.insertStmt, group2Res.g2resParentID);
                    this.setShort(this.insertStmt, group2Res.g2resResourceType);
                    this.setShort(this.insertStmt, group2Res.g2resIndicator);
                    this.setString(this.insertStmt, group2Res.g2resAncestors);
                } else {
                    this.setInt(this.insertStmt, group2Res.g2resResourceID);
                    this.setInt(this.insertStmt, n);
                    this.setInt(this.insertStmt, n);
                    this.setShort(this.insertStmt, group2Res.g2resResourceType);
                    this.setShort(this.insertStmt, (short)1);
                    this.setString(this.insertStmt, String.valueOf(n));
                }
                this.stmtPhase = 3;
                this.insertStmt.executeUpdate();
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"insertResources", (Throwable)sQLException);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.sqlError(sQLException);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < arrayList2.size()) {
            group2Res = (Group2Res)arrayList2.get(n2);
            int n3 = group2Res.g2resGroupID;
            String string = group2Res.g2resAncestors;
            int n4 = 0;
            while (n4 < arrayList.size()) {
                this.stmtType = 1;
                this.stmtPhase = 0;
                this.colIndex = 1;
                Group2Res group2Res2 = (Group2Res)((Group2Res)arrayList.get(n4)).clone();
                group2Res2.g2resGroupID = n3;
                group2Res2.g2resIndicator = group2Res2.g2resIndicator == 1 ? (short)2 : (group2Res2.g2resIndicator == 3 ? (short)4 : group2Res2.g2resIndicator);
                if (s == GroupDefHndlr.REPORTING_GROUP) {
                    group2Res2.g2resAncestors = String.valueOf(string) + ":" + group2Res2.g2resAncestors;
                } else {
                    group2Res2.g2resParentID = n;
                    group2Res2.g2resAncestors = String.valueOf(string) + ":" + n;
                }
                try {
                    this.setInt(this.insertStmt, group2Res2.g2resResourceID);
                    this.setInt(this.insertStmt, group2Res2.g2resGroupID);
                    this.setInt(this.insertStmt, group2Res2.g2resParentID);
                    this.setShort(this.insertStmt, group2Res2.g2resResourceType);
                    this.setShort(this.insertStmt, group2Res2.g2resIndicator);
                    this.setString(this.insertStmt, group2Res2.g2resAncestors);
                    this.stmtPhase = 3;
                    this.insertStmt.executeUpdate();
                }
                catch (SQLException sQLException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"insertResources", (Throwable)sQLException);
                    }
                    if (this.locked) {
                        this.unlockTGroup();
                    }
                    this.sqlError(sQLException);
                }
                ++n4;
            }
            ++n2;
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertResources");
        }
    }

    private void deleteGroup(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteGroup", (String)"group_id");
        }
        this.deleteStmt = this.prepareStmt(DELETE_GROUP);
        this.stmtType = 3;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, n);
            this.setInt(this.deleteStmt, n);
            this.stmtPhase = 3;
            this.deleteStmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteGroup", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.sqlError(sQLException);
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteGroup");
        }
    }

    public void deleteResource(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteResource", (String)"resource_id, isTGroupLocked");
        }
        this.locked = false;
        this.resName = Integer.toString(n);
        if (!bl) {
            this.locked = this.lockTGroup((byte)1);
        }
        this.deleteStmt = this.prepareStmt(DELETE_RESOURCE);
        this.stmtType = 3;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, n);
            this.stmtPhase = 3;
            this.deleteStmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteResource", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.sqlError(sQLException);
        }
        this.closeDelete();
        if (this.locked) {
            this.unlockTGroup();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteResource");
        }
    }

    private ArrayList getResources(int n, NameList nameList, ArrayList arrayList, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getResources", (String)"group_id, resource_list, parentList, isDelete");
        }
        ArrayList<Group2Res> arrayList2 = new ArrayList<Group2Res>(512);
        NameList nameList2 = nameList;
        while (nameList2 != null) {
            Group2Res group2Res = new Group2Res();
            if (this.isGroup(nameList2.nlInfo)) {
                Group2Res group2Res2;
                int n2;
                if (arrayList != null) {
                    n2 = 0;
                    while (n2 < arrayList.size()) {
                        group2Res2 = (Group2Res)arrayList.get(n2);
                        if (group2Res2.g2resGroupID == nameList2.nlID) {
                            this.cleanup();
                            if (this.locked) {
                                this.unlockTGroup();
                            }
                            String string = MessageLog.getMessage((String)"SRV0161E");
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exit((String)clazz.getName(), (String)"getResources");
                            }
                            throw new GeneralException(string);
                        }
                        ++n2;
                    }
                }
                group2Res.g2resResourceID = nameList2.nlID;
                group2Res.g2resGroupID = n;
                group2Res.g2resParentID = n;
                group2Res.g2resIndicator = (short)3;
                group2Res.g2resResourceType = nameList2.nlInfo;
                group2Res.g2resAncestors = String.valueOf(n);
                arrayList2.add(group2Res);
                ArrayList arrayList3 = this.findChildResources(nameList2.nlID, bl);
                n2 = 0;
                while (n2 < arrayList3.size()) {
                    group2Res2 = (Group2Res)arrayList3.get(n2);
                    group2Res2.g2resGroupID = n;
                    group2Res2.g2resIndicator = group2Res2.g2resIndicator == 1 ? (short)2 : (group2Res2.g2resIndicator == 3 ? (short)4 : group2Res2.g2resIndicator);
                    group2Res2.g2resAncestors = String.valueOf(String.valueOf(n)) + ":" + group2Res2.g2resAncestors;
                    arrayList2.add(group2Res2);
                    ++n2;
                }
            } else if (this.isMask(nameList2.nlInfo)) {
                group2Res.g2resResourceID = nameList2.nlID;
                group2Res.g2resGroupID = n;
                group2Res.g2resParentID = n;
                group2Res.g2resIndicator = (short)5;
                if (nameList2.nlInfo == 95) {
                    group2Res.g2resResourceType = 1;
                } else if (nameList2.nlInfo == 96) {
                    group2Res.g2resResourceType = (short)3;
                }
                group2Res.g2resAncestors = String.valueOf(n);
                arrayList2.add(group2Res);
            } else {
                group2Res.g2resResourceID = nameList2.nlID;
                group2Res.g2resGroupID = n;
                group2Res.g2resParentID = n;
                group2Res.g2resIndicator = 1;
                group2Res.g2resResourceType = nameList2.nlInfo;
                group2Res.g2resAncestors = String.valueOf(n);
                arrayList2.add(group2Res);
            }
            nameList2 = nameList2.nlNext;
        }
        ArrayList<Group2Res> arrayList4 = arrayList2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getResources", arrayList4);
        }
        return arrayList4;
    }

    private Group2Res getMGroupByMember(NameList nameList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getMGroupByMember", (String)"nm");
        }
        int n = nameList.nlID;
        int n2 = 0;
        Group2Res group2Res = new Group2Res();
        String string = null;
        switch (nameList.nlInfo) {
            case 1: {
                string = SELECT_MON_GROUP_BY_COMP_ID;
                break;
            }
            case 3: {
                string = SELECT_MON_GROUP_BY_FS_ID;
            }
        }
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            this.stmtPhase = 1;
            if (this.resultSet.next()) {
                n2 = this.getInt(this.resultSet);
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getMGroupByMember", (Throwable)sQLException);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        this.closeSelect();
        if (n2 > 0) {
            group2Res.g2resGroupID = n2;
            group2Res.g2resResourceID = n;
            group2Res.g2resParentID = n2;
            group2Res.g2resIndicator = 1;
            group2Res.g2resResourceType = nameList.nlInfo;
            group2Res.g2resAncestors = String.valueOf(n2);
        } else {
            group2Res = null;
        }
        Group2Res group2Res2 = group2Res;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getMGroupByMember", (Object)group2Res2);
        }
        return group2Res2;
    }

    private boolean isGroup(short s) {
        return s == 2 || s == 0 || s == 77 || s == 89 || s == 90;
    }

    private boolean isMask(short s) {
        return s == 95 || s == 96;
    }

    public void deleteResources(int n, short s, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteResources", (String)"group_id, group_type, isTGroupLocked");
        }
        int n2 = -1;
        this.locked = false;
        this.resName = Integer.toString(n);
        if (!bl) {
            this.locked = this.lockTGroup((byte)1);
        }
        ArrayList arrayList = this.findAncestors(n, true);
        ArrayList arrayList2 = this.findChildResources(n, true);
        if (GroupDefHndlr.whichGroup(s) == GroupDefHndlr.REPORTING_GROUP) {
            this.removeResources(n, GroupDefHndlr.REPORTING_GROUP, arrayList2, arrayList);
            this.deleteGroup(n);
        }
        if (GroupDefHndlr.whichGroup(s) == GroupDefHndlr.MONITORING_GROUP) {
            switch (s) {
                case 0: {
                    n2 = 4;
                    break;
                }
                case 2: {
                    n2 = 3;
                }
            }
            this.removeResources(n, GroupDefHndlr.MONITORING_GROUP, arrayList2, arrayList);
            arrayList = this.findAncestors(n2, false);
            this.insertResources(n2, GroupDefHndlr.MONITORING_GROUP, arrayList2, arrayList);
            this.deleteGroup(n);
        }
        if (this.locked) {
            this.unlockTGroup();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteResources");
        }
    }

    public void insertNewResources(int n, int n2, String string, boolean bl) throws GeneralException {
        short s;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertNewResources", (String)"resourceID, grpID, resourceName, isTGroupLocked");
        }
        TGroup2Mask tGroup2Mask = new TGroup2Mask(this.dbc);
        NameList nameList = new NameList();
        nameList.nlID = n;
        switch (n2) {
            case 8: {
                s = 77;
                nameList.nlInfo = (short)78;
                nameList.nlName = string;
                this.addRemoveResources(n2, s, nameList, null, bl);
                break;
            }
            case 4: {
                s = 0;
                nameList.nlInfo = 1;
                nameList.nlName = string;
                this.addRemoveResources(n2, s, nameList, null, bl);
                break;
            }
            case 3: {
                s = 2;
                nameList.nlInfo = (short)3;
                nameList.nlName = string;
                this.addRemoveResources(n2, s, nameList, null, bl);
                break;
            }
            default: {
                Object[] objectArray = new Object[]{new Integer(n2)};
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"insertNewResources");
                }
                throw new GeneralException(MessageLog.getMessage((String)"SRV0109E", (Object[])objectArray));
            }
        }
        switch (s) {
            case 0: {
                s = 89;
                nameList.nlInfo = (short)95;
                break;
            }
            case 2: {
                s = 90;
                nameList.nlInfo = (short)96;
                break;
            }
            default: {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"insertNewResources");
                }
                return;
            }
        }
        if (nameList.nlName != null) {
            NameList nameList2 = tGroup2Mask.retrieveMasksByGroupType(s, nameList.nlName);
            while (nameList2 != null) {
                this.addRemoveResources(nameList2.nlID, s, nameList, null, false);
                nameList2 = nameList2.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertNewResources");
        }
    }

    public void addRemoveResources(int n, short s, NameList nameList, NameList nameList2, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"addRemoveResources", (String)"group_id, group_type, resource_list, remove_list, isTGroupLocked");
        }
        ArrayList arrayList = null;
        int n2 = -1;
        this.locked = false;
        this.resName = Integer.toString(n);
        if (!bl) {
            this.locked = this.lockTGroup((byte)1);
        }
        int n3 = this.getParentLevels(n);
        NameList nameList3 = nameList;
        while (nameList3 != null) {
            int n4;
            if ((nameList3.nlInfo == 0 || nameList3.nlInfo == 2 || nameList3.nlInfo == 89 || nameList3.nlInfo == 90) && (n4 = this.getChildrenLevels(nameList3.nlID)) + n3 > 5) {
                String string = MessageLog.getMessage((String)"SRV0166E");
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"addRemoveResources");
                }
                throw new GeneralException(string);
            }
            nameList3 = nameList3.nlNext;
        }
        ArrayList arrayList2 = this.findAncestors(n, false);
        if (GroupDefHndlr.whichGroup(s) == GroupDefHndlr.MONITORING_GROUP) {
            switch (s) {
                case 0: {
                    n2 = 4;
                    break;
                }
                case 2: {
                    n2 = 3;
                }
            }
            ArrayList arrayList3 = this.findAncestors(n2, false);
            if (nameList2 != null) {
                arrayList = null;
                arrayList = this.getResources(n, nameList2, null, false);
                this.removeResources(n, GroupDefHndlr.MONITORING_GROUP, arrayList, arrayList2);
                this.insertResources(n2, GroupDefHndlr.MONITORING_GROUP, arrayList, arrayList3);
            }
            if (nameList != null) {
                NameList nameList4 = nameList;
                while (nameList4 != null) {
                    Group2Res group2Res = this.getMGroupByMember(nameList4);
                    if (group2Res != null) {
                        ArrayList arrayList4 = this.findAncestors(group2Res.g2resGroupID, false);
                        ArrayList<Group2Res> arrayList5 = new ArrayList<Group2Res>(1);
                        arrayList5.add(group2Res);
                        this.removeResources(group2Res.g2resGroupID, GroupDefHndlr.MONITORING_GROUP, arrayList5, arrayList4);
                    }
                    nameList4 = nameList4.nlNext;
                }
                arrayList = null;
                arrayList = this.getResources(n, nameList, arrayList2, false);
                this.insertResources(n, GroupDefHndlr.MONITORING_GROUP, arrayList, arrayList2);
            }
        }
        if (GroupDefHndlr.whichGroup(s) == GroupDefHndlr.REPORTING_GROUP) {
            if (nameList2 != null) {
                arrayList = null;
                arrayList = this.getResources(n, nameList2, null, false);
                this.removeResources(n, GroupDefHndlr.REPORTING_GROUP, arrayList, arrayList2);
            }
            if (nameList != null) {
                arrayList = null;
                arrayList = this.getResources(n, nameList, arrayList2, false);
                this.insertResources(n, GroupDefHndlr.REPORTING_GROUP, arrayList, arrayList2);
            }
        }
        if (this.locked) {
            this.unlockTGroup();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"addRemoveResources");
        }
    }

    private boolean lockTGroup(byte by) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"lockTGroup", (String)"lockType");
        }
        boolean bl = LockManager.lock((short)0, (String)"GROUP", (String)this.resName, (byte)by, (boolean)true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"lockTGroup", (boolean)bl);
        }
        return bl;
    }

    private void unlockTGroup() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"unlockTGroup", (String)"");
        }
        if (this.resName != null) {
            LockManager.unLock((short)0, (String)"GROUP", (String)this.resName);
        }
        this.locked = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TGroup2Res");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"unlockTGroup");
        }
    }
}

