/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResChunkCollection;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResStorExtent;
import org.eclipse.aperi.repository.table.TResVolGroup;

public class TResChunk
extends StorageRepositoryAccessor {
    private static String SELECT = "select a.disk_id, a.collection_id, a.logical_disk_id, a.seqno,";
    private static String INSERT;
    private static final String BY_COLLECTION = " where a.collection_id = ? order by a.disk_id desc, a.offset desc";
    private static final String BY_LOCATION = ", t_res_chunk b where a.collection_id = b.collection_id and b.disk_id = ? and b.offset = ? order by a.seqno desc";
    private static final String BY_DISKID = " where a.disk_id = ? order by a.offset desc";
    private static final String DELETE_BY_LOCATION = "delete from t_res_chunk where disk_id = ? and offset >= ? and offset < ?";
    private static final String DELETE_BY_LOGICAL_DISK = "delete from t_res_chunk where logical_disk_id = ?";
    private long chunkSize = 0L;
    private short seqNo = 0;
    TResLogicalDisk ldAccessor = new TResLogicalDisk(this.dbc);
    TResVolGroup vgAccessor = new TResVolGroup(this.dbc);
    TResComputer cmpAccessor = new TResComputer(this.dbc);
    TResChunkCollection ccAccessor = new TResChunkCollection(this.dbc);
    TResDiskArray ssAccessor = new TResDiskArray(this.dbc);
    TResDevAccess daAccessor = new TResDevAccess(this.dbc);
    TResStorExtent seAccessor = new TResStorExtent(this.dbc);
    TResDevice devAccessor = new TResDevice(this.dbc);
    boolean autoCommit = false;
    int numLuns = 0;

    static {
        SELECT = SQLUtil.isSybase() || SQLUtil.isUDB() ? String.valueOf(SELECT) + "a.\"partition\", " : String.valueOf(SELECT) + "a.partition, ";
        SELECT = String.valueOf(SELECT) + "a.unit_size, a.chunk_size, a.offset, a.has_db from t_res_chunk a";
        INSERT = "insert into t_res_chunk (disk_id, collection_id, logical_disk_id, seqno,";
        INSERT = SQLUtil.isSybase() || SQLUtil.isUDB() ? String.valueOf(INSERT) + "\"partition\", " : String.valueOf(INSERT) + "partition, ";
        INSERT = String.valueOf(INSERT) + "offset, chunk_size, unit_size, has_db) values (?,?,?,?,?,?,?,?,?)";
    }

    public TResChunk(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResChunk", (String)"dbc");
        }
        this.tableName = "t_res_chunk";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResChunk");
        }
    }

    public void prepSelectByCollection() throws GeneralException {
        this.selectStmt = this.prepareStmt(String.valueOf(SELECT) + BY_COLLECTION);
    }

    public Chunk getChunksByCollection(ChunkCollection chunkCollection) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getChunksByCollection", (String)"collection");
        }
        Chunk chunk = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, chunkCollection.ccID);
            chunk = this.fetchChunks();
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getChunksByCollection", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Chunk chunk2 = chunk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getChunksByCollection", (Object)chunk2);
        }
        return chunk2;
    }

    public void prepSelectByLocation() throws GeneralException {
        this.selectStmt = this.prepareStmt(String.valueOf(SELECT) + BY_LOCATION);
    }

    public Chunk getChunksByLocation(Chunk chunk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getChunksByLocation", (String)"baseChk");
        }
        Chunk chunk2 = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, chunk.chkDiskID);
            this.setLong(this.selectStmt, chunk.chkOffset);
            chunk2 = this.fetchChunks();
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getChunksByLocation", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Chunk chunk3 = chunk2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getChunksByLocation", (Object)chunk3);
        }
        return chunk3;
    }

    public void prepSelectByDiskID() throws GeneralException {
        this.selectStmt = this.prepareStmt(String.valueOf(SELECT) + BY_DISKID);
    }

    public Chunk getChunksByDiskID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getChunksByDiskID", (String)"diskID");
        }
        Chunk chunk = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            chunk = this.fetchChunks();
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getChunksByDiskID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Chunk chunk2 = chunk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getChunksByDiskID", (Object)chunk2);
        }
        return chunk2;
    }

    private Chunk fetchChunks() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchChunks", (String)"");
        }
        Chunk chunk = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        this.stmtPhase = 1;
        while (this.nextResult()) {
            Chunk chunk2 = new Chunk();
            this.colIndex = 1;
            chunk2.chkDiskID = this.getInt(this.resultSet);
            chunk2.chkCollectionID = this.getInt(this.resultSet);
            chunk2.chkLogicalDiskID = this.getInt(this.resultSet);
            chunk2.chkSeqno = this.getShort(this.resultSet);
            chunk2.chkPartition = this.getShort(this.resultSet);
            chunk2.chkUnitSize = this.getInt(this.resultSet);
            chunk2.chkSize = this.getLong(this.resultSet);
            chunk2.chkOffset = this.getLong(this.resultSet);
            chunk2.chkHasDB = this.getBoolean(this.resultSet);
            chunk2.chkNextInCollection = chunk;
            chunk = chunk2;
        }
        this.closeResultSet();
        Chunk chunk3 = chunk;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchChunks", chunk3);
        }
        return chunk3;
    }

    public void prepSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSave", (String)"");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.deleteStmt = this.prepareStmt(DELETE_BY_LOCATION);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSave");
        }
    }

    public void closeSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"closeSave", (String)"");
        }
        this.closeInsert();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"closeSave");
        }
    }

    public void saveChunks(Chunk chunk, boolean bl, boolean bl2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveChunks", (String)"chkList");
        }
        try {
            Chunk chunk2 = chunk;
            while (chunk2 != null) {
                if (bl) {
                    this.deleteChunk(chunk2);
                }
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"saveChunks", (String)(" Inserting chunk: " + chunk2 + "\n"));
                }
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, chunk2.chkDiskID);
                this.setInt(this.insertStmt, chunk2.chkCollectionID);
                this.setInt(this.insertStmt, chunk2.chkLogicalDiskID);
                this.setShort(this.insertStmt, chunk2.chkSeqno);
                this.setShort(this.insertStmt, chunk2.chkPartition);
                this.setLong(this.insertStmt, chunk2.chkOffset);
                this.setLong(this.insertStmt, chunk2.chkSize);
                this.setInt(this.insertStmt, chunk2.chkUnitSize);
                this.setBoolean(this.insertStmt, chunk2.chkHasDB);
                this.executeUpdate(this.insertStmt);
                chunk2 = chunk2.chkNextInCollection;
            }
            if (bl2) {
                this.dbc.commit();
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveChunks", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveChunks");
        }
    }

    private void deleteChunk(Chunk chunk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteChunk", (String)"chk");
        }
        try {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"deleteChunk", (String)(" Deleting chunk: " + chunk));
            }
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, chunk.chkDiskID);
            this.setLong(this.deleteStmt, chunk.chkOffset);
            this.setLong(this.deleteStmt, chunk.chkOffset + chunk.chkSize);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteChunk", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.deleteError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteChunk");
        }
    }

    public void prepDeleteByLogicalDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepDeleteByLogicalDisk", (String)"");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BY_LOGICAL_DISK);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepDeleteByLogicalDisk");
        }
    }

    public void ssPopulateChunkInfo(int[] nArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"ssPopulateChunkInfo", (String)"ss_ids");
        }
        ResultSet resultSet = null;
        short s = -1;
        int n = 0;
        while (n < nArray.length) {
            s = this.cmpAccessor.getStorageSubsystemType(nArray[n]);
            resultSet = this.vgAccessor.getStoragePools(nArray[n]);
            this.buildSSChunkInfo(resultSet, s, nArray[n]);
            this.numLuns = 0;
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ssPopulateChunkInfo");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildSSChunkInfo(ResultSet var1_1, short var2_2, int var3_3) throws GeneralException {
        block37: {
            if (TraceLogger.enableTrace) {
                try {
                    v0 = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException v1) {
                    throw new NoClassDefFoundError(v1.getMessage());
                }
                TraceLogger.entry((String)v0.getName(), (String)"buildSSChunkInfo", (String)"rsPool, ssType");
            }
            try {
                try {
                    this.autoCommit = this.dbc.getAutoCommit();
                    this.dbc.setAutoCommit(true);
                    this.ccAccessor.prepInsert();
                    this.ccAccessor.prepDeleteByLogicalDisk();
                    this.prepSave();
                    this.prepDeleteByLogicalDisk();
                    this.ldAccessor.setSSLogicalDiskType(var3_3, (byte)1);
                    block17: while (true) {
                        if (!var1_1.next()) {
                            SQLUtil.closeResources(var1_1);
                            this.dbc.commit();
                        }
                        var4_4 = var1_1.getInt(1);
                        var5_6 = 0;
                        var6_7 = new Hashtable();
                        var7_8 = this.daAccessor.getPoolDisks(var3_3, var4_4);
                        var8_10 = 0;
                        while (true) {
                            if (!var7_8.next()) {
                                SQLUtil.closeResources(var7_8);
                                var8_9 = this.ldAccessor.getLUNs(var4_4);
                                var9_11 = 0L;
                                var11_13 = -1;
                                var12_14 = 0L;
                                this.seqNo = 0;
                                var14_15 = 0;
                                var15_16 = false;
                                if (var2_2 == 27 || var2_2 == 25) {
                                    var15_16 = true;
                                }
                                if (!var15_16) {
                                    var14_15 = this.getWidth(var2_2, var4_4, var5_6);
                                }
                                var16_17 = 11;
                                var17_18 = var1_1.getString(3);
                                if (var17_18 == null || (var18_19 /* !! */  = this.getRaid(var17_18)).length == 0) break;
                                var16_17 = var18_19 /* !! */ [0];
                                break;
                            }
                            var9_12 = new DiskID();
                            var9_12.diskId = var7_8.getInt(1);
                            this.devAccessor.setSpare(var9_12.diskId, true);
                            var9_12.isSpare = false;
                            var6_7.put(new Integer(var8_10), var9_12);
                            ++var5_6;
                            ++var8_10;
                        }
                        block19: while (true) {
                            if (!var8_9.next()) {
                                SQLUtil.closeResources(var8_9);
                                continue block17;
                            }
                            this.dbc.setAutoCommit(true);
                            ++this.numLuns;
                            var11_13 = var8_9.getInt(1);
                            var12_14 = var8_9.getLong(3);
                            var18_19 /* !! */  = null;
                            if (var15_16) {
                                var18_19 /* !! */  = (short[])this.buildDSChunkCollections(var11_13, var4_4, var12_14, var5_6, var16_17, var6_7, var9_11, var2_2);
                            } else if (var2_2 == 12 || var2_2 == 15) {
                                var18_19 /* !! */  = (short[])this.buildChunkCollections(var11_13, var12_14, var5_6, var14_15, var16_17, var6_7, var9_11, var2_2);
                            } else {
                                if (var5_6 == 0) {
                                    var6_7 = this.buildFakeDisk(var3_3, var4_4, var2_2);
                                    var5_6 = 1;
                                }
                                var18_19 /* !! */  = (short[])this.buildGenericChunkCollections(var11_13, var12_14, var5_6, var14_15, var16_17, var6_7, var9_11, var2_2);
                            }
                            var20_21 = new LogicalDisk();
                            var20_21.ldID = var11_13;
                            this.dbc.setAutoCommit(false);
                            this.ccAccessor.deleteByLogicalDisk(var20_21);
                            this.deleteByLogicalDisk(var20_21);
                            var20_21 = null;
                            this.ccAccessor.insertCollections((ChunkCollection)var18_19 /* !! */ );
                            var19_20 /* !! */  = var18_19 /* !! */ ;
                            while (true) {
                                if (var19_20 /* !! */  == null) {
                                    if (var2_2 == 15) {
                                        this.seqNo = (short)(this.seqNo + var5_6);
                                    }
                                    var9_11 += this.chunkSize;
                                    this.dbc.commit();
                                    if (!TraceLogger.enableTrace) continue block19;
                                    ** try [egrp 3[TRYBLOCK] [1 : 592->600)] { 
lbl93:
                                    // 1 sources

                                    break;
                                }
                                this.saveChunks(var19_20 /* !! */ .ccChunkList, false, false);
                                var19_20 /* !! */  = (short[])var19_20 /* !! */ .ccNext;
                            }
                            {
                                v2 = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                            }
lbl99:
                            // 1 sources

                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)v2.getName(), (String)"buildSSChunkInfo", (String)(" Processed LUN # " + this.numLuns));
                        }
                        break;
                    }
                }
                catch (SQLException var4_5) {
                    if (TraceLogger.enableTrace) {
                        try {
                            v4 = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                        }
                        catch (ClassNotFoundException v5) {
                            throw new NoClassDefFoundError(v5.getMessage());
                        }
                        TraceLogger.exception((String)v4.getName(), (String)"buildSSChunkInfo", (Throwable)var4_5);
                    }
                    this.sqlError(var4_5);
                }
            }
            catch (Throwable var22_22) {
                var21_23 = null;
                try {
                    this.dbc.setAutoCommit(this.autoCommit);
                }
                catch (SQLException var23_25) {
                    var23_25.printStackTrace();
                }
                this.ccAccessor.closeInsert();
                this.ccAccessor.closeDelete();
                this.closeSave();
                if (TraceLogger.enableTrace == false) throw var22_22;
                try {
                    v6 = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                }
                catch (ClassNotFoundException v7) {
                    throw new NoClassDefFoundError(v7.getMessage());
                }
                TraceLogger.exit((String)v6.getName(), (String)"buildSSChunkInfo");
                throw var22_22;
            }
            {
                var21_24 = null;
            }
            ** try [egrp 5[TRYBLOCK] [6 : 741->757)] { 
lbl136:
            // 1 sources

            this.dbc.setAutoCommit(this.autoCommit);
            break block37;
lbl138:
            // 1 sources

            catch (SQLException var23_26) {
                var23_26.printStackTrace();
            }
        }
        this.ccAccessor.closeInsert();
        this.ccAccessor.closeDelete();
        this.closeSave();
        if (TraceLogger.enableTrace == false) return;
        try {}
        catch (ClassNotFoundException v8) {
            throw new NoClassDefFoundError(v8.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.repository.table.TResChunk").getName(), (String)"buildSSChunkInfo");
    }

    public void svcPopulateChunkInfo(int[] nArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"svcPopulateChunkInfo", (String)"svc_ids");
        }
        ResultSet resultSet = null;
        int n = 0;
        while (n < nArray.length) {
            resultSet = this.vgAccessor.getStoragePools(nArray[n]);
            this.buildSVCChunkInfo(resultSet);
            this.numLuns = 0;
            ++n;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"svcPopulateChunkInfo");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildSVCChunkInfo(ResultSet resultSet) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"buildSVCChunkInfo", (String)"rsPools");
        }
        try {
            try {
                this.ccAccessor.prepInsert();
                this.ccAccessor.prepDeleteByLogicalDisk();
                this.prepSave();
                this.prepDeleteByLogicalDisk();
                block14: while (true) {
                    if (!resultSet.next()) {
                        SQLUtil.closeResources(resultSet);
                        this.dbc.setAutoCommit(this.autoCommit);
                    }
                    int n = resultSet.getInt(1);
                    int n2 = resultSet.getInt(2);
                    ResultSet resultSet2 = this.ldAccessor.getLUNs(n);
                    Chunk chunk = null;
                    Hashtable<Integer, Long> hashtable = new Hashtable<Integer, Long>();
                    block15: while (true) {
                        Class<?> clazz;
                        if (!resultSet2.next()) {
                            SQLUtil.closeResources(resultSet2);
                            continue block14;
                        }
                        ++this.numLuns;
                        int n3 = 0;
                        long l = 0L;
                        chunk = null;
                        int n4 = resultSet2.getInt(1);
                        short s = resultSet2.getShort(2);
                        this.ldAccessor.setLogicalDiskType(n4, this.ldAccessor.getSVCLogicalDiskType(s));
                        ChunkCollection chunkCollection = new ChunkCollection();
                        chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                        chunkCollection.ccSeqno = 0;
                        chunkCollection.ccStripingSize = -1;
                        chunkCollection.ccLogicalDiskID = n4;
                        chunkCollection.ccType = this.getSVCChunkCollectionType(s);
                        ResultSet resultSet3 = this.ldAccessor.getSVCMDisksForVDisk(n4);
                        block16: while (true) {
                            if (!resultSet3.next()) {
                                SQLUtil.closeResources(resultSet3);
                                LogicalDisk logicalDisk = new LogicalDisk();
                                logicalDisk.ldID = n4;
                                this.ccAccessor.deleteByLogicalDisk(logicalDisk);
                                this.deleteByLogicalDisk(logicalDisk);
                                this.ccAccessor.insertCollections(chunkCollection);
                                this.saveChunks(chunkCollection.ccChunkList, false, false);
                                if (!TraceLogger.enableTrace) continue block15;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                                    break;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            int n5 = resultSet3.getInt(1);
                            int n6 = resultSet3.getInt(2);
                            Long l2 = (Long)hashtable.get(new Integer(n5));
                            l = l2 == null ? 0L : l2;
                            int n7 = 0;
                            while (true) {
                                if (n7 >= n6) {
                                    hashtable.put(new Integer(n5), new Long(l));
                                    continue block16;
                                }
                                Chunk chunk2 = new Chunk();
                                chunk2.chkSize = n2;
                                chunk2.chkPartition = (short)-1;
                                chunk2.chkHasDB = false;
                                int n8 = n3;
                                n3 = (short)(n8 + 1);
                                chunk2.chkSeqno = (short)n8;
                                chunk2.chkUnitSize = n2;
                                chunk2.chkCollection = chunkCollection;
                                chunk2.chkCollectionID = chunkCollection.ccID;
                                chunk2.chkLogicalDiskID = n4;
                                chunk2.chkDiskID = n5;
                                chunk2.chkOffset = l;
                                l += chunk2.chkSize;
                                if (chunk == null) {
                                    chunkCollection.ccChunkList = chunk2;
                                } else {
                                    chunk.chkNextInCollection = chunk2;
                                }
                                chunk = chunk2;
                                ++chunkCollection.ccChunkCount;
                                ++n7;
                            }
                            break;
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"buildSSChunkInfo", (String)(" Processed VDisk # " + this.numLuns));
                    }
                    break;
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"buildSVCChunkInfo", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Class<?> clazz;
            Object var19_21 = null;
            this.ccAccessor.closeInsert();
            this.ccAccessor.closeDelete();
            this.closeSave();
            if (!TraceLogger.enableTrace) throw throwable;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"buildSVCChunkInfo");
            throw throwable;
        }
        {
            Object var19_22 = null;
        }
        this.ccAccessor.closeInsert();
        this.ccAccessor.closeDelete();
        this.closeSave();
        if (!TraceLogger.enableTrace) return;
        try {}
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.repository.table.TResChunk").getName(), (String)"buildSVCChunkInfo");
    }

    public byte getSVCChunkCollectionType(short s) {
        int n = 0;
        if (s == 0) {
            n = 0;
        } else if (s == 1) {
            n = 1;
        } else if (s == 2) {
            n = 0;
        } else if (s == 3) {
            n = 5;
        }
        return (byte)n;
    }

    private ChunkCollection buildChunkCollections(int n, long l, int n2, short s, short s2, Hashtable hashtable, long l2, short s3) throws GeneralException {
        Chunk chunk;
        int n3;
        ChunkCollection chunkCollection;
        int n4;
        int n5 = 0;
        int n6 = 0;
        float f = 0.0f;
        ChunkCollection chunkCollection2 = new ChunkCollection();
        TResLogicalDisk tResLogicalDisk = new TResLogicalDisk(this.dbc);
        if (s3 == 12) {
            if (s > 5) {
                n6 = n5 = s + 1;
                chunkCollection2 = new ChunkCollection();
                chunkCollection2.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = 0x100000;
                chunkCollection2.ccType = (byte)2;
                chunkCollection2.ccLogicalDiskID = n;
            } else if (s > 1) {
                n5 = s;
                n6 = n5 * 2;
                chunkCollection2 = new ChunkCollection();
                n4 = TResLogicalDisk.getIdentifier(1, 2, this.dbc);
                chunkCollection2.ccID = n4++;
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = 0x100000;
                chunkCollection2.ccType = 1;
                chunkCollection2.ccLogicalDiskID = n;
                chunkCollection2.ccNext = new ChunkCollection();
                chunkCollection2.ccNext.ccID = n4;
                chunkCollection2.ccNext.ccSeqno = (short)2;
                chunkCollection2.ccNext.ccStripingSize = 0x100000;
                chunkCollection2.ccNext.ccType = (byte)5;
                chunkCollection2.ccNext.ccLogicalDiskID = n;
            } else {
                n6 = n5 = 1;
                tResLogicalDisk.setLogicalDiskType(n, (byte)0);
                chunkCollection2 = new ChunkCollection();
                chunkCollection2.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = 0x100000;
                chunkCollection2.ccType = 0;
                chunkCollection2.ccLogicalDiskID = n;
            }
        }
        if (s3 == 15) {
            n6 = n5 = n2;
            if (s2 == 3) {
                chunkCollection2.ccStripingSize = -1;
                chunkCollection2.ccType = (byte)2;
                chunkCollection2.ccLogicalDiskID = n;
                chunkCollection2 = new ChunkCollection();
                chunkCollection2.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = -1;
                chunkCollection2.ccType = 1;
                chunkCollection2.ccLogicalDiskID = n;
                f = 1.0f;
            } else if (s2 == 4) {
                chunkCollection2 = new ChunkCollection();
                chunkCollection2.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = -1;
                chunkCollection2.ccType = (byte)5;
                chunkCollection2.ccLogicalDiskID = n;
                f = 2.0f;
            } else if (s2 == 6 || s2 == 0) {
                chunkCollection2 = new ChunkCollection();
                chunkCollection2.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = -1;
                chunkCollection2.ccLogicalDiskID = n;
                chunkCollection2.ccType = s2 == 6 ? (byte)6 : (byte)2;
                Integer n7 = new Integer(n2);
                Integer n8 = new Integer(n2 - 1);
                if (n8 == 0) {
                    n8 = new Integer(1);
                }
                f = n7.floatValue() / n8.floatValue();
            } else {
                tResLogicalDisk.setLogicalDiskType(n, (byte)8);
                n4 = n2 / 2;
                chunkCollection2 = new ChunkCollection();
                int n9 = TResLogicalDisk.getIdentifier(1, n4, this.dbc);
                chunkCollection2.ccID = n9++;
                chunkCollection2.ccSeqno = 1;
                chunkCollection2.ccStripingSize = -1;
                chunkCollection2.ccType = (byte)5;
                chunkCollection2.ccLogicalDiskID = n;
                chunkCollection = chunkCollection2;
                n3 = 1;
                while (n3 < n4) {
                    chunk = new ChunkCollection();
                    chunkCollection2.ccID = n9++;
                    chunk.ccSeqno = (short)(n3 + 1);
                    chunk.ccStripingSize = -1;
                    chunk.ccType = (byte)5;
                    chunk.ccLogicalDiskID = n;
                    chunkCollection2.ccNext = chunk;
                    chunkCollection2 = chunk;
                    ++n3;
                }
                chunkCollection2 = chunkCollection;
                f = 2.0f;
            }
        }
        this.chunkSize = this.getChunkSize(s, f, n2, l, s3);
        int n10 = 0;
        ChunkCollection chunkCollection3 = chunkCollection2;
        while (chunkCollection3 != null) {
            if (s3 == 12) {
                this.seqNo = 0;
            }
            chunkCollection = null;
            n3 = 0;
            while (n3 < n5) {
                chunk = new Chunk();
                chunk.chkSize = this.chunkSize;
                chunk.chkOffset = l2;
                chunk.chkPartition = (short)-1;
                this.seqNo = (short)(this.seqNo + 1);
                chunk.chkSeqno = chunk.chkSeqno;
                chunk.chkUnitSize = 512;
                chunk.chkCollection = chunkCollection3;
                chunk.chkCollectionID = chunkCollection3.ccID;
                chunk.chkLogicalDiskID = n;
                if (chunkCollection == null) {
                    chunkCollection3.ccChunkList = chunk;
                } else {
                    chunkCollection.chkNextInCollection = chunk;
                }
                chunkCollection = chunk;
                if (n10 < n2) {
                    int n11 = n10;
                    n10 = (short)(n11 + 1);
                    chunk.chkDiskID = ((DiskID)hashtable.get((Object)new Integer((int)n11))).diskId;
                }
                ++n3;
            }
            chunkCollection3 = chunkCollection3.ccNext;
        }
        if (n6 < n2) {
            int n12 = 0;
            while (n12 < n2 - n6) {
                int n13 = n10;
                n10 = (short)(n13 + 1);
                DiskID diskID = (DiskID)hashtable.get(new Integer(n13));
                if (diskID != null) {
                    if (!diskID.isSpare) {
                        this.devAccessor.setSpare(diskID.diskId, false);
                    }
                    diskID.isSpare = true;
                }
                ++n12;
            }
        }
        return chunkCollection2;
    }

    private short getWidth(short s, int n, int n2) throws GeneralException {
        short s2;
        block11: {
            s2 = 0;
            int n3 = 0;
            ResultSet resultSet = null;
            try {
                if (s == 12) {
                    resultSet = this.vgAccessor.getStoragePoolDiskGroupWidthRaid(n);
                    if (resultSet.next()) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"buildSSChunkInfo", (String)("ResultSet state: " + resultSet.getCursorName() + "  fetch size: " + resultSet.getFetchSize()));
                        }
                        s2 = resultSet.getShort(1);
                        n3 = resultSet.getShort(2);
                    }
                    SQLUtil.closeResources(resultSet);
                    if (s2 == 0) {
                        s2 = n3 == 5 ? (short)7 : (n3 == 10 ? (short)4 : (short)1);
                    }
                    break block11;
                }
                s2 = n2 == 0 ? (short)1 : (short)n2;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getWidth", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
        }
        return s2;
    }

    private long getChunkSize(short s, float f, int n, long l, short s2) {
        long l2 = 0L;
        if (s2 == 12) {
            l2 = l / (long)s;
        } else if (s2 == 15) {
            l2 = new Float((float)l * f / (float)n).longValue();
        }
        return l2;
    }

    private ChunkCollection buildGenericChunkCollections(int n, long l, int n2, short s, short s2, Hashtable hashtable, long l2, short s3) throws GeneralException {
        int n3;
        int n4 = n2;
        ChunkCollection chunkCollection = new ChunkCollection();
        if (s2 == 3) {
            chunkCollection = new ChunkCollection();
            chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            chunkCollection.ccSeqno = 1;
            chunkCollection.ccStripingSize = -1;
            chunkCollection.ccType = 1;
            chunkCollection.ccLogicalDiskID = n;
        } else if (s2 == 4) {
            chunkCollection = new ChunkCollection();
            chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            chunkCollection.ccSeqno = 1;
            chunkCollection.ccStripingSize = -1;
            chunkCollection.ccType = (byte)5;
            chunkCollection.ccLogicalDiskID = n;
        } else if (s2 == 0 || s2 == 6) {
            chunkCollection = new ChunkCollection();
            chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            chunkCollection.ccSeqno = 1;
            chunkCollection.ccStripingSize = -1;
            chunkCollection.ccType = s2 == 6 ? (byte)6 : (byte)2;
            chunkCollection.ccLogicalDiskID = n;
        } else if (s2 == 1 || s2 == 10 || s2 == 9) {
            n3 = n2 / 2;
            if (s2 == 10 || s2 == 9) {
                --n3;
            }
            chunkCollection = new ChunkCollection();
            int n5 = TResLogicalDisk.getIdentifier(1, n3, this.dbc);
            chunkCollection.ccID = n5++;
            chunkCollection.ccSeqno = 1;
            chunkCollection.ccStripingSize = -1;
            chunkCollection.ccType = (byte)5;
            chunkCollection.ccLogicalDiskID = n;
            ChunkCollection chunkCollection2 = chunkCollection;
            int n6 = 1;
            while (n6 < n3) {
                ChunkCollection chunkCollection3 = new ChunkCollection();
                chunkCollection3.ccID = n5++;
                chunkCollection3.ccSeqno = (short)(n6 + 1);
                chunkCollection3.ccStripingSize = -1;
                chunkCollection3.ccType = (byte)5;
                chunkCollection3.ccLogicalDiskID = n;
                chunkCollection.ccNext = chunkCollection3;
                chunkCollection = chunkCollection3;
                ++n6;
            }
            chunkCollection = chunkCollection2;
        } else {
            n4 = s;
            chunkCollection = new ChunkCollection();
            chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
            chunkCollection.ccSeqno = 1;
            chunkCollection.ccStripingSize = 0x100000;
            chunkCollection.ccType = 0;
            chunkCollection.ccLogicalDiskID = n;
        }
        n3 = 0;
        this.chunkSize = l / (long)s;
        ChunkCollection chunkCollection4 = chunkCollection;
        while (chunkCollection4 != null) {
            int n7 = 0;
            Chunk chunk = null;
            int n8 = 0;
            while (n8 < n4) {
                Chunk chunk2 = new Chunk();
                if (s < 1) {
                    s = 1;
                }
                chunk2.chkSize = l / (long)s;
                chunk2.chkOffset = l2;
                chunk2.chkPartition = (short)-1;
                int n9 = n7;
                n7 = (short)(n9 + 1);
                chunk2.chkSeqno = (short)n9;
                chunk2.chkUnitSize = 512;
                chunk2.chkCollection = chunkCollection4;
                chunk2.chkCollectionID = chunkCollection4.ccID;
                chunk2.chkLogicalDiskID = n;
                if (chunk == null) {
                    chunkCollection4.ccChunkList = chunk2;
                } else {
                    chunk.chkNextInCollection = chunk2;
                }
                chunk = chunk2;
                if (n3 < n2) {
                    int n10 = n3;
                    n3 = (short)(n10 + 1);
                    chunk2.chkDiskID = ((DiskID)hashtable.get((Object)new Integer((int)n10))).diskId;
                }
                ++n8;
            }
            chunkCollection4 = chunkCollection4.ccNext;
        }
        if (n4 < n2) {
            int n11 = 0;
            while (n11 < n2 - n4) {
                int n12 = n3;
                n3 = (short)(n12 + 1);
                DiskID diskID = (DiskID)hashtable.get(new Integer(n12));
                if (diskID != null) {
                    if (!diskID.isSpare) {
                        this.devAccessor.setSpare(diskID.diskId, false);
                    }
                    diskID.isSpare = true;
                }
                ++n11;
            }
        }
        return chunkCollection;
    }

    private ChunkCollection buildDSChunkCollections(int n, int n2, long l, int n3, short s, Hashtable hashtable, long l2, short s2) throws GeneralException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ChunkCollection chunkCollection = null;
        ChunkCollection chunkCollection2 = null;
        ChunkCollection chunkCollection3 = null;
        short s3 = 0;
        short s4 = 0;
        short s5 = 0;
        short s6 = 0;
        try {
            int n7;
            int n8;
            int n9;
            int n10 = 0;
            Hashtable<Integer, Short> hashtable2 = new Hashtable<Integer, Short>();
            Hashtable<Integer, Short> hashtable3 = new Hashtable<Integer, Short>();
            Hashtable<Integer, Short> hashtable4 = new Hashtable<Integer, Short>();
            Hashtable<Integer, Short> hashtable5 = new Hashtable<Integer, Short>();
            ResultSet resultSet = this.seAccessor.getLUNRankInfo(n);
            int n11 = 0;
            while (resultSet.next()) {
                hashtable2.put(new Integer(n11), new Short(resultSet.getShort(1)));
                hashtable3.put(new Integer(n11), new Short(resultSet.getShort(2)));
                n9 = resultSet.getInt(3);
                n8 = this.seAccessor.getNumOfArraySites(n9);
                n7 = this.seAccessor.getNumOfDisks(n9);
                hashtable4.put(new Integer(n11), new Short((short)n8));
                hashtable5.put(new Integer(n11), new Short((short)n7));
                ++n10;
                ++n11;
            }
            SQLUtil.closeResources(resultSet);
            n11 = 0;
            while (n11 < n10) {
                s3 = (Short)hashtable3.get(new Integer(n11));
                s4 = (Short)hashtable2.get(new Integer(n11));
                s5 = (Short)hashtable4.get(new Integer(n11));
                if (s3 == 5) {
                    n4 = (short)(n4 + s4);
                    n4 = (short)(n4 + s5);
                } else {
                    n4 = s3 == 10 ? (int)((short)(n4 + (short)(s4 / 2))) : (s3 == 15 || s3 == 51 ? (int)((short)(n4 + (short)(s4 + s5 * 2) / 2)) : (int)((short)(n4 + 1)));
                }
                ++n11;
            }
            if (n4 == 0) {
                n4 = s2 == 25 ? (s == 0 ? 7 : (s == 1 || s == 9 || s == 10 ? 4 : 1)) : (s2 == 27 ? (s == 0 ? 3 : (s == 1 || s == 9 || s == 10 ? 2 : 1)) : 1);
            }
            this.chunkSize = l / (long)n4;
            n11 = 0;
            n9 = 0;
            n8 = 0;
            while (n8 < n10) {
                s3 = (Short)hashtable3.get(new Integer(n8));
                s4 = (Short)hashtable2.get(new Integer(n8));
                s5 = (Short)hashtable4.get(new Integer(n8));
                s6 = (Short)hashtable5.get(new Integer(n8));
                if (s3 == 5) {
                    n6 = n5 = s4 + s5;
                    chunkCollection = new ChunkCollection();
                    n11 = (short)(n11 + 1);
                    chunkCollection.ccSeqno = chunkCollection.ccSeqno;
                    chunkCollection.ccStripingSize = 0x100000;
                    chunkCollection.ccType = (byte)2;
                    chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                    chunkCollection.ccLogicalDiskID = n;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"buildSSChunkInfo", (String)("RAID 5 chunk collection created for logical_disk_id = " + n));
                    }
                } else if (s3 == 10) {
                    n5 = s4 / 2;
                    n6 = n5 * 2;
                    chunkCollection = new ChunkCollection();
                    n11 = (short)(n11 + 1);
                    chunkCollection.ccSeqno = chunkCollection.ccSeqno;
                    chunkCollection.ccStripingSize = 0x100000;
                    chunkCollection.ccType = 1;
                    n7 = TResLogicalDisk.getIdentifier(1, 2, this.dbc);
                    chunkCollection.ccID = n7++;
                    chunkCollection.ccLogicalDiskID = n;
                    chunkCollection.ccNext = new ChunkCollection();
                    n11 = (short)(n11 + 1);
                    chunkCollection.ccNext.ccSeqno = chunkCollection.ccNext.ccSeqno;
                    chunkCollection.ccNext.ccStripingSize = 0x100000;
                    chunkCollection.ccNext.ccType = (byte)5;
                    chunkCollection.ccNext.ccID = n7;
                    chunkCollection.ccNext.ccLogicalDiskID = n;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"buildSSChunkInfo", (String)("RAID 10 chunk collection created for logical_disk_id = " + n));
                    }
                } else if (s3 == 15 || s3 == 51) {
                    n5 = (s4 + s5 * 2) / 2;
                    n6 = n5 * 2;
                    chunkCollection = new ChunkCollection();
                    n11 = (short)(n11 + 1);
                    chunkCollection.ccSeqno = chunkCollection.ccSeqno;
                    chunkCollection.ccStripingSize = 0x100000;
                    chunkCollection.ccType = (byte)2;
                    n7 = TResLogicalDisk.getIdentifier(1, 2, this.dbc);
                    chunkCollection.ccID = n7++;
                    chunkCollection.ccLogicalDiskID = n;
                    chunkCollection.ccNext = new ChunkCollection();
                    n11 = (short)(n11 + 1);
                    chunkCollection.ccNext.ccSeqno = chunkCollection.ccNext.ccSeqno;
                    chunkCollection.ccNext.ccStripingSize = 0x100000;
                    chunkCollection.ccNext.ccType = (byte)5;
                    chunkCollection.ccNext.ccID = n7;
                    chunkCollection.ccNext.ccLogicalDiskID = n;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"buildSSChunkInfo", (String)("RAID 15 or 51 chunk collection created for logical_disk_id = " + n));
                    }
                } else {
                    n6 = n5 = 1;
                    this.ldAccessor.setLogicalDiskType(n, (byte)0);
                    chunkCollection = new ChunkCollection();
                    chunkCollection.ccID = -1;
                    n11 = (short)(n11 + 1);
                    chunkCollection.ccSeqno = chunkCollection.ccSeqno;
                    chunkCollection.ccStripingSize = 0x100000;
                    chunkCollection.ccType = 0;
                    chunkCollection.ccID = TResLogicalDisk.getIdentifier(1, 1, this.dbc);
                    chunkCollection.ccLogicalDiskID = n;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunk");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.traceMessage((int)2, (String)clazz.getName(), (String)"buildSSChunkInfo", (String)("JBOD chunk collection created for logical_disk_id = " + n));
                    }
                }
                n7 = 0;
                ChunkCollection chunkCollection4 = chunkCollection;
                while (chunkCollection4 != null) {
                    int n12 = 0;
                    Chunk chunk = null;
                    int n13 = 0;
                    while (n13 < n5) {
                        Chunk chunk2 = new Chunk();
                        chunk2.chkSize = l / (long)n4;
                        chunk2.chkOffset = l2;
                        chunk2.chkPartition = (short)-1;
                        int n14 = n12;
                        n12 = (short)(n14 + 1);
                        chunk2.chkSeqno = (short)n14;
                        chunk2.chkUnitSize = 512;
                        chunk2.chkCollection = chunkCollection4;
                        chunk2.chkLogicalDiskID = n;
                        chunk2.chkCollectionID = chunkCollection4.ccID;
                        if (chunk == null) {
                            chunkCollection4.ccChunkList = chunk2;
                        } else {
                            chunk.chkNextInCollection = chunk2;
                        }
                        chunk = chunk2;
                        if (n7 < s6) {
                            int n15 = n9;
                            n9 = (short)(n15 + 1);
                            DiskID diskID = (DiskID)hashtable.get(new Integer(n15));
                            if (diskID != null) {
                                chunk2.chkDiskID = diskID.diskId;
                            }
                            n7 = (short)(n7 + 1);
                        }
                        ++n13;
                    }
                    chunkCollection4 = chunkCollection4.ccNext;
                }
                if (n6 < s6) {
                    int n16 = 0;
                    while (n16 < s6 - n6) {
                        int n17 = n9;
                        n9 = (short)(n17 + 1);
                        DiskID diskID = (DiskID)hashtable.get(new Integer(n17));
                        if (diskID != null) {
                            if (!diskID.isSpare) {
                                this.devAccessor.setSpare(diskID.diskId, false);
                            }
                            diskID.isSpare = true;
                        }
                        ++n16;
                    }
                }
                if (chunkCollection2 == null) {
                    chunkCollection2 = chunkCollection;
                } else {
                    chunkCollection2.ccNext = chunkCollection;
                }
                chunkCollection3 = chunkCollection2;
                ++n8;
            }
        }
        catch (SQLException sQLException) {
            this.sqlError(sQLException);
        }
        return chunkCollection3;
    }

    public short[] getRaid(String string) {
        Pattern pattern = Pattern.compile(" ");
        String[] stringArray = pattern.split(string);
        short[] sArray = new short[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            sArray[n] = 11;
            int n2 = 0;
            while (n2 < VolGroup.RAID_LEVELS.length) {
                if (VolGroup.RAID_LEVELS[n2].equalsIgnoreCase(stringArray[n].trim())) {
                    sArray[n] = n2;
                }
                n2 = (short)(n2 + 1);
            }
            ++n;
        }
        return sArray;
    }

    public Hashtable buildFakeDisk(int n, int n2, short s) throws GeneralException {
        Hashtable<Integer, DiskID> hashtable = new Hashtable<Integer, DiskID>();
        Disk disk = new Disk();
        disk.initUnknown();
        disk.devFlags = 1;
        disk.devType = 0;
        disk.devStorageSystemType = (short)14;
        disk.dskLogicalBlockSize = 512;
        disk.dskSectorSize = 512;
        String string = null;
        string = s == 18 ? "HP DISK" : (s == 14 ? "HDS Disk" : "Disk");
        this.cmpAccessor.prepGetSS();
        NasFiler nasFiler = this.cmpAccessor.getSS(n);
        disk.devSerialNumber = String.valueOf(string) + "-" + nasFiler.nfName + "_" + n2;
        disk.devManufacturer = nasFiler.nfManufacturer;
        disk.devName = string;
        this.devAccessor.saveDevices((Device)disk);
        int n3 = this.devAccessor.getPVID(disk.devSerialNumber);
        DiskID diskID = new DiskID();
        diskID.diskId = n3;
        diskID.isSpare = false;
        hashtable.put(new Integer(0), diskID);
        return hashtable;
    }

    private class DiskID {
        public int diskId;
        public boolean isSpare;

        private DiskID() {
        }
    }
}

