/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResChunkCollection
extends StorageRepositoryAccessor {
    private static final String FETCH_BY_LOGICAL_DISK = "select collection_id, seqno, collection_type, striping_size from t_res_chunk_cllctn where logical_disk_id = ? order by seqno desc";
    private static final String FETCH_BY_FLEXIBLE_LOGICAL_DISK = "select collection_id, seqno, collection_type, striping_size from t_res_chunk_cllctn where collection_id = (select collection_id from t_res_aggregate  where logical_disk_id = ?)  order by seqno desc";
    private static final String INSERT = "insert into t_res_chunk_cllctn (collection_id, logical_disk_id, seqno, collection_type, striping_size) values (?,?,?,?,?)";
    private static final String DELETE_BY_LOGICAL_DISK = "delete from t_res_chunk_cllctn where logical_disk_id = ?";
    private static final String INSERT_AGGREGATE = "insert into t_res_aggregate values(?,?)";

    public TResChunkCollection(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResChunkCollection", (String)"dbc");
        }
        this.tableName = "t_res_chunk_cllctn";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResChunkCollection");
        }
    }

    public void prepSelectByLogicalDisk() throws GeneralException {
        this.selectStmt = this.prepareStmt(FETCH_BY_LOGICAL_DISK);
    }

    public void prepSelectByFlexibleLogicalDisk() throws GeneralException {
        this.selectStmt = this.prepareStmt(FETCH_BY_FLEXIBLE_LOGICAL_DISK);
    }

    public ChunkCollection getCollections(LogicalDisk logicalDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getCollections", (String)"lDisk");
        }
        ChunkCollection chunkCollection = null;
        try {
            ChunkCollection chunkCollection2;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, logicalDisk.ldID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while ((chunkCollection2 = this.fetchCollection()) != null) {
                chunkCollection2.ccLogicalDiskID = logicalDisk.ldID;
                chunkCollection2.ccNext = chunkCollection;
                chunkCollection = chunkCollection2;
            }
            this.closeResultSet();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getCollections", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        ChunkCollection chunkCollection3 = chunkCollection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getCollections", chunkCollection3);
        }
        return chunkCollection3;
    }

    private ChunkCollection fetchCollection() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchCollection", (String)"");
        }
        if (!this.nextResult()) {
            ChunkCollection chunkCollection = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"fetchCollection", chunkCollection);
            }
            return chunkCollection;
        }
        ChunkCollection chunkCollection = new ChunkCollection();
        this.colIndex = 1;
        chunkCollection.ccID = this.getInt(this.resultSet);
        chunkCollection.ccSeqno = this.getShort(this.resultSet);
        chunkCollection.ccType = this.getByte(this.resultSet);
        chunkCollection.ccStripingSize = this.getInt(this.resultSet);
        ChunkCollection chunkCollection2 = chunkCollection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchCollection", (Object)chunkCollection2);
        }
        return chunkCollection2;
    }

    public void prepInsert() throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
    }

    public void insertCollections(ChunkCollection chunkCollection) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertCollections", (String)"colList");
        }
        try {
            ChunkCollection chunkCollection2 = chunkCollection;
            while (chunkCollection2 != null) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"insertCollections", (String)(" Inserting collection: " + chunkCollection2));
                }
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, chunkCollection2.ccID);
                this.setInt(this.insertStmt, chunkCollection2.ccLogicalDiskID);
                this.setShort(this.insertStmt, chunkCollection2.ccSeqno);
                this.setByte(this.insertStmt, chunkCollection2.ccType);
                this.setInt(this.insertStmt, chunkCollection2.ccStripingSize);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                chunkCollection2 = chunkCollection2.ccNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertCollections", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertCollections");
        }
    }

    public void insertAggregates(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertAggregates", (String)"ldID, ccID");
        }
        try {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.traceMessage((int)3, (String)clazz.getName(), (String)"insertAggregates", (String)(" Inserting Aggregate: " + n + "," + n2));
            }
            PreparedStatement preparedStatement = this.prepareStmt(INSERT_AGGREGATE);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(preparedStatement, n);
            this.setInt(preparedStatement, n2);
            this.executeUpdate(preparedStatement);
            this.dbc.commit();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insertAggregates", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResChunkCollection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertAggregates");
        }
    }

    public void prepDeleteByLogicalDisk() throws GeneralException {
        this.deleteStmt = this.prepareStmt(DELETE_BY_LOGICAL_DISK);
    }
}

