/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;

public class TResLdapTree
extends RepositoryAccessor {
    public static final String TABLE_NAME = "t_res_ldap_tree";
    public static final String ID_COLUMN = "tree_id";
    private static final String SELECT_ID = "select tree_id from t_res_ldap_tree where name = ?";
    private static final String SELECT = "select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id";
    private static final String SELECT_NAME = "select name from t_res_ldap_tree where id = ?";
    private static final String WHERE_COMPUTER_EQUALS = " and t.computer_id = ";
    private static final String WHERE_NAME_EQUALS = " and t.name = ?";
    private static final String GUI_SELECT1 = "select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id union all ";
    private static final String GUI_SELECT2 = " select tt.tree_id, tt.name, tt.computer_id, ' ', ' '";
    private static final String GUI_SELECT_FROM = " from t_res_ldap_tree tt where not exists (select pp.resource_id from t_res_pwd pp where pp.resource_id = tt.tree_id)";
    private static final String INSERT = "insert into t_res_ldap_tree (tree_id, name, computer_id) values (?,?,?)";
    private static final String SELECT_NOVELL_PROBE_AGENT = "select t.computer_id from t_res_ldap_tree t, t_stat_computer c, t_res_domain d where c.computer_id = ? and c.domain_id = d.domain_id and d.tree_id = t.tree_id";
    private static final String UPDATE_COMPUTER_ID = "update t_res_ldap_tree set computer_id = ? where tree_id = ? and computer_id = ?";
    private static final String UPDATE_GUI_ID = "update t_res_ldap_tree set computer_id = ? where tree_id = ?";

    public TResLdapTree(Connection connection) {
        super(connection);
        this.tableName = TABLE_NAME;
    }

    public LdapTree getTrees(int n) throws GeneralException {
        LdapTree ldapTree;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTrees", (String)"computerID");
        }
        LdapTree ldapTree2 = null;
        if (n > 0) {
            string = "select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id and t.computer_id = " + n;
        } else {
            string = GUI_SELECT1;
            string = String.valueOf(string) + GUI_SELECT2;
            string = String.valueOf(string) + GUI_SELECT_FROM;
        }
        try {
            this.selectStmt = this.prepareStmt(string);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.resultSet.next()) {
                ldapTree = this.fetchTree();
                ldapTree.ltNext = ldapTree2;
                ldapTree2 = ldapTree;
            }
            this.closeSelect();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getTrees", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        ldapTree = ldapTree2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTrees", (Object)ldapTree);
        }
        return ldapTree;
    }

    private LdapTree fetchTree() throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchTree", (String)"");
        }
        this.getPhase();
        LdapTree ldapTree = new LdapTree();
        ldapTree.ltTreeID = this.getInt(this.resultSet);
        ldapTree.setLtName(this.getString(this.resultSet));
        ldapTree.ltComputerID = this.getInt(this.resultSet);
        ldapTree.ltLdapUser = this.getString(this.resultSet);
        ldapTree.ltPassword = this.getString(this.resultSet);
        LdapTree ldapTree2 = ldapTree;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchTree", (Object)ldapTree2);
        }
        return ldapTree2;
    }

    public LdapTree[] getPackedTree() throws GeneralException {
        return LdapTree.pack((LdapTree)this.getTrees(-1));
    }

    public void prepGetByName() throws GeneralException {
        this.selectStmt = this.prepareStmt("select t.tree_id, t.name, t.computer_id, p.user_name, p.pwd from t_res_ldap_tree t, t_res_pwd p where t.tree_id = p.resource_id and t.name = ?");
    }

    public LdapTree getByName(String string) throws GeneralException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getByName", (String)"treeName");
            }
            try {
                this.setPhase();
                this.setString(this.selectStmt, string);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (!this.resultSet.next()) break block14;
                LdapTree ldapTree = this.fetchTree();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getByName", (Object)ldapTree);
                }
                return ldapTree;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getByName", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        LdapTree ldapTree = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getByName", ldapTree);
        }
        return ldapTree;
    }

    public void prepGetTreeID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_ID);
    }

    public int getTreeID(String string) throws GeneralException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getTreeID", (String)"treeName");
            }
            try {
                this.setPhase();
                this.setString(this.selectStmt, string);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                if (!this.resultSet.next()) break block14;
                this.getPhase();
                int n = this.getInt(this.resultSet);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getTreeID", (int)n);
                }
                return n;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getTreeID", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        int n = -1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTreeID", (int)n);
        }
        return n;
    }

    public void prepGetProbeAgent() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_NOVELL_PROBE_AGENT);
    }

    public int getProbeAgent(int n) throws GeneralException {
        block14: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getProbeAgent", (String)"filerID");
            }
            try {
                this.setPhase();
                this.setInt(this.selectStmt, n);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                if (!this.resultSet.next()) break block14;
                this.getPhase();
                int n2 = this.getInt(this.resultSet);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getProbeAgent", (int)n2);
                }
                return n2;
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getProbeAgent", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        int n3 = -1;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getProbeAgent", (int)n3);
        }
        return n3;
    }

    public void prepFetchByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_NAME);
    }

    public String fetchByID(int n, boolean bl) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchByID", (String)"treeID, failFriendly");
        }
        String string = null;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.getPhase();
                string = this.getString(this.resultSet);
            } else if (bl) {
                string = "? (" + n + ")";
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        String string2 = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchByID", (Object)string2);
        }
        return string2;
    }

    public String fetchByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchByID", (String)"treeID");
        }
        String string = this.fetchByID(n, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchByID", (Object)string);
        }
        return string;
    }

    public void save(LdapTree ldapTree) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"save", (String)"treeList");
        }
        if (ldapTree == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"save");
            }
            return;
        }
        int n = 0;
        this.prepGetTreeID();
        LdapTree ldapTree2 = ldapTree;
        while (ldapTree2 != null) {
            ldapTree2.ltTreeID = this.getTreeID(ldapTree2.getTrueLtName());
            if (ldapTree2.ltTreeID == -1) {
                ++n;
            }
            ldapTree2 = ldapTree2.ltNext;
        }
        if (n > 0) {
            int n2 = 0;
            try {
                n2 = SQLUtil.getIdentifier(1, n, this.dbc);
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"save", (Throwable)sQLException);
                }
                this.sqlError(sQLException);
            }
            this.insertStmt = this.prepareStmt(INSERT);
            LdapTree ldapTree3 = ldapTree;
            while (ldapTree3 != null) {
                if (ldapTree3.ltTreeID == -1) {
                    ldapTree3.ltTreeID = n2++;
                    if (!this.insert(ldapTree3)) {
                        ldapTree3.ltTreeID = this.getTreeID(ldapTree3.getTrueLtName());
                    }
                }
                ldapTree3 = ldapTree3.ltNext;
            }
            this.closeInsert();
        }
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"save");
        }
    }

    private boolean insert(LdapTree ldapTree) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"tree");
        }
        try {
            this.setPhase();
            this.setInt(this.insertStmt, ldapTree.ltTreeID);
            this.setString(this.insertStmt, ldapTree.getTrueLtName());
            this.setInt(this.insertStmt, ldapTree.ltComputerID);
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"insert", (boolean)bl);
            }
            return bl;
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            if (!SQLUtil.isDuplicateKeyViolation(sQLException)) {
                this.stmtType = 1;
                this.sqlError(sQLException);
            }
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"insert", (boolean)bl);
            }
            return bl;
        }
    }

    public void updateComputerID(int n, int n2, int n3) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateComputerID", (String)"treeID, computerID, oldComputerID");
        }
        this.updateStmt = this.prepareStmt(UPDATE_COMPUTER_ID);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.updateStmt, n2);
            this.setInt(this.updateStmt, n);
            this.setInt(this.updateStmt, n3);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateComputerID", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.commit();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateComputerID");
        }
    }

    public void updateGuiID(int n, int n2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateGuiID", (String)"treeID, computerID");
        }
        this.updateStmt = this.prepareStmt(UPDATE_GUI_ID);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.updateStmt, n2);
            this.setInt(this.updateStmt, n);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateGuiID", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLdapTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateGuiID");
        }
    }
}

