/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;

public class TResStorExtent
extends StorageRepositoryAccessor {
    private static final String SELECT_STORAGE_EXTENT = "select distinct se.other_name, se.rank_id, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy  from T_RES_DISK_GROUP dg, \t   T_RES_STORAGE_SUBSYSTEM ss,       T_RES_STORAGE_EXTENT se,       t_res_physical_volume phv,      t_res_physicalvolume2extent phv2e  where ss.subsystem_id = dg.subsystem_id  and dg.disk_group_id = phv.disk_group_id  and phv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and se.subsystem_id = dg.subsystem_id and ";
    private static final String COLLECT_RANK_GROUP = "select sp.rank_group from T_RES_STORAGE_EXTENT se, T_RES_STORAGE_POOL sp where se.pool_id = sp.pool_id and se.storage_extent_id = ? ";
    private static final String COLLECT_ARRAY_SITES = "select distinct dg.disk_group_number  from t_res_disk_group dg,       T_RES_STORAGE_SUBSYSTEM ss,       t_res_storage_extent se,       t_res_physical_volume phv,       t_res_physicalvolume2extent phv2e  where ss.subsystem_id = dg.subsystem_id  and dg.disk_group_id = phv.disk_group_id  and phv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and se.subsystem_id = dg.subsystem_id  and se.storage_extent_id = ?  order by 1";
    private static final String GET_LUN_NUM_RANKS = "select count(*) from  t_res_storage_volume v, t_res_storage_extent se, t_res_volume2extent v2e  where v.svid = v2e.volume_id and v2e.storage_extent_id = se.storage_extent_id  and v.svid = ?";
    private static final String GET_LUN_RANK_INFO = "select distinct dg.width, se.redundancy, se.storage_extent_id from t_res_disk_group dg,  t_res_storage_extent se, t_res_storage_volume v, t_res_storage_pool sp where v.pool_id = sp.pool_id and sp.pool_id = se.pool_id  and se.storage_extent_id = dg.storage_extent_id and v.svid = ?";
    private static final String GET_STORAGE_POOL_IN_RANK = " select p.pool_id from t_res_storage_extent se, t_res_storage_pool p where  se.pool_id = p.pool_id and se.storage_extent_id = ?";
    private static final String GET_NUM_ARRAY_SITES = "select count(*) from T_RES_DISK_GROUP dg, T_RES_STORAGE_EXTENT se where dg.storage_extent_id = se.storage_extent_id and  se.storage_extent_id = ? ";
    private static final String GET_NUM_DISKS = "select count(*) from T_RES_DISK_GROUP dg, T_RES_STORAGE_EXTENT se, T_RES_PHYSICAL_VOLUME pv where dg.storage_extent_id = se.storage_extent_id and dg.disk_group_id = pv.disk_group_id and se.storage_extent_id = ? ";
    private static final String BY_DISK_GROUP_ID = " dg.disk_group_id = ?";
    private static final String BY_SUBSYSTEM_ID = " se.subsystem_id = ?";
    private static final String BY_STORAGE_EXTENT_ID = " se.storage_extent_id = ?";
    private static final String INSERT = "insert into t_res_stor_extent (other_name, name, size_extent, storext_id, status, config, type, volgroup_id, arrays, group_id, computer_id) values (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_stor_extent set other_name = ?, name = ?, size_extent = ?, status = ?, config = ?, type = ?, volgroup_id = ?,  arrays = ?, group_id = ?, computer_id = ? where storext_id = ?";
    private static final String DELETE_BY_ID = "delete from t_res_storage_extent where storage_extent_id = ?";
    private static final String DELETE_BY_COMPID = "delete from t_res_storage_extent where subsystem_id = ?";
    private static final String ORDER = " order by 2";

    public TResStorExtent(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TResStorExtent", (String)"dbc");
        }
        this.tableName = "t_res_storage_extent";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TResStorExtent");
        }
    }

    public Rank getStorExtentByComputer(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStorExtentByComputer", (String)"compID");
        }
        Rank rank = null;
        String string = "select distinct se.other_name, se.rank_id, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy  from T_RES_DISK_GROUP dg, \t   T_RES_STORAGE_SUBSYSTEM ss,       T_RES_STORAGE_EXTENT se,       t_res_physical_volume phv,      t_res_physicalvolume2extent phv2e  where ss.subsystem_id = dg.subsystem_id  and dg.disk_group_id = phv.disk_group_id  and phv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and se.subsystem_id = dg.subsystem_id and  se.subsystem_id = ?";
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            rank = this.getStorageExtents();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getStorExtentByComputer", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Rank rank2 = rank;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getStorExtentByComputer", (Object)rank2);
        }
        return rank2;
    }

    public Rank getStorExtentByID(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStorExtentByID", (String)"rankID");
        }
        Rank rank = null;
        String string = "select distinct se.other_name, se.rank_id, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy  from T_RES_DISK_GROUP dg, \t   T_RES_STORAGE_SUBSYSTEM ss,       T_RES_STORAGE_EXTENT se,       t_res_physical_volume phv,      t_res_physicalvolume2extent phv2e  where ss.subsystem_id = dg.subsystem_id  and dg.disk_group_id = phv.disk_group_id  and phv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and se.subsystem_id = dg.subsystem_id and  se.storage_extent_id = ?";
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            rank = this.getStorageExtents();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getStorExtentByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Rank rank2 = rank;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getStorExtentByID", (Object)rank2);
        }
        return rank2;
    }

    public Rank getStorExtentByController(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResCimom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStorExtentByController", (String)"ctrlrID");
        }
        Rank rank = null;
        String string = "select distinct se.other_name, se.rank_id, se.storage_extent_id, se.operational_status, se.extent_type, se.total_capacity, se.vol_group_id, se.array_ids, se.subsystem_id, se.redundancy  from T_RES_DISK_GROUP dg, \t   T_RES_STORAGE_SUBSYSTEM ss,       T_RES_STORAGE_EXTENT se,       t_res_physical_volume phv,      t_res_physicalvolume2extent phv2e  where ss.subsystem_id = dg.subsystem_id  and dg.disk_group_id = phv.disk_group_id  and phv.physical_volume_id = phv2e.physical_volume_id  and phv2e.storage_extent_id = se.storage_extent_id  and se.subsystem_id = dg.subsystem_id and  dg.disk_group_id = ? order by 2";
        this.selectStmt = this.prepareStmt(string);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, n);
            rank = this.getStorageExtents();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getStorExtentByComputer", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        Rank rank2 = rank;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getStorExtentByComputer", (Object)rank2);
        }
        return rank2;
    }

    private Rank getStorageExtents() throws SQLException, GeneralException {
        Rank rank;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStorageExtents", (String)"");
        }
        Rank rank2 = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        while ((rank = this.getStorageExtent()) != null) {
            rank.rankNext = rank2;
            rank2 = rank;
        }
        this.closeSelect();
        Rank rank3 = rank2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getStorageExtents", (Object)rank3);
        }
        return rank3;
    }

    public Rank getStorageExtent() throws GeneralException {
        Object object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStorageExtent", (String)"");
        }
        Rank rank = null;
        try {
            if (!this.nextResult()) {
                Rank rank2 = null;
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getStorageExtent", rank2);
                }
                return rank2;
            }
            this.stmtPhase = 1;
            this.colIndex = 1;
            rank = new Rank();
            rank.rankOtherName = this.getString(this.resultSet);
            rank.rankName = this.getString(this.resultSet);
            rank.rankID = this.getInt(this.resultSet);
            rank.rankStatus = this.getInt(this.resultSet);
            rank.rankType = this.getInt(this.resultSet);
            rank.rankSize = this.getLong(this.resultSet);
            rank.rankVolGroupID = this.getInt(this.resultSet);
            rank.rankArrays = this.getArrayIDs(this.getString(this.resultSet));
            rank.rankComputerID = this.getInt(this.resultSet);
            rank.rankConfig = this.getConfig(Integer.toString(this.getInt(this.resultSet)));
            object = new TResComputer(this.dbc);
            short s = ((TResComputer)object).getStorageSubsystemType(rank.rankComputerID);
            if (s == 27 || s == 25) {
                rank.rankGroup = this.getRankGroup(rank.rankID);
                rank.rankArraySiteNames = this.getArraySites(rank.rankID);
                rank.rankVolGroupID = this.getStoragePoolInRank(rank.rankID);
            } else {
                rank.rankGroup = (short)-1;
                rank.rankArraySiteNames = null;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getStorageExtent", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        object = rank;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getStorageExtent", (Object)object);
        }
        return object;
    }

    public void saveStorExtents(Rank rank, int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"saveStorExtents", (String)"vgList, identifierCount");
        }
        if (rank == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"saveStorExtents");
            }
            return;
        }
        Rank rank2 = null;
        int n2 = 0;
        try {
            this.updateStmt = this.prepareStmt(UPDATE);
            if (n > 0) {
                n2 = TResStorExtent.getIdentifier(1, n, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT);
            }
            rank2 = rank;
            while (rank2 != null) {
                if (rank2.rankID == -1) {
                    rank2.rankID = n2++;
                    this.insertStorExtent(rank2);
                } else {
                    this.updateStorExtent(rank2);
                }
                this.dbc.commit();
                rank2 = rank2.rankNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"saveStorExtents", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveStorExtents");
        }
    }

    private void insertStorExtent(Rank rank) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResVolGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insertStorExtent", (String)"rank");
        }
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setString(this.insertStmt, rank.rankOtherName);
        this.setString(this.insertStmt, rank.rankName);
        this.setLong(this.insertStmt, rank.rankSize);
        this.setInt(this.insertStmt, rank.rankID);
        this.setInt(this.insertStmt, rank.rankStatus);
        this.setShort(this.insertStmt, rank.rankConfig);
        this.setInt(this.insertStmt, rank.rankType);
        this.setInt(this.insertStmt, rank.rankVolGroupID);
        this.setString(this.insertStmt, rank.rankArrays);
        this.setShort(this.insertStmt, rank.rankGroup);
        this.setInt(this.insertStmt, rank.rankComputerID);
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insertStorExtent");
        }
    }

    public void deleteStorExtents(Rank rank) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteStorExtents", (String)"rankList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_ID);
            Rank rank2 = rank;
            while (rank2 != null) {
                this.deleteStorExtent(rank2);
                rank2 = rank2.rankNext;
            }
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteStorExtents", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteStorExtents");
        }
    }

    public void deleteStorExtents(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteStorExtents", (String)"cmpID");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_COMPID);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, n);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deleteStorExtents", (Throwable)sQLException);
            }
            this.stmtType = 3;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteStorExtents");
        }
    }

    private void deleteStorExtent(Rank rank) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteStorExtent", (String)"rank");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.deleteStmt, rank.rankID);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteStorExtent");
        }
    }

    public void updateStorExtent(Rank rank) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"updateStorExtent", (String)"rank");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.updateStmt, rank.rankOtherName);
            this.setString(this.updateStmt, rank.rankName);
            this.setLong(this.updateStmt, rank.rankSize);
            this.setInt(this.updateStmt, rank.rankStatus);
            this.setShort(this.updateStmt, rank.rankConfig);
            this.setInt(this.updateStmt, rank.rankType);
            this.setInt(this.updateStmt, rank.rankVolGroupID);
            this.setString(this.updateStmt, rank.rankArrays);
            this.setShort(this.updateStmt, rank.rankGroup);
            this.setInt(this.updateStmt, rank.rankComputerID);
            this.setInt(this.updateStmt, rank.rankID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"updateStorExtent", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"updateStorExtent");
        }
    }

    private short getConfig(String string) {
        int n = 11;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConfig", (String)"redundancy");
        }
        if (string != null) {
            int n2 = 0;
            while (n2 < Rank.REDUNDANCY.length) {
                if (string.compareToIgnoreCase(Rank.REDUNDANCY[n2]) == 0) {
                    n = n2;
                    break;
                }
                n2 = (short)(n2 + 1);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getAccessParms", (short)n);
        }
        return (short)n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getStoragePoolInRank(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getStoragePoolInRank", (String)"rank_id");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n2 = -1;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(GET_STORAGE_POOL_IN_RANK);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = resultSet.getInt(1);
                }
            }
            catch (SQLException sQLException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"deleteStorExtents", (Throwable)sQLException);
                }
                this.stmtType = 0;
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Class<?> clazz;
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            if (!TraceLogger.enableTrace) throw throwable;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResStorExtent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getStoragePoolInRank", (int)n2);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (!TraceLogger.enableTrace) return n2;
        try {}
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.exit((String)Class.forName("org.eclipse.aperi.repository.table.TResStorExtent").getName(), (String)"getStoragePoolInRank", (int)n2);
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getArraySites(int n) throws GeneralException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string = new String();
        try {
            block12: {
                try {
                    preparedStatement = this.dbc.prepareStatement(COLLECT_ARRAY_SITES);
                    preparedStatement.setInt(1, n);
                    resultSet = preparedStatement.executeQuery();
                    this.dbc.commit();
                    while (true) {
                        if (!resultSet.next()) {
                            if (!bl) break;
                            string = string.substring(0, string.length() - 2);
                            break block12;
                        }
                        this.getPhase();
                        String string2 = Short.toString(this.getShort(resultSet));
                        string = string.concat(string2);
                        string = string.concat(", ");
                        bl = true;
                    }
                    string = " ";
                }
                catch (SQLException sQLException) {
                    this.sqlError(sQLException);
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {
            return string;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return string;
        resultSet.close();
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private short getRankGroup(int n) throws GeneralException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        short s = -1;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(COLLECT_RANK_GROUP);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                this.dbc.commit();
                if (resultSet.next()) {
                    this.getPhase();
                    s = this.getShort(resultSet);
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return s;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return s;
        resultSet.close();
        return s;
    }

    private String getArrayIDs(String string) {
        String string2 = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " []");
            string2 = stringTokenizer.nextToken();
            string2 = string2.concat(", ");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2.concat(stringTokenizer.nextToken());
                string2 = string2.concat(", ");
            }
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public short getNumOfDisks(int n) throws GeneralException {
        return this.getNum(GET_NUM_DISKS, n);
    }

    public short getNumOfArraySites(int n) throws GeneralException {
        return this.getNum(GET_NUM_ARRAY_SITES, n);
    }

    public short getNumOfLUNRanks(int n) throws GeneralException {
        return this.getNum(GET_LUN_NUM_RANKS, n);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private short getNum(String string, int n) throws GeneralException {
        short s = -1;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                preparedStatement = this.dbc.prepareStatement(string);
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    s = resultSet.getShort(1);
                }
            }
            catch (SQLException sQLException) {
                this.sqlError(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet == null) throw throwable;
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (SQLException sQLException) {
            return s;
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet == null) return s;
        resultSet.close();
        return s;
    }

    public ResultSet getLUNRankInfo(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPoolRanks", (String)"pool_id");
        }
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.dbc.prepareStatement(GET_LUN_RANK_INFO);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getPoolRanks", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TResLogicalDisk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPoolRanks", (Object)resultSet);
        }
        return resultSet;
    }

    public void closeInsert() throws GeneralException {
        super.closeInsert();
    }

    public void closeDelete() throws GeneralException {
        super.closeDelete();
    }

    public void closeSelect() throws GeneralException {
        super.closeSelect();
    }
}

