/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.scheduler.JobHndlr;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class VMTransceiver
extends Transceiver {
    private boolean isClosed;
    private boolean resultAvailable;
    private boolean dataAvailable;
    private boolean jobDataAvailable;
    private Object data;
    private Response result;

    public void returnTransceiver() {
    }

    public synchronized Response transmitRequest(Request request, Object object) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"transmitRequest", (String)"request, requestData");
        }
        if (!Server.serviceMgr.routeRequest(request, this)) {
            Response response = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"transmitRequest", response);
            }
            return response;
        }
        if ((request.typeCode.equals("org.eclipse.aperi.server.svp.AgentSvp") && request.subType.equals("org.eclipse.aperi.server.handler.scheduler.JobHndlr.Agent") || request.typeCode.equals("org.eclipse.aperi.server.svp.CimomSvp") && request.subType.equals("org.eclipse.aperi.server.handler.scheduler.JobHndlr.CIMOM")) && !this.sendJobReceivedResponse(request)) {
            Response response = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"transmitRequest", response);
            }
            return response;
        }
        int n = object == null ? 0 : 1;
        Response response = this.getResponse(request, n);
        if (object == null || response == null || response.status > 4) {
            Response response2 = response;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"transmitRequest", (Object)response2);
            }
            return response2;
        }
        try {
            this.data = object;
            this.dataAvailable = true;
            this.checkClosed();
            ((Object)((Object)this)).notify();
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"transmitRequest", (Throwable)localizableException);
            }
            MessageLog.logMessage((String)"SRV0069E", (Object)RequestTypeManager.getInternalName((String)request.typeCode));
            localizableException.print();
            this.logTransmitExplanation(request, 2);
            Response response3 = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"transmitRequest", response3);
            }
            return response3;
        }
        Response response4 = this.getResponse(request, 2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"transmitRequest", (Object)response4);
        }
        return response4;
    }

    public synchronized boolean transmitResponse(Request request, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"transmitResponse", (String)"request, response");
        }
        if (response.status != 0) {
            this.logResponse(request, response);
        }
        try {
            this.checkResponseToSend(request, response);
            this.result = response;
            this.resultAvailable = true;
            this.checkClosed();
            ((Object)((Object)this)).notify();
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"transmitResponse", (Throwable)localizableException);
            }
            MessageLog.logMessage((String)"SRV0071E");
            localizableException.print();
            boolean bl = false;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"transmitResponse", (boolean)bl);
            }
            return bl;
        }
        boolean bl = true;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"transmitResponse", (boolean)bl);
        }
        return bl;
    }

    public synchronized Request receiveRequest() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"receiveRequest", (String)"");
        }
        MessageLog.logMessage((String)"SRV0072E");
        Request request = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"receiveRequest", request);
        }
        return request;
    }

    public synchronized Object receiveData(Request request) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"receiveData", (String)"request");
        }
        try {
            this.checkTwoPhase(request);
            while (!this.dataAvailable) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"receiveData", (Throwable)interruptedException);
                }
            }
            this.checkClosed();
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"receiveData", (Throwable)localizableException);
            }
            MessageLog.logMessage((String)"SRV0073E");
            localizableException.print();
            this.data = null;
        }
        Object object = this.data;
        this.data = null;
        this.dataAvailable = false;
        if (object == null) {
            MessageLog.logMessage((String)"GEN7070I", (Object)request.toString());
        }
        Object object2 = object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"receiveData", (Object)object2);
        }
        return object2;
    }

    public synchronized boolean close() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        if (!this.isClosed) {
            this.isClosed = true;
            this.resultAvailable = true;
            this.dataAvailable = true;
            this.jobDataAvailable = true;
            ((Object)((Object)this)).notify();
            boolean bl = true;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"close", (boolean)bl);
            }
            return bl;
        }
        boolean bl = false;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close", (boolean)bl);
        }
        return bl;
    }

    private Response getResponse(Request request, int n) {
        block22: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getResponse", (String)"request, phase");
            }
            while (!this.resultAvailable) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) continue;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getResponse", (Throwable)interruptedException);
                }
            }
            this.resultAvailable = false;
            try {
                if (this.result == null) {
                    MessageLog.logMessage((String)"SRV0075E", (Object)RequestTypeManager.getInternalName((String)request.typeCode));
                    this.logTransmitExplanation(request, n);
                    this.checkClosed();
                    Response response = null;
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exit((String)clazz.getName(), (String)"getResponse", response);
                    }
                    return response;
                }
                if (this.result.status != 0) {
                    MessageLog.logMessage((String)"SRV0074I", (Object)RequestTypeManager.getInternalName((String)request.typeCode));
                    this.logReceivedResponse(this.result);
                    this.logTransmitExplanation(request, n);
                }
                if (this.result.status <= 4) {
                    this.checkReceivedResponse(request, n, this.result);
                }
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getResponse", (Throwable)localizableException);
                }
                localizableException.print();
                if (this.result == null) break block22;
                this.result.status = (short)12;
            }
        }
        Response response = this.result;
        this.result = null;
        Response response2 = response;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getResponse", (Object)response2);
        }
        return response2;
    }

    public synchronized VMJobResults getJobData(Request request) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"getJobData", (String)"request");
        }
        while (!this.jobDataAvailable) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {
                Class<?> clazz3;
                if (!TraceLogger.enableTrace) continue;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz3.getName(), (String)"getJobData", (Throwable)interruptedException);
            }
        }
        VMJobResults vMJobResults = null;
        Response response = new Response(0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.server.VMJobResults");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            vMJobResults = (VMJobResults)request.requestData;
        } else {
            MessageLog.getThreadLog().println(response.getErrorMessage());
            try {
                this.checkClosed();
            }
            catch (LocalizableException localizableException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz4.getName(), (String)"getJobData", (Throwable)localizableException);
                }
                localizableException.print();
            }
        }
        VMJobResults vMJobResults2 = vMJobResults;
        if (TraceLogger.enableTrace) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz5.getName(), (String)"getJobData", (Object)vMJobResults2);
        }
        return vMJobResults2;
    }

    private void checkClosed() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkClosed", (String)"");
        }
        if (this.isClosed) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkClosed");
            }
            throw new LocalizableException("SRV0070E", null);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkClosed");
        }
    }

    private void logTransmitExplanation(Request request, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"logTransmitExplanation", (String)"request, phase");
        }
        if (n == 0) {
            MessageLog.logMessage((String)"GEN7071I", (Object)request.toString());
        } else {
            MessageLog.logMessage((String)"GEN7072I", (Object)request.toString(), (Object)new Integer(n));
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"logTransmitExplanation");
        }
    }

    private boolean sendJobReceivedResponse(Request request) {
        Class<?> clazz;
        if (TraceLogger.enableTrace) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz2.getName(), (String)"sendJobReceivedResponse", (String)"request");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            clazz = Class.forName("org.eclipse.aperi.jobs.JobRun");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!RequestChecker.isDesiredType(clazz, (Request)request, (Response)response)) {
            boolean bl = this.transmitResponse(request, response);
            if (TraceLogger.enableTrace) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz3.getName(), (String)"sendJobReceivedResponse", (boolean)bl);
            }
            return bl;
        }
        JobRun jobRun = (JobRun)request.requestData;
        VMJobResults vMJobResults = new VMJobResults(jobRun);
        this.jobDataAvailable = this.transmitResponse(request, response);
        if (this.jobDataAvailable) {
            if (JobHndlr.jobNeedsLogFile(jobRun)) {
                response.responseData = vMJobResults.createJobLog();
                vMJobResults.logMessage("STS0306I", null);
                vMJobResults.closeJobLog();
            }
            request.requestData = vMJobResults;
            JobHndlr.addToJobTable(jobRun);
        }
        boolean bl = this.jobDataAvailable;
        if (TraceLogger.enableTrace) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("org.eclipse.aperi.server.VMTransceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz4.getName(), (String)"sendJobReceivedResponse", (boolean)bl);
        }
        return bl;
    }
}

