/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alerts;

import java.io.Serializable;
import java.sql.Connection;
import java.text.DecimalFormat;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class BaseAlerter {
    protected Connection dbc;
    protected AlertDefinition alertDef;
    protected TAlertDefinition alertAccessor;
    protected String[] alertParms;
    protected String hostName;
    protected int computerID;
    private TAlertLog logAccessor;
    private static DecimalFormat formatter = new DecimalFormat();
    protected static final int COMPUTER = 0;
    public static final int[] COMPUTER_OID = new int[]{2, 1, 1};
    public static final int[] RESOURCE_NAME_OID = new int[]{2, 1, 2};
    public static final int[] RESOURCE_TYPE_OID = new int[]{2, 1, 3};
    public static final int[] THRESHOLD_OID = new int[]{2, 1, 4};
    public static final int[] NEW_VALUE_OID = new int[]{2, 1, 5};
    public static final int[] OLD_VALUE_OID = new int[]{2, 1, 6};
    public static final int[] VIOLATOR_NAME_OID = new int[]{2, 1, 8};
    public static final int[] VIOLATOR_TYPE_OID = new int[]{2, 1, 9};
    public static final int[] FILER_NAME_OID = new int[]{2, 1, 10};
    public static final int[] CURRENT_CAPACITY_OID = new int[]{2, 1, 11};
    public static final int[] TARGET_CAPACITY_OID = new int[]{2, 1, 12};
    public static final int[] FREESPACE_OID = new int[]{2, 1, 13};
    public static final int[] VIRTUAL_SERVER_NAME_OID = new int[]{2, 1, 14};
    public static final int[] CLUSTER_NAME_OID = new int[]{2, 1, 15};
    public static final int[] CURRENT_NODE_NAME_OID = new int[]{2, 1, 16};
    public static final int[] OLD_NODE_NAME_OID = new int[]{2, 1, 17};
    public static final int[] STORAGE_SUBSYSTEM_OID = new int[]{2, 1, 18};
    public static final int[] DEVICE_NAME_OID = new int[]{2, 1, 19};
    public static final int[] THRESHOLD_BOUNDARY_OID = new int[]{2, 1, 20};
    public static final int[] THRESHOLD_TIME_OID = new int[]{2, 1, 21};
    public static final int[] THRESHOLD_NAME_OID = new int[]{2, 1, 22};
    public static final int[] THRESH_DESCRIPTION_OID = new int[]{2, 1, 23};
    public static final int[] START_TIME_OID = new int[]{2, 1, 24};
    public static final int[] STOP_TIME_OID = new int[]{2, 1, 25};
    public static final int[] ERROR_OID = new int[]{2, 1, 26};
    public static final int[] RECORDS_CNT_OID = new int[]{2, 1, 27};
    public static final String COMPUTER_SLOT = "hostname";
    public static final String RESOURCE_NAME_SLOT = "resourceName";
    public static final String RESOURCE_TYPE_SLOT = "resourceType";
    public static final String THRESHOLD_SLOT = "threshold";
    public static final String NEW_VALUE_SLOT = "currentValue";
    public static final String OLD_VALUE_SLOT = "previousValue";
    public static final String VIOLATOR_NAME_SLOT = "violatorName";
    public static final String VIOLATOR_TYPE_SLOT = "violatorType";
    public static final String FILER_NAME_SLOT = "filerName";
    public static final String RDBMS_TYPE_SLOT = "rdbmsType";
    public static final String RDBMS_NAME_SLOT = "rdbmsName";
    public static final String DATABASE_NAME_SLOT = "databaseName";
    public static final String CURRENT_CAPACITY_SLOT = "currentCapacity";
    public static final String TARGET_CAPACITY_SLOT = "targetCapacity";
    public static final String FREESPACE_SLOT = "freespace";
    public static final String VIRTUAL_SERVER_NAME_SLOT = "vsName";
    public static final String CLUSTER_NAME_SLOT = "clusterName";
    public static final String CURRENT_NODE_NAME_SLOT = "currentNodeName";
    public static final String OLD_NODE_NAME_SLOT = "previousNodeName";
    public static final String STORAGE_SUBSYSTEM_NAME_SLOT = "storageSubsystemName";
    public static final String DEVICE_NAME_SLOT = "deviceName";
    public static final String THRESHOLD_BOUNDARY_SLOT = "thresholdBoundary";
    public static final String THRESHOLD_NAME_SLOT = "thresholdName";
    public static final String THRESHOLD_TIME_SLOT = "thresholdTime";
    public static final String THRESH_DESCRIPTION_SLOT = "threshDescription";
    public static final String START_TIME_SLOT = "startTime";
    public static final String STOP_TIME_SLOT = "stopTime";
    public static final String ERROR_SLOT = "error";
    public static final String RECORDS_CNT_SLOT = "recordCnt";
    protected int[][] snmpOIDs;
    protected String[] tecSlotNames;

    protected BaseAlerter(Connection connection, int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"BaseAlerter", (String)"dbc, computerID");
        }
        this.dbc = connection;
        this.setComputer(n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"BaseAlerter");
        }
    }

    protected void initAlertAccessor() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initAlertAccessor", (String)"");
        }
        this.alertAccessor = new TAlertDefinition(this.dbc);
        this.alertAccessor.prepSelectByID(false, true);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initAlertAccessor");
        }
    }

    protected void setComputer(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setComputer", (String)"computerID");
        }
        this.computerID = n;
        this.hostName = null;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setComputer");
        }
    }

    protected void setHostName() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setHostName", (String)"");
        }
        if (this.hostName == null) {
            AgentManager agentManager = Server.getAgentManager();
            this.hostName = agentManager.getAgentName(this.computerID);
        }
        this.alertParms[0] = this.hostName;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setHostName");
        }
    }

    protected void setHostName(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setHostName", (String)"computerID");
        }
        this.setComputer(n);
        this.setHostName();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setHostName");
        }
    }

    protected void setNumParm(int n, long l, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setNumParm", (String)"parmKey, value, suffix");
        }
        String string2 = Long.toString(l);
        if (string != null) {
            string2 = String.valueOf(string2) + string;
        }
        this.alertParms[n] = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setNumParm");
        }
    }

    protected void setNumParm(int n, double d, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setNumParm", (String)"parmKey, value, suffix");
        }
        formatter.setMaximumFractionDigits(2);
        String string2 = formatter.format(d);
        if (string != null) {
            string2 = String.valueOf(string2) + string;
        }
        this.alertParms[n] = string2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setNumParm");
        }
    }

    protected void setByteSizeParm(int n, long l) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setByteSizeParm", (String)"parmKey, value");
        }
        if (l < 2L) {
            this.setNumParm(n, l * 512L, " bytes");
        } else if (l < 2048L) {
            this.setNumParm(n, (double)l / 2.0, "KB");
        } else if (l < 0x200000L) {
            this.setNumParm(n, (double)l / 2048.0, "MB");
        } else {
            this.setNumParm(n, (double)l / 2097152.0, "GB");
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setByteSizeParm");
        }
    }

    protected void setParmFromMsg(int n, String string) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"setParmFromMsg", (String)"parmKey, msgID");
        }
        this.alertParms[n] = MessageLog.getMessageNoID((String)string, null);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"setParmFromMsg");
        }
    }

    protected void clearAlert(int n, short s) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"clearAlert", (String)"resourceID, resourceType");
        }
        this.clearAlert(n, s, -1, (short)-1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"clearAlert");
        }
    }

    protected void clearAlert(int n, short s, int n2, short s2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"clearAlert", (String)"resourceID, resourceType, violatorID, violatorType");
        }
        try {
            if (this.logAccessor == null) {
                this.logAccessor = new TAlertLog(this.dbc);
                this.logAccessor.prepDeactivate();
            }
            this.logAccessor.deactivate(this.alertDef.aldAlertID, this.computerID, n, s, this.alertDef.aldCondition, n2, s2);
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"clearAlert", (Throwable)generalException);
            }
            this.close();
            MessageLog.logException((String)"STS0078E", (Exception)((Object)generalException), (Object)this.alertDef.aldCreator, (Object)this.alertDef.getAldName());
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"clearAlert");
        }
    }

    protected void genAlert(int n, short s, int n2, int n3, int n4) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, oldValue");
        }
        Alert alert = new Alert(this.computerID, n, s, this.alertDef, this.alertParms, n2, this.snmpOIDs, this.tecSlotNames, n3, n4);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int n, short s, int n2, int n3, int n4, int n5, Serializable serializable) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, oldValue, targetValue, jobData");
        }
        Alert alert = new Alert(this.computerID, n, s, this.alertDef, this.alertParms, n2, this.snmpOIDs, this.tecSlotNames, n3, n4, n5, -1);
        alert.jobData = serializable;
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int n, short s, int n2, int n3, int n4, byte by, int n5) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, oldValue, dbmsType, parentID");
        }
        Alert alert = new Alert(this.computerID, n, s, this.alertDef, this.alertParms, n2, this.snmpOIDs, this.tecSlotNames, n3, n4, by, n5);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int n, short s, int n2, int n3, int n4, short s2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, violatorID, violatorType");
        }
        Alert alert = new Alert(this.computerID, n, s, this.alertDef, this.alertParms, n2, this.snmpOIDs, this.tecSlotNames, n3, -1, n4, s2);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genAlert");
        }
    }

    protected void genAlert(int n, short s, int n2, int n3, int n4, short s2, byte by, int n5) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"genAlert", (String)"resourceID, resourceType, trapType, violatingValue, violatorID, violatorType, dbmsType, parentID");
        }
        Alert alert = new Alert(this.computerID, n, s, this.alertDef, this.alertParms, n2, this.snmpOIDs, this.tecSlotNames, n3, -1, n4, s2, by, n5);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"genAlert");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void close() {
        Object var2_6;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"close", (String)"");
        }
        if (this.logAccessor != null) {
            try {
                block22: {
                    try {
                        this.logAccessor.closeUpdate();
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block22;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
                    }
                }
                var2_6 = null;
                this.logAccessor = null;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.logAccessor = null;
                throw throwable;
            }
        }
        if (this.alertAccessor != null) {
            try {
                block23: {
                    try {
                        this.alertAccessor.closeSelect();
                    }
                    catch (GeneralException generalException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block23;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"close", (Throwable)generalException);
                    }
                }
                var2_6 = null;
                this.alertAccessor = null;
            }
            catch (Throwable throwable) {
                var2_6 = null;
                this.alertAccessor = null;
                throw throwable;
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.BaseAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"close");
        }
    }
}

