/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.alerts;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.ScheduleQueryable;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.alerts.BaseAlerter;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class StormAlerter
extends BaseAlerter {
    private TResFS fsAccessor;
    private TResComputer cmpAccessor;
    public static final int RESOURCE_NAME = 1;
    public static final int THRESHOLD = 2;
    public static final int NEW_VALUE = 3;
    public static final int OLD_VALUE = 4;
    public static final int PERCENTAGE = 5;
    public static final int VIOLATOR_NAME = 6;
    public static final int VIOLATOR_TYPE = 7;
    public static final int FILE_COUNT = 8;
    public static final int RESOURCE_GROUP = 9;
    public static final int ALERT_TYPE = 10;
    public static final int RESOURCE_TYPE = 11;
    public static final int USER = 12;
    public static final int USER_COUNT = 13;
    public static final int USER_SIZE = 14;
    public static final int LIST_OF_FILES = 15;
    public static final int VIRTUAL_SERVER_NAME = 16;
    public static final int CLUSTER_NAME = 17;
    public static final int CURRENT_NODE_NAME = 18;
    public static final int OLD_NODE_NAME = 19;
    public static final int STORAGE_SUBSYSTEM_NAME = 20;
    public static final int DEVICE_NAME = 21;
    public static final int THRESHOLD_BOUNDARY = 22;
    public static final int THRESHOLD_TIME = 23;
    public static final int THRESHOLD_NAME = 24;
    public static final int THRESH_DESCRIPTION = 25;
    public static final int START_TIME = 26;
    public static final int STOP_TIME = 27;
    public static final int ERROR = 28;
    public static final int RECORDS_CNT = 29;
    public static final int KEY_COUNT = 30;
    public static final int RAM_TRAP = 1;
    public static final int MEMORY_TRAP = 2;
    public static final int NEW_DISK_TRAP = 3;
    public static final int MISSING_DISK_TRAP = 4;
    public static final int DISK_DEFECT_TRAP = 5;
    public static final int DISK_FAILURE_TRAP = 6;
    public static final int NEW_FS_TRAP = 7;
    public static final int MISSING_FS_TRAP = 8;
    public static final int FS_RECONFIGURED_TRAP = 9;
    public static final int FS_FREESPACE_TRAP = 10;
    public static final int FS_FREE_INODE_TRAP = 11;
    public static final int NEW_DIR_TRAP = 12;
    public static final int MISSING_DIR_TRAP = 13;
    public static final int QUOTA_VIOLATION_TRAP = 14;
    public static final int CONSTRAINT_VIOLATION_TRAP = 15;
    public static final int PING_FAILURE_TRAP = 16;
    public static final int COMPUTER_DISCOVERED_TRAP = 17;
    public static final int NEW_NAS_COMPUTER_TRAP = 18;
    public static final int MISSING_FILER_TRAP = 21;
    public static final int MISSING_DISK_ARRAY_TRAP = 22;
    public static final int NEW_DISK_ARRAY_TRAP = 23;
    public static final int AUTO_FS_EXTEND_TRAP = 24;
    public static final int STOPPED_AUTO_FS_EXTEND_TRAP = 25;
    public static final int ADDED_VIRTUAL_SERVER_TRAP = 26;
    public static final int REMOVED_VIRTUAL_SERVER_TRAP = 27;
    public static final int MOVED_VIRTUAL_SERVER_TRAP = 28;
    public static final int PERF_THRESHOLD_TRAP = 29;
    public static final int PERF_MONITOR_FAIL_TRAP = 30;
    public static final int TRAP_COUNT = 31;
    public static final String RAM_EVENT_CLASS = "Ram_Changed";
    public static final String MEMORY_EVENT_CLASS = "VirtualMemory_Changed";
    public static final String NEW_DISK_EVENT_CLASS = "Disk_New";
    public static final String MISSING_DISK_EVENT_CLASS = "Disk_Missing";
    public static final String DISK_DEFECT_EVENT_CLASS = "Disk_Defect";
    public static final String DISK_FAILURE_EVENT_CLASS = "Disk_Failure";
    public static final String NEW_FS_EVENT_CLASS = "Filesystem_New";
    public static final String MISSING_FS_EVENT_CLASS = "Filesystem_Missing";
    public static final String FS_RECONFIGURED_EVENT_CLASS = "Filesystem_Reconfigured";
    public static final String FS_FREESPACE_EVENT_CLASS = "Filesystem_Freespace_Low";
    public static final String FS_FREE_INODE_EVENT_CLASS = "Filesystem_Inode_Low";
    public static final String MISSING_DIR_EVENT_CLASS = "Directory_Missing";
    public static final String CONSTRAINT_VIOLATION_EVENT_CLASS = "Filesystem_Constraint_Violated";
    public static final String PING_FAILURE_EVENT_CLASS = "Computer_Offline";
    public static final String COMPUTER_DISCOVERED_EVENT_CLASS = "Computer_Discovered";
    public static final String NEW_NAS_COMPUTER_EVENT_CLASS = "NasComputer_Discovered";
    public static final String MISSING_FILER_EVENT_CLASS = "Filer_Missing";
    public static final String MISSING_DISK_ARRAY_EVENT_CLASS = "DiskArray_Missing";
    public static final String NEW_DISK_ARRAY_EVENT_CLASS = "DiskArray_New";
    public static final String AUTO_FS_EXTEND_EVENT_CLASS = "Filesystem_Auto_Extend";
    public static final String STOPPED_AUTO_FS_EXTEND_EVENT_CLASS = "Filesystem_Stopped_Auto_Extend";
    public static final String ADDED_VIRTUAL_SERVER_EVENT_CLASS = "VirtualServer_Added";
    public static final String REMOVED_VIRTUAL_SERVER_EVENT_CLASS = "VirtualServer_Removed";
    public static final String MOVED_VIRTUAL_SERVER_EVENT_CLASS = "VirtualServer_Moved";
    public static final String PERF_THRESHOLD_EVENT_CLASS = "Perf_Threshold";
    public static final String PERF_MONITOR_FAIL_EVENT_CLASS = "PerfMonitor_Fail";
    public static String[] tecClassNames = StormAlerter.getTecClassNames();
    public static String[] tecEventMsgs = StormAlerter.getTecEventMsgs();
    public static String[] tecEventMsgIDs = StormAlerter.getTecEventMsgIDs();

    protected StormAlerter(Connection connection, int n) {
        super(connection, n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"StormAlerter", (String)"dbc, computerID");
        }
        this.snmpOIDs = StormAlerter.getSnmpOIDTable();
        this.tecSlotNames = StormAlerter.getTecSlotNames();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"StormAlerter");
        }
    }

    public static int[][] getSnmpOIDTable() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getSnmpOIDTable", (String)"");
        }
        int[][] nArray = new int[30][];
        nArray[0] = COMPUTER_OID;
        nArray[11] = RESOURCE_TYPE_OID;
        nArray[1] = RESOURCE_NAME_OID;
        nArray[10] = Alerter.ALERT_TYPE_OID;
        nArray[2] = THRESHOLD_OID;
        nArray[3] = NEW_VALUE_OID;
        nArray[4] = OLD_VALUE_OID;
        nArray[7] = VIOLATOR_TYPE_OID;
        nArray[6] = VIOLATOR_NAME_OID;
        nArray[16] = VIRTUAL_SERVER_NAME_OID;
        nArray[17] = CLUSTER_NAME_OID;
        nArray[18] = CURRENT_NODE_NAME_OID;
        nArray[19] = OLD_NODE_NAME_OID;
        nArray[20] = STORAGE_SUBSYSTEM_OID;
        nArray[21] = DEVICE_NAME_OID;
        nArray[22] = THRESHOLD_BOUNDARY_OID;
        nArray[24] = THRESHOLD_NAME_OID;
        nArray[23] = THRESHOLD_TIME_OID;
        nArray[25] = THRESH_DESCRIPTION_OID;
        nArray[26] = START_TIME_OID;
        nArray[27] = STOP_TIME_OID;
        nArray[28] = ERROR_OID;
        nArray[29] = RECORDS_CNT_OID;
        int[][] nArray2 = nArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getSnmpOIDTable", (Object)nArray2);
        }
        return nArray2;
    }

    public static String[] getTecSlotNames() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTecSlotNames", (String)"");
        }
        String[] stringArray = new String[30];
        stringArray[0] = "hostname";
        stringArray[11] = "resourceType";
        stringArray[1] = "resourceName";
        stringArray[10] = "alertType";
        stringArray[2] = "threshold";
        stringArray[3] = "currentValue";
        stringArray[4] = "previousValue";
        stringArray[7] = "violatorType";
        stringArray[6] = "violatorName";
        stringArray[16] = "vsName";
        stringArray[17] = "clusterName";
        stringArray[18] = "currentNodeName";
        stringArray[19] = "previousNodeName";
        stringArray[20] = "storageSubsystemName";
        stringArray[21] = "deviceName";
        stringArray[22] = "thresholdBoundary";
        stringArray[23] = "thresholdTime";
        stringArray[24] = "thresholdName";
        stringArray[26] = "startTime";
        stringArray[27] = "stopTime";
        stringArray[28] = "error";
        stringArray[29] = "recordCnt";
        String[] stringArray2 = stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTecSlotNames", (Object)stringArray2);
        }
        return stringArray2;
    }

    protected static String[] getTecClassNames() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTecClassNames", (String)"");
        }
        String[] stringArray = new String[31];
        stringArray[1] = RAM_EVENT_CLASS;
        stringArray[2] = MEMORY_EVENT_CLASS;
        stringArray[3] = NEW_DISK_EVENT_CLASS;
        stringArray[4] = MISSING_DISK_EVENT_CLASS;
        stringArray[5] = DISK_DEFECT_EVENT_CLASS;
        stringArray[6] = DISK_FAILURE_EVENT_CLASS;
        stringArray[7] = NEW_FS_EVENT_CLASS;
        stringArray[8] = MISSING_FS_EVENT_CLASS;
        stringArray[9] = FS_RECONFIGURED_EVENT_CLASS;
        stringArray[10] = FS_FREESPACE_EVENT_CLASS;
        stringArray[11] = FS_FREE_INODE_EVENT_CLASS;
        stringArray[13] = MISSING_DIR_EVENT_CLASS;
        stringArray[15] = CONSTRAINT_VIOLATION_EVENT_CLASS;
        stringArray[16] = PING_FAILURE_EVENT_CLASS;
        stringArray[17] = COMPUTER_DISCOVERED_EVENT_CLASS;
        stringArray[18] = NEW_NAS_COMPUTER_EVENT_CLASS;
        stringArray[21] = MISSING_FILER_EVENT_CLASS;
        stringArray[22] = MISSING_DISK_ARRAY_EVENT_CLASS;
        stringArray[23] = NEW_DISK_ARRAY_EVENT_CLASS;
        stringArray[24] = AUTO_FS_EXTEND_EVENT_CLASS;
        stringArray[25] = STOPPED_AUTO_FS_EXTEND_EVENT_CLASS;
        stringArray[26] = ADDED_VIRTUAL_SERVER_EVENT_CLASS;
        stringArray[27] = REMOVED_VIRTUAL_SERVER_EVENT_CLASS;
        stringArray[28] = MOVED_VIRTUAL_SERVER_EVENT_CLASS;
        stringArray[29] = PERF_THRESHOLD_EVENT_CLASS;
        stringArray[30] = PERF_MONITOR_FAIL_EVENT_CLASS;
        String[] stringArray2 = stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTecClassNames", (Object)stringArray2);
        }
        return stringArray2;
    }

    protected static String[] getTecEventMsgs() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTecEventMsgs", (String)"");
        }
        String[] stringArray = new String[31];
        stringArray[1] = MessageLog.getMessageNoID((String)"ALR1300W", null);
        stringArray[2] = MessageLog.getMessageNoID((String)"ALR1301W", null);
        stringArray[3] = MessageLog.getMessageNoID((String)"ALR1302W", null);
        stringArray[4] = MessageLog.getMessageNoID((String)"ALR1303W", null);
        stringArray[5] = MessageLog.getMessageNoID((String)"ALR1304W", null);
        stringArray[6] = MessageLog.getMessageNoID((String)"ALR1305W", null);
        stringArray[7] = MessageLog.getMessageNoID((String)"ALR1306W", null);
        stringArray[8] = MessageLog.getMessageNoID((String)"ALR1307W", null);
        stringArray[9] = MessageLog.getMessageNoID((String)"ALR1308W", null);
        stringArray[10] = MessageLog.getMessageNoID((String)"ALR1309W", null);
        stringArray[11] = MessageLog.getMessageNoID((String)"ALR1312W", null);
        stringArray[13] = MessageLog.getMessageNoID((String)"ALR1310W", null);
        stringArray[15] = MessageLog.getMessageNoID((String)"ALR1311W", null);
        stringArray[16] = MessageLog.getMessageNoID((String)"ALR1315W", null);
        stringArray[18] = MessageLog.getMessageNoID((String)"ALR1316W", null);
        stringArray[17] = MessageLog.getMessageNoID((String)"ALR1314W", null);
        stringArray[21] = MessageLog.getMessageNoID((String)"ALR1317W", null);
        stringArray[22] = MessageLog.getMessageNoID((String)"ALR1319W", null);
        stringArray[23] = MessageLog.getMessageNoID((String)"ALR1318W", null);
        stringArray[24] = MessageLog.getMessageNoID((String)"ALR1340W", null);
        stringArray[25] = MessageLog.getMessageNoID((String)"ALR1341W", null);
        stringArray[26] = MessageLog.getMessageNoID((String)"ALR1342W", null);
        stringArray[27] = MessageLog.getMessageNoID((String)"ALR1343W", null);
        stringArray[28] = MessageLog.getMessageNoID((String)"ALR1344W", null);
        stringArray[29] = MessageLog.getMessageNoID((String)"ALR1345W", null);
        stringArray[30] = MessageLog.getMessageNoID((String)"ALR1346W", null);
        String[] stringArray2 = stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTecEventMsgs", (Object)stringArray2);
        }
        return stringArray2;
    }

    protected static String[] getTecEventMsgIDs() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getTecEventMsgIDs", (String)"");
        }
        String[] stringArray = new String[31];
        stringArray[1] = "ALR1300W";
        stringArray[2] = "ALR1301W";
        stringArray[3] = "ALR1302W";
        stringArray[4] = "ALR1303W";
        stringArray[5] = "ALR1304W";
        stringArray[6] = "ALR1305W";
        stringArray[7] = "ALR1306W";
        stringArray[8] = "ALR1307W";
        stringArray[9] = "ALR1308W";
        stringArray[10] = "ALR1309W";
        stringArray[11] = "ALR1312W";
        stringArray[13] = "ALR1310W";
        stringArray[15] = "ALR1311W";
        stringArray[16] = "ALR1315W";
        stringArray[17] = "ALR1314W";
        stringArray[18] = "ALR1316W";
        stringArray[21] = "ALR1317W";
        stringArray[22] = "ALR1319W";
        stringArray[23] = "ALR1318W";
        stringArray[24] = "ALR1340W";
        stringArray[25] = "ALR1341W";
        stringArray[26] = "ALR1342W";
        stringArray[27] = "ALR1343W";
        stringArray[28] = "ALR1344W";
        stringArray[29] = "ALR1345W";
        stringArray[30] = "ALR1346W";
        String[] stringArray2 = stringArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getTecEventMsgIDs", (Object)stringArray2);
        }
        return stringArray2;
    }

    private void missingFSAlert(Filesystem filesystem) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"missingFSAlert", (String)"fs");
        }
        this.initParms();
        this.setHostName();
        this.alertParms[1] = filesystem.fsMountPoint;
        this.alertParms[11] = "filesystem";
        this.setParmFromMsg(10, "ALR1062W");
        this.genAlert(filesystem.fsID, (short)3, 8, -1, -1);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"missingFSAlert");
        }
    }

    private void checkFreeSpace(Filesystem filesystem) {
        long l;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkFreeSpace", (String)"fs");
        }
        if (filesystem.fsFreeSpace < (l = this.alertDef.aldThresholdType == 2 ? filesystem.fsCapacity * (long)this.alertDef.aldThresholdValue / 100L : (long)(this.alertDef.aldThresholdValue * 2))) {
            this.initParms();
            this.setHostName();
            if (this.alertDef.aldThresholdType == 2) {
                this.setNumParm(2, this.alertDef.aldThresholdValue, "%");
            } else {
                this.setByteSizeParm(2, l);
            }
            this.setByteSizeParm(3, filesystem.fsFreeSpace);
            double d = filesystem.fsFreeSpace * 100L;
            this.setNumParm(5, d /= (double)filesystem.fsCapacity, "%");
            this.alertParms[1] = filesystem.fsMountPoint;
            this.alertParms[11] = "filesystem";
            this.setParmFromMsg(10, "ALR1064W");
            this.genAlert(filesystem.fsID, (short)3, 10, (int)filesystem.fsFreeSpace, -1);
        } else {
            this.clearAlert(filesystem.fsID, (short)3);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkFreeSpace");
        }
    }

    private void checkFreeInodes(Filesystem filesystem) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"checkFreeInodes", (String)"fs");
        }
        if (filesystem.fsFreeInodes == -1) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"checkFreeInodes");
            }
            return;
        }
        long l = this.alertDef.aldThresholdType == 2 ? (long)(filesystem.fsMaxFiles * this.alertDef.aldThresholdValue / 100) : (long)this.alertDef.aldThresholdValue;
        if ((long)filesystem.fsFreeInodes < l) {
            this.initParms();
            this.setHostName();
            if (this.alertDef.aldThresholdType == 2) {
                this.setNumParm(2, this.alertDef.aldThresholdValue, "%");
            } else {
                this.setNumParm(2, this.alertDef.aldThresholdValue, (String)null);
            }
            this.setNumParm(3, filesystem.fsFreeInodes, (String)null);
            double d = filesystem.fsFreeInodes * 100;
            this.setNumParm(5, d /= (double)filesystem.fsMaxFiles, "%");
            this.alertParms[1] = filesystem.fsMountPoint;
            this.alertParms[11] = "filesystem";
            this.setParmFromMsg(10, "ALR1065W");
            this.genAlert(filesystem.fsID, (short)3, 11, filesystem.fsFreeInodes, -1);
        } else {
            this.clearAlert(filesystem.fsID, (short)3);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"checkFreeInodes");
        }
    }

    protected void initParms() {
        this.alertParms = new String[30];
    }

    protected boolean processFilesystemAlert(Filesystem filesystem) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processFilesystemAlert", (String)"fs");
        }
        if (filesystem.fsComputerID != this.computerID) {
            this.setComputer(filesystem.fsComputerID);
        }
        boolean bl = true;
        switch (this.alertDef.aldCondition) {
            case 13: {
                this.checkFreeSpace(filesystem);
                break;
            }
            case 14: {
                this.checkFreeInodes(filesystem);
                break;
            }
            case 12: {
                this.missingFSAlert(filesystem);
                break;
            }
            default: {
                bl = false;
            }
        }
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processFilesystemAlert", (boolean)bl2);
        }
        return bl2;
    }

    protected void processAlert(HasID hasID) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processAlert", (String)"resource");
        }
        this.processFilesystemAlert((Filesystem)hasID);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processAlert");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void processOncePrepared(ScheduleQueryable var1_1, HasID var2_2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            try {
                v0 = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            TraceLogger.entry((String)v0.getName(), (String)"processOncePrepared", (String)"accessor, head");
        }
        var3_3 = new NameList();
        this.alertDef = null;
        var4_4 = -1;
        var5_5 = -1;
        var6_6 = var2_2;
        while (var1_1.fetchQueryBySchedule(var3_3)) {
            if (var3_3.nlID2 != var4_4) {
                var4_4 = var3_3.nlID2;
                var5_5 = -1;
                var6_6 = var2_2;
            }
            if (var3_3.nlID == var5_5) continue;
            var5_5 = var3_3.nlID;
            if (var3_3.nlState == 0) ** GOTO lbl23
            continue;
lbl-1000:
            // 1 sources

            {
                var6_6 = (HasID)var6_6.getNext();
lbl23:
                // 2 sources

                ** while (var6_6 != null && var6_6.getID() != var3_3.nlID)
            }
lbl24:
            // 1 sources

            if (var6_6 == null) {
                var7_7 = new Object[]{new Integer(var3_3.nlID), new Integer(var4_4)};
                var8_8 = MessageLog.getMessage((String)"STS0116E", (Object[])var7_7);
                if (TraceLogger.enableTrace) {
                    try {
                        v2 = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                    TraceLogger.exit((String)v2.getName(), (String)"processOncePrepared");
                }
                throw new GeneralException(var8_8);
            }
            if (this.alertDef == null || this.alertDef.aldAlertID != var4_4) {
                this.alertDef = this.alertAccessor.getByID(var4_4);
            }
            if (this.alertDef == null) continue;
            this.processAlert(var6_6);
        }
        if (TraceLogger.enableTrace) {
            try {
                v4 = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException v5) {
                throw new NoClassDefFoundError(v5.getMessage());
            }
            TraceLogger.exit((String)v4.getName(), (String)"processOncePrepared");
        }
    }

    private void processFilesystemAlerts(Filesystem filesystem, short s) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processFilesystemAlerts", (String)"head, attributeType");
        }
        this.fsAccessor = new TResFS(this.dbc);
        this.fsAccessor.initQueryByAttrType(s, filesystem, null);
        this.processOncePrepared(this.fsAccessor, (HasID)filesystem);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processFilesystemAlerts");
        }
    }

    protected void processFilesystemAlerts(Filesystem filesystem, Filesystem filesystem2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"processFilesystemAlerts", (String)"present, missing");
        }
        if (filesystem == null && filesystem2 == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"processFilesystemAlerts");
            }
            return;
        }
        try {
            if (filesystem != null) {
                this.processFilesystemAlerts(filesystem, (short)27);
            }
            if (filesystem2 != null) {
                this.processFilesystemAlerts(filesystem2, (short)29);
            }
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"processFilesystemAlerts", (Throwable)generalException);
            }
            this.fsAccessor.closeSelect();
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"processFilesystemAlerts");
            }
            throw generalException;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processFilesystemAlerts");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processVirtualServerAlerts(Computer computer, Computer computer2) throws StorageException {
        block12: {
            Class<?> clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"processVirtualServerAlerts", (String)"computer, oldComputer");
            }
            try {
                if (this.cmpAccessor == null) {
                    this.cmpAccessor = new TResComputer(this.dbc);
                }
                this.cmpAccessor.prepSelectName();
                this.initParms();
                this.setHostName();
                this.alertParms[16] = this.hostName;
                this.alertParms[18] = this.cmpAccessor.fetchName(computer.cmpNodeHostedID);
                this.alertParms[17] = computer.cmpCluster.clusterName;
                this.setParmFromMsg(11, "STS0054I");
                if (this.alertDef.aldCondition == 73) {
                    this.setParmFromMsg(10, "ALR1119W");
                    this.genAlert(this.computerID, (short)1, 26, -1, -1, (byte)0, -1);
                } else if (this.alertDef.aldCondition == 75) {
                    String string;
                    this.alertParms[19] = string = this.cmpAccessor.fetchName(computer2.cmpNodeHostedID);
                    this.setParmFromMsg(10, "ALR1121W");
                    this.genAlert(this.computerID, (short)1, 28, -1, -1, (byte)0, -1);
                }
                Object var4_6 = null;
                this.cleanupSelect(this.cmpAccessor);
                if (!TraceLogger.enableTrace) break block12;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.cleanupSelect(this.cmpAccessor);
                throw throwable;
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processVirtualServerAlerts");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processVirtualServerRemovedAlert(int n, int n2) throws GeneralException {
        block10: {
            Class<?> clazz;
            if (TraceLogger.enableTrace) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz2.getName(), (String)"processVirtualServerRemovedAlert", (String)"cmpID, clusterID");
            }
            try {
                if (this.cmpAccessor == null) {
                    this.cmpAccessor = new TResComputer(this.dbc);
                }
                this.cmpAccessor.prepSelectName();
                TResCluster tResCluster = new TResCluster(this.dbc);
                String string = null;
                Cluster cluster = tResCluster.getClusterByID(n2);
                if (cluster != null) {
                    string = cluster.clusterName;
                }
                this.initParms();
                this.alertParms[16] = this.cmpAccessor.fetchName(n);
                this.alertParms[18] = this.cmpAccessor.getVSNodeName(n);
                this.alertParms[17] = string;
                this.setParmFromMsg(11, "STS0054I");
                this.setParmFromMsg(10, "ALR1120W");
                this.setComputer(n);
                this.genAlert(n, (short)1, 27, -1, -1, (byte)0, -1);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.cleanupSelect(this.cmpAccessor);
                throw throwable;
            }
            {
                Object var6_8 = null;
                this.cleanupSelect(this.cmpAccessor);
                if (!TraceLogger.enableTrace) break block10;
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"processVirtualServerRemovedAlert");
        }
    }

    private void cleanupSelect(RepositoryAccessor repositoryAccessor) {
        block10: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"cleanupSelect", (String)"accessor");
            }
            try {
                repositoryAccessor.closeSelect();
            }
            catch (GeneralException generalException) {
                Class<?> clazz;
                if (!TraceLogger.enableTrace) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"cleanupSelect", (Throwable)generalException);
            }
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.alerts.StormAlerter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"cleanupSelect");
        }
    }
}

