/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import java.util.Hashtable;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.disk.GUIEntityFactory;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"handle", (String)"request, transceiver");
        }
        GUIRequestData gUIRequestData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (gUIRequestData.getActionId() == 30) {
                this.getVolumeIdsBySubsystem(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 51) {
                this.getVolumeNamesBySubsystem(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 31) {
                this.getVolumesBySubsystem(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 32) {
                this.getVolumeIdsByStoragePool(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 33) {
                this.getVolumesByStoragePool(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 34) {
                this.getVolumeIdsByHost(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 35) {
                this.getVolumesByHost(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 36) {
                this.getVolume(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 37) {
                this.getMDisksByMDiskGroup(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 38) {
                this.getVDiskIdsByIOGroup(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 39) {
                this.getVDiskIdsByMDiskGroup(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 40) {
                this.getVDisksByMDiskGroup(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 41) {
                this.getVDiskIdsByHost(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 42) {
                this.getVDisksByHost(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 43) {
                this.getVDiskIdsBySVC(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 44) {
                this.getVDisksBySVC(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 45) {
                this.getVDisk(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 46) {
                this.getPortAssignments(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 49) {
                this.getPortAssignmentsExt(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 47) {
                this.getVolumeSizeRange(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 48) {
                this.areVolumeActionsInProgress(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 50) {
                this.setStorageVolumeAttributes(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 52) {
                this.getMDisksForVDisk(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 53) {
                this.getHostTypes(gUIRequestData, response);
            }
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"handle", (Throwable)exception);
            }
            response.status = (short)12;
            if (exception instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)exception).getLocalizedMessage();
            } else {
                String[] stringArray = new String[]{};
                String string = exception.getMessage();
                if (string != null) {
                    stringArray = new String[]{string};
                }
                response.errorMessage = new SRMMessage("HWN021503E", stringArray).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void getVolumeIdsBySubsystem(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumeIdsBySubsystem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getVolumeIdsBySubsystem(string);
    }

    private void getVolumeNamesBySubsystem(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumeNamesBySubsystem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getVolumeNamesBySubsystem(string);
    }

    private void getVolumesBySubsystem(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumesBySubsystem", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getVolumesBySubsystem(string);
    }

    private void getVolumeIdsByStoragePool(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVolumeIdsByStoragePool", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("storagepool.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumeIdsByStoragePool", (String)("stgpoolId: " + string2));
        response.responseData = this.entityFactory.getVolumeIdsByStoragePool(string, string2);
    }

    private void getVolumesByStoragePool(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVolumesByStoragePool", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("storagepool.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumesByStoragePool", (String)("stgpoolId: " + string2));
        response.responseData = this.entityFactory.getVolumesByStoragePool(string, string2);
    }

    private void getVolumeIdsByHost(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVolumeIdsByHost", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("host.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumeIdsByHost", (String)("hostId: " + string2));
        response.responseData = this.entityFactory.getVolumeIdsByHost(string, string2);
    }

    private void getVolumesByHost(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVolumesByHost", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("host.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumesByHost", (String)("hostId: " + string2));
        response.responseData = this.entityFactory.getVolumesByHost(string, string2);
    }

    private void getVolume(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVolume", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("volume.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolume", (String)("volumeId: " + string2));
        response.responseData = this.entityFactory.getVolume(string, string2);
    }

    private void getMDisksByMDiskGroup(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getMDisksByMDiskGroup", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("mdiskgroup.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getMDisksByMDiskGroup", (String)("mdiskGroupId: " + string2));
        response.responseData = this.entityFactory.getMDisksByMDiskGroup(string, string2);
    }

    private void getMDisksForVDisk(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getMDisksForVDisk", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("vdisk.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getMDisksForVDisk", (String)("vdiskId: " + string2));
        response.responseData = this.entityFactory.getMDisksForVDisk(string, string2);
    }

    private void getVDiskIdsByIOGroup(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVDiskIdsByIOGroup", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("iogroup.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDiskIdsByIOGroup", (String)("ioGroupId: " + string2));
        response.responseData = this.entityFactory.getVDiskIdsByIOGroup(string, string2);
    }

    private void getVDiskIdsByMDiskGroup(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVDiskIdsByMDiskGroup", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("mdiskgroup.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDiskIdsByMDiskGroup", (String)("mdiskgroupId: " + string2));
        response.responseData = this.entityFactory.getVDiskIdsByMDiskGroup(string, string2);
    }

    private void getVDisksByMDiskGroup(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVDisksByMDiskGroup", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("mdiskgroup.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDisksByMDiskGroup", (String)("mdiskgroupId: " + string2));
        response.responseData = this.entityFactory.getVDisksByMDiskGroup(string, string2);
    }

    private void getVDiskIdsByHost(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVDiskIdsByHost", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("host.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDiskIdsByHost", (String)("hostId: " + string2));
        response.responseData = this.entityFactory.getVDiskIdsByHost(string, string2);
    }

    private void getVDisksByHost(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVDisksByHost", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("host.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDisksByHost", (String)("hostId: " + string2));
        response.responseData = this.entityFactory.getVDisksByHost(string, string2);
    }

    private void getVDiskIdsBySVC(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDiskIdsBySVC", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getVDiskIdsBySVC(string);
    }

    private void getVDisksBySVC(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDisksBySVC", (String)("subsystemId: " + string));
        response.responseData = this.entityFactory.getVDisksBySVC(string);
    }

    private void getVDisk(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVDisk", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("vdisk.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVDisk", (String)("vdiskId: " + string2));
        response.responseData = this.entityFactory.getVDisk(string, string2);
    }

    private void getPortAssignments(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getPortAssignments", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("volume.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getPortAssignments", (String)("volumeId: " + string2));
        response.responseData = this.entityFactory.getPortAssignments(string, string2);
    }

    private void getPortAssignmentsExt(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getPortAssignmentsExt", (String)("subsystemId: " + string));
        String[] stringArray = (String[])gUIRequestData.getParameter("volume.ids");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getPortAssignmentsExt", (String)("volumeIds: " + stringArray.toString()));
        response.responseData = this.entityFactory.getPortAssignments(string, stringArray);
    }

    private void getVolumeSizeRange(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        long[] lArray = null;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"getVolumeSizeRange", (String)("subsystemId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("storagepool.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getVolumeSizeRange", (String)("stgpoolId: " + string2));
        DeviceServerManager deviceServerManager = Server.getDeviceServerManager();
        org.eclipse.aperi.infrastructure.database.objects.Server server = deviceServerManager.getDeviceServer();
        if (server != null) {
            Class<?> clazz3;
            if (SecurityContext.getDefaultContext() == null) {
                SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
            }
            String string3 = null;
            try {
                string3 = SRMCrypto.decrypt((String)server.getPassword());
            }
            catch (Exception exception) {
                exception.printStackTrace(MessageLog.getThreadLog());
                string3 = server.getPassword();
            }
            MiddlewareCrypto.initialize((char[])string3.toCharArray());
            try {
                clazz3 = Class.forName("org.eclipse.aperi.disk.api.IDiskManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskManagerService iDiskManagerService = (IDiskManagerService)ConnectorClient.getService((String)server.getServerName(), (int)server.getPortNumber(), clazz3, (String)"DiskManagerService");
            lArray = iDiskManagerService.getDefaultSupportedVolumeSizeRange(string2);
        }
        response.responseData = lArray;
    }

    private void getHostTypes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        HostType[] hostTypeArray = null;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"getHostTypes", (String)("subSystemId: " + string));
        DeviceServerManager deviceServerManager = Server.getDeviceServerManager();
        org.eclipse.aperi.infrastructure.database.objects.Server server = deviceServerManager.getDeviceServer();
        if (server != null) {
            Class<?> clazz2;
            if (SecurityContext.getDefaultContext() == null) {
                SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
            }
            String string2 = null;
            try {
                string2 = SRMCrypto.decrypt((String)server.getPassword());
            }
            catch (Exception exception) {
                exception.printStackTrace(MessageLog.getThreadLog());
                string2 = server.getPassword();
            }
            MiddlewareCrypto.initialize((char[])string2.toCharArray());
            try {
                clazz2 = Class.forName("org.eclipse.aperi.disk.api.IDiskManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IDiskManagerService iDiskManagerService = (IDiskManagerService)ConnectorClient.getService((String)server.getServerName(), (int)server.getPortNumber(), clazz2, (String)"DiskManagerService");
            hostTypeArray = iDiskManagerService.getHostTypes(string);
        }
        response.responseData = hostTypeArray;
    }

    private void areVolumeActionsInProgress(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("subsystem.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"areVolumeActionsInProgress", (String)("subsystemId: " + string));
        response.responseData = new Boolean(this.entityFactory.areVolumeActionsInProgress(string));
    }

    private void setStorageVolumeAttributes(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        String string = (String)((Object)gUIRequestData.getParameter("volume.id"));
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"setStorageVolumeAttributes", (String)("volumeId: " + string));
        Hashtable hashtable = (Hashtable)gUIRequestData.getParameter("volume.attrs");
        response.responseData = new Integer(this.entityFactory.setStorageVolumeAttributes(string, hashtable));
    }
}

