/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.disk.common.model.DiskDataControllerConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;

public class FabricActionHandler
extends DeviceJobHndlr {
    private IFabricManagerService fmService = null;
    private String userName = null;

    public int deviceAPI(DeviceRequest deviceRequest, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deviceAPI", (String)"request, response");
        }
        GUIRequestData gUIRequestData = (GUIRequestData)deviceRequest.requestData;
        this.userName = deviceRequest.userName;
        int n = DiskDataControllerConstants.INVALID_JOBID;
        try {
            Class<?> clazz;
            DeviceRequestHndlr.initDeviceServerComm(deviceRequest);
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.api.IFabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.fmService = (IFabricManagerService)ConnectorClient.getService((String)deviceRequest.deviceServerHost, (int)deviceRequest.deviceServerPort, clazz, (String)"FabricManagerService");
            AsyncResult asyncResult = null;
            if (gUIRequestData.getActionId() == 30) {
                asyncResult = this.createZone(gUIRequestData, response);
            } else if (gUIRequestData.getActionId() == 31) {
                asyncResult = this.updateZone(gUIRequestData, response);
            }
            if (asyncResult != null) {
                if (asyncResult.getReturnException() != null) {
                    throw asyncResult.getReturnException();
                }
                n = Integer.parseInt(asyncResult.getJobId());
            }
        }
        catch (Exception exception) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"deviceAPI", (Throwable)exception);
            }
            response.status = (short)12;
            if (exception instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)exception).getLocalizedMessage();
            } else {
                String[] stringArray = new String[]{};
                String string = exception.getMessage();
                if (string != null) {
                    stringArray = new String[]{string};
                }
                response.errorMessage = new SRMMessage("HWN021503E", stringArray).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deviceAPI", (int)n);
        }
        return n;
    }

    private AsyncResult createZone(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"createZone", (String)("fabricId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("zoneset.name"));
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"createZone", (String)("zoneSetName: " + string2));
        String string3 = (String)((Object)gUIRequestData.getParameter("zone.name"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"createZone", (String)("zoneName: " + string3));
        String[] stringArray = (String[])gUIRequestData.getParameter("ports");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"createZone", (String)("portWwpns: " + stringArray));
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Create Zone ");
        stringBuffer.append("\n fabric ID = ");
        stringBuffer.append(string);
        stringBuffer.append("\n zone name = ");
        stringBuffer.append(string3);
        stringBuffer.append("\n port wwpns = ");
        stringBuffer.append(stringArray);
        short[] sArray = new short[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            sArray[n] = 11;
            ++n;
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz5.getName(), (String)"createZone()", (String)String.valueOf(stringBuffer));
        }
        this.fmService.startTransaction(string);
        this.fmService.createZone(string, string3, (short)0, (short)0);
        this.fmService.addZoneToZoneSet(string, string2, string3);
        this.fmService.addZoneMembersToZone(string, string3, stringArray, sArray);
        this.fmService.activateZoneSet(string, string2);
        return this.fmService.commitTransaction(string);
    }

    private AsyncResult updateZone(GUIRequestData gUIRequestData, Response response) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        String string = (String)((Object)gUIRequestData.getParameter("fabric.id"));
        try {
            clazz4 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz4.getName(), (String)"updateZone", (String)("fabricId: " + string));
        String string2 = (String)((Object)gUIRequestData.getParameter("zoneset.name"));
        try {
            clazz3 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz3.getName(), (String)"updateZone", (String)("zoneSetName: " + string2));
        String string3 = (String)((Object)gUIRequestData.getParameter("zone.name"));
        try {
            clazz2 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz2.getName(), (String)"updateZone", (String)("zoneName: " + string3));
        String[] stringArray = (String[])gUIRequestData.getParameter("ports");
        try {
            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        TraceLogger.traceMessage((int)1, (String)clazz.getName(), (String)"updateZone", (String)("portWwpns: " + stringArray.toString()));
        StringBuffer stringBuffer = new StringBuffer("Username = " + this.userName);
        stringBuffer.append("\n Update Zone ");
        stringBuffer.append("\n fabric ID = ");
        stringBuffer.append(string);
        stringBuffer.append("\n zone set name= ");
        stringBuffer.append(string2);
        stringBuffer.append("\n zone name = ");
        stringBuffer.append(string3);
        stringBuffer.append("\n port wwpns = ");
        stringBuffer.append(stringArray);
        short[] sArray = new short[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            sArray[n] = 11;
            ++n;
        }
        if (TraceLogger.enableAudit) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("org.eclipse.aperi.server.handler.scheduler.FabricActionHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.auditMessage((String)clazz5.getName(), (String)"updateZone()", (String)String.valueOf(stringBuffer));
        }
        this.fmService.startTransaction(string);
        this.fmService.addZoneMembersToZone(string, string3, stringArray, sArray);
        this.fmService.activateZoneSet(string, string2);
        return this.fmService.commitTransaction(string);
    }
}

