/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.File;
import org.eclipse.aperi.backend.SectionedConfigParser;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleConfig {
    private File file;
    private int number;
    SectionedConfigParser parser;
    private String[][] concurrencyKeys;
    private String[][] jobsKeys;
    private String[][][] sectionKeyWords;
    private static final int MAX_SUBMIT_THREADS_KEY = 0;
    private static final int MAX_COMPLETE_THREADS_KEY = 1;
    private static final int MINUTES_ADVANCED_KEY = 0;
    private static final int DELAY_LIMIT_KEY = 1;
    private static final int CONCURRENCY_SECTION = 0;
    private static final int JOBS_SECTION = 1;
    private static final String[] sectionNames = new String[]{"concurrency", "jobs"};
    private static final String configFile = "configuration" + File.separator + "Scheduler.config";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScheduleConfig() {
        block17: {
            this.concurrencyKeys = new String[][]{{"maxSubmitThreads", "4"}, {"maxCompleteThreads", "4"}};
            this.jobsKeys = new String[][]{{"minutesAdvanced", "1"}, {"delayLimitMinutes", "120"}};
            this.sectionKeyWords = new String[][][]{this.concurrencyKeys, this.jobsKeys};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"ScheduleConfig", (String)"");
            }
            this.file = new File(configFile);
            if (!this.file.exists()) break block17;
            try {
                try {
                    int n;
                    this.parser = new SectionedConfigParser(configFile, sectionNames, this.sectionKeyWords);
                    while ((n = this.parser.nextSection()) >= 0) {
                        if (n == 0) {
                            SchCommon.submitThreads = this.getNumber(this.concurrencyKeys[0][1], "maxSubmitThreads", SchCommon.submitThreads, 2, 8);
                            SchCommon.completeThreads = this.getNumber(this.concurrencyKeys[1][1], "maxCompleteThreads", SchCommon.completeThreads, 2, 8);
                            continue;
                        }
                        SchCommon.minutesAdvanced = this.getNumber(this.jobsKeys[0][1], "minutesAdvanced", SchCommon.minutesAdvanced, 1, 9);
                        SchCommon.millisAdvanced = SchCommon.minutesAdvanced * 60000;
                        SchCommon.delayLimitMinutes = this.getNumber(this.jobsKeys[1][1], "delayLimitMinutes", SchCommon.delayLimitMinutes, 1, 2880);
                        SchCommon.delayLimit = SchCommon.delayLimitMinutes * 60000;
                    }
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleConfig");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"ScheduleConfig", (Throwable)localizableException);
                    }
                    localizableException.print();
                }
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                if (this.parser != null) {
                    this.parser.close();
                }
                throw throwable;
            }
            {
                Object var2_5 = null;
                if (this.parser == null) break block17;
            }
            this.parser.close();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"ScheduleConfig");
        }
    }

    private int getNumber(String string, String string2, int n, int n2, int n3) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNumber", (String)"input, keyword, defaultValue, min, max");
        }
        int n4 = n;
        boolean bl = false;
        try {
            n4 = Integer.parseInt(string);
            if (n4 < n2 || n4 > n3) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNumber", (Throwable)numberFormatException);
            }
            bl = true;
        }
        if (bl) {
            Object[] objectArray = new Object[]{string2, Integer.toString(n2), Integer.toString(n3), Integer.toString(n)};
            MessageLog.logMessage((String)"JSS0062W", (Object[])objectArray);
            n4 = n;
        }
        int n5 = n4;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.handler.scheduler.ScheduleConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNumber", (int)n5);
        }
        return n5;
    }
}

