/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.common.PingHist;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TStatPingHist;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.alerts.PingAlerter;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Ping
implements ServerJob {
    private static HashMap<PingStats, PingStats> statMap = new HashMap();
    private static AgentManager agentMgr = Server.getAgentManager();
    private static long startTime;
    private static final String pingFileName;
    public static final int SUCCESS = 0;
    public static final int PACKET_DAMAGED = 1;
    public static final int UNREACHABLE = 2;
    private static final long[] INTERVAL_UNITS;
    private Connection dbc;
    private long nativeHandle;
    private int transitTime;
    private long saveInterval;
    private int saveIntervalType;
    private int alertID;
    private VMJobResults jobResults;
    private boolean jobLogInitialized;

    static {
        pingFileName = "PING." + Server.getServerName();
        INTERVAL_UNITS = new long[]{1L, 60000L, 3600000L, 86400000L};
    }

    public Ping(Connection connection) {
        this.initialize(connection);
    }

    public Ping() {
    }

    public void initialize(Connection connection) {
        this.dbc = connection;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"init", (String)"");
        }
        Connection connection = Ping.getConnection();
        try {
            Ping ping = new Ping(connection);
            ping.getPingFile();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Server.returnConnection(connection);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        Server.returnConnection(connection);
        {
            startTime = SQLUtil.getTimestamp(connection).getTime();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void term(byte by) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"term", (String)"termOption");
        }
        Connection connection = null;
        HashMap<PingStats, PingStats> hashMap = statMap;
        synchronized (hashMap) {
            Object object;
            block21: {
                object = null;
                Iterator<PingStats> iterator = statMap.values().iterator();
                while (true) {
                    Object object2;
                    if (!iterator.hasNext()) {
                        if (by != 1) break block21;
                        try {
                            try {
                                connection = Ping.getConnection();
                                object2 = new Ping(connection);
                                super.saveToRepository((PingStats)object);
                            }
                            catch (GeneralException generalException) {
                                if (TraceLogger.enableTrace) {
                                    Class<?> clazz;
                                    try {
                                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    TraceLogger.exception((String)clazz.getName(), (String)"term", (Throwable)generalException);
                                }
                                MessageLog.logException((String)"STS0045E", (Exception)((Object)generalException));
                                by = (byte)2;
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            if (connection != null) {
                                Server.returnConnection(connection);
                            }
                            throw throwable;
                        }
                    }
                    object2 = iterator.next();
                    if (((PingStats)object2).pingInProgress || ((PingStats)object2).transmitted <= 0) continue;
                    ((PingStats)object2).next = object;
                    object = object2;
                }
                {
                    Object var6_9 = null;
                    if (connection == null) break block21;
                }
                Server.returnConnection(connection);
            }
            if (by == 2) {
                Ping.saveToFile(object);
            }
            statMap.clear();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"term");
        }
    }

    public int run(VMJobResults vMJobResults, String[] stringArray) {
        int n;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"run", (String)"job, parms");
        }
        this.jobResults = vMJobResults;
        JobRun jobRun = vMJobResults.getJobRun();
        int n2 = 8;
        try {
            n = Integer.parseInt(stringArray[0]);
            this.saveIntervalType = Integer.parseInt(stringArray[1]);
            this.saveInterval = (long)(n + 1) * INTERVAL_UNITS[this.saveIntervalType];
            this.alertID = stringArray.length > 2 && stringArray[2] != null ? Integer.parseInt(stringArray[2]) : -1;
            n2 = this.ping(jobRun);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)indexOutOfBoundsException);
            }
            this.initJobLog();
            MessageLog.logMessage((String)"STS0043E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)numberFormatException);
            }
            this.initJobLog();
            MessageLog.logMessage((String)"STS0043E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)localizableException);
            }
            this.initJobLog();
            MessageLog.logMessage((String)"STS0044E", (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
            localizableException.print();
        }
        catch (GeneralException generalException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"run", (Throwable)generalException);
            }
            this.initJobLog();
            MessageLog.logException((String)"STS0044E", (Exception)((Object)generalException), (Object)jobRun.getSchedCreator(), (Object)jobRun.getSchedName());
        }
        n = n2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"run", (int)n);
        }
        return n;
    }

    private void initJobLog() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"initJobLog", (String)"");
        }
        if (!this.jobLogInitialized) {
            this.jobResults.setJobLog();
            this.jobLogInitialized = true;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"initJobLog");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int ping(JobRun var1_1) throws LocalizableException, GeneralException {
        block54: {
            block53: {
                if (TraceLogger.enableTrace) {
                    try {
                        v0 = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                    TraceLogger.entry((String)v0.getName(), (String)"ping", (String)"jobRun");
                }
                var2_2 = false;
                var3_3 = null;
                var4_4 = null;
                var5_5 = 0;
                try {
                    block55: {
                        var3_3 = String.valueOf(var1_1.getSchedID());
                        var6_6 = LockManager.lock((short)0, (String)"Ping", (String)var3_3, (byte)1, (boolean)false);
                        if (var6_6 != 0) break block55;
                        var3_3 = null;
                        var7_7 = 0;
                        if (TraceLogger.enableTrace) {
                            try {
                                v2 = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException v3) {
                                throw new NoClassDefFoundError(v3.getMessage());
                            }
                            TraceLogger.exit((String)v2.getName(), (String)"ping", (int)var7_7);
                        }
                        var14_11 = var7_7;
                        var12_13 = null;
                        var15_17 = var4_4;
                        if (true) ** GOTO lbl123
                    }
                    var4_4 = this.buildStatList(var1_1.getComputerList());
                    if (var4_4 == null) {
                        var7_8 = 0;
                        if (TraceLogger.enableTrace) {
                            try {
                                v4 = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException v5) {
                                throw new NoClassDefFoundError(v5.getMessage());
                            }
                            TraceLogger.exit((String)v4.getName(), (String)"ping", (int)var7_8);
                        }
                        var14_12 = var7_8;
                        break block53;
                    }
                    this.nativeHandle = Ping.open(AgentSvp.pingReceiveTimeout);
                    var7_9 = var4_4;
                    while (true) {
                        block56: {
                            if (var7_9 != null) break block56;
                            this.saveToRepository(var4_4);
                            if (var2_2 && this.alertID > 0) {
                                ** try [egrp 6[TRYBLOCK] [5 : 583->610)] { 
lbl51:
                                // 1 sources

                                break;
                            }
                            ** GOTO lbl-1000
                        }
                        var8_25 = Ping.agentMgr.getHostAddress(var7_9.computerID);
                        var9_26 = null;
                        if (var8_25 == null && (var9_26 = Ping.agentMgr.getNasComputer(var7_9.computerID)) != null && !var9_26.expired) {
                            var8_25 = var9_26.networkAddress;
                        }
                        if (var8_25 == null) {
                            if (var9_26 == null || var9_26.osType != 20) {
                                this.initJobLog();
                                MessageLog.logMessage((String)"STS0124E", (Object)Integer.toString(var7_9.computerID));
                                var5_5 = 8;
                            }
                        } else {
                            var10_27 = 2;
                            try {
                                var10_27 = this.ping(this.nativeHandle, var8_25);
                            }
                            catch (LocalizableException var11_28) {
                                if (TraceLogger.enableTrace) {
                                    try {
                                        v6 = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                                    }
                                    catch (ClassNotFoundException v7) {
                                        throw new NoClassDefFoundError(v7.getMessage());
                                    }
                                    TraceLogger.exception((String)v6.getName(), (String)"ping", (Throwable)var11_28);
                                }
                                this.initJobLog();
                                var11_28.print();
                                var5_5 = var11_28.getKey().equals("STS0036E") != false && var5_5 <= 4 ? 4 : 8;
                            }
                            var7_9.lastPingStatus = var10_27;
                            var7_9.transmitted = (short)(var7_9.transmitted + 1);
                            if (var10_27 == 2) {
                                var7_9.unreachableCount = (short)(var7_9.unreachableCount + 1);
                                var2_2 = true;
                                if (var5_5 < 4) {
                                    var5_5 = 4;
                                }
                            } else {
                                var7_9.unreachableCount = 0;
                                if (var7_9.alertExists) {
                                    var2_2 = true;
                                }
                                if (this.transitTime < var7_9.minTransitTime) {
                                    var7_9.minTransitTime = this.transitTime;
                                }
                                if (this.transitTime > var7_9.maxTransitTime) {
                                    var7_9.maxTransitTime = this.transitTime;
                                }
                                var7_9.totalTransitTime += (long)this.transitTime;
                                var7_9.received = (short)(var7_9.received + 1);
                                if (var10_27 == 1) {
                                    var7_9.damaged = (short)(var7_9.damaged + 1);
                                }
                            }
                        }
                        var7_9 = var7_9.next;
                    }
                    {
                        var7_9 = new PingAlerter(this.dbc, var4_4, this.alertID);
                        var7_9.alert();
                    }
lbl103:
                    // 1 sources

                    catch (LocalizableException var7_10) {
                        if (TraceLogger.enableTrace) {
                            try {
                                v8 = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException v9) {
                                throw new NoClassDefFoundError(v9.getMessage());
                            }
                            TraceLogger.exception((String)v8.getName(), (String)"ping", (Throwable)var7_10);
                        }
                        this.initJobLog();
                        var7_10.print();
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var13_29) {
                    var12_15 = null;
                    var15_19 = var4_4;
                    break block54;
                }
                do {
                    var16_21 = var15_17.next;
                    var15_17.pingInProgress = false;
                    var15_17 = var16_21;
lbl123:
                    // 2 sources

                } while (var15_17 != null);
                if (this.nativeHandle != 0L) {
                    Ping.close(this.nativeHandle);
                }
                if (var3_3 == null) return var14_11;
                LockManager.unLock((short)0, (String)"Ping", (String)var3_3);
                return var14_11;
            }
            var12_14 = null;
            var15_18 = var4_4;
            while (var15_18 != null) {
                var16_22 = var15_18.next;
                var15_18.pingInProgress = false;
                var15_18 = var16_22;
            }
            if (this.nativeHandle != 0L) {
                Ping.close(this.nativeHandle);
            }
            if (var3_3 == null) return var14_12;
            LockManager.unLock((short)0, (String)"Ping", (String)var3_3);
            return var14_12;
        }
        while (true) {
            if (var15_19 == null) {
                if (this.nativeHandle != 0L) {
                    Ping.close(this.nativeHandle);
                }
                if (var3_3 == null) throw var13_29;
                LockManager.unLock((short)0, (String)"Ping", (String)var3_3);
                throw var13_29;
            }
            var16_23 = var15_19.next;
            var15_19.pingInProgress = false;
            var15_19 = var16_23;
        }
lbl-1000:
        // 3 sources

        {
            var12_16 = null;
            var15_20 = var4_4;
        }
        while (true) {
            if (var15_20 == null) {
                if (this.nativeHandle != 0L) {
                    Ping.close(this.nativeHandle);
                }
                if (var3_3 != null) {
                    LockManager.unLock((short)0, (String)"Ping", (String)var3_3);
                }
                var6_6 = var5_5;
                if (!TraceLogger.enableTrace) return var6_6;
                ** try [egrp 9[TRYBLOCK] [11 : 743->751)] { 
lbl165:
                // 1 sources

                break;
            }
            var16_24 = var15_20.next;
            var15_20.pingInProgress = false;
            var15_20 = var16_24;
        }
        {
            v10 = Class.forName("org.eclipse.aperi.server.jobs.Ping");
        }
lbl172:
        // 1 sources

        catch (ClassNotFoundException v11) {
            throw new NoClassDefFoundError(v11.getMessage());
        }
        TraceLogger.exit((String)v10.getName(), (String)"ping", (int)var6_6);
        return var6_6;
    }

    private static native long open(int var0) throws LocalizableException;

    private static native void close(long var0);

    private native int ping(long var1, String var3) throws LocalizableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingStats buildStatList(LinkedInteger linkedInteger) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"buildStatList", (String)"computerList");
        }
        PingStats pingStats = null;
        PingStats pingStats2 = new PingStats();
        HashMap<PingStats, PingStats> hashMap = statMap;
        synchronized (hashMap) {
            LinkedInteger linkedInteger2 = linkedInteger;
            while (linkedInteger2 != null) {
                pingStats2.computerID = linkedInteger2.value;
                PingStats pingStats3 = statMap.get(pingStats2);
                if (pingStats3 == null) {
                    pingStats3 = new PingStats(linkedInteger2.value, startTime);
                    statMap.put(pingStats3, pingStats3);
                }
                if (!pingStats3.pingInProgress) {
                    pingStats3.next = pingStats;
                    pingStats = pingStats3;
                    pingStats3.pingInProgress = true;
                }
                linkedInteger2 = linkedInteger2.next;
            }
        }
        hashMap = pingStats;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"buildStatList", hashMap);
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveToRepository(PingStats pingStats) throws GeneralException {
        PingStats pingStats2;
        block22: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"saveToRepository", (String)"statList");
            }
            long l = 0L;
            boolean bl = false;
            PingHist pingHist = null;
            TStatPingHist tStatPingHist = null;
            try {
                l = SQLUtil.getTimestamp(this.dbc).getTime();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping$PingStats");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"saveToRepository", (Throwable)exception);
                }
                return;
            }
            try {
                pingStats2 = pingStats;
                while (pingStats2 != null) {
                    boolean bl2;
                    if (this.saveIntervalType == 0) {
                        bl2 = (long)pingStats2.transmitted >= this.saveInterval;
                    } else {
                        boolean bl3 = bl2 = l - pingStats2.lastSaveTime >= this.saveInterval;
                    }
                    if (bl2) {
                        if (!bl) {
                            bl = true;
                            LockManager.lock((short)0, (String)"History", (String)"PingHist", (byte)2, (boolean)true);
                            pingHist = new PingHist();
                            pingHist.pngMonitorEnd = l;
                            tStatPingHist = new TStatPingHist(this.dbc);
                            tStatPingHist.prepSave();
                        }
                        pingHist.pngComputerID = pingStats2.computerID;
                        pingHist.pngTransmitted = pingStats2.transmitted;
                        pingHist.pngReceived = pingStats2.received;
                        pingHist.pngDamaged = pingStats2.damaged;
                        pingHist.pngMinTransitTime = pingStats2.minTransitTime;
                        pingHist.pngMaxTransitTime = pingStats2.maxTransitTime;
                        pingHist.pngAvgTransitTime = pingStats2.totalTransitTime;
                        pingHist.pngMonitorStart = pingStats2.lastSaveTime;
                        pingStats2.lastSaveTime = l;
                        tStatPingHist.save(pingHist);
                        pingStats2.resetStats(l);
                    }
                    pingStats2 = pingStats2.next;
                }
                if (bl) {
                    tStatPingHist.closeSave();
                }
                Object var9_11 = null;
                if (!bl) break block22;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (bl) {
                    LockManager.unLock((short)0, (String)"History", (String)"PingHist");
                }
                throw throwable;
            }
            LockManager.unLock((short)0, (String)"History", (String)"PingHist");
        }
        pingStats2 = pingStats;
        while (pingStats2 != null) {
            HostAgentPingDbAccess.updateHostStatus((int)pingStats2.computerID, (int)(pingStats2.lastPingStatus > 0 ? pingStats2.lastPingStatus : 1));
            pingStats2 = pingStats2.next;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveToRepository");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteComputer(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"deleteComputer", (String)"computerID");
        }
        PingStats pingStats = new PingStats();
        pingStats.computerID = n;
        HashMap<PingStats, PingStats> hashMap = statMap;
        synchronized (hashMap) {
            statMap.remove(pingStats);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"deleteComputer");
        }
    }

    private static void saveToFile(PingStats pingStats) {
        boolean bl;
        block32: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"saveToFile", (String)"statList");
            }
            PingStats[] pingStatsArray = Ping.packStats(pingStats);
            FileOutputStream fileOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            bl = false;
            try {
                fileOutputStream = new FileOutputStream(pingFileName);
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"saveToFile", (Throwable)iOException);
                }
                MessageLog.logException((String)"STS0046E", (Exception)iOException, (Object)pingFileName);
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"saveToFile");
                }
                return;
            }
            try {
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(pingStatsArray);
                bl = true;
            }
            catch (IOException iOException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"saveToFile", (Throwable)iOException);
                }
                MessageLog.logException((String)"STS0047E", (Exception)iOException, (Object)pingFileName);
            }
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"saveToFile", (Throwable)iOException);
                    }
                    if (bl) {
                        MessageLog.logException((String)"STS0047E", (Exception)iOException, (Object)pingFileName);
                        bl = false;
                    }
                    break block32;
                }
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block32;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"saveToFile", (Throwable)iOException);
                }
            }
        }
        if (!bl) {
            File file = new File(pingFileName);
            file.delete();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"saveToFile");
        }
    }

    private void getPingFile() {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getPingFile", (String)"");
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        File file = new File(pingFileName);
        if (file.canRead()) {
            block49: {
                block48: {
                    block47: {
                        try {
                            fileInputStream = new FileInputStream(pingFileName);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            Class<?> clazz;
                            if (!TraceLogger.enableTrace) break block47;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)fileNotFoundException);
                        }
                    }
                    if (fileInputStream != null) {
                        try {
                            objectInputStream = new ObjectInputStream(fileInputStream);
                        }
                        catch (IOException iOException) {
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)iOException);
                            }
                            MessageLog.logException((String)"STS0048W", (Exception)iOException, (Object)pingFileName);
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException2) {}
                            if (TraceLogger.enableTrace) {
                                Class<?> clazz;
                                try {
                                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                TraceLogger.exit((String)clazz.getName(), (String)"getPingFile");
                            }
                            return;
                        }
                    }
                    try {
                        PingStats[] pingStatsArray = (PingStats[])objectInputStream.readObject();
                        if (pingStatsArray != null) {
                            this.saveToRepository(Ping.unpackStats(pingStatsArray));
                        }
                    }
                    catch (EOFException eOFException) {
                        Class<?> clazz;
                        if (!TraceLogger.enableTrace) break block48;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)eOFException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException classNotFoundException2) {
                                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)classNotFoundException);
                        }
                        MessageLog.logMessage((String)"STS0048W", (Object)pingFileName);
                        MessageLog.logException((String)"STS0049W", (Exception)classNotFoundException, (Object)pingFileName);
                    }
                    catch (IOException iOException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)iOException);
                        }
                        MessageLog.logException((String)"STS0048W", (Exception)iOException, (Object)pingFileName);
                    }
                    catch (ClassCastException classCastException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)classCastException);
                        }
                        MessageLog.logMessage((String)"STS0048W", (Object)pingFileName);
                        MessageLog.logException((String)"STS0050W", (Exception)classCastException, (Object)pingFileName);
                    }
                    catch (GeneralException generalException) {
                        if (TraceLogger.enableTrace) {
                            Class<?> clazz;
                            try {
                                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)generalException);
                        }
                        MessageLog.logException((String)"STS0051W", (Exception)((Object)generalException));
                    }
                }
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    Class<?> clazz;
                    if (!TraceLogger.enableTrace) break block49;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception((String)clazz.getName(), (String)"getPingFile", (Throwable)iOException);
                }
            }
            file.delete();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getPingFile");
        }
    }

    private static Connection getConnection() throws GeneralException {
        Connection connection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getConnection", (String)"");
        }
        if ((connection = Server.getConnection()) == null) {
            MessageLog.logMessage((String)"GEN0050E");
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getConnection");
            }
            throw new GeneralException();
        }
        Connection connection2 = connection;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConnection", (Object)connection2);
        }
        return connection2;
    }

    private static PingStats[] packStats(PingStats pingStatsArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"packStats", (String)"statList");
        }
        int n = 0;
        Object object = pingStatsArray;
        while (object != null) {
            ++n;
            object = object.next;
        }
        object = new PingStats[n];
        Object object2 = pingStatsArray;
        while (object2 != null) {
            object[--n] = object2;
            object2 = object2.next;
        }
        object2 = object;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"packStats", (Object)object2);
        }
        return object2;
    }

    private static PingStats unpackStats(PingStats[] pingStatsArray) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"unpackStats", (String)"statArray");
        }
        PingStats pingStats = null;
        if (pingStatsArray != null) {
            int n = 0;
            while (n < pingStatsArray.length) {
                PingStats pingStats2 = pingStatsArray[n];
                pingStats2.next = pingStats;
                pingStats = pingStats2;
                ++n;
            }
        }
        PingStats pingStats3 = pingStats;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"unpackStats", pingStats3);
        }
        return pingStats3;
    }

    /*
     * Exception decompiling
     */
    public static int pingHostByName(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 126->129)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class PingStats
    implements Serializable {
        static final long serialVersionUID = 2885925143459169759L;
        public transient PingStats next;
        public int computerID;
        public long totalTransitTime;
        public int minTransitTime = Integer.MAX_VALUE;
        public int maxTransitTime;
        public short transmitted;
        public short received;
        public short damaged;
        public long lastSaveTime;
        public transient short unreachableCount;
        public transient boolean alertExists = true;
        public transient boolean pingInProgress;
        public int lastPingStatus;

        PingStats() {
            this(0, 0L);
        }

        PingStats(int n, long l) {
            this.computerID = n;
            this.lastSaveTime = l;
        }

        void resetStats(long l) {
            this.lastSaveTime = l;
            this.totalTransitTime = 0L;
            this.minTransitTime = Integer.MAX_VALUE;
            this.maxTransitTime = 0;
            this.transmitted = 0;
            this.received = 0;
            this.damaged = 0;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping$PingStats");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"equals", (String)"o");
            }
            PingStats pingStats = (PingStats)object;
            boolean bl2 = bl = this.computerID == pingStats.computerID;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.jobs.Ping$PingStats");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"equals", (boolean)bl);
            }
            return bl;
        }

        public int hashCode() {
            return this.computerID;
        }
    }
}

