/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import java.io.File;
import org.eclipse.aperi.backend.SectionedConfigParser;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class CimomConfig {
    private static final int THREAD_POOL_SIZE_KEY = 0;
    private static final int MAX_THREADS_KEY = 1;
    private static final int SPAWN_THREAD_TRIGGER_KEY = 2;
    private static final String configFile = "configuration" + File.separator + "Cimom.config";
    public static final int DEFAULT_THREAD_POOL_SIZE = 2;
    public static final int DEFAULT_MAX_THREADS = 5;
    public static final int DEFAULT_SPAWN_THREAD_TRIGGER = 2;
    public static final String[] SECTION_NAMES = new String[]{"threads"};
    public String[][] threadKeys = new String[][]{{"threadPoolSize", "2"}, {"maxThreads", "5"}, {"spawnThreadTrigger", "2"}};
    public String[][][] sectionKeyWords = new String[][][]{this.threadKeys};
    public int threadPoolSize = 2;
    public int maxThreads = 5;
    public int spawnThreadTrigger = 2;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadConfigSettings() throws LocalizableException {
        block19: {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.entry((String)clazz.getName(), (String)"getConfigSettings", (String)"");
            }
            if (!new File(configFile).exists()) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit((String)clazz.getName(), (String)"getConfigSettings");
                }
                return;
            }
            MessageLog.logMessage((String)"STS0001I", (Object)configFile);
            SectionedConfigParser sectionedConfigParser = null;
            try {
                try {
                    sectionedConfigParser = new SectionedConfigParser(configFile, SECTION_NAMES, this.sectionKeyWords);
                    sectionedConfigParser.nextSection();
                    this.threadPoolSize = this.getNumber(0, 2, 1, 10);
                    this.maxThreads = this.getNumber(1, 5, 1, 16);
                    this.spawnThreadTrigger = this.getNumber(2, 2, 1, 10);
                }
                catch (LocalizableException localizableException) {
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"getConfigSettings", (Throwable)localizableException);
                    }
                    localizableException.print();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (sectionedConfigParser != null) {
                    sectionedConfigParser.close();
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (sectionedConfigParser == null) break block19;
            }
            sectionedConfigParser.close();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getConfigSettings");
        }
    }

    private int getNumber(int n, int n2, int n3, int n4) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getNumber", (String)"key, defaultValue, min, max");
        }
        int n5 = n2;
        boolean bl = false;
        String string = this.threadKeys[n][1];
        if (string == null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit((String)clazz.getName(), (String)"getNumber", (int)n2);
            }
            return n2;
        }
        try {
            n5 = Integer.parseInt(string);
            if (n5 < n3 || n5 > n4) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"getNumber", (Throwable)numberFormatException);
            }
            bl = true;
        }
        if (bl) {
            Object[] objectArray = new Object[]{this.threadKeys[n][0], Integer.toString(n3), Integer.toString(n4), Integer.toString(n2)};
            MessageLog.logMessage((String)"JSS0062W", (Object[])objectArray);
            n5 = n2;
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.server.svp.CimomConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getNumber", (int)n5);
        }
        return n5;
    }
}

