/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.server.ConfigParser;
import org.eclipse.aperi.server.req.ServerStatusResp;
import org.eclipse.aperi.xmsg.MessageLog;

public class Export {
    private static String serverHost;
    private static int serverPort;
    private static String fileName;
    private static Request request;
    private static ObjectOutputStream oStream;
    private static HashMap<MutableInteger, MutableInteger> idMap;
    private static MutableInteger hashKey;
    private static int serverComputerID;
    private static boolean export;
    private static boolean objectsProcessed;

    static {
        request = new Request();
        hashKey = new MutableInteger();
        serverComputerID = -1;
    }

    public static void main(String[] stringArray) throws Exception {
        Export.getArgs(stringArray);
        ConfigParser configParser = new ConfigParser("config/server.config", null);
        if (!configParser.parse()) {
            System.exit(8);
        }
        serverHost = "localhost";
        serverPort = configParser.listenerPort;
        Export.request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        Export.request.serviceName = RequestTypeManager.getInternalName((String)Export.request.typeCode);
        Export.request.flags = (byte)4;
        if (export) {
            Export.exportFile();
        } else {
            Export.importFile();
        }
    }

    private static void getArgs(String[] stringArray) {
        String string;
        if (stringArray.length > 0 && stringArray.length < 2) {
            Export.exitWithMessage("GEN1001I");
        }
        if (stringArray.length == 2) {
            export = stringArray[0].equalsIgnoreCase("-e");
            if (!export && !stringArray[0].equalsIgnoreCase("-i")) {
                Export.exitWithMessage("GEN1001I");
            }
            fileName = stringArray[1];
            return;
        }
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string2 = String.valueOf(MessageLog.getMessageNoID((String)"GEN1020L")) + " ";
        while (!(string = Export.getUserInput(bufferedReader, string2, "e")).equalsIgnoreCase("i") && !string.equalsIgnoreCase("e")) {
        }
        export = string.equalsIgnoreCase("e");
        string2 = String.valueOf(MessageLog.getMessageNoID((String)"GEN1021L")) + " ";
        while ((fileName = Export.getUserInput(bufferedReader, string2, "")).length() == 0) {
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    private static void exitWithMessage(String string) {
        System.out.println("");
        MessageLog.logMessage((String)string);
        System.exit(8);
    }

    private static String getUserInput(BufferedReader bufferedReader, String string, String string2) {
        String string3 = null;
        try {
            System.out.print(string);
            System.out.flush();
            string3 = bufferedReader.readLine();
            if (string3 == null) {
                Export.exitWithMessage("GEN1022I");
            }
            if ((string3 = string3.trim()).length() == 0) {
                string3 = string2;
            }
        }
        catch (IOException iOException) {
            MessageLog.getThreadLog().println(iOException.getMessage());
            Export.exitWithMessage("GEN1023E");
        }
        return string3;
    }

    private static void exportFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileName);
            oStream = new ObjectOutputStream(fileOutputStream);
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"GEN0131E", (Exception)iOException, (Object)fileName);
            System.exit(8);
        }
        MessageLog.logMessage((String)"GEN1008I", (Object)fileName);
        Export.exportObjectType((short)0, new GroupExporter(), (CreateHeader)new GroupDefinition(), "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", "GEN1024I");
        Export.exportObjectType((short)2, new GroupExporter(), (CreateHeader)new GroupDefinition(), "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", "GEN1025I");
        Export.exportObjectType((short)89, new GroupExporter(), (CreateHeader)new GroupDefinition(), "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", "GEN1024I");
        Export.exportObjectType((short)90, new GroupExporter(), (CreateHeader)new GroupDefinition(), "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", "GEN1025I");
        Export.exportObjectType((short)36, new ReportExporter(), (CreateHeader)new Report(36), "org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr", "GEN1014I");
        try {
            oStream.close();
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"GEN1002E", (Exception)iOException, (Object)fileName);
            System.exit(8);
        }
        if (objectsProcessed) {
            MessageLog.logMessage((String)"GEN1007I");
        } else {
            MessageLog.logMessage((String)"GEN1018I");
        }
    }

    private static void exportObjectType(short s, Exporter exporter, CreateHeader createHeader, String string, String string2) {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10000 + s;
        guiListReq.resourceType = (short)-1;
        NameList[] nameListArray = (NameList[])Export.sendRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", (Serializable)guiListReq, true);
        if (nameListArray != null) {
            int n = 0;
            while (n < nameListArray.length) {
                NameList nameList = nameListArray[n];
                if (nameList.nlID > 299) {
                    objectsProcessed = true;
                    MessageLog.logMessage((String)string2, (Object)nameList.nlName);
                    createHeader.ID = nameList.nlID;
                    CreateHeader createHeader2 = (CreateHeader)Export.sendRequest(string, (Serializable)createHeader, true);
                    if (createHeader2 != null) {
                        exporter.export(createHeader2, s);
                    }
                }
                ++n;
            }
        }
    }

    private static void importFile() {
        FileInputStream fileInputStream;
        boolean bl = false;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileName);
            objectInputStream = new ObjectInputStream(fileInputStream);
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"GEN0131E", (Exception)iOException, (Object)fileName);
            System.exit(8);
        }
        idMap = new HashMap();
        MessageLog.logMessage((String)"GEN1009I", (Object)fileName);
        try {
            while (true) {
                if (!Export.importObject((CreateHeader)(fileInputStream = (CreateHeader)objectInputStream.readObject()))) {
                    bl = true;
                }
                objectsProcessed = true;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"GEN0133E", (Exception)iOException, (Object)fileName);
            System.exit(8);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageLog.logMessage((String)"GEN0133E", (Object)fileName);
            MessageLog.logException((String)"STS0049W", (Exception)classNotFoundException, (Object)fileName);
            System.exit(8);
        }
        catch (ClassCastException classCastException) {
            MessageLog.logMessage((String)"GEN0133E", (Object)fileName);
            MessageLog.logException((String)"STS0050W", (Exception)classCastException, (Object)fileName);
            System.exit(8);
        }
        try {
            objectInputStream.close();
        }
        catch (IOException iOException) {}
        if (objectsProcessed) {
            MessageLog.logMessage((String)(bl ? "GEN1010I" : "GEN1011I"));
        } else {
            MessageLog.logMessage((String)"GEN1019I");
        }
    }

    private static boolean importObject(CreateHeader createHeader) {
        MutableInteger mutableInteger = null;
        String string = null;
        if (createHeader instanceof GroupDefinition) {
            mutableInteger = new MutableInteger(createHeader.ID);
            MessageLog.logMessage((String)"GEN1028I", (Object)createHeader.creator, (Object)createHeader.getName());
            string = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        } else if (createHeader instanceof Report) {
            MessageLog.logMessage((String)"GEN1015I", (Object)createHeader.creator, (Object)createHeader.getName());
            string = "org.eclipse.aperi.server.handler.gui.GuiBatchReportHndlr";
            if (!Export.translateIDs((Report)createHeader)) {
                return false;
            }
        } else {
            MessageLog.logMessage((String)"GEN1012E", (Object)createHeader);
            System.exit(8);
        }
        createHeader.ID = 0;
        CreateHeader createHeader2 = (CreateHeader)Export.sendRequest(string, (Serializable)createHeader, false);
        if (createHeader2 == null) {
            MessageLog.logMessage((String)"GEN1013E", (Object)createHeader.creator, (Object)createHeader.getName());
            mutableInteger = null;
            return false;
        }
        if (mutableInteger != null) {
            idMap.put(mutableInteger, new MutableInteger(createHeader2.ID));
        }
        return true;
    }

    private static boolean translateIDs(Report report) {
        MutableInteger mutableInteger;
        GuiReportReq guiReportReq;
        if (serverComputerID == -1) {
            Export.request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
            Export.request.serviceName = RequestTypeManager.getInternalName((String)Export.request.typeCode);
            guiReportReq = (ServerStatusResp)Export.sendRequest("org.eclipse.aperi.server.handler.server.ServerStatusHndlr", null, false);
            if (guiReportReq == null) {
                MessageLog.logMessage((String)"GEN1017E");
                System.exit(16);
            }
            serverComputerID = guiReportReq.computerID;
            Export.request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            Export.request.serviceName = RequestTypeManager.getInternalName((String)Export.request.typeCode);
        }
        report.computerID = serverComputerID;
        guiReportReq = report.batchReport.grr;
        if (guiReportReq.profile > 299) {
            Export.hashKey.value = guiReportReq.profile;
            mutableInteger = idMap.get(hashKey);
            if (mutableInteger == null) {
                MessageLog.logMessage((String)"GEN1016E", (Object)report.creator, (Object)report.getName());
                return false;
            }
            guiReportReq.profile = mutableInteger.value;
        }
        if (Export.isTranslatable(guiReportReq.reportSubtype) && guiReportReq.selectedResources != null) {
            int n = 0;
            while (n < guiReportReq.selectedResources.length) {
                Export.hashKey.value = guiReportReq.selectedResources[n];
                if (Export.hashKey.value > 299) {
                    mutableInteger = idMap.get(hashKey);
                    if (mutableInteger == null) {
                        MessageLog.logMessage((String)"GEN1016E", (Object)report.creator, (Object)report.getName());
                        return false;
                    }
                    guiReportReq.selectedResources[n] = mutableInteger.value;
                }
                ++n;
            }
        }
        return true;
    }

    private static boolean isTranslatable(int n) {
        return n == 11 || n == 13 || n == 110 || n == 111;
    }

    private static Serializable sendRequest(String string, Serializable serializable, boolean bl) {
        Export.request.subType = string;
        Export.request.flags = (byte)4;
        Export.request.requestData = serializable;
        Socket socket = null;
        try {
            socket = new Socket(serverHost, serverPort);
        }
        catch (Exception exception) {
            MessageLog.logException((String)"AGT0121E", (Exception)exception);
            System.exit(8);
        }
        SocketTransceiver socketTransceiver = new SocketTransceiver(socket, serverHost);
        Response response = socketTransceiver.transmitRequest(request, null);
        if (response == null) {
            MessageLog.logMessage((String)"GUI0022M");
            System.exit(8);
        } else if (response.status > 4) {
            if (bl) {
                System.exit(8);
            }
            response.responseData = null;
        }
        return response.responseData;
    }

    private static void exportObject(Serializable serializable) {
        try {
            oStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            MessageLog.logException((String)"GEN0175E", (Exception)iOException, (Object)fileName);
            System.exit(8);
        }
    }

    private static class Exporter {
        private Exporter() {
        }

        public void export(CreateHeader createHeader, short s) {
            Export.exportObject((Serializable)createHeader);
        }
    }

    private static class GroupExporter
    extends Exporter {
        private GroupExporter() {
        }

        public void export(CreateHeader createHeader, short s) {
            GroupDefinition groupDefinition = (GroupDefinition)createHeader;
            groupDefinition.members = null;
            groupDefinition.groupType = s;
            Export.exportObject((Serializable)createHeader);
        }
    }

    private static class ReportExporter
    extends Exporter {
        private ReportExporter() {
        }

        public void export(CreateHeader createHeader, short s) {
            Report report = (Report)createHeader;
            GuiReportReq guiReportReq = report.batchReport.grr;
            guiReportReq.selectedUsers = null;
            guiReportReq.isUserInList = true;
            if (!Export.isTranslatable(guiReportReq.reportSubtype)) {
                guiReportReq.selectedResources = null;
                guiReportReq.isResourceInList = true;
            }
            Export.exportObject((Serializable)createHeader);
        }
    }
}

