/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.snmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.xmsg.LocalizableException;

public class Asn1Value {
    public static final int UNIVERSAL_CLASS = 0;
    public static final int APPLICATION_CLASS = 1;
    public static final int CONTEXT_CLASS = 2;
    public static final int PRIVATE_CLASS = 3;
    public static final int INTEGER_ID = Asn1Value.universalId(2);
    public static final int OCTET_STRING_ID = Asn1Value.universalId(4);
    public static final int NULL_ID = Asn1Value.universalId(5);
    public static final int OBJECT_IDENTIFIER_ID = Asn1Value.universalId(6);
    public static final int SEQUENCE_ID = Asn1Value.universalId(16);
    public static final int NUMERIC_STRING_ID = Asn1Value.universalId(18);
    public static final int PRINTABLE_STRING_ID = Asn1Value.universalId(19);
    public static final int TRAP_ID = Asn1Value.contextId(4);
    public static final int IP_ADDRESS_ID = Asn1Value.applicationId(0);
    public static final int COUNTER_ID = Asn1Value.applicationId(1);
    public static final int GAUGE_ID = Asn1Value.applicationId(2);
    public static final int TIME_TICKS_ID = Asn1Value.applicationId(3);
    public static final int OPAQUE_ID = Asn1Value.applicationId(4);
    public static final int[] TRELLISOFT_ENTERPRISE_OID = new int[]{1, 3, 6, 1, 4, 1, 6076};
    public static final Asn1Value Null = new Asn1Value(NULL_ID, null);
    public static final Asn1Value EmptySequence = new Asn1Value(new Asn1Value[0]);
    public static final Asn1Value EmptyString = new Asn1Value("");
    static final int TAG_MASK = 0xFFFFFFF;
    static final int constructedShift = 28;
    static final int classShift = 29;
    static final int CONSTRUCTED_MASK = 0x10000000;
    static final int CLASS_MASK = 0x60000000;
    public int identifier;
    public Object content = null;

    public static int identifier(int n, int n2) {
        return n << 29 | n2 & 0xFFFFFFF;
    }

    public static int identifierClass(int n) {
        return n >> 29;
    }

    public static int identifierTag(int n) {
        return n & 0xFFFFFFF;
    }

    public static boolean identifierConstructed(int n) {
        return (n & 0x10000000) != 0;
    }

    public static final int universalId(int n) {
        return Asn1Value.identifier(0, n);
    }

    public static final int applicationId(int n) {
        return Asn1Value.identifier(1, n);
    }

    public static final int contextId(int n) {
        return Asn1Value.identifier(2, n);
    }

    public static final int privateId(int n) {
        return Asn1Value.identifier(3, n);
    }

    public static Asn1Value counter(int n) {
        return new Asn1Value(COUNTER_ID, new Integer(n));
    }

    public static Asn1Value gauge(int n) {
        return new Asn1Value(GAUGE_ID, new Integer(n));
    }

    public static Asn1Value timeTicks(long l) {
        return new Asn1Value(TIME_TICKS_ID, new Long(l));
    }

    public static Asn1Value Opaque(String string) {
        return new Asn1Value(OPAQUE_ID, string);
    }

    public static Asn1Value ipAddress(InetAddress inetAddress) {
        return new Asn1Value(IP_ADDRESS_ID, inetAddress.getAddress());
    }

    public static Asn1Value trellisoftOID(int[] nArray) {
        int[] nArray2 = new int[TRELLISOFT_ENTERPRISE_OID.length + nArray.length];
        System.arraycopy(TRELLISOFT_ENTERPRISE_OID, 0, nArray2, 0, TRELLISOFT_ENTERPRISE_OID.length);
        System.arraycopy(nArray, 0, nArray2, TRELLISOFT_ENTERPRISE_OID.length, nArray.length);
        return new Asn1Value(nArray2);
    }

    public Asn1Value(int n, Object object) {
        this.identifier = n;
        this.content = object;
    }

    public Asn1Value(int n) {
        this.identifier = INTEGER_ID;
        this.content = new Integer(n);
    }

    public Asn1Value(long l) {
        this.identifier = INTEGER_ID;
        this.content = new Long(l);
    }

    public Asn1Value(String string) {
        this.identifier = OCTET_STRING_ID;
        this.content = string;
    }

    public Asn1Value(int[] nArray) {
        this.identifier = OBJECT_IDENTIFIER_ID;
        this.content = nArray;
    }

    public Asn1Value(Vector vector) {
        this.identifier = SEQUENCE_ID;
        this.content = vector;
    }

    public Asn1Value(Asn1Value[] asn1ValueArray) {
        this.identifier = SEQUENCE_ID;
        this.content = asn1ValueArray;
    }

    public Asn1Value explicit(int n, Asn1Value asn1Value) {
        Asn1Value[] asn1ValueArray = new Asn1Value[]{asn1Value};
        return new Asn1Value(n, asn1ValueArray);
    }

    public Asn1Value implicit(int n, Asn1Value asn1Value) {
        return new Asn1Value(n, asn1Value.content);
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        if (this.content instanceof Long) {
            return (Long)this.content;
        }
        return ((Integer)this.content).intValue();
    }

    public String getString() {
        return (String)this.content;
    }

    public Vector getVector() {
        return (Vector)this.content;
    }

    public Asn1Value[] getArray() {
        return (Asn1Value[])this.content;
    }

    public void print(PrintWriter printWriter) throws IOException {
        int n = Asn1Value.identifierClass(this.identifier);
        String[] stringArray = new String[]{"[UNIVERSAL ", "[APPLICATION ", "[CONTEXT ", "[PRIVATE "};
        printWriter.print(stringArray[n]);
        printWriter.print(Asn1Value.identifierTag(this.identifier));
        printWriter.print("] ");
        if (this.content == null) {
            printWriter.print("NULL");
        } else if (this.content instanceof Integer) {
            printWriter.print((Integer)this.content);
        } else if (this.content instanceof Long) {
            printWriter.print((Long)this.content);
        } else if (this.content instanceof String) {
            printWriter.print("\"" + (String)this.content + "\"");
        } else if (this.content instanceof byte[]) {
            printWriter.print("OCTET STRING:");
            Asn1Value.printHex(printWriter, (byte[])this.content);
        } else if (this.content instanceof int[]) {
            int[] nArray = (int[])this.content;
            StringBuffer stringBuffer = new StringBuffer();
            if (nArray.length > 0) {
                stringBuffer.append(String.valueOf(nArray[0]));
                int n2 = 1;
                while (n2 < nArray.length) {
                    stringBuffer.append(".");
                    stringBuffer.append(String.valueOf(nArray[n2]));
                    ++n2;
                }
            } else {
                stringBuffer.append(".");
            }
            printWriter.print(stringBuffer.toString());
        } else if (this.content instanceof Vector) {
            printWriter.print("{ ");
            Enumeration enumeration = ((Vector)this.content).elements();
            while (enumeration.hasMoreElements()) {
                ((Asn1Value)enumeration.nextElement()).print(printWriter);
                printWriter.print(", ");
            }
            printWriter.print("}");
        } else if (this.content instanceof Asn1Value[]) {
            Asn1Value[] asn1ValueArray = (Asn1Value[])this.content;
            printWriter.print("{ ");
            int n3 = 0;
            while (n3 < asn1ValueArray.length) {
                asn1ValueArray[n3].print(printWriter);
                printWriter.print(", ");
                ++n3;
            }
            printWriter.print("}");
        } else {
            printWriter.print("<UNKNOWN>");
        }
    }

    private static void printHex(PrintWriter printWriter, byte[] byArray, int n) {
        String string = "0123456789ABCDEF";
        int n2 = 0;
        while (n2 < byArray.length && n2 < n) {
            int n3 = byArray[n2];
            if (n3 < 0) {
                n3 += 256;
            }
            int n4 = n3 & 0xF;
            int n5 = n3 >> 4;
            printWriter.print(string.substring(n5, n5 + 1));
            printWriter.print(string.substring(n4, n4 + 1));
            ++n2;
        }
    }

    private static void printHex(PrintWriter printWriter, byte[] byArray) {
        Asn1Value.printHex(printWriter, byArray, byArray.length);
    }

    private static void encodeTagInteger(OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[5];
        int n2 = 0;
        while (n != 0) {
            byArray[n2] = (byte)(n & 0x7F);
            n >>= 7;
            ++n2;
        }
        int n3 = n2 - 1;
        while (n3 > 0) {
            outputStream.write(byArray[n3] | 0x80);
            --n3;
        }
        outputStream.write(byArray[0]);
    }

    private static void encodeLength(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write((byte)n);
        } else {
            byte[] byArray = new byte[4];
            int n2 = 0;
            while (n != 0) {
                byArray[n2] = (byte)(n & 0xFF);
                n >>= 8;
                n2 = (byte)(n2 + 1);
            }
            outputStream.write(0x80 | n2);
            int n3 = n2 - 1;
            while (n3 >= 0) {
                outputStream.write(byArray[n3]);
                --n3;
            }
        }
    }

    private void encodeIdentifier(OutputStream outputStream, boolean bl) throws IOException {
        int n = Asn1Value.identifierClass(this.identifier);
        int n2 = Asn1Value.identifierTag(this.identifier);
        byte by = (byte)(n << 6 | (bl ? 32 : 0));
        if (n2 <= 30) {
            outputStream.write(by | n2);
        } else {
            outputStream.write(by | 0x1F);
            Asn1Value.encodeTagInteger(outputStream, n2);
        }
    }

    private void encode(OutputStream outputStream) throws IOException {
        boolean bl = this.content instanceof Vector || this.content instanceof Asn1Value[];
        this.encodeIdentifier(outputStream, bl);
        if (this.content instanceof Integer) {
            Asn1Value.encodeContent(outputStream, this.getInt());
        } else if (this.content instanceof Long) {
            Asn1Value.encodeContent(outputStream, this.getLong());
        } else if (this.content instanceof String) {
            Asn1Value.encodeContent(outputStream, this.getString());
        } else if (this.content instanceof byte[]) {
            Asn1Value.encodeContent(outputStream, (byte[])this.content);
        } else if (this.content instanceof int[]) {
            Asn1Value.encodeContent(outputStream, (int[])this.content);
        } else if (this.content instanceof Vector) {
            Asn1Value.encodeContent(outputStream, this.getVector());
        } else if (this.content instanceof Asn1Value[]) {
            Asn1Value.encodeContent(outputStream, this.getArray());
        } else if (this.content == null) {
            outputStream.write(0);
        } else {
            throw new ClassCastException("invalid content class");
        }
    }

    private static void encodeContent(OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[8];
        long l2 = l < 0L ? -1 : 0;
        long l3 = l2 & 0x80L;
        int n = 0;
        while (n == 0 || l != l2 || (long)(byArray[n - 1] & 0x80) != l3) {
            byArray[n] = (byte)(l & 0xFFL);
            l >>= 8;
            n = (byte)(n + 1);
        }
        outputStream.write(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            outputStream.write(byArray[n2]);
            --n2;
        }
    }

    private static void encodeContent(OutputStream outputStream, String string) throws IOException {
        Asn1Value.encodeLength(outputStream, string.length());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write(string);
        outputStreamWriter.close();
    }

    private static void encodeContent(OutputStream outputStream, byte[] byArray) throws IOException {
        Asn1Value.encodeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    private static void encodeContent(OutputStream outputStream, int[] nArray) throws IOException {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("OID has less than 2 numbers");
        }
        int n = 40 * nArray[0] + nArray[1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Asn1Value.encodeTagInteger(byteArrayOutputStream, n);
        int n2 = 2;
        while (n2 < nArray.length) {
            Asn1Value.encodeTagInteger(byteArrayOutputStream, nArray[n2]);
            ++n2;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Asn1Value.encodeLength(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    private static void encodeContent(OutputStream outputStream, Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        Vector<ByteArrayOutputStream> vector2 = new Vector<ByteArrayOutputStream>();
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            ((Asn1Value)enumeration.nextElement()).encode(byteArrayOutputStream);
            vector2.addElement(byteArrayOutputStream);
            n += byteArrayOutputStream.size();
        }
        Asn1Value.encodeLength(outputStream, n);
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            byteArrayOutputStream = (ByteArrayOutputStream)enumeration.nextElement();
            outputStream.write(byteArrayOutputStream.toByteArray());
        }
    }

    private static void encodeContent(OutputStream outputStream, Asn1Value[] asn1ValueArray) throws IOException {
        ByteArrayOutputStream[] byteArrayOutputStreamArray = new ByteArrayOutputStream[asn1ValueArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < asn1ValueArray.length) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            asn1ValueArray[n2].encode(byteArrayOutputStream);
            byteArrayOutputStreamArray[n2] = byteArrayOutputStream;
            n += byteArrayOutputStream.size();
            ++n2;
        }
        Asn1Value.encodeLength(outputStream, n);
        n2 = 0;
        while (n2 < asn1ValueArray.length) {
            outputStream.write(byteArrayOutputStreamArray[n2].toByteArray());
            ++n2;
        }
    }

    public byte[] encode() throws LocalizableException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.encode(byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }
}

