/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.List;
import org.eclipse.birt.report.model.api.CustomColorHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class CustomColor
extends ReferencableStructure {
    public static final String CUSTOM_COLOR_STRUCT = "CustomColor";
    public static final String NAME_MEMBER = "name";
    public static final String COLOR_MEMBER = "color";
    public static final String DISPLAY_NAME_MEMBER = "displayName";
    public static final String DISPLAY_NAME_ID_MEMBER = "displayNameID";
    protected String name;
    protected String color;
    protected String displayName;
    protected String displayNameID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CustomColor() {
    }

    public CustomColor(String theName, String value) {
        this.name = theName;
        this.color = value;
    }

    public String getStructName() {
        return CUSTOM_COLOR_STRUCT;
    }

    protected Object getIntrinsicProperty(String valueName) {
        if (valueName.equals(NAME_MEMBER)) {
            return this.name;
        }
        if (valueName.equals(COLOR_MEMBER)) {
            return this.color;
        }
        if (valueName.equals(DISPLAY_NAME_MEMBER)) {
            return this.displayName;
        }
        if (valueName.equals(DISPLAY_NAME_ID_MEMBER)) {
            return this.displayNameID;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void setIntrinsicProperty(String valueName, Object value) {
        if (valueName.equals(NAME_MEMBER)) {
            this.name = (String)value;
        } else if (valueName.equals(COLOR_MEMBER)) {
            this.color = (String)value;
        } else if (valueName.equals(DISPLAY_NAME_MEMBER)) {
            this.displayName = (String)value;
        } else if (valueName.equals(DISPLAY_NAME_ID_MEMBER)) {
            this.displayNameID = (String)value;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public int getRGB() {
        if (this.color == null) {
            return -1;
        }
        try {
            return ColorUtil.parseColor(this.color);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getName() {
        return (String)this.getProperty(null, NAME_MEMBER);
    }

    public String getColor() {
        return (String)this.getProperty(null, COLOR_MEMBER);
    }

    public String getDisplayNameID() {
        return (String)this.getProperty(null, DISPLAY_NAME_ID_MEMBER);
    }

    public String getDisplayName() {
        return (String)this.getProperty(null, DISPLAY_NAME_MEMBER);
    }

    public String getDisplayName(Module module) {
        String value = null;
        Translation translation = module.findTranslation(this.displayNameID, ThreadResources.getLocale().toString());
        if (translation != null && !StringUtil.isBlank(value = translation.getText())) {
            return value;
        }
        value = this.getDisplayName();
        if (!StringUtil.isBlank(value)) {
            return value;
        }
        return this.name;
    }

    protected StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new CustomColorHandle(valueHandle, index);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setColor(String colorValue) {
        this.color = colorValue;
    }

    public void setDisplayNameID(String displayNameID) {
        this.displayNameID = displayNameID;
    }

    public List validate(Module module, DesignElement element) {
        IChoiceSet colors;
        List list = super.validate(module, element);
        if (StringUtil.isBlank(this.name)) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), (Object)this.name, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        if ((colors = MetaDataDictionary.getInstance().getChoiceSet("colors")).contains(this.name)) {
            list.add(new SemanticError(element, new String[]{this.name}, "Error.SemanticError.INVALID_CUSTOM_COLOR_NAME"));
        }
        return list;
    }

    public boolean isReferencableProperty(String memberName) {
        return NAME_MEMBER.equalsIgnoreCase(memberName);
    }

    public String getReferencableProperty() {
        return this.name;
    }

    static {
        $assertionsDisabled = !CustomColor.class.desiredAssertionStatus();
    }
}

