/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.api.metadata.MetaDataReaderException;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ExtensionManager;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaDataReader;
import org.eclipse.birt.report.model.metadata.MetaLogManager;

public class DesignEngineImpl
implements IDesignEngine {
    protected static Logger errorLogger = Logger.getLogger(DesignEngineImpl.class.getName());
    private static final String ROM_DEF_FILE_NAME = "rom.def";
    private DesignConfig designConfig;

    public DesignEngineImpl(DesignConfig config) {
        this.designConfig = config;
    }

    private static void initialize(InputStream is) throws MetaDataReaderException {
        try {
            MetaDataReader.read(is);
            ExtensionManager.initialize();
            MetaLogManager.shutDown();
        }
        catch (MetaDataParserException e) {
            throw new MetaDataReaderException("Error.MetaDataReaderException.META_DATA_ERROR", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle newSessionHandle(ULocale locale) {
        IResourceLocator locator;
        if (!MetaDataDictionary.getInstance().isEmpty()) {
            return new SessionHandle(locale);
        }
        Class clazz = DesignEngine.class;
        synchronized (clazz) {
            if (!MetaDataDictionary.getInstance().isEmpty()) {
                return new SessionHandle(locale);
            }
            MetaDataDictionary.reset();
            try {
                DesignEngineImpl.initialize(ReportDesign.class.getResourceAsStream(ROM_DEF_FILE_NAME));
            }
            catch (MetaDataReaderException e) {
            }
            finally {
                MetaLogManager.shutDown();
            }
        }
        SessionHandle session = new SessionHandle(locale);
        if (this.designConfig != null && (locator = this.designConfig.getResourceLocator()) != null) {
            session.setResourceLocator(locator);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMetaDataDictionary getMetaData() {
        if (!MetaDataDictionary.getInstance().isEmpty()) {
            return MetaDataDictionary.getInstance();
        }
        Class clazz = DesignEngine.class;
        synchronized (clazz) {
            if (!MetaDataDictionary.getInstance().isEmpty()) {
                return MetaDataDictionary.getInstance();
            }
            MetaDataDictionary.reset();
            try {
                DesignEngineImpl.initialize(ReportDesign.class.getResourceAsStream(ROM_DEF_FILE_NAME));
            }
            catch (MetaDataReaderException metaDataReaderException) {
            }
            finally {
                MetaLogManager.shutDown();
            }
        }
        return MetaDataDictionary.getInstance();
    }

    public void registerMetaLogger(IMetaLogger newLogger) {
        MetaLogManager.registerLogger(newLogger);
    }

    public boolean removeMetaLogger(IMetaLogger logger) {
        return MetaLogManager.removeLogger(logger);
    }
}

