/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ContentRecord;
import org.eclipse.birt.report.model.command.ElementBackRefRecord;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.MoveContentRecord;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.TemplateCommand;
import org.eclipse.birt.report.model.command.TemplateTransformRecord;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;

public class ContentCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ContentCommand(Module module, DesignElement container) {
        super(module, container);
    }

    public void add(DesignElement content, int slotID, int newPos) throws ContentException, NameException {
        if (!$assertionsDisabled && newPos < 0 && newPos != -1) {
            throw new AssertionError();
        }
        this.doAdd(content, slotID, newPos);
    }

    public void add(DesignElement content, int slotID) throws ContentException, NameException {
        this.doAdd(content, slotID, -1);
    }

    private void doAdd(DesignElement content, int slotID, int newPos) throws ContentException, NameException {
        if (!$assertionsDisabled && content.getContainer() != null) {
            throw new AssertionError();
        }
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (!metaData.isContainer()) {
            throw new ContentException(this.element, slotID, "Error.ContentException.NOT_CONTAINER");
        }
        SlotDefn slotInfo = (SlotDefn)metaData.getSlot(slotID);
        if (slotInfo == null) {
            throw new ContentException(this.element, slotID, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!slotInfo.canContain(content)) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.WRONG_TYPE");
        }
        if (this.element.isVirtualElement() || this.element.getExtendsName() != null) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.element.isContentOf(content)) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.RECURSIVE");
        }
        if (!slotInfo.isMultipleCardinality() && this.element.getSlot(slotID).getCount() > 0) {
            throw new ContentException(this.element, slotID, "Error.ContentException.SLOT_IS_FULL");
        }
        if (slotID == 5 && StringUtil.isBlank(content.getName())) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.CONTENT_NAME_REQUIRED");
        }
        this.checkContainmentContext(slotID, content);
        ContentRecord addRecord = newPos == -1 ? new ContentRecord(this.module, this.element, slotID, content, true) : new ContentRecord(this.module, this.element, slotID, content, newPos);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(addRecord.getLabel());
        try {
            TemplateCommand cmd = new TemplateCommand(this.module, this.element);
            cmd.checkAdd(content, slotID);
            stack.execute(addRecord);
            this.addElementNames(content);
            if (content instanceof GroupElement) {
                String name = this.module.getUniqueName(content);
                this.setGroupName(content, stack, name);
            }
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void setGroupName(DesignElement content, ActivityStack stack, String name) {
        if (name != null && !name.equals(content.getName())) {
            PropertyRecord propertyRecord = new PropertyRecord(content, "groupName", (Object)name);
            stack.execute(propertyRecord);
        }
    }

    private void checkContainmentContext(int slotId, DesignElement content) throws NameException, ContentException {
        List errors = this.element.checkContainmentContext(this.module, slotId, content);
        if (!errors.isEmpty()) {
            SemanticException e = (SemanticException)((Object)errors.get(0));
            if (!($assertionsDisabled || e instanceof NameException || e instanceof ContentException)) {
                throw new AssertionError();
            }
            if (e instanceof NameException) {
                throw (NameException)e;
            }
            if (e instanceof ContentException) {
                throw (ContentException)e;
            }
        }
    }

    private void addElementNames(DesignElement content) throws NameException {
        if (!$assertionsDisabled && content.getContainer() == null) {
            throw new AssertionError();
        }
        NameCommand nameCmd = new NameCommand(this.module, content);
        nameCmd.addElement();
        for (int i = 0; i < content.getDefn().getSlotCount(); ++i) {
            ContainerSlot slot = content.getSlot(i);
            for (int j = 0; j < slot.getCount(); ++j) {
                DesignElement tmpElement = slot.getContent(j);
                this.addElementNames(tmpElement);
            }
        }
    }

    public void remove(DesignElement content, int slotID) throws SemanticException {
        this.remove(content, slotID, false);
    }

    public void remove(DesignElement content, int slotID, boolean unresolveReference) throws SemanticException {
        this.doRemove(content, slotID, unresolveReference, false);
    }

    public void remove(DesignElement content, int slotID, boolean unresolveReference, boolean flag) throws SemanticException {
        this.doRemove(content, slotID, unresolveReference, flag);
    }

    private void doRemove(DesignElement content, int slotID, boolean unresolveReference, boolean flag) throws SemanticException {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (!this.element.getDefn().isContainer()) {
            throw new ContentException(this.element, slotID, "Error.ContentException.NOT_CONTAINER");
        }
        ContainerSlot slot = this.element.getSlot(slotID);
        if (slot == null) {
            throw new ContentException(this.element, slotID, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!slot.contains(content)) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        if (!slot.canDrop(content)) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.DROP_FORBIDDEN");
        }
        if (!content.canDrop() && !flag) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (this.hasDescendents(content, slotID)) {
            throw new ContentException(this.element, slotID, "Error.ContentException.HAS_DESCENDENTS");
        }
        ContentRecord dropRecord = new ContentRecord(this.module, this.element, slotID, content, false);
        ActivityStack stack = this.getActivityStack();
        stack.startFilterEventTrans(dropRecord.getLabel());
        try {
            this.doDelectAction(content, unresolveReference);
        }
        catch (SemanticException ex) {
            stack.rollback();
            throw ex;
        }
        stack.execute(dropRecord);
        stack.commit();
    }

    private void adjustDerived(DesignElement obj) throws ExtendsException {
        List derived = obj.getDerived();
        if (derived.isEmpty()) {
            return;
        }
        DesignElement parent = obj.getExtendsElement();
        Iterator iter = derived.iterator();
        while (iter.hasNext()) {
            DesignElement child = (DesignElement)iter.next();
            ExtendsCommand childCmd = new ExtendsCommand(this.module, child);
            childCmd.setExtendsElement(parent);
        }
    }

    private void adjustReferenceClients(ReferenceableElement referred, boolean unresolveReference) throws SemanticException {
        ArrayList clients = new ArrayList(referred.getClientList());
        Iterator iter = clients.iterator();
        while (iter.hasNext()) {
            BackRef ref = (BackRef)iter.next();
            DesignElement client = ref.element;
            if (unresolveReference) {
                ElementBackRefRecord record = new ElementBackRefRecord(this.module, referred, client, ref.propName);
                this.getActivityStack().execute(record);
                continue;
            }
            if (referred.isStyle()) {
                StyleCommand clientCmd = new StyleCommand(this.module, client);
                clientCmd.setStyleElement((DesignElement)null);
                continue;
            }
            PropertyCommand cmd = new PropertyCommand(this.module, client);
            cmd.setProperty(ref.propName, null);
        }
    }

    private void adjustReferredClients(DesignElement element) {
        List propDefns = element.getPropertyDefns();
        Iterator iter = propDefns.iterator();
        while (iter.hasNext()) {
            List valueList;
            PropertyDefn propDefn = (PropertyDefn)iter.next();
            if ("extends".equalsIgnoreCase(propDefn.getName()) || "style".equalsIgnoreCase(propDefn.getName())) continue;
            if (propDefn.getTypeCode() == 15 || propDefn.getTypeCode() == 19) {
                ElementRefValue templateParam;
                Object value = element.getLocalProperty(this.module, (ElementPropertyDefn)propDefn);
                if (value == null || !(value instanceof StructRefValue) && !((ElementRefValue)value).isResolved()) continue;
                TemplateParameterDefinition definition = null;
                if (value instanceof ElementRefValue && (templateParam = (ElementRefValue)value).getTargetElement() instanceof TemplateParameterDefinition) {
                    definition = (TemplateParameterDefinition)templateParam.getTargetElement();
                }
                try {
                    PropertyCommand cmd = new PropertyCommand(this.module, element);
                    cmd.setProperty(propDefn.getName(), null);
                    if (definition == null || definition.hasReferences()) continue;
                    if (!$assertionsDisabled && definition.getRoot() != this.module) {
                        throw new AssertionError();
                    }
                    ContentCommand contentCmd = new ContentCommand(this.module, this.module);
                    contentCmd.remove(definition, 8);
                    continue;
                }
                catch (SemanticException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
            }
            if (propDefn.getTypeCode() != 20 || propDefn.getSubTypeCode() != 15 || (valueList = (List)element.getLocalProperty(this.module, (ElementPropertyDefn)propDefn)) == null) continue;
            for (int i = valueList.size() - 1; i >= 0; --i) {
                ElementRefValue item = (ElementRefValue)valueList.get(i);
                if (!item.isResolved()) continue;
                try {
                    PropertyCommand cmd = new PropertyCommand(this.module, element);
                    cmd.removeItem((ElementPropertyDefn)propDefn, item.getElement());
                    continue;
                }
                catch (SemanticException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
            }
        }
    }

    private void dropUserProperties(DesignElement obj) throws UserPropertyException {
        List props = obj.getLocalUserProperties();
        if (props != null) {
            UserPropertyCommand propCmd = new UserPropertyCommand(this.module, obj);
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                UserPropertyDefn prop = (UserPropertyDefn)iter.next();
                propCmd.dropUserProperty(prop.getName());
            }
        }
    }

    private void removeContents(DesignElement obj) throws SemanticException {
        IElementDefn metaData = obj.getDefn();
        if (!metaData.isContainer()) {
            return;
        }
        int slotCount = metaData.getSlotCount();
        for (int slotID = 0; slotID < slotCount; ++slotID) {
            ContainerSlot slot = obj.getSlot(slotID);
            ContentCommand contentCmd = new ContentCommand(this.module, obj);
            while (!slot.isEmpty()) {
                DesignElement content = slot.getContent(0);
                contentCmd.doRemove(content, slotID, false, true);
            }
        }
    }

    private void doMove(DesignElement content, int fromSlotID, DesignElement to, int toSlotID, int newPos) throws ContentException {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && to == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && newPos < -1) {
            throw new AssertionError();
        }
        if (this.element == to && fromSlotID == toSlotID) {
            return;
        }
        if (content.isVirtualElement() || content.getExtendsName() != null) {
            throw new ContentException(this.element, fromSlotID, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (to.isContentOf(content)) {
            throw new ContentException(to, fromSlotID, content, "Error.ContentException.RECURSIVE");
        }
        if (!this.element.getDefn().isContainer()) {
            throw new ContentException(this.element, fromSlotID, "Error.ContentException.NOT_CONTAINER");
        }
        if (!to.getDefn().isContainer()) {
            throw new ContentException(to, toSlotID, "Error.ContentException.NOT_CONTAINER");
        }
        ContainerSlot fromSlot = this.element.getSlot(fromSlotID);
        if (fromSlot == null) {
            throw new ContentException(this.element, fromSlotID, "Error.ContentException.SLOT_NOT_FOUND");
        }
        ContainerSlot toSlot = to.getSlot(toSlotID);
        if (toSlot == null) {
            throw new ContentException(to, toSlotID, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!fromSlot.contains(content)) {
            throw new ContentException(this.element, fromSlotID, content, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        if (!fromSlot.canDrop(content)) {
            throw new ContentException(this.element, fromSlotID, content, "Error.ContentException.DROP_FORBIDDEN");
        }
        if (this.hasDescendents(content, fromSlotID)) {
            throw new ContentException(this.element, fromSlotID, "Error.ContentException.HAS_DESCENDENTS");
        }
        SlotDefn slotInfo = (SlotDefn)to.getDefn().getSlot(toSlotID);
        if (!slotInfo.canContain(content)) {
            throw new ContentException(to, toSlotID, content, "Error.ContentException.WRONG_TYPE");
        }
        if (!slotInfo.isMultipleCardinality() && toSlot.getCount() > 0) {
            throw new ContentException(to, toSlotID, "Error.ContentException.SLOT_IS_FULL");
        }
        if (!to.canContain(this.module, toSlotID, content)) {
            throw new ContentException(to, toSlotID, content, "Error.ContentException.INVALID_CONTEXT_CONTAINMENT");
        }
        ActivityStack stack = this.getActivityStack();
        String label = ModelMessages.getMessage("Message.MoveElement");
        stack.startTrans(label);
        ContentRecord record = new ContentRecord(this.module, this.element, fromSlotID, content, false);
        stack.execute(record);
        record = new ContentRecord(this.module, to, toSlotID, content, newPos);
        stack.execute(record);
        stack.commit();
    }

    public void move(DesignElement content, int fromSlotID, DesignElement to, int toSlotID, int newPos) throws ContentException {
        if (!$assertionsDisabled && newPos < 0) {
            throw new AssertionError();
        }
        this.doMove(content, fromSlotID, to, toSlotID, newPos);
    }

    public void move(DesignElement content, int fromSlotID, DesignElement to, int toSlotID) throws ContentException {
        this.doMove(content, fromSlotID, to, toSlotID, -1);
    }

    public void movePosition(DesignElement content, int slotID, int newPosn) throws ContentException {
        int adjustedNewPosn;
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (!this.element.getDefn().isContainer()) {
            throw new ContentException(this.element, slotID, "Error.ContentException.NOT_CONTAINER");
        }
        ContainerSlot slot = this.element.getSlot(slotID);
        if (slot == null) {
            throw new ContentException(this.element, slotID, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!content.isContentOf(this.element)) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        SlotDefn slotInfo = (SlotDefn)this.element.getDefn().getSlot(slotID);
        if (!slotInfo.isMultipleCardinality()) {
            return;
        }
        if (content.isVirtualElement()) {
            throw new ContentException(this.element, slotID, content, "Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN");
        }
        if (!this.canMovePosition(content, slotID, newPosn)) {
            throw new ContentException(this.element, slotID, "Error.ContentException.MOVE_FORBIDDEN");
        }
        int oldPosn = slot.findPosn(content);
        if (oldPosn == (adjustedNewPosn = ContentCommand.checkAndAdjustPosition(oldPosn, newPosn, slot.getCount()))) {
            return;
        }
        MoveContentRecord record = new MoveContentRecord(this.element, slotID, content, adjustedNewPosn);
        this.getActivityStack().execute(record);
    }

    private boolean canMovePosition(DesignElement content, int slotID, int newPosn) {
        if (this.element instanceof ReportDesign && slotID == 5) {
            List derived = content.getDerived();
            ContainerSlot slot = this.element.getSlot(slotID);
            Iterator iter = derived.iterator();
            while (iter.hasNext()) {
                DesignElement child = (DesignElement)iter.next();
                if (!slot.contains(child) || slot.findPosn(child) > newPosn) continue;
                return false;
            }
            for (DesignElement e = content.getExtendsElement(); e != null; e = e.getExtendsElement()) {
                if (slot.findPosn(e) < newPosn) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasDescendents(DesignElement content, int fromSlotID) {
        return this.element instanceof ReportDesign && fromSlotID == 5 && content.hasDerived();
    }

    public void transformTemplate(DesignElement from, DesignElement to, int slotID, boolean unresolveReference) throws SemanticException {
        this.doReplace(from, to, slotID, unresolveReference);
    }

    private void doReplace(DesignElement oldElement, DesignElement newElement, int slotID, boolean unresolveReference) throws SemanticException {
        if (!$assertionsDisabled && newElement.getContainer() != null) {
            throw new AssertionError();
        }
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (!metaData.isContainer()) {
            throw new ContentException(this.element, slotID, "Error.ContentException.NOT_CONTAINER");
        }
        SlotDefn slotInfo = (SlotDefn)metaData.getSlot(slotID);
        if (slotInfo == null) {
            throw new ContentException(this.element, slotID, "Error.ContentException.SLOT_NOT_FOUND");
        }
        if (!slotInfo.canContain(newElement)) {
            throw new ContentException(this.element, slotID, newElement, "Error.ContentException.WRONG_TYPE");
        }
        if (this.element.isContentOf(newElement)) {
            throw new ContentException(this.element, slotID, newElement, "Error.ContentException.RECURSIVE");
        }
        if (slotID == 5 && StringUtil.isBlank(newElement.getName())) {
            throw new ContentException(this.element, slotID, newElement, "Error.ContentException.CONTENT_NAME_REQUIRED");
        }
        ContainerSlot slot = this.element.getSlot(slotID);
        if (!slot.contains(oldElement)) {
            throw new ContentException(this.element, slotID, oldElement, "Error.ContentException.CONTENT_NOT_FOUND");
        }
        if (oldElement instanceof TemplateElement) {
            if (!(oldElement.canDrop() && oldElement.isTemplateParameterValue(this.module) && newElement.getDefn().isKindOf(((TemplateElement)oldElement).getDefaultElement(this.module).getDefn()))) {
                throw new TemplateException(oldElement, "Error.TemplateException.REVERT_TO_TEMPLATE_FORBIDDEN");
            }
        } else if (!oldElement.canTransformToTemplate(this.module) || !(newElement instanceof TemplateElement)) {
            throw new ContentException(this.element, slotID, "Error.ContentException.TEMPLATE_TRANSFORM_FORBIDDEN");
        }
        if (this.hasDescendents(oldElement, slotID)) {
            throw new ContentException(oldElement, slotID, "Error.ContentException.HAS_DESCENDENTS");
        }
        TemplateTransformRecord replaceRecord = new TemplateTransformRecord(this.module, this.element, slotID, oldElement, newElement);
        ActivityStack stack = this.getActivityStack();
        stack.startFilterEventTrans(replaceRecord.getLabel());
        try {
            this.doDelectAction(oldElement, unresolveReference);
            TemplateCommand cmd = new TemplateCommand(this.module, this.element);
            cmd.checkAdd(newElement, slotID);
            stack.execute(replaceRecord);
            this.addElementNames(newElement);
        }
        catch (ContentException e) {
            stack.rollback();
            throw e;
        }
        catch (NameException e) {
            stack.rollback();
            throw e;
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void doDelectAction(DesignElement content, boolean unresolveReference) throws SemanticException {
        this.removeContents(content);
        this.dropUserProperties(content);
        if (content.hasReferences()) {
            this.adjustReferenceClients((ReferenceableElement)content, unresolveReference);
        }
        this.adjustReferredClients(content);
        this.adjustDerived(content);
        if (content.getStyle(this.module) != null) {
            StyleCommand styleCmd = new StyleCommand(this.module, content);
            styleCmd.setStyle(null);
        }
        if (content.getExtendsElement() != null) {
            ExtendsCommand extendsCmd = new ExtendsCommand(this.module, content);
            extendsCmd.setExtendsName(null);
        }
        if (content.getName() != null) {
            NameCommand nameCmd = new NameCommand(this.module, content);
            nameCmd.dropElement();
        }
        List propertyBindings = this.module.getPropertyBindings(content);
        for (int i = 0; i < propertyBindings.size(); ++i) {
            PropertyBinding propBinding = (PropertyBinding)propertyBindings.get(i);
            ElementPropertyDefn propDefn = this.module.getPropertyDefn("propertyBindings");
            PropertyCommand propCommand = new PropertyCommand(this.module, this.module);
            propCommand.removeItem((MemberRef)new CachedMemberRef(propDefn), propBinding);
        }
        this.handleRemovingElement(content);
    }

    private void handleRemovingElement(DesignElement content) {
        if (content instanceof GroupElement) {
            ListingElement tmpContainer = (ListingElement)this.element;
            List boundColumns = tmpContainer.getListProperty(this.module, "boundDataColumns");
            if (boundColumns == null || boundColumns.isEmpty()) {
                return;
            }
            String groupName = (String)content.getProperty(this.module, "groupName");
            ArrayList<Integer> toCleared = new ArrayList<Integer>();
            for (int i = 0; i < boundColumns.size(); ++i) {
                ComputedColumn column = (ComputedColumn)boundColumns.get(i);
                String aggregateGroup = column.getAggregateOn();
                if (aggregateGroup == null || !aggregateGroup.equals(groupName)) continue;
                toCleared.add(new Integer(i));
            }
            StructPropertyDefn structPropDefn = (StructPropertyDefn)MetaDataDictionary.getInstance().getStructure("ComputedColumn").getMember("aggregateOn");
            ElementPropertyDefn propDefn = tmpContainer.getPropertyDefn("boundDataColumns");
            try {
                for (int i = 0; i < toCleared.size(); ++i) {
                    int columnIndex = (Integer)toCleared.get(i);
                    CachedMemberRef memberRef = new CachedMemberRef(propDefn, columnIndex, structPropDefn);
                    PropertyCommand propCmd = new PropertyCommand(this.module, tmpContainer);
                    propCmd.setMember(memberRef, null);
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
    }

    static {
        $assertionsDisabled = !ContentCommand.class.desiredAssertionStatus();
    }
}

