/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public class ContentRecord
extends SimpleRecord {
    protected DesignElement container = null;
    protected DesignElement content = null;
    protected int slotID = 0;
    protected boolean add = true;
    protected int oldPosn = -1;
    protected final Module module;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ContentRecord(Module module, DesignElement containerObj, int theSlot, DesignElement contentObj, boolean isAdd) {
        this.init(containerObj, theSlot, contentObj, -1, isAdd);
        this.module = module;
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
    }

    public ContentRecord(Module module, DesignElement containerObj, int theSlot, DesignElement contentObj, int newPos) {
        this.init(containerObj, theSlot, contentObj, newPos, true);
        this.module = module;
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
    }

    private void init(DesignElement containerObj, int theSlot, DesignElement contentObj, int newPos, boolean isAdd) {
        this.container = containerObj;
        this.slotID = theSlot;
        this.content = contentObj;
        this.add = isAdd;
        if (!$assertionsDisabled && newPos < -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.container == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.content == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || isAdd && this.content.getContainer() == null || !isAdd && this.content.getContainer() != null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.container.getDefn().getSlot(this.slotID).canContain(this.content)) {
            throw new AssertionError();
        }
        ContainerSlot slot = this.container.getSlot(this.slotID);
        if (!$assertionsDisabled && slot == null) {
            throw new AssertionError();
        }
        if (isAdd) {
            this.oldPosn = newPos == -1 || slot.getCount() < newPos ? slot.getCount() : newPos;
        } else {
            this.oldPosn = slot.findPosn(this.content);
            if (!$assertionsDisabled && this.oldPosn == -1) {
                throw new AssertionError();
            }
        }
        this.label = this.add ? ModelMessages.getMessage("Message.AddElement") : ModelMessages.getMessage("Message.DropElement");
    }

    public DesignElement getTarget() {
        return this.container;
    }

    public NotificationEvent getEvent() {
        return null;
    }

    protected void perform(boolean undo) {
        ContainerSlot slot = this.container.getSlot(this.slotID);
        if (this.add && !undo || !this.add && undo) {
            slot.insert(this.content, this.oldPosn);
            this.content.setContainer(this.container, this.slotID);
            if (this.content.getRoot() != null) {
                this.module.manageId(this.content, true);
            }
        } else {
            slot.remove(this.content);
            if (this.content.getRoot() != null) {
                this.module.manageId(this.content, false);
            }
            this.content.setContainer(null, -1);
        }
    }

    private boolean isSelector(DesignElement content) {
        if (!(content instanceof StyleElement)) {
            return false;
        }
        return MetaDataDictionary.getInstance().getPredefinedStyle(content.getName()) != null;
    }

    public List getValidators() {
        SlotDefn slotDefn = (SlotDefn)this.container.getDefn().getSlot(this.slotID);
        List list = ValidationExecutor.getValidationNodes(this.container, slotDefn.getTriggerDefnSet(), false);
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            ElementDefn contentDefn = (ElementDefn)this.content.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.content, contentDefn.getTriggerDefnSet(), false));
        }
        return list;
    }

    protected List getPostTasks() {
        ReportItem compoundElement;
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        if ((this.container instanceof TableItem || this.container instanceof GridItem || this.container instanceof TableGroup || this.container instanceof TableRow) && (compoundElement = LayoutUtil.getCompoundContainer(this.container)) != null) {
            retValue.add(new LayoutRecordTask(this.module, compoundElement));
        }
        NotificationEvent event = null;
        event = this.add && this.state != 2 || !this.add && this.state == 2 ? new ContentEvent(this.container, this.content, this.slotID, 1) : new ContentEvent(this.container, this.content, this.slotID, 2);
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        retValue.add(new NotificationRecordTask(this.container, event));
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            if (this.isSelector(this.content)) {
                retValue.add(new NotificationRecordTask(this.content, event, this.container.getRoot()));
            }
            return retValue;
        }
        if (this.content instanceof Parameter || this.content instanceof ParameterGroup || this.content instanceof SimpleDataSet || this.content instanceof StyleElement) {
            event = new ElementDeletedEvent(this.container, this.content);
            if (this.state == 1) {
                event.setSender(this.sender);
            }
            retValue.add(new NotificationRecordTask(this.content, event, this.container.getRoot()));
        } else {
            this.content.clearListeners();
        }
        return retValue;
    }

    static {
        $assertionsDisabled = !ContentRecord.class.desiredAssertionStatus();
    }
}

