/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.parser.ModuleParserErrorHandler;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ModuleParserHandler
extends XMLParserHandler {
    protected DesignSession session = null;
    protected Module module = null;
    protected String fileName = null;
    int versionNumber = 0;
    boolean isCurrentVersion = false;
    protected HashMap tempValue = new HashMap();

    protected ModuleParserHandler(DesignSession theSession, String fileName) {
        super(new ModuleParserErrorHandler());
        this.session = theSession;
        this.fileName = fileName;
    }

    String getFileName() {
        return this.fileName;
    }

    public boolean isVersion(int toCompare) {
        return this.versionNumber == toCompare;
    }

    public Module getModule() {
        return this.module;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.errorHandler.setCurrentElement(qName);
        AbstractParseState newState = this.topState().startElement(qName);
        newState.parseAttrs(atts);
        AbstractParseState jumpToState = newState.jumpTo();
        if (jumpToState != null) {
            this.pushState(jumpToState);
            return;
        }
        newState.setElementName(qName);
        this.pushState(newState);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.module.getAllExceptions().addAll(this.getErrorHandler().getErrors());
        List libraries = this.module.getAllLibraries();
        Iterator iter = libraries.iterator();
        while (iter.hasNext()) {
            Exception fatalException;
            Library library = (Library)iter.next();
            if (library.isValid() || (fatalException = ModelUtil.getFirstFatalException(library.getAllExceptions())) == null) continue;
            XMLParserException exception = this.errorHandler.semanticError(fatalException);
            this.module.getAllExceptions().add(exception);
        }
        if (!this.module.getAllErrors().isEmpty() || this.module.getFatalException() != null) {
            this.module.setValid(false);
            ArrayList allExceptions = new ArrayList();
            allExceptions.addAll(this.module.getAllExceptions());
            allExceptions.addAll(this.errorHandler.getWarnings());
            DesignFileException exception = new DesignFileException(this.module.getFileName(), allExceptions);
            throw new SAXException((Exception)((Object)exception));
        }
        this.module.manageId(this.module, true);
        ModuleOption options = this.module.getOptions();
        if (options == null || options.useSemanticCheck()) {
            this.module.semanticCheck(this.module);
        }
        if (this.errorHandler.getWarnings() != null) {
            this.module.getAllExceptions().addAll(this.errorHandler.getWarnings());
        }
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }
}

